/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.stat.model;

import drasys.or.alg.QuickSort;
import drasys.or.matrix.MatrixI;
import drasys.or.matrix.VectorI;
import drasys.or.stat.model.GeneralLinearModelI;
import drasys.or.stat.model.LinearRegression;
import drasys.or.stat.model.LinearRegressionI;

public class StepwiseLinear
extends LinearRegression
implements LinearRegressionI {
    int _histCnt = 0;
    int[][] _histVars;
    VectorI[] _histPvals;

    public StepwiseLinear(VectorI vectorI, MatrixI matrixI) {
        super(vectorI, matrixI);
    }

    public StepwiseLinear(GeneralLinearModelI generalLinearModelI) {
        super(generalLinearModelI);
    }

    private void hist(VectorI vectorI) {
        if (this._histCnt < this._histVars.length) {
            this._histVars[this._histCnt] = this._selectedVariables;
            this._histPvals[this._histCnt] = vectorI;
            ++this._histCnt;
        }
    }

    private void reverse(boolean[] blArray, boolean[] blArray2, VectorI vectorI) {
        while (true) {
            int n;
            int n2 = -1;
            double d = -1.0;
            int n3 = this._selectedVariables.length;
            int n4 = 0;
            while (n4 < n3) {
                n = this._selectedVariables[n4];
                double d2 = vectorI.elementAt(n4);
                if (d2 > this._exitPValue && !blArray[n] && (n2 == -1 || d2 > d)) {
                    n2 = n4;
                    d = d2;
                }
                ++n4;
            }
            if (n2 == -1) {
                return;
            }
            n = this._selectedVariables[n2];
            blArray2[n] = false;
            int[] nArray = new int[n3 - 1];
            int n5 = 0;
            while (n5 < n2) {
                nArray[n5] = this._selectedVariables[n5];
                ++n5;
            }
            int n6 = n2 + 1;
            while (n6 < n3) {
                nArray[n6 - 1] = this._selectedVariables[n6];
                ++n6;
            }
            this.setSelectedVariables(nArray);
            vectorI = this.getTPV();
            this.hist(vectorI);
        }
    }

    public int solve() {
        if (this._enterPValue > this._exitPValue) {
            throw new Error("The entering p-value must be <= the exiting to insure convergence.");
        }
        this._histCnt = 0;
        this._histVars = new int[1024][];
        this._histPvals = new VectorI[1024];
        boolean[] blArray = new boolean[this._n];
        boolean[] blArray2 = new boolean[this._n];
        int n = 0;
        while (n < this._requiredVariables.length) {
            int n2 = this._requiredVariables[n];
            blArray2[n2] = true;
            blArray[n2] = true;
            ++n;
        }
        this.setSelectedVariables(this._requiredVariables);
        VectorI vectorI = this.getTPV();
        this.hist(vectorI);
        while (true) {
            int n3;
            int n4 = -1;
            double d = -1.0;
            int n5 = this._selectedVariables.length;
            int[] nArray = this._selectedVariables;
            int[] nArray2 = new int[n5 + 1];
            int n6 = 0;
            while (n6 < n5) {
                nArray2[n6] = this._selectedVariables[n6];
                ++n6;
            }
            int n7 = 0;
            while (n7 < this._enteringVariables.length) {
                n3 = this._enteringVariables[n7];
                if (!blArray2[n3]) {
                    nArray2[n5] = n3;
                    this.setSelectedVariables(nArray2);
                    vectorI = this.getTPV();
                    double d2 = vectorI.elementAt(n5);
                    if (d2 <= this._enterPValue && (n4 == -1 || d2 < d)) {
                        n4 = n7;
                        d = d2;
                    }
                }
                ++n7;
            }
            if (n4 == -1) {
                new QuickSort().sort(nArray);
                this.setSelectedVariables(nArray);
                return n5;
            }
            nArray2[n5] = n3 = this._enteringVariables[n4];
            blArray2[n3] = true;
            this.setSelectedVariables(nArray2);
            vectorI = this.getTPV();
            this.hist(vectorI);
            this.reverse(blArray, blArray2, vectorI);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\n");
        stringBuffer.append("----------------------------\n");
        stringBuffer.append("---- Stepwise Algorithm ----\n");
        stringBuffer.append("----------------------------\n");
        stringBuffer.append("\n");
        int n = 0;
        while (n < this._histCnt) {
            stringBuffer.append("ITERATION-" + n + "\n");
            int[] nArray = this._histVars[n];
            VectorI vectorI = this._histPvals[n];
            int n2 = 0;
            while (n2 < nArray.length) {
                stringBuffer.append("  (" + nArray[n2] + ") = " + vectorI.elementAt(n2) + "\n");
                ++n2;
            }
            stringBuffer.append("\n");
            ++n;
        }
        return stringBuffer.toString();
    }
}

