/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.prob;

import drasys.or.InvalidArgumentError;
import drasys.or.prob.ContinuousDistribution;
import drasys.or.prob.ContinuousDistributionI;
import drasys.or.prob.ProbError;

public class UniformDistribution
extends ContinuousDistribution
implements ContinuousDistributionI {
    double _min;
    double _max;
    double _scale;
    double _offset;

    public UniformDistribution() {
        this.setParameters(0.0, 1.0);
    }

    public UniformDistribution(double d, double d2) {
        this.setParameters(d, d2);
    }

    public UniformDistribution(double d, double d2, long l) {
        super(l);
        this.setParameters(d, d2);
    }

    public double cdf(double d) {
        if (d <= this._min) {
            return 0.0;
        }
        if (d >= this._max) {
            return 1.0;
        }
        return (d - this._min) / (this._max - this._min);
    }

    public boolean equals(Object object) {
        if (!(object instanceof UniformDistribution)) {
            return false;
        }
        UniformDistribution uniformDistribution = (UniformDistribution)object;
        return uniformDistribution._min == this._min && uniformDistribution._max == this._max;
    }

    public double getRandomScaler() {
        return this._offset + this._scale * this._random.nextDouble();
    }

    public double inverseCdf(double d) {
        if (d < 0.0) {
            throw new ProbError("The 'probability' can't be less than '0.0'.");
        }
        if (d > 1.0) {
            throw new ProbError("The 'probability' can't be greater than '1.0'.");
        }
        return this._min + d * (this._max - this._min);
    }

    public double mean() {
        return (this._max + this._min) / 2.0;
    }

    public double pdf(double d) {
        if (d <= this._min || d >= this._max) {
            return 0.0;
        }
        return 1.0 / (this._max - this._min);
    }

    public double probability(double d, double d2) {
        if (d2 < d) {
            throw new InvalidArgumentError("X2 must be greater than or equal to x1.");
        }
        if (d == d2) {
            return 0.0;
        }
        if (d < this._min) {
            d = this._min;
        }
        if (d2 > this._max) {
            d2 = this._max;
        }
        return (d2 - d) / (this._max - this._min);
    }

    public void setParameters(double d, double d2) {
        if (d2 <= d) {
            throw new InvalidArgumentError("Max must be greater than min.");
        }
        this._min = d;
        this._max = d2;
        this._scale = this._max - this._min;
        this._offset = this._min;
    }

    public double std() {
        double d = this._max - this._min;
        return Math.sqrt(d * d / 12.0);
    }

    public String toString() {
        return "UniformDistribution(min = " + this._min + ", max = " + this._max + ")";
    }

    public double variance() {
        double d = this._max - this._min;
        return d * d / 12.0;
    }
}

