/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.prob;

import drasys.or.Functions;
import drasys.or.FunctionsI;
import drasys.or.InvalidArgumentError;
import drasys.or.prob.DiscreteDistribution;
import drasys.or.prob.DiscreteDistributionI;
import drasys.or.prob.PoissonDistribution;

public class PoissonDistributionBase
extends DiscreteDistribution
implements DiscreteDistributionI {
    double _exp;
    double _log;
    double _gam;
    double _mean;
    double _sqrt;
    FunctionsI _fnct;

    public PoissonDistributionBase(double d) {
        this._fnct = new Functions();
        this.setParameters(d);
    }

    public PoissonDistributionBase(double d, long l) {
        super(l);
        this._fnct = new Functions();
        this.setParameters(d);
    }

    public PoissonDistributionBase(double d, FunctionsI functionsI) {
        this._fnct = functionsI;
        this.setParameters(d);
    }

    public double cdf(int n) {
        if (n < 0) {
            throw new InvalidArgumentError("The x argument must be greater than or equal to zero.");
        }
        double d = 0.0;
        int n2 = 0;
        while (n2 <= n) {
            d += this.pdf(n2);
            ++n2;
        }
        return d;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PoissonDistribution)) {
            return false;
        }
        PoissonDistribution poissonDistribution = (PoissonDistribution)object;
        return poissonDistribution._mean == this._mean;
    }

    public int getRandomInteger() {
        double d;
        if (this._mean < 12.0) {
            int n = -1;
            double d2 = 1.0;
            do {
                ++n;
            } while ((d2 *= this._random.nextDouble()) > this._exp);
            return n;
        }
        while (true) {
            double d3;
            if ((d = this._sqrt * (d3 = Math.tan(Math.PI * this._random.nextDouble())) * this._mean) < 0.0) {
                continue;
            }
            d = Math.floor(d);
            double d4 = 0.9 * (1.0 + d3 * d3) * Math.exp(d * this._log - this._fnct.lnGamma(d + 1.0) - this._gam);
            if (!(this._random.nextDouble() > d4)) break;
        }
        return (int)d;
    }

    public double mean() {
        return this._mean;
    }

    public double pdf(int n) {
        if (n < 0) {
            throw new InvalidArgumentError("The x argument must be greater than or equal to zero.");
        }
        return Math.exp(this._log * (double)n - this._mean - this._fnct.lnFactorial(n));
    }

    public double probability(int n, int n2) {
        if (n2 < n) {
            throw new InvalidArgumentError("The x2 must be greater than x1.");
        }
        if (n < 0) {
            throw new InvalidArgumentError("The x argument must be greater than or equal to zero.");
        }
        double d = 0.0;
        int n3 = n;
        while (n3 <= n2) {
            d += this.pdf(n3);
            ++n3;
        }
        return d;
    }

    public void setParameters(double d) {
        if (d <= 0.0) {
            throw new InvalidArgumentError("The mean must be greater than zero.");
        }
        this._mean = d;
        this._exp = Math.exp(-this._mean);
        this._sqrt = Math.sqrt(2.0 * this._mean);
        this._log = Math.log(this._mean);
        this._gam = this._mean * this._log - this._fnct.lnGamma(this._mean + 1.0);
    }

    public double std() {
        return Math.sqrt(this._mean);
    }

    public String toString() {
        return "PoissonDistribution(mean = " + this._mean + ")";
    }

    public double variance() {
        return this._mean;
    }
}

