/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.prob;

import drasys.or.FunctionsI;
import drasys.or.InvalidArgumentError;
import drasys.or.prob.DiscreteDistributionI;
import drasys.or.prob.IncompleteGamma;
import drasys.or.prob.PoissonDistributionBase;

public class PoissonDistribution
extends PoissonDistributionBase
implements DiscreteDistributionI {
    public PoissonDistribution(double d) {
        super(d);
    }

    public PoissonDistribution(double d, long l) {
        super(d, l);
    }

    public PoissonDistribution(double d, FunctionsI functionsI) {
        super(d, functionsI);
    }

    public double cdf(int n) {
        if (n < 0) {
            throw new InvalidArgumentError("The x argument must be greater than or equal to zero.");
        }
        return 1.0 - new IncompleteGamma(n + 1).function(this._mean);
    }

    public double probability(int n, int n2) {
        if (n2 < n) {
            throw new InvalidArgumentError("The x2 must be greater than x1.");
        }
        if (n < 0) {
            throw new InvalidArgumentError("The x argument must be greater than or equal to zero.");
        }
        if (n == 0) {
            return this.cdf(n2);
        }
        return this.cdf(n2) - this.cdf(n - 1);
    }
}

