/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.prob;

import drasys.or.InvalidArgumentError;
import drasys.or.nonlinear.Bisection;
import drasys.or.nonlinear.EquationSolutionI;
import drasys.or.nonlinear.FunctionI;
import drasys.or.nonlinear.NonlinearException;
import drasys.or.prob.ContinuousDistribution;
import drasys.or.prob.IncompleteBeta;
import drasys.or.prob.ProbError;

public class FDistribution
extends ContinuousDistribution
implements FunctionI {
    double _m;
    double _n;
    double _mn2;
    double _m22;
    double _k;
    IncompleteBeta _ibeta;
    static final double MAX = 20000.0;
    static EquationSolutionI _solver;

    public FDistribution(double d, double d2) {
        if (d < 1.0) {
            throw new InvalidArgumentError("The degreesOfFreedom can't be less than '1.0'.");
        }
        if (d2 < 1.0) {
            throw new InvalidArgumentError("The degreesOfFreedom can't be less than '1.0'.");
        }
        this._m = d;
        this._n = d2;
        this._ibeta = new IncompleteBeta(0.5 * this._n, 0.5 * this._m);
        this._mn2 = 0.5 * (this._m + this._n);
        this._m22 = 0.5 * (this._m - 2.0);
        this._k = this._ibeta.lnGamma(this._mn2) - this._ibeta.lnGamma(0.5 * this._m) - this._ibeta.lnGamma(0.5 * this._n);
        this._k += Math.log(this._m) * 0.5 * this._m;
        this._k += Math.log(this._n) * 0.5 * this._n;
    }

    public double cdf(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        if (d >= 20000.0) {
            return 1.0;
        }
        return 1.0 - this._ibeta.function(this._n / (this._n + this._m * d));
    }

    public boolean equals(Object object) {
        if (!(object instanceof FDistribution)) {
            return false;
        }
        FDistribution fDistribution = (FDistribution)object;
        return fDistribution._n == this._n && fDistribution._m == this._m;
    }

    public double function(double d) {
        return this.cdf(d);
    }

    public double inverseCdf(double d) {
        double d2;
        if (d < 0.0) {
            throw new ProbError("The 'probability' can't be less than '0.0'.");
        }
        if (d > 1.0) {
            throw new ProbError("The 'probability' can't be greater than '1.0'.");
        }
        if (d <= 0.0) {
            return 0.0;
        }
        if (d >= this.cdf(20000.0)) {
            return 20000.0;
        }
        if (_solver == null) {
            _solver = new Bisection();
        }
        try {
            d2 = _solver.solve(this, 0.0, 20000.0, d);
        }
        catch (NonlinearException nonlinearException) {
            throw new ProbError("Nonlinear:" + nonlinearException.getMessage());
        }
        return d2;
    }

    public double mean() {
        return this._n / (this._n - 2.0);
    }

    public double pdf(double d) {
        if (d == 0.0) {
            return 0.0;
        }
        if (d < 0.0) {
            throw new InvalidArgumentError("'x' can't be negative.");
        }
        return Math.exp(this._k + Math.log(d) * this._m22 - Math.log(this._n + this._m * d) * this._mn2);
    }

    public double probability(double d, double d2) {
        if (d2 < d) {
            throw new InvalidArgumentError("X2 must be greater than or equal to x1.");
        }
        if (d == d2) {
            return 0.0;
        }
        return this.cdf(d2) - this.cdf(d);
    }

    public double std() {
        if (this._n <= 4.0) {
            throw new ProbError("Can't compute the std for degreesOfFreedom <= 4.0");
        }
        return Math.sqrt(this.variance());
    }

    public String toString() {
        return "FDistribution(degreesOfFreedom = " + this._n + ")";
    }

    public double variance() {
        if (this._n <= 4.0) {
            throw new ProbError("Can't compute the variance for degreesOfFreedom2 <= 4.0");
        }
        double d = this._n - 2.0;
        return 2.0 * this._n * this._n * (this._m + d) / (this._m * d * d * (this._n - 4.0));
    }
}

