/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.prob;

import drasys.or.InvalidArgumentError;
import drasys.or.prob.ContinuousDistribution;
import drasys.or.prob.ContinuousDistributionI;
import drasys.or.prob.ProbError;

public class ExponentialDistribution
extends ContinuousDistribution
implements ContinuousDistributionI {
    double _mean;

    public ExponentialDistribution() {
        this.setParameters(1.0);
    }

    public ExponentialDistribution(double d) {
        this.setParameters(d);
    }

    public ExponentialDistribution(double d, long l) {
        super(l);
        this.setParameters(d);
    }

    public double cdf(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        return 1.0 - Math.exp(-d / this._mean);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ExponentialDistribution)) {
            return false;
        }
        ExponentialDistribution exponentialDistribution = (ExponentialDistribution)object;
        return exponentialDistribution._mean == this._mean;
    }

    public double getRandomScaler() {
        return -this._mean * Math.log(this._random.nextDouble());
    }

    public double inverseCdf(double d) {
        if (d < 0.0) {
            throw new ProbError("The 'probability' can't be less than '0.0'.");
        }
        if (d > 1.0) {
            throw new ProbError("The 'probability' can't be greater than '1.0'.");
        }
        return -this._mean * Math.log(1.0 - d);
    }

    public double mean() {
        return this._mean;
    }

    public double pdf(double d) {
        if (d < 0.0) {
            return 0.0;
        }
        return Math.exp(-d / this._mean) / this._mean;
    }

    public double probability(double d, double d2) {
        if (d2 < d) {
            throw new InvalidArgumentError("X2 must be greater than or equal to x1.");
        }
        if (d == d2) {
            return 0.0;
        }
        return this.cdf(d2) - this.cdf(d);
    }

    public void setParameters(double d) {
        if (d <= 0.0) {
            throw new InvalidArgumentError("The mean must be greater than zero.");
        }
        this._mean = d;
    }

    public double std() {
        return this._mean;
    }

    public String toString() {
        return "ExponentialDistribution(mean = " + this._mean + ")";
    }

    public double variance() {
        return this._mean * this._mean;
    }
}

