/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.opt.lp;

import drasys.or.matrix.DenseVector;
import drasys.or.matrix.VectorI;
import drasys.or.opt.lp.ConvergenceException;
import drasys.or.opt.lp.DenseLPBase;
import drasys.or.opt.lp.LPError;
import drasys.or.opt.lp.NoSolutionException;
import drasys.or.opt.lp.ScaleException;
import drasys.or.opt.lp.UnboundedException;

public class DenseSimplex
extends DenseLPBase {
    private int _sizeOfLess;
    private int _sizeOfEqual;
    private int _sizeOfGreater;
    private int[] _rhv;
    private int[] _lhv;
    private double _sign;
    private double[][] _eqn;
    private byte[] _types;

    public DenseSimplex() {
    }

    public DenseSimplex(int n, int n2) {
        super(n, n2);
    }

    public double getObjectiveValue() {
        if (!this._solved) {
            throw new LPError("The model has not been solved");
        }
        return this._sign * this._eqn[1][1];
    }

    public VectorI getSolution() {
        if (!this._solved) {
            throw new LPError("The model has not been solved");
        }
        DenseVector denseVector = new DenseVector(this._sizeOfColumns);
        int n = 1;
        while (n <= this._sizeOfRows) {
            int n2 = this._lhv[n];
            if (n2 <= this._sizeOfColumns) {
                denseVector.setElementAt(n2 - 1, this._eqn[n + 1][1]);
            }
            ++n;
        }
        return denseVector;
    }

    public double maximize() throws NoSolutionException, UnboundedException, ConvergenceException, ScaleException {
        this._sign = 1.0;
        return this.solve();
    }

    public double minimize() throws NoSolutionException, UnboundedException, ConvergenceException, ScaleException {
        this._sign = -1.0;
        return this.solve();
    }

    public void setAutomaticScaling(boolean bl) {
        this._autoScale = false;
    }

    private void simplex() throws NoSolutionException, UnboundedException, ConvergenceException {
        int n;
        double d;
        double d2;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        n10 = this._sizeOfColumns;
        int[] nArray = new int[this._sizeOfColumns + 2];
        n7 = 1;
        while (n7 <= this._sizeOfColumns) {
            nArray[n7] = this._rhv[n7] = n7;
            ++n7;
        }
        n11 = this._sizeOfRows;
        int[] nArray2 = new int[this._sizeOfRows + 1];
        n4 = 1;
        while (n4 <= this._sizeOfRows) {
            if (this._eqn[n4 + 1][1] < 0.0) {
                throw new LPError("RHS less than zero");
            }
            nArray2[n4] = n4;
            this._lhv[n4] = this._sizeOfColumns + n4;
            ++n4;
        }
        double[] dArray = this._eqn[1];
        double[] dArray2 = this._eqn[this._sizeOfRows + 2];
        boolean[] blArray = new boolean[this._sizeOfRows + 1];
        n4 = 1;
        while (n4 <= this._sizeOfGreater) {
            blArray[n4] = true;
            ++n4;
        }
        boolean bl = false;
        if (this._sizeOfGreater + this._sizeOfEqual != 0) {
            bl = true;
            n7 = 1;
            while (n7 <= this._sizeOfColumns + 1) {
                d3 = 0.0;
                n4 = this._sizeOfLess + 1;
                while (n4 <= this._sizeOfRows) {
                    d3 += this._eqn[n4 + 1][n7];
                    ++n4;
                }
                dArray2[n7] = -d3;
                ++n7;
            }
            n3 = 0;
            do {
                int n12;
                int n13;
                block66: {
                    int n14;
                    if (n3++ >= this._maxIt) {
                        throw new ConvergenceException("Phase 1 didn't converge after " + (n3 - 1) + " iterations.");
                    }
                    n9 = nArray[1];
                    d4 = dArray2[n9 + 1];
                    n2 = 2;
                    while (n2 <= n10) {
                        n14 = nArray[n2];
                        d2 = dArray2[n14 + 1];
                        if (d2 > d4) {
                            d4 = d2;
                            n9 = n14;
                        }
                        ++n2;
                    }
                    if (d4 <= this._fuzz && dArray2[1] < -this._fuzz) {
                        throw new NoSolutionException();
                    }
                    if (d4 <= this._fuzz && dArray2[1] <= this._fuzz) {
                        n14 = this._sizeOfLess + this._sizeOfGreater + 1;
                        if (n14 <= this._sizeOfRows) {
                            n5 = n14;
                            while (n5 <= this._sizeOfRows) {
                                if (this._lhv[n5] == n5 + this._sizeOfColumns) {
                                    n9 = nArray[1];
                                    double[] dArray3 = this._eqn[n5 + 1];
                                    d = dArray3[n9 + 1];
                                    n13 = 2;
                                    while (n13 <= n10) {
                                        n12 = nArray[n13];
                                        double d5 = dArray3[n12 + 1];
                                        if (Math.abs(d5) > Math.abs(d)) {
                                            d4 = d5;
                                            n9 = n12;
                                        }
                                        ++n13;
                                    }
                                    if (d4 > 0.0) break block66;
                                }
                                ++n5;
                            }
                        }
                        bl = false;
                        if (this._sizeOfLess + 1 > --n14) break;
                        n4 = this._sizeOfLess + 1;
                        while (n4 <= n14) {
                            double[] dArray4 = this._eqn[n4 + 1];
                            if (blArray[n4 - this._sizeOfLess]) {
                                n7 = 1;
                                while (n7 <= this._sizeOfColumns + 1) {
                                    dArray4[n7] = -dArray4[n7];
                                    ++n7;
                                }
                            }
                            ++n4;
                        }
                        break;
                    }
                    double d6 = 0.0;
                    d = 0.0;
                    n5 = 0;
                    int n15 = 1;
                    while (n15 <= n11) {
                        int n16 = nArray2[n15];
                        double[] dArray5 = this._eqn[n16 + 1];
                        if (dArray5[n9 + 1] < -this._fuzz) {
                            d3 = -dArray5[1] / dArray5[n9 + 1];
                            n5 = n16;
                            ++n15;
                            while (n15 <= n11) {
                                n16 = nArray2[n15];
                                dArray5 = this._eqn[n16 + 1];
                                if (dArray5[n9 + 1] < -this._fuzz) {
                                    double d7 = -dArray5[1] / dArray5[n9 + 1];
                                    if (d7 < d3) {
                                        n5 = n16;
                                        d3 = d7;
                                    } else if (d7 == d3) {
                                        double[] dArray6 = this._eqn[n5 + 1];
                                        n = 1;
                                        while (n <= this._sizeOfColumns) {
                                            d = -dArray5[n + 1] / dArray5[n9 + 1];
                                            d6 = -dArray6[n + 1] / dArray6[n9 + 1];
                                            if (d != d6) break;
                                            ++n;
                                        }
                                        if (d < d6) {
                                            n5 = n16;
                                        }
                                    }
                                }
                                ++n15;
                            }
                        }
                        ++n15;
                    }
                    if (n5 == 0) {
                        throw new UnboundedException();
                    }
                }
                double[] dArray7 = this._eqn[n5 + 1];
                d2 = 1.0 / dArray7[n9 + 1];
                int n17 = 1;
                while (n17 <= this._sizeOfRows + 2) {
                    if (n17 - 1 != n5) {
                        double[] dArray8 = this._eqn[n17];
                        int n18 = n9 + 1;
                        dArray8[n18] = dArray8[n18] * d2;
                        n12 = 1;
                        while (n12 <= this._sizeOfColumns + 1) {
                            if (n12 - 1 != n9) {
                                int n19 = n12;
                                dArray8[n19] = dArray8[n19] - dArray7[n12] * dArray8[n9 + 1];
                            }
                            ++n12;
                        }
                    }
                    ++n17;
                }
                n13 = 1;
                while (n13 <= this._sizeOfColumns + 1) {
                    if (n13 - 1 != n9) {
                        int n20 = n13;
                        dArray7[n20] = dArray7[n20] * -d2;
                    }
                    ++n13;
                }
                dArray7[n9 + 1] = d2;
                if (this._lhv[n5] >= this._sizeOfColumns + this._sizeOfLess + this._sizeOfGreater + 1) {
                    n7 = 1;
                    while (n7 <= n10) {
                        if (nArray[n7] == n9) break;
                        ++n7;
                    }
                    --n10;
                    n6 = n7;
                    while (n6 <= n10) {
                        nArray[n6] = nArray[n6 + 1];
                        ++n6;
                    }
                    int n21 = n9 + 1;
                    dArray2[n21] = dArray2[n21] + 1.0;
                    n4 = 1;
                    while (n4 <= this._sizeOfRows + 2) {
                        this._eqn[n4][n9 + 1] = -this._eqn[n4][n9 + 1];
                        ++n4;
                    }
                } else if (this._lhv[n5] >= this._sizeOfColumns + this._sizeOfLess + 1 && blArray[n8 = this._lhv[n5] - this._sizeOfLess - this._sizeOfColumns]) {
                    blArray[n8] = false;
                    int n22 = n9 + 1;
                    dArray2[n22] = dArray2[n22] + 1.0;
                    n4 = 1;
                    while (n4 <= this._sizeOfRows + 2) {
                        this._eqn[n4][n9 + 1] = -this._eqn[n4][n9 + 1];
                        ++n4;
                    }
                }
                n6 = this._rhv[n9];
                this._rhv[n9] = this._lhv[n5];
                this._lhv[n5] = n6;
            } while (bl);
        }
        n3 = 0;
        while (true) {
            if (n3++ >= this._maxIt) {
                throw new ConvergenceException("Phase 2 didn't converge after " + (n3 - 1) + " iterations.");
            }
            n9 = nArray[1];
            d4 = dArray[n9 + 1];
            n2 = 2;
            while (n2 <= n10) {
                int n23 = nArray[n2];
                d2 = dArray[n23 + 1];
                if (d2 > d4) {
                    d4 = d2;
                    n9 = n23;
                }
                ++n2;
            }
            if (d4 <= 0.0) {
                this._solved = true;
                return;
            }
            double d8 = 0.0;
            d = 0.0;
            n5 = 0;
            int n24 = 1;
            while (n24 <= n11) {
                int n25 = nArray2[n24];
                double[] dArray9 = this._eqn[n25 + 1];
                if (dArray9[n9 + 1] < -this._fuzz) {
                    d3 = -dArray9[1] / dArray9[n9 + 1];
                    n5 = nArray2[n24];
                    ++n24;
                    while (n24 <= n11) {
                        n25 = nArray2[n24];
                        dArray9 = this._eqn[n25 + 1];
                        if (dArray9[n9 + 1] < -this._fuzz) {
                            double d9 = -dArray9[1] / dArray9[n9 + 1];
                            if (d9 < d3) {
                                n5 = n25;
                                d3 = d9;
                            } else if (d9 == d3) {
                                int n26 = 1;
                                while (n26 <= this._sizeOfColumns) {
                                    d = -dArray9[n26 + 1] / dArray9[n9 + 1];
                                    double[] dArray10 = this._eqn[n5 + 1];
                                    d8 = -dArray10[n26 + 1] / dArray10[n9 + 1];
                                    if (d != d8) break;
                                    ++n26;
                                }
                                if (d < d8) {
                                    n5 = n25;
                                }
                            }
                        }
                        ++n24;
                    }
                }
                ++n24;
            }
            if (n5 == 0) {
                throw new UnboundedException();
            }
            double[] dArray11 = this._eqn[n5 + 1];
            double d10 = 1.0 / dArray11[n9 + 1];
            n = 1;
            while (n <= this._sizeOfRows + 1) {
                if (n - 1 != n5) {
                    double[] dArray12 = this._eqn[n];
                    int n27 = n9 + 1;
                    dArray12[n27] = dArray12[n27] * d10;
                    int n28 = 1;
                    while (n28 <= this._sizeOfColumns + 1) {
                        if (n28 - 1 != n9) {
                            int n29 = n28;
                            dArray12[n29] = dArray12[n29] - dArray11[n28] * dArray12[n9 + 1];
                        }
                        ++n28;
                    }
                }
                ++n;
            }
            int n30 = 1;
            while (n30 <= this._sizeOfColumns + 1) {
                if (n30 - 1 != n9) {
                    double[] dArray13 = this._eqn[n5 + 1];
                    int n31 = n30;
                    dArray13[n31] = dArray13[n31] * -d10;
                }
                ++n30;
            }
            this._eqn[n5 + 1][n9 + 1] = d10;
            n6 = this._rhv[n9];
            this._rhv[n9] = this._lhv[n5];
            this._lhv[n5] = n6;
        }
    }

    private double solve() throws NoSolutionException, UnboundedException, ConvergenceException, ScaleException {
        int n;
        int n2;
        int n3;
        this._solved = false;
        this._eqn = new double[this._sizeOfRows + 3][this._sizeOfColumns + 2];
        this._types = new byte[this._sizeOfRows];
        if (this._minAbsVal < this._minRange) {
            throw new ScaleException("Value: " + this._minAbsVal + " is below Range: " + this._minRange);
        }
        if (this._maxAbsVal > this._maxRange) {
            throw new ScaleException("Value: " + this._maxAbsVal + " is above Range: " + this._maxRange);
        }
        int n4 = 0;
        while (n4 < this._sizeOfRows) {
            n3 = 0;
            while (n3 < this._sizeOfColumns) {
                this._eqn[n4 + 2][n3 + 2] = -this._cof[n4][n3];
                ++n3;
            }
            ++n4;
        }
        n3 = 0;
        while (n3 < this._sizeOfRows) {
            this._eqn[n3 + 2][1] = this._rhs[n3];
            this._types[n3] = this._typ[n3];
            ++n3;
        }
        int n5 = 0;
        while (n5 < this._sizeOfColumns) {
            this._eqn[1][n5 + 2] = this._sign * this._obj[n5];
            ++n5;
        }
        int n6 = 0;
        while (n6 < this._sizeOfRows) {
            double[] dArray = this._eqn[n6 + 2];
            if (dArray[1] < 0.0) {
                n2 = 0;
                while (n2 < this._sizeOfColumns + 1) {
                    int n7 = n2 + 1;
                    dArray[n7] = dArray[n7] * -1.0;
                    ++n2;
                }
                n = this._types[n6];
                this._types[n6] = n == 0 ? 1 : (n == 1 ? 0 : 2);
            }
            ++n6;
        }
        int n8 = 2;
        this._sizeOfLess = 0;
        n2 = n8;
        while (n2 <= this._sizeOfRows + 1) {
            if (this._types[n2 - 2] == 0) {
                double[] dArray = this._eqn[n8];
                this._eqn[n8] = this._eqn[n2];
                this._eqn[n2] = dArray;
                byte by = this._types[n8 - 2];
                this._types[n8 - 2] = this._types[n2 - 2];
                this._types[n2 - 2] = by;
                ++n8;
                ++this._sizeOfLess;
            }
            ++n2;
        }
        this._sizeOfGreater = 0;
        n = n8;
        while (n <= this._sizeOfRows + 1) {
            if (this._types[n - 2] == 1) {
                double[] dArray = this._eqn[n8];
                this._eqn[n8] = this._eqn[n];
                this._eqn[n] = dArray;
                byte by = this._types[n8 - 2];
                this._types[n8 - 2] = this._types[n - 2];
                this._types[n - 2] = by;
                ++n8;
                ++this._sizeOfGreater;
            }
            ++n;
        }
        this._sizeOfEqual = this._sizeOfRows - this._sizeOfLess - this._sizeOfGreater;
        this._rhv = new int[this._sizeOfColumns + 2];
        this._lhv = new int[this._sizeOfRows + 3];
        this.simplex();
        return this.getObjectiveValue();
    }
}

