/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.opt.lp;

import drasys.or.InvalidArgumentError;
import drasys.or.matrix.MatrixI;
import drasys.or.matrix.VectorI;
import drasys.or.opt.lp.ConvergenceException;
import drasys.or.opt.lp.LPError;
import drasys.or.opt.lp.LinearProgrammingI;
import drasys.or.opt.lp.NoSolutionException;
import drasys.or.opt.lp.ScaleException;
import drasys.or.opt.lp.UnboundedException;
import java.io.Serializable;

public abstract class DenseLPBase
implements LinearProgrammingI,
Serializable {
    protected int _maxRows;
    protected int _sizeOfRows;
    protected int _sizeOfColumns;
    protected int _maxIt;
    protected int _nonZeroCnt;
    protected double _fuzz;
    protected double _minRange;
    protected double _maxRange;
    protected double _minAbsVal;
    protected double _maxAbsVal;
    protected byte[] _typ;
    protected double[] _obj;
    protected double[] _rhs;
    protected double[][] _cof;
    protected boolean _solved;
    protected boolean _autoScale;

    public DenseLPBase() {
        this.resize(0, 0);
        this._solved = false;
        this._autoScale = false;
        this._fuzz = 1.0E-6;
        this._minRange = 1.0E-4;
        this._maxRange = 100000.0;
    }

    public DenseLPBase(int n, int n2) {
        this.resize(n, n2);
        this._solved = false;
        this._autoScale = false;
        this._fuzz = 1.0E-6;
        this._minRange = 1.0E-4;
        this._maxRange = 100000.0;
    }

    public void addConstraint(MatrixI matrixI, VectorI vectorI, byte[] byArray) {
        if (matrixI.sizeOfRows() != vectorI.size()) {
            throw new InvalidArgumentError("The coefficient row size doesn't match the right hand side vector size");
        }
        if (matrixI.sizeOfRows() != byArray.length) {
            throw new InvalidArgumentError("The coefficient row size doesn't match the type array length");
        }
        this.ensureCapacity(this._sizeOfRows + matrixI.sizeOfRows(), this._sizeOfColumns);
        double[][] dArray = matrixI.getArray();
        double[] dArray2 = vectorI.getArray();
        int n = 0;
        while (n < dArray.length) {
            this.addConstraint(dArray[n], dArray2[n], byArray[n]);
            ++n;
        }
    }

    public void addConstraint(VectorI vectorI, double d, byte by) {
        if (this._maxRows <= this._sizeOfRows + 1) {
            this.ensureCapacity(Math.max(this._sizeOfRows * 2, 10), this._sizeOfColumns);
        }
        this.addConstraint(vectorI.getArray(), d, by);
    }

    private void addConstraint(double[] dArray, double d, byte by) {
        if (dArray.length != this._sizeOfColumns) {
            throw new InvalidArgumentError("The coefficient size doesn't match the number of columns");
        }
        if (by != 0 && by != 1 && by != 2) {
            throw new LPError("Bad equation type");
        }
        this._cof[this._sizeOfRows] = dArray;
        this._typ[this._sizeOfRows] = by;
        this._rhs[this._sizeOfRows] = d;
        ++this._sizeOfRows;
        this._solved = false;
        if (d != 0.0) {
            ++this._nonZeroCnt;
            this._minAbsVal = Math.min(this._minAbsVal, Math.abs(d));
            this._maxAbsVal = Math.max(this._maxAbsVal, Math.abs(d));
        }
        int n = 0;
        while (n < this._sizeOfColumns) {
            double d2 = dArray[n];
            if (d2 != 0.0) {
                ++this._nonZeroCnt;
                this._minAbsVal = Math.min(this._minAbsVal, Math.abs(d2));
                this._maxAbsVal = Math.max(this._maxAbsVal, Math.abs(d2));
            }
            ++n;
        }
    }

    public void ensureCapacity(int n, int n2) {
        double[][] dArray = new double[n][];
        if (this._cof != null) {
            int n3 = 0;
            while (n3 < this._sizeOfRows) {
                dArray[n3] = this._cof[n3];
                ++n3;
            }
        }
        this._cof = dArray;
        byte[] byArray = new byte[n];
        if (this._typ != null) {
            int n4 = 0;
            while (n4 < this._sizeOfRows) {
                byArray[n4] = this._typ[n4];
                ++n4;
            }
        }
        this._typ = byArray;
        double[] dArray2 = new double[n];
        if (this._rhs != null) {
            int n5 = 0;
            while (n5 < this._sizeOfRows) {
                dArray2[n5] = this._rhs[n5];
                ++n5;
            }
        }
        this._rhs = dArray2;
        this._maxRows = n;
    }

    public double getMaxAbsoluteValue() {
        if (this._sizeOfRows == 0) {
            throw new LPError("There are no constraints");
        }
        return this._maxAbsVal;
    }

    public double getMinAbsoluteValue() {
        if (this._sizeOfRows == 0) {
            throw new LPError("There are no constraints");
        }
        return this._minAbsVal;
    }

    public abstract double getObjectiveValue();

    public double getRangeMax() {
        return this._maxRange;
    }

    public double getRangeMin() {
        return this._minRange;
    }

    public abstract VectorI getSolution();

    public abstract double maximize() throws NoSolutionException, UnboundedException, ConvergenceException, ScaleException;

    public abstract double minimize() throws NoSolutionException, UnboundedException, ConvergenceException, ScaleException;

    public void removeAllElements() {
        this._typ = null;
        this._cof = null;
        this._obj = null;
        this._sizeOfRows = 0;
        this._solved = false;
        this._minAbsVal = Double.MAX_VALUE;
        this._maxAbsVal = Double.MIN_VALUE;
    }

    public void resize(int n, int n2) {
        this.removeAllElements();
        this._maxRows = n;
        this._sizeOfColumns = n2;
        this._maxIt = this._sizeOfColumns * 10;
    }

    public void setAutomaticScaling(boolean bl) {
        this._autoScale = bl;
    }

    public void setEqualityFuzz(double d) {
        this._fuzz = d;
    }

    public void setMaxIterations(int n) {
        this._maxIt = n;
    }

    public void setObjective(VectorI vectorI) {
        if (vectorI.size() != this._sizeOfColumns) {
            throw new InvalidArgumentError("The objective size must match the number of columns.");
        }
        this._obj = vectorI.getArray();
        this._solved = false;
        int n = 0;
        while (n < this._sizeOfColumns) {
            double d = this._obj[n];
            if (d != 0.0) {
                ++this._nonZeroCnt;
                this._minAbsVal = Math.min(this._minAbsVal, Math.abs(d));
                this._maxAbsVal = Math.max(this._maxAbsVal, Math.abs(d));
            }
            ++n;
        }
    }

    public void setRange(double d, double d2) {
        if (d < 0.0) {
            throw new LPError("MinAbsoluteValue must be greater than zero.");
        }
        if (d2 < 0.0) {
            throw new LPError("MaxAbsoluteValue must be greater than zero.");
        }
        if (d2 <= d) {
            throw new LPError("MaxAbsoluteValue must be greater than minAbsoluteValue.");
        }
        this._minRange = d;
        this._maxRange = d2;
        this._nonZeroCnt = 0;
    }
}

