/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.matrix.complex;

import drasys.or.Complex;
import drasys.or.matrix.complex.MatrixI;
import drasys.or.matrix.complex.MatrixReaderI;
import drasys.or.matrix.complex.SizableMatrixI;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;

public class SMFReader
extends BufferedReader
implements MatrixReaderI {
    int _nrow = 0;
    int _ncol = 0;
    boolean _haveSize = false;
    boolean _ignoreInvalid = false;

    public SMFReader(Reader reader) {
        super(reader);
    }

    public SMFReader(Reader reader, int n) {
        super(reader, n);
    }

    public int readMatrix(MatrixI matrixI) throws IOException {
        String string;
        int n = 0;
        boolean bl = false;
        Complex complex = new Complex();
        this._haveSize = false;
        while ((string = this.readLine()) != null) {
            int n2;
            int n3;
            String string2;
            String string3;
            String string4;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string5 = string4 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
            if (string4 == null || string4.charAt(0) == '#') continue;
            String string6 = string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
            if (string3 == null) continue;
            String string7 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
            String string8 = string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
            if (string7 == null) {
                if (bl) {
                    this._haveSize = true;
                    this._nrow = new Integer(string4);
                    this._ncol = new Integer(string3);
                    return n;
                }
                n3 = new Integer(string4);
                n2 = new Integer(string3);
                if (!(this._ignoreInvalid || n3 <= matrixI.sizeOfRows() && n2 <= matrixI.sizeOfColumns())) {
                    throw new ArrayIndexOutOfBoundsException("Invalid size.");
                }
            } else {
                n3 = new Integer(string4);
                n2 = new Integer(string3);
                complex.real = new Double(string7);
                double d = complex.imag = string2 == null ? 0.0 : new Double(string2);
                if (n3 >= matrixI.sizeOfRows() || n2 >= matrixI.sizeOfColumns()) {
                    if (this._ignoreInvalid) continue;
                    throw new ArrayIndexOutOfBoundsException("Invalid element index: " + n3 + ", " + n2);
                }
                matrixI.setElementAt(n3, n2, complex);
                ++n;
            }
            bl = true;
        }
        return n;
    }

    public int readMatrix(SizableMatrixI sizableMatrixI, boolean bl) throws IOException {
        String string;
        int n = 0;
        boolean bl2 = false;
        Complex complex = new Complex();
        if (this._haveSize) {
            bl2 = true;
            sizableMatrixI.setSize(this._nrow, this._ncol);
        }
        this._haveSize = false;
        while ((string = this.readLine()) != null) {
            int n2;
            int n3;
            String string2;
            String string3;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string4 = stringTokenizer.nextToken();
            if (string4 == null || string4.charAt(0) == '#') continue;
            String string5 = string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
            if (string3 == null) continue;
            String string6 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
            String string7 = string2 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
            if (string6 == null) {
                if (bl2) {
                    this._haveSize = true;
                    this._nrow = new Integer(string4);
                    this._ncol = new Integer(string3);
                    return n;
                }
                n3 = new Integer(string4);
                n2 = new Integer(string3);
                if (bl) {
                    sizableMatrixI.setSize(n3, n2);
                } else if (!(this._ignoreInvalid || n3 <= sizableMatrixI.sizeOfRows() && n2 <= sizableMatrixI.sizeOfColumns())) {
                    throw new ArrayIndexOutOfBoundsException("Invalid size.");
                }
            } else {
                n3 = new Integer(string4);
                n2 = new Integer(string3);
                complex.real = new Double(string6);
                double d = complex.imag = string2 == null ? 0.0 : new Double(string2);
                if (n3 >= sizableMatrixI.sizeOfRows() || n2 >= sizableMatrixI.sizeOfColumns()) {
                    if (this._ignoreInvalid) continue;
                    throw new ArrayIndexOutOfBoundsException("Invalid element index: " + n3 + ", " + n2);
                }
                sizableMatrixI.setElementAt(n3, n2, complex);
                ++n;
            }
            bl2 = true;
        }
        return n;
    }

    public void setIgnoreInvalid(boolean bl) {
        this._ignoreInvalid = bl;
    }
}

