/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.matrix;

import drasys.or.matrix.Matrix;
import drasys.or.matrix.MatrixI;

public abstract class FunctionMatrix
extends Matrix
implements MatrixI {
    protected int _sizeOfRows = 0;
    protected int _sizeOfColumns = 0;

    public double elementAt(int n, int n2) {
        if (n < 0 || n >= this._sizeOfRows) {
            throw new IndexOutOfBoundsException("Row=" + n + ", sizeOfRows=" + this._sizeOfRows);
        }
        if (n2 < 0 || n2 >= this._sizeOfColumns) {
            throw new IndexOutOfBoundsException("Column=" + n2 + ", sizeOfColumns=" + this._sizeOfColumns);
        }
        return this.functionElementAt(n, n2);
    }

    public abstract double functionElementAt(int var1, int var2);

    public boolean isColumnMajor() {
        return false;
    }

    public boolean isNull(int n, int n2) {
        return false;
    }

    public boolean isRowMajor() {
        return false;
    }

    public void setElementAt(int n, int n2, double d) {
        throw new Error("Can't set an element in a 'FunctionMatrix'");
    }

    public void setElements(double d) {
        throw new Error("Can't set the elements of a 'FunctionMAtrix'.");
    }

    public int sizeOfColumns() {
        return this._sizeOfColumns;
    }

    public int sizeOfElements() {
        int n = this._sizeOfRows * this._sizeOfColumns;
        return n;
    }

    public int sizeOfRows() {
        return this._sizeOfRows;
    }
}

