/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.linear.blas;

import drasys.or.Complex;
import drasys.or.ComplexI;
import drasys.or.linear.blas.BLAS1I;
import drasys.or.linear.blas.BlasException;
import drasys.or.linear.blas.SmpBLAS1;
import drasys.or.matrix.ContiguousVectorI;

public class VectorBLAS1 {
    int _base = 0;
    BLAS1I _blas1;

    public VectorBLAS1() {
        this._blas1 = new SmpBLAS1();
    }

    public VectorBLAS1(int n) {
        this._base = n;
        this._blas1 = new SmpBLAS1();
    }

    public VectorBLAS1(int n, BLAS1I bLAS1I) {
        this._base = n;
        this._blas1 = bLAS1I;
    }

    public double dasum(ContiguousVectorI contiguousVectorI) throws BlasException {
        int n = contiguousVectorI.getIncrement();
        return this._blas1.dasum(contiguousVectorI.size() - this._base, contiguousVectorI.getValueArray(), this._base * n, n);
    }

    public void daxpy(double d, ContiguousVectorI contiguousVectorI, ContiguousVectorI contiguousVectorI2) throws BlasException {
        int n = contiguousVectorI.getIncrement();
        int n2 = contiguousVectorI2.getIncrement();
        if (contiguousVectorI.size() != contiguousVectorI2.size()) {
            throw new BlasException("X and Y must be the same size.");
        }
        this._blas1.daxpy(contiguousVectorI.size() - this._base, d, contiguousVectorI.getValueArray(), this._base * n, n, contiguousVectorI2.getValueArray(), this._base * n2, n2);
    }

    public void dcopy(ContiguousVectorI contiguousVectorI, ContiguousVectorI contiguousVectorI2) throws BlasException {
        int n = contiguousVectorI.getIncrement();
        int n2 = contiguousVectorI2.getIncrement();
        if (contiguousVectorI.size() != contiguousVectorI2.size()) {
            throw new BlasException("X and Y must be the same size.");
        }
        this._blas1.dcopy(contiguousVectorI.size() - this._base, contiguousVectorI.getValueArray(), this._base * n, n, contiguousVectorI2.getValueArray(), this._base * n2, n2);
    }

    public double ddot(ContiguousVectorI contiguousVectorI, ContiguousVectorI contiguousVectorI2) throws BlasException {
        int n = contiguousVectorI.getIncrement();
        int n2 = contiguousVectorI2.getIncrement();
        if (contiguousVectorI.size() != contiguousVectorI2.size()) {
            throw new BlasException("X and Y must be the same size.");
        }
        return this._blas1.ddot(contiguousVectorI.size() - this._base, contiguousVectorI.getValueArray(), this._base * n, n, contiguousVectorI2.getValueArray(), this._base * n2, n2);
    }

    public double dnrm2(ContiguousVectorI contiguousVectorI) throws BlasException {
        int n = contiguousVectorI.getIncrement();
        return this._blas1.dnrm2(contiguousVectorI.size() - this._base, contiguousVectorI.getValueArray(), this._base * n, n);
    }

    public void drot(ContiguousVectorI contiguousVectorI, ContiguousVectorI contiguousVectorI2, double d, double d2) throws BlasException {
        int n = contiguousVectorI.getIncrement();
        int n2 = contiguousVectorI2.getIncrement();
        if (contiguousVectorI.size() != contiguousVectorI2.size()) {
            throw new BlasException("X and Y must be the same size.");
        }
        this._blas1.drot(contiguousVectorI.size() - this._base, contiguousVectorI.getValueArray(), this._base * n, n, contiguousVectorI2.getValueArray(), this._base * n2, n2, d, d2);
    }

    public void dscal(double d, ContiguousVectorI contiguousVectorI) throws BlasException {
        int n = contiguousVectorI.getIncrement();
        this._blas1.dscal(contiguousVectorI.size() - this._base, d, contiguousVectorI.getValueArray(), this._base * n, n);
    }

    public void dswap(ContiguousVectorI contiguousVectorI, ContiguousVectorI contiguousVectorI2) throws BlasException {
        int n = contiguousVectorI.getIncrement();
        int n2 = contiguousVectorI2.getIncrement();
        if (contiguousVectorI.size() != contiguousVectorI2.size()) {
            throw new BlasException("X and Y must be the same size.");
        }
        this._blas1.dswap(contiguousVectorI.size() - this._base, contiguousVectorI.getValueArray(), this._base * n, n, contiguousVectorI2.getValueArray(), this._base * n2, n2);
    }

    public int idamax(ContiguousVectorI contiguousVectorI) throws BlasException {
        int n = contiguousVectorI.getIncrement();
        return this._base + this._blas1.idamax(contiguousVectorI.size() - this._base, contiguousVectorI.getValueArray(), this._base * n, n);
    }

    public void zaxpy(ComplexI complexI, drasys.or.matrix.complex.ContiguousVectorI contiguousVectorI, drasys.or.matrix.complex.ContiguousVectorI contiguousVectorI2) throws BlasException {
        int n = contiguousVectorI.getIncrement();
        int n2 = contiguousVectorI2.getIncrement();
        if (contiguousVectorI.size() != contiguousVectorI2.size()) {
            throw new BlasException("X and Y must be the same size.");
        }
        this._blas1.zaxpy(contiguousVectorI.size() - this._base, complexI, contiguousVectorI.getValueArray(), this._base * n, n, contiguousVectorI2.getValueArray(), this._base * n2, n2);
    }

    public void zcopy(drasys.or.matrix.complex.ContiguousVectorI contiguousVectorI, drasys.or.matrix.complex.ContiguousVectorI contiguousVectorI2) throws BlasException {
        int n = contiguousVectorI.getIncrement();
        int n2 = contiguousVectorI2.getIncrement();
        if (contiguousVectorI.size() != contiguousVectorI2.size()) {
            throw new BlasException("X and Y must be the same size.");
        }
        this._blas1.zcopy(contiguousVectorI.size() - this._base, contiguousVectorI.getValueArray(), this._base * n, n, contiguousVectorI2.getValueArray(), this._base * n2, n2);
    }

    public Complex zdotc(drasys.or.matrix.complex.ContiguousVectorI contiguousVectorI, drasys.or.matrix.complex.ContiguousVectorI contiguousVectorI2, Complex complex) throws BlasException {
        int n = contiguousVectorI.getIncrement();
        int n2 = contiguousVectorI2.getIncrement();
        if (contiguousVectorI.size() != contiguousVectorI2.size()) {
            throw new BlasException("X and Y must be the same size.");
        }
        return this._blas1.zdotc(contiguousVectorI.size() - this._base, contiguousVectorI.getValueArray(), this._base * n, n, contiguousVectorI2.getValueArray(), this._base * n2, n2, complex);
    }

    public Complex zdotu(drasys.or.matrix.complex.ContiguousVectorI contiguousVectorI, drasys.or.matrix.complex.ContiguousVectorI contiguousVectorI2, Complex complex) throws BlasException {
        int n = contiguousVectorI.getIncrement();
        int n2 = contiguousVectorI2.getIncrement();
        if (contiguousVectorI.size() != contiguousVectorI2.size()) {
            throw new BlasException("X and Y must be the same size.");
        }
        return this._blas1.zdotu(contiguousVectorI.size() - this._base, contiguousVectorI.getValueArray(), this._base * n, n, contiguousVectorI2.getValueArray(), this._base * n2, n2, complex);
    }

    public void zscal(ComplexI complexI, drasys.or.matrix.complex.ContiguousVectorI contiguousVectorI) throws BlasException {
        int n = contiguousVectorI.getIncrement();
        this._blas1.zscal(contiguousVectorI.size() - this._base, complexI, contiguousVectorI.getValueArray(), this._base * n, n);
    }

    public void zswap(drasys.or.matrix.complex.ContiguousVectorI contiguousVectorI, drasys.or.matrix.complex.ContiguousVectorI contiguousVectorI2) throws BlasException {
        int n = contiguousVectorI.getIncrement();
        int n2 = contiguousVectorI2.getIncrement();
        if (contiguousVectorI.size() != contiguousVectorI2.size()) {
            throw new BlasException("X and Y must be the same size.");
        }
        this._blas1.zswap(contiguousVectorI.size() - this._base, contiguousVectorI.getValueArray(), this._base * n, n, contiguousVectorI2.getValueArray(), this._base * n2, n2);
    }
}

