/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.linear.blas;

import drasys.or.ComplexI;
import drasys.or.linear.blas.BLAS2I;
import drasys.or.linear.blas.BlasException;
import drasys.or.linear.blas.SmpBLAS2;
import drasys.or.matrix.ContiguousMatrixI;
import drasys.or.matrix.ContiguousVectorI;

public class MatrixBLAS2 {
    int _base = 0;
    BLAS2I _blas2;

    public MatrixBLAS2() {
        this._blas2 = new SmpBLAS2();
    }

    public MatrixBLAS2(int n) {
        this._base = n;
        this._blas2 = new SmpBLAS2();
    }

    public MatrixBLAS2(int n, BLAS2I bLAS2I) {
        this._base = n;
        this._blas2 = bLAS2I;
    }

    public void dgemv(boolean bl, double d, ContiguousMatrixI contiguousMatrixI, ContiguousVectorI contiguousVectorI, double d2, ContiguousVectorI contiguousVectorI2) throws BlasException {
        int n = bl ? contiguousMatrixI.sizeOfColumns() : contiguousMatrixI.sizeOfRows();
        int n2 = bl ? contiguousMatrixI.sizeOfRows() : contiguousMatrixI.sizeOfColumns();
        int n3 = bl ? contiguousMatrixI.getColumnIncrement() : contiguousMatrixI.getRowIncrement();
        int n4 = bl ? contiguousMatrixI.getRowIncrement() : contiguousMatrixI.getColumnIncrement();
        int n5 = contiguousVectorI.getIncrement();
        int n6 = contiguousVectorI2.getIncrement();
        this._blas2.dgemv(n - this._base, n2 - this._base, d, contiguousMatrixI.getValueArray(), this._base * (n3 + n4), n3, n4, contiguousVectorI.getValueArray(), this._base * n5, n5, d2, contiguousVectorI2.getValueArray(), this._base * n6, n6);
    }

    public void dger(double d, ContiguousVectorI contiguousVectorI, ContiguousVectorI contiguousVectorI2, ContiguousMatrixI contiguousMatrixI) throws BlasException {
        int n = contiguousMatrixI.getRowIncrement();
        int n2 = contiguousMatrixI.getColumnIncrement();
        int n3 = contiguousVectorI.getIncrement();
        int n4 = contiguousVectorI2.getIncrement();
        this._blas2.dger(contiguousMatrixI.sizeOfRows() - this._base, contiguousMatrixI.sizeOfColumns() - this._base, d, contiguousVectorI.getValueArray(), this._base * n3, n3, contiguousVectorI2.getValueArray(), this._base * n4, n4, contiguousMatrixI.getValueArray(), this._base * (n + n2), n, n2);
    }

    public void zgemv(boolean bl, ComplexI complexI, drasys.or.matrix.complex.ContiguousMatrixI contiguousMatrixI, drasys.or.matrix.complex.ContiguousVectorI contiguousVectorI, ComplexI complexI2, drasys.or.matrix.complex.ContiguousVectorI contiguousVectorI2) throws BlasException {
        int n = bl ? contiguousMatrixI.sizeOfColumns() : contiguousMatrixI.sizeOfRows();
        int n2 = bl ? contiguousMatrixI.sizeOfRows() : contiguousMatrixI.sizeOfColumns();
        int n3 = bl ? contiguousMatrixI.getColumnIncrement() : contiguousMatrixI.getRowIncrement();
        int n4 = bl ? contiguousMatrixI.getRowIncrement() : contiguousMatrixI.getColumnIncrement();
        int n5 = contiguousVectorI.getIncrement();
        int n6 = contiguousVectorI2.getIncrement();
        this._blas2.zgemv(n - this._base, n2 - this._base, complexI, contiguousMatrixI.getValueArray(), this._base * (n3 + n4), n3, n4, contiguousVectorI.getValueArray(), this._base * n5, n5, complexI2, contiguousVectorI2.getValueArray(), this._base * n6, n6);
    }

    public void zgerc(ComplexI complexI, drasys.or.matrix.complex.ContiguousVectorI contiguousVectorI, drasys.or.matrix.complex.ContiguousVectorI contiguousVectorI2, drasys.or.matrix.complex.ContiguousMatrixI contiguousMatrixI) throws BlasException {
        int n = contiguousMatrixI.getRowIncrement();
        int n2 = contiguousMatrixI.getColumnIncrement();
        int n3 = contiguousVectorI.getIncrement();
        int n4 = contiguousVectorI2.getIncrement();
        this._blas2.zgerc(contiguousMatrixI.sizeOfRows() - this._base, contiguousMatrixI.sizeOfColumns() - this._base, complexI, contiguousVectorI.getValueArray(), this._base * n3, n3, contiguousVectorI2.getValueArray(), this._base * n4, n4, contiguousMatrixI.getValueArray(), this._base * (n + n2), n, n2);
    }

    public void zgeru(ComplexI complexI, drasys.or.matrix.complex.ContiguousVectorI contiguousVectorI, drasys.or.matrix.complex.ContiguousVectorI contiguousVectorI2, drasys.or.matrix.complex.ContiguousMatrixI contiguousMatrixI) throws BlasException {
        int n = contiguousMatrixI.getRowIncrement();
        int n2 = contiguousMatrixI.getColumnIncrement();
        int n3 = contiguousVectorI.getIncrement();
        int n4 = contiguousVectorI2.getIncrement();
        this._blas2.zgeru(contiguousMatrixI.sizeOfRows() - this._base, contiguousMatrixI.sizeOfColumns() - this._base, complexI, contiguousVectorI.getValueArray(), this._base * n3, n3, contiguousVectorI2.getValueArray(), this._base * n4, n4, contiguousMatrixI.getValueArray(), this._base * (n + n2), n, n2);
    }
}

