/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.linear.algebra;

import drasys.or.linear.algebra.AlgebraException;
import drasys.or.linear.algebra.AlgebraI;
import drasys.or.linear.algebra.QRIteration;
import drasys.or.linear.blas.BlasException;
import drasys.or.linear.blas.MatrixBLAS2;
import drasys.or.linear.blas.MatrixBLAS3;
import drasys.or.linear.blas.VectorBLAS1;
import drasys.or.matrix.ContiguousMatrixI;
import drasys.or.matrix.ContiguousVectorI;
import drasys.or.matrix.DenseMatrix;
import drasys.or.matrix.DenseVector;
import drasys.or.matrix.MatrixElementI;
import drasys.or.matrix.MatrixI;
import drasys.or.matrix.VectorElementI;
import drasys.or.matrix.VectorI;
import java.io.Serializable;
import java.util.Enumeration;

public class Algebra
implements AlgebraI,
Serializable {
    private static VectorBLAS1 _blas1 = null;
    private static MatrixBLAS2 _blas2 = null;
    private static MatrixBLAS3 _blas3 = null;

    public Algebra() {
        _blas1 = new VectorBLAS1();
        _blas2 = new MatrixBLAS2();
        _blas3 = new MatrixBLAS3();
    }

    public Algebra(VectorBLAS1 vectorBLAS1, MatrixBLAS2 matrixBLAS2, MatrixBLAS3 matrixBLAS3) {
    }

    public DenseMatrix add(MatrixI matrixI, MatrixI matrixI2) throws AlgebraException {
        DenseMatrix denseMatrix;
        int n = matrixI.sizeOfRows();
        if (n != matrixI2.sizeOfRows()) {
            throw new AlgebraException("The row sizes don't match.");
        }
        int n2 = matrixI.sizeOfColumns();
        if (n2 != matrixI2.sizeOfColumns()) {
            throw new AlgebraException("The column sizes don't match.");
        }
        if (matrixI.sizeOfElements() < matrixI2.sizeOfElements()) {
            denseMatrix = new DenseMatrix(matrixI2);
            Enumeration enumeration = matrixI.elements();
            while (enumeration.hasMoreElements()) {
                MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
                double d = denseMatrix.elementAt(matrixElementI.getRowIndex(), matrixElementI.getColumnIndex());
                denseMatrix.setElementAt(matrixElementI.getRowIndex(), matrixElementI.getColumnIndex(), d + matrixElementI.getValue());
            }
        } else {
            denseMatrix = new DenseMatrix(matrixI);
            Enumeration enumeration = matrixI2.elements();
            while (enumeration.hasMoreElements()) {
                MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
                double d = denseMatrix.elementAt(matrixElementI.getRowIndex(), matrixElementI.getColumnIndex());
                denseMatrix.setElementAt(matrixElementI.getRowIndex(), matrixElementI.getColumnIndex(), d + matrixElementI.getValue());
            }
        }
        return denseMatrix;
    }

    public DenseVector add(VectorI vectorI, VectorI vectorI2) throws AlgebraException {
        DenseVector denseVector;
        int n = vectorI.size();
        if (n != vectorI2.size()) {
            throw new AlgebraException("The sizes don't match.");
        }
        if (_blas1 != null && vectorI instanceof ContiguousVectorI && vectorI2 instanceof ContiguousVectorI) {
            denseVector = new DenseVector(vectorI);
            try {
                _blas1.daxpy(1.0, (ContiguousVectorI)vectorI2, denseVector);
            }
            catch (BlasException blasException) {
                throw new AlgebraException("BLAS3:" + blasException.getMessage());
            }
        } else if (vectorI.sizeOfElements() < vectorI2.sizeOfElements()) {
            denseVector = new DenseVector(vectorI2);
            Enumeration enumeration = vectorI.elements();
            while (enumeration.hasMoreElements()) {
                VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
                double d = denseVector.elementAt(vectorElementI.getIndex());
                denseVector.setElementAt(vectorElementI.getIndex(), d + vectorElementI.getValue());
            }
        } else {
            denseVector = new DenseVector(vectorI);
            Enumeration enumeration = vectorI2.elements();
            while (enumeration.hasMoreElements()) {
                VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
                double d = denseVector.elementAt(vectorElementI.getIndex());
                denseVector.setElementAt(vectorElementI.getIndex(), d + vectorElementI.getValue());
            }
        }
        return denseVector;
    }

    public DenseMatrix invert(MatrixI matrixI) throws AlgebraException {
        if (matrixI.sizeOfRows() != matrixI.sizeOfColumns()) {
            throw new AlgebraException("Can't invert a matrix that isn't square.");
        }
        QRIteration qRIteration = new QRIteration();
        qRIteration.decompose(matrixI);
        DenseMatrix denseMatrix = new DenseMatrix(matrixI.sizeOfRows(), matrixI.sizeOfColumns());
        qRIteration.computeInverse(denseMatrix);
        return denseMatrix;
    }

    public DenseMatrix matrixProduct(VectorI vectorI, VectorI vectorI2) throws AlgebraException {
        if (vectorI.size() != vectorI2.size()) {
            throw new AlgebraException("Can't multiply vectors of different sizes.");
        }
        int n = vectorI2.size();
        DenseMatrix denseMatrix = new DenseMatrix(n, n);
        if (_blas2 != null && vectorI instanceof ContiguousVectorI && vectorI2 instanceof ContiguousVectorI) {
            try {
                _blas2.dger(1.0, (ContiguousVectorI)vectorI, (ContiguousVectorI)vectorI2, denseMatrix);
            }
            catch (BlasException blasException) {
                throw new AlgebraException("BLAS3:" + blasException.getMessage());
            }
        } else {
            Enumeration enumeration = vectorI.elements();
            while (enumeration.hasMoreElements()) {
                VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
                int n2 = vectorElementI.getIndex();
                double d = vectorElementI.getValue();
                Enumeration enumeration2 = vectorI2.elements();
                while (enumeration2.hasMoreElements()) {
                    VectorElementI vectorElementI2 = (VectorElementI)enumeration2.nextElement();
                    denseMatrix.setElementAt(n2, vectorElementI2.getIndex(), vectorElementI2.getValue() * d);
                }
            }
        }
        return denseMatrix;
    }

    public DenseMatrix multiply(MatrixI matrixI, MatrixI matrixI2) throws AlgebraException {
        if (matrixI.sizeOfColumns() != matrixI2.sizeOfRows()) {
            throw new AlgebraException("Can't multiply matrices if the columns in the first matrix don't match the rows in the second.");
        }
        DenseMatrix denseMatrix = new DenseMatrix(matrixI.sizeOfRows(), matrixI2.sizeOfColumns());
        if (_blas3 != null && matrixI instanceof ContiguousMatrixI && matrixI2 instanceof ContiguousMatrixI) {
            try {
                _blas3.dgemm(false, false, 1.0, (ContiguousMatrixI)matrixI, (ContiguousMatrixI)matrixI2, 1.0, denseMatrix);
            }
            catch (BlasException blasException) {
                throw new AlgebraException("BLAS3:" + blasException.getMessage());
            }
        } else {
            int n = 0;
            while (n < matrixI.sizeOfRows()) {
                int n2 = 0;
                while (n2 < matrixI2.sizeOfColumns()) {
                    double d = 0.0;
                    int n3 = 0;
                    while (n3 < matrixI.sizeOfColumns()) {
                        d += matrixI.elementAt(n, n3) * matrixI2.elementAt(n3, n2);
                        ++n3;
                    }
                    denseMatrix.setElementAt(n, n2, d);
                    ++n2;
                }
                ++n;
            }
        }
        return denseMatrix;
    }

    public DenseVector multiply(MatrixI matrixI, VectorI vectorI) throws AlgebraException {
        if (matrixI.sizeOfColumns() != vectorI.size()) {
            throw new AlgebraException("The size of the column vector must match the number of columns in the matrix.");
        }
        DenseVector denseVector = new DenseVector(matrixI.sizeOfRows());
        if (_blas2 != null && vectorI instanceof ContiguousVectorI && matrixI instanceof ContiguousMatrixI) {
            try {
                _blas2.dgemv(false, 1.0, (ContiguousMatrixI)matrixI, (ContiguousVectorI)vectorI, 1.0, denseVector);
            }
            catch (BlasException blasException) {
                throw new AlgebraException("BLAS3:" + blasException.getMessage());
            }
        } else {
            int n = 0;
            while (n < matrixI.sizeOfRows()) {
                double d = 0.0;
                int n2 = 0;
                while (n2 < matrixI.sizeOfColumns()) {
                    d += matrixI.elementAt(n, n2) * vectorI.elementAt(n2);
                    ++n2;
                }
                denseVector.setElementAt(n, d);
                ++n;
            }
        }
        return denseVector;
    }

    public DenseVector multiply(VectorI vectorI, MatrixI matrixI) throws AlgebraException {
        if (matrixI.sizeOfRows() != vectorI.size()) {
            throw new AlgebraException("The size of the row vector must match the number of rows in the matrix.");
        }
        DenseVector denseVector = new DenseVector(matrixI.sizeOfColumns());
        if (_blas2 != null && vectorI instanceof ContiguousVectorI && matrixI instanceof ContiguousMatrixI) {
            try {
                _blas2.dgemv(true, 1.0, (ContiguousMatrixI)matrixI, (ContiguousVectorI)vectorI, 1.0, denseVector);
            }
            catch (BlasException blasException) {
                throw new AlgebraException("BLAS3:" + blasException.getMessage());
            }
        } else {
            int n = 0;
            while (n < matrixI.sizeOfColumns()) {
                double d = 0.0;
                int n2 = 0;
                while (n2 < matrixI.sizeOfRows()) {
                    d += matrixI.elementAt(n2, n) * vectorI.elementAt(n2);
                    ++n2;
                }
                denseVector.setElementAt(n, d);
                ++n;
            }
        }
        return denseVector;
    }

    public double scalerProduct(VectorI vectorI, VectorI vectorI2) throws AlgebraException {
        if (vectorI.size() != vectorI2.size()) {
            throw new AlgebraException("Can't multiply vectors of different sizes.");
        }
        double d = 0.0;
        if (_blas1 != null && vectorI instanceof ContiguousVectorI && vectorI2 instanceof ContiguousVectorI) {
            try {
                d = _blas1.ddot((ContiguousVectorI)vectorI, (ContiguousVectorI)vectorI2);
            }
            catch (BlasException blasException) {
                throw new AlgebraException("BLAS3:" + blasException.getMessage());
            }
        } else if (vectorI.sizeOfElements() < vectorI2.sizeOfElements()) {
            Enumeration enumeration = vectorI.elements();
            while (enumeration.hasMoreElements()) {
                VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
                d += vectorI2.elementAt(vectorElementI.getIndex()) * vectorElementI.getValue();
            }
        } else {
            Enumeration enumeration = vectorI2.elements();
            while (enumeration.hasMoreElements()) {
                VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
                d += vectorI.elementAt(vectorElementI.getIndex()) * vectorElementI.getValue();
            }
        }
        return d;
    }

    public DenseMatrix subtract(MatrixI matrixI, MatrixI matrixI2) throws AlgebraException {
        DenseMatrix denseMatrix;
        int n = matrixI.sizeOfRows();
        if (n != matrixI2.sizeOfRows()) {
            throw new AlgebraException("The row sizes don't match.");
        }
        int n2 = matrixI.sizeOfColumns();
        if (n2 != matrixI2.sizeOfColumns()) {
            throw new AlgebraException("The column sizes don't match.");
        }
        if (matrixI.sizeOfElements() < matrixI2.sizeOfElements()) {
            denseMatrix = new DenseMatrix(matrixI2);
            Enumeration enumeration = matrixI.elements();
            while (enumeration.hasMoreElements()) {
                MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
                double d = denseMatrix.elementAt(matrixElementI.getRowIndex(), matrixElementI.getColumnIndex());
                denseMatrix.setElementAt(matrixElementI.getRowIndex(), matrixElementI.getColumnIndex(), d - matrixElementI.getValue());
            }
        } else {
            denseMatrix = new DenseMatrix(matrixI);
            Enumeration enumeration = matrixI2.elements();
            while (enumeration.hasMoreElements()) {
                MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
                double d = denseMatrix.elementAt(matrixElementI.getRowIndex(), matrixElementI.getColumnIndex());
                denseMatrix.setElementAt(matrixElementI.getRowIndex(), matrixElementI.getColumnIndex(), d - matrixElementI.getValue());
            }
        }
        return denseMatrix;
    }

    public DenseVector subtract(VectorI vectorI, VectorI vectorI2) throws AlgebraException {
        DenseVector denseVector;
        int n = vectorI.size();
        if (n != vectorI2.size()) {
            throw new AlgebraException("The sizes don't match.");
        }
        if (_blas1 != null && vectorI instanceof ContiguousVectorI && vectorI2 instanceof ContiguousVectorI) {
            denseVector = new DenseVector(vectorI);
            try {
                _blas1.daxpy(-1.0, (ContiguousVectorI)vectorI2, denseVector);
            }
            catch (BlasException blasException) {
                throw new AlgebraException("BLAS3:" + blasException.getMessage());
            }
        } else if (vectorI.sizeOfElements() < vectorI2.sizeOfElements()) {
            denseVector = new DenseVector(vectorI2);
            Enumeration enumeration = vectorI.elements();
            while (enumeration.hasMoreElements()) {
                VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
                double d = denseVector.elementAt(vectorElementI.getIndex());
                denseVector.setElementAt(vectorElementI.getIndex(), d - vectorElementI.getValue());
            }
        } else {
            denseVector = new DenseVector(vectorI);
            Enumeration enumeration = vectorI2.elements();
            while (enumeration.hasMoreElements()) {
                VectorElementI vectorElementI = (VectorElementI)enumeration.nextElement();
                double d = denseVector.elementAt(vectorElementI.getIndex());
                denseVector.setElementAt(vectorElementI.getIndex(), d - vectorElementI.getValue());
            }
        }
        return denseVector;
    }

    public DenseMatrix transpose(MatrixI matrixI) {
        DenseMatrix denseMatrix = new DenseMatrix(matrixI.sizeOfColumns(), matrixI.sizeOfRows());
        Enumeration enumeration = matrixI.elements();
        while (enumeration.hasMoreElements()) {
            MatrixElementI matrixElementI = (MatrixElementI)enumeration.nextElement();
            denseMatrix.setElementAt(matrixElementI.getColumnIndex(), matrixElementI.getRowIndex(), matrixElementI.getValue());
        }
        return denseMatrix;
    }
}

