/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph.vrp;

import drasys.or.graph.GraphI;
import drasys.or.graph.PropertiesI;
import drasys.or.graph.tsp.ConstructI;
import drasys.or.graph.tsp.ConstructToImproveConverter;
import drasys.or.graph.tsp.TourNotFoundException;
import drasys.or.graph.vrp.ImproveBase;
import drasys.or.graph.vrp.ImproveI;
import drasys.or.graph.vrp.SolutionNotFoundException;
import drasys.or.graph.vrp.VRPBase;
import java.util.Vector;

public class ImproveWithTSP
extends ImproveBase
implements ImproveI {
    double _cost = 0.0;
    double[] _costs = null;
    Vector[] _tours = null;
    drasys.or.graph.tsp.ImproveI _improve = null;

    public ImproveWithTSP(ConstructI constructI) {
        this._improve = new ConstructToImproveConverter(constructI);
        this.setEdgeKey(this._edgeKey);
        this.setProperties(this._properties);
    }

    public ImproveWithTSP(drasys.or.graph.tsp.ImproveI improveI) {
        this._improve = improveI;
        this.setEdgeKey(this._edgeKey);
        this.setProperties(this._properties);
    }

    public double getCost() throws SolutionNotFoundException {
        if (this._tours == null) {
            throw new SolutionNotFoundException("No solution has been created");
        }
        return this._cost;
    }

    public double[] getCosts() throws SolutionNotFoundException {
        if (this._tours == null) {
            throw new SolutionNotFoundException("No solution has been created");
        }
        return this._costs;
    }

    public double[] getLoads() throws SolutionNotFoundException {
        if (this._tours == null) {
            throw new SolutionNotFoundException("No solution has been created");
        }
        return this.getLoads(this._tours);
    }

    public Vector[] getTours() throws SolutionNotFoundException {
        if (this._tours == null) {
            throw new SolutionNotFoundException("No solution has been created");
        }
        return VRPBase.copyTours(this._tours);
    }

    public double improveClosedTours(Vector[] vectorArray) throws SolutionNotFoundException {
        this._cost = 0.0;
        this._costs = new double[vectorArray.length];
        this._tours = null;
        Vector[] vectorArray2 = new Vector[vectorArray.length];
        if (this._graph == null) {
            throw new SolutionNotFoundException("The graph is not set");
        }
        int n = 0;
        while (n < vectorArray.length) {
            try {
                this._costs[n] = this._vehicleCost + this._improve.improveClosedTour(vectorArray[n]);
                this._cost += this._costs[n];
                vectorArray2[n] = this._improve.getTour();
            }
            catch (TourNotFoundException tourNotFoundException) {
                throw new SolutionNotFoundException("From TSP: " + tourNotFoundException.getMessage());
            }
            ++n;
        }
        this._tours = vectorArray2;
        return this.getCost();
    }

    public double improveInboundTours(Vector[] vectorArray) throws SolutionNotFoundException {
        this._cost = 0.0;
        this._costs = new double[vectorArray.length];
        this._tours = null;
        Vector[] vectorArray2 = new Vector[vectorArray.length];
        if (this._graph == null) {
            throw new SolutionNotFoundException("The graph is not set");
        }
        int n = 0;
        while (n < vectorArray.length) {
            try {
                this._costs[n] = this._vehicleCost + this._improve.improveOpenTour(vectorArray[n], false, true);
                this._cost += this._costs[n];
                vectorArray2[n] = this._improve.getTour();
            }
            catch (TourNotFoundException tourNotFoundException) {
                throw new SolutionNotFoundException("From TSP: " + tourNotFoundException.getMessage());
            }
            ++n;
        }
        this._tours = vectorArray2;
        return this.getCost();
    }

    public double improveOutboundTours(Vector[] vectorArray) throws SolutionNotFoundException {
        this._cost = 0.0;
        this._costs = new double[vectorArray.length];
        this._tours = null;
        Vector[] vectorArray2 = new Vector[vectorArray.length];
        if (this._graph == null) {
            throw new SolutionNotFoundException("The graph is not set");
        }
        int n = 0;
        while (n < vectorArray.length) {
            try {
                this._costs[n] = this._vehicleCost + this._improve.improveOpenTour(vectorArray[n], true, false);
                this._cost += this._costs[n];
                vectorArray2[n] = this._improve.getTour();
            }
            catch (TourNotFoundException tourNotFoundException) {
                throw new SolutionNotFoundException("From TSP: " + tourNotFoundException.getMessage());
            }
            ++n;
        }
        this._tours = vectorArray2;
        return this.getCost();
    }

    public void setEdgeKey(Object object) {
        super.setEdgeKey(object);
        this._improve.setEdgeKey(object);
    }

    public void setGraph(GraphI graphI) {
        super.setGraph(graphI);
        this._improve.setGraph(graphI);
    }

    public void setProperties(PropertiesI propertiesI) {
        if (this._improve != null) {
            this._improve.setProperties(propertiesI);
        }
    }
}

