/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph.vrp;

import drasys.or.graph.GraphI;
import drasys.or.graph.PropertiesI;
import drasys.or.graph.VertexNotFoundException;
import drasys.or.graph.vrp.ConstructI;
import drasys.or.graph.vrp.ImproveI;
import drasys.or.graph.vrp.RandomizableBase;
import drasys.or.graph.vrp.SolutionNotFoundException;
import java.util.Vector;

public class Composite
extends RandomizableBase
implements ConstructI {
    ImproveI _improve;
    ConstructI _construct;

    public Composite(ConstructI constructI, ImproveI improveI) {
        if (constructI == null) {
            throw new Error("The construction algorithm can not be null");
        }
        this._improve = improveI;
        this._construct = constructI;
    }

    public Composite(ConstructI constructI, ImproveI improveI, GraphI graphI) {
        if (constructI == null) {
            throw new Error("The construction algorithm can not be null");
        }
        if (graphI == null) {
            throw new Error("The graph can not be null");
        }
        this._improve = improveI;
        this._construct = constructI;
        this.setGraph(graphI);
    }

    public double constructClosedTours(Object object) throws SolutionNotFoundException, VertexNotFoundException {
        double d = this._construct.constructClosedTours(object);
        if (this._improve != null) {
            Vector[] vectorArray = this._construct.getTours();
            this._improve.improveClosedTours(vectorArray);
        }
        return d;
    }

    public double constructInboundTours(Object object) throws SolutionNotFoundException, VertexNotFoundException {
        double d = this._construct.constructInboundTours(object);
        if (this._improve != null) {
            Vector[] vectorArray = this._construct.getTours();
            d = this._improve.improveInboundTours(vectorArray);
        }
        return d;
    }

    public double constructOutboundTours(Object object) throws SolutionNotFoundException, VertexNotFoundException {
        double d = this._construct.constructOutboundTours(object);
        if (this._improve != null) {
            Vector[] vectorArray = this._construct.getTours();
            d = this._improve.improveOutboundTours(vectorArray);
        }
        return d;
    }

    public ConstructI getConstructAlgorithm() {
        return this._construct;
    }

    public double getCost() throws SolutionNotFoundException {
        return this._improve != null ? this._improve.getCost() : this._construct.getCost();
    }

    public double[] getCosts() throws SolutionNotFoundException {
        return this._improve != null ? this._improve.getCosts() : this._construct.getCosts();
    }

    public ImproveI getImproveAlgorithm() {
        return this._improve;
    }

    public double[] getLoads() throws SolutionNotFoundException {
        return this._improve != null ? this._improve.getLoads() : this._construct.getLoads();
    }

    public Vector[] getTours() throws SolutionNotFoundException {
        return this._improve != null ? this._improve.getTours() : this._construct.getTours();
    }

    public void selectVertex(Object object, boolean bl) throws VertexNotFoundException {
        this._construct.selectVertex(object, bl);
    }

    public void selectVertex(boolean bl) {
        this._construct.selectVertex(bl);
    }

    public void selectVertex(boolean[] blArray) {
        this._construct.selectVertex(blArray);
    }

    public void setCapacityConstraint(double d) {
        if (this._improve != null) {
            this._improve.setCapacityConstraint(d);
        }
        this._construct.setCapacityConstraint(d);
    }

    public void setCostConstraint(double d) {
        if (this._improve != null) {
            this._improve.setCostConstraint(d);
        }
        this._construct.setCostConstraint(d);
    }

    public void setEdgeKey(Object object) {
        if (this._improve != null) {
            this._improve.setEdgeKey(object);
        }
        this._construct.setEdgeKey(object);
    }

    public void setGraph(GraphI graphI) {
        if (this._improve != null) {
            this._improve.setGraph(graphI);
        }
        this._construct.setGraph(graphI);
    }

    public void setProperties(PropertiesI propertiesI) {
        if (this._improve != null) {
            this._improve.setProperties(propertiesI);
        }
        this._construct.setProperties(propertiesI);
    }

    public void setVehicleCost(double d) {
        if (this._improve != null) {
            this._improve.setVehicleCost(d);
        }
        this._construct.setVehicleCost(d);
    }
}

