/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph.tsp;

import drasys.or.graph.GraphI;
import drasys.or.graph.tsp.TSPBase;
import drasys.or.graph.tsp.TSPError;
import drasys.or.graph.tsp.TourNotFoundException;
import java.util.Vector;

public abstract class ImproveBase
extends TSPBase {
    Vert _head;
    Vert _tail;

    public ImproveBase() {
    }

    public ImproveBase(GraphI graphI) {
        super(graphI);
    }

    protected final void flip(Vert vert, Vert vert2) {
        Vert vert3 = null;
        Vert vert4 = vert;
        while (vert4 != vert2) {
            Vert vert5 = vert4._next;
            vert4._next = vert3;
            vert3 = vert4;
            vert4 = vert5;
        }
        vert2._next = vert3;
    }

    protected abstract void improve() throws TourNotFoundException;

    public double improveClosedTour(Vector vector) throws TourNotFoundException {
        if (vector.firstElement() != vector.lastElement()) {
            throw new TSPError("The tour is not closed, use 'improveOpenTour' instead.");
        }
        this._closed = true;
        this.initVertices(vector);
        this.initTour(0, 0);
        this.improve();
        return this.getCost();
    }

    public double improveOpenTour(Vector vector) throws TourNotFoundException {
        return this.improveOpenTour(vector, false, false);
    }

    public double improveOpenTour(Vector vector, boolean bl, boolean bl2) throws TourNotFoundException {
        if (vector.firstElement() == vector.lastElement()) {
            throw new TSPError("The tour is not open, use 'improveClosedTour' instead.");
        }
        this._closed = false;
        this.initVertices(vector);
        int n = bl ? 0 : -1;
        int n2 = bl2 ? this._size - 1 : -1;
        this.initTour(n, n2);
        this.improve();
        return this.getCost();
    }

    private void initTour(int n, int n2) {
        if (this._graph == null) {
            throw new TSPError("The graph has not been set.");
        }
        this._head = new Vert(n);
        this._tail = new Vert(n2);
        Vert vert = this._head;
        int n3 = 0;
        while (n3 < this._size) {
            if (n3 != n && n3 != n2) {
                vert = vert._next = new Vert(n3);
            }
            ++n3;
        }
        vert._next = this._tail;
        this.setVertCosts();
    }

    protected void saveTour() {
        int n = this._size;
        this._bestCost = 0.0;
        this._bestTour = new int[n];
        Vert vert = this._head._idx == -1 ? this._head._next : this._head;
        int n2 = 0;
        while (n2 < n) {
            this._bestTour[n2] = vert._idx;
            if (vert._next != null) {
                this._bestCost += this.forwardCost(vert._idx, vert._next._idx);
            }
            ++n2;
            vert = vert._next;
        }
    }

    protected final void setVertCosts() {
        double d = 0.0;
        double d2 = 0.0;
        Vert vert = this._head;
        while (vert != this._tail) {
            vert._cost = this.forwardCost(vert._idx, vert._next._idx);
            vert._reverseSum = d2;
            vert._forwardSum = d;
            d2 += this.reverseCost(vert._idx, vert._next._idx);
            d += vert._cost;
            vert = vert._next;
        }
        this._tail._reverseSum = d2;
        this._tail._forwardSum = d;
    }

    class Vert {
        int _idx;
        Vert _next;
        double _cost;
        double _forwardSum;
        double _reverseSum;

        Vert(int n) {
            this._idx = n;
            this._next = null;
        }
    }
}

