/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph.tsp;

import drasys.or.graph.GraphI;
import drasys.or.graph.VertexI;
import drasys.or.graph.VertexNotFoundException;
import drasys.or.graph.tsp.ConstructI;
import drasys.or.graph.tsp.TSPBase;
import drasys.or.graph.tsp.TSPError;
import drasys.or.graph.tsp.TourNotFoundException;

public class Geni
extends TSPBase
implements ConstructI {
    static final byte INIT = 0;
    static final byte TYPE0 = 1;
    static final byte FORWARD_TYPE1 = 2;
    static final byte FORWARD_TYPE2 = 3;
    static final byte REVERSE_TYPE1 = 4;
    static final byte REVERSE_TYPE2 = 5;
    int _p;
    int _neighborhood;
    Vert _insVi;
    Vert _insVj;
    Vert _insVk;
    Vert _insVl;
    Vert _rmvVj;
    Vert _rmvVk;
    Vert _rmvVl;
    Vert _head;
    Vert _tail;
    Vert _virtualHead;
    Vert _virtualTail;
    double _insMin;
    byte _insState;
    byte _rmvState;
    boolean _lower;
    boolean _newMin;
    Vert[] _verts;

    public Geni(int n) {
        this(n, null);
    }

    public Geni(int n, GraphI graphI) {
        super(graphI);
        this._neighborhood = n;
        this._tail = null;
        this._head = null;
        this._bestTour = null;
        this.setGraph(graphI);
    }

    protected void addNeighbor(Vert vert) {
        if (this._virtualHead != null) {
            this._virtualHead.addNeighbor(vert);
        }
        if (this._virtualTail != null) {
            this._virtualTail.addNeighbor(vert);
        }
        int n = 0;
        while (n < this._verts.length) {
            this._verts[n].addNeighbor(vert);
            ++n;
        }
    }

    protected void addToTour(Vert vert) throws TourNotFoundException {
        switch (this._insState) {
            case 1: {
                this.applyType0(vert);
                break;
            }
            case 2: {
                this.applyForwardType1(vert);
                break;
            }
            case 3: {
                this.applyForwardType2(vert);
                break;
            }
            case 4: {
                this.applyReverseType1(vert);
                break;
            }
            case 5: {
                this.applyReverseType2(vert);
                break;
            }
            default: {
                throw new TourNotFoundException();
            }
        }
        this.addNeighbor(vert);
        vert._inTour = true;
    }

    protected void applyForwardType1(Vert vert) {
        Vert vert2 = this._insVi._next;
        Vert vert3 = this._insVj._next;
        Vert vert4 = this._insVk._next;
        this.forwardFlip(vert2, this._insVj);
        this.forwardFlip(vert3, this._insVk);
        this.newForwardEdge(this._insVi, vert);
        this.newForwardEdge(vert, this._insVj);
        this.newForwardEdge(vert2, this._insVk);
        this.newForwardEdge(vert3, vert4);
    }

    protected void applyForwardType2(Vert vert) {
        Vert vert2 = this._insVi._next;
        Vert vert3 = this._insVj._next;
        Vert vert4 = this._insVk._prev;
        Vert vert5 = this._insVl._prev;
        this.forwardFlip(vert2, vert5);
        this.forwardFlip(this._insVl, this._insVj);
        this.newForwardEdge(this._insVi, vert);
        this.newForwardEdge(vert, this._insVj);
        this.newForwardEdge(this._insVl, vert3);
        this.newForwardEdge(vert4, vert5);
        this.newForwardEdge(vert2, this._insVk);
    }

    protected void applyReverseType1(Vert vert) {
        Vert vert2 = this._insVi._prev;
        Vert vert3 = this._insVj._prev;
        Vert vert4 = this._insVk._prev;
        this.reverseFlip(vert2, this._insVj);
        this.reverseFlip(vert3, this._insVk);
        this.newReverseEdge(this._insVi, vert);
        this.newReverseEdge(vert, this._insVj);
        this.newReverseEdge(vert2, this._insVk);
        this.newReverseEdge(vert3, vert4);
    }

    protected void applyReverseType2(Vert vert) {
        Vert vert2 = this._insVi._prev;
        Vert vert3 = this._insVj._prev;
        Vert vert4 = this._insVk._next;
        Vert vert5 = this._insVl._next;
        this.reverseFlip(vert2, vert5);
        this.reverseFlip(this._insVl, this._insVj);
        this.newReverseEdge(this._insVi, vert);
        this.newReverseEdge(vert, this._insVj);
        this.newReverseEdge(this._insVl, vert3);
        this.newReverseEdge(vert4, vert5);
        this.newReverseEdge(vert2, this._insVk);
    }

    protected void applyType0(Vert vert) {
        Vert vert2 = this._insVi._next;
        this.newForwardEdge(this._insVi, vert);
        this.newForwardEdge(vert, vert2);
    }

    protected double calcCost() {
        if (this._head == null || this._tail == null) {
            throw new TSPError("No solution has been found");
        }
        double d = this._head._nextCost;
        Vert vert = this._head._next;
        while (vert != this._tail) {
            d += vert._nextCost;
            vert = vert._next;
        }
        return d;
    }

    protected int[] calcTour() {
        if (this._head == null || this._tail == null) {
            throw new TSPError("No solution has been found");
        }
        int n = 0;
        int[] nArray = new int[this._size];
        if (this._head._idx != -1) {
            nArray[n++] = this._head._idx;
        }
        Vert vert = this._head._next;
        while (vert != this._tail) {
            if (vert._idx != -1) {
                nArray[n++] = vert._idx;
            }
            vert = vert._next;
        }
        if (!this._closed && this._tail._idx != -1) {
            nArray[n++] = this._tail._idx;
        }
        return nArray;
    }

    protected boolean checkList() {
        int n = 0;
        boolean[] blArray = new boolean[this._size];
        if (this._head._idx != -1) {
            blArray[this._head._idx] = true;
        }
        if (this._tail._idx != this._head._idx && this._tail._idx != -1) {
            blArray[this._tail._idx] = true;
        }
        Vert vert = this._head._next;
        while (vert != this._tail) {
            if (blArray[vert._idx]) {
                return false;
            }
            blArray[vert._idx] = true;
            if (++n > this._size) {
                return false;
            }
            if (this.forwardCost(vert._prev._idx, vert._idx) != vert._prev._nextCost) {
                return false;
            }
            if (this.reverseCost(vert._prev._idx, vert._idx) != vert._prevCost) {
                return false;
            }
            vert = vert._next;
        }
        n = 0;
        Vert vert2 = this._tail._prev;
        while (vert2 != this._head) {
            if (++n > this._size) {
                return false;
            }
            vert2 = vert2._prev;
        }
        return true;
    }

    protected void construct() throws TourNotFoundException {
        int n = this._size;
        int n2 = 0;
        while (n2 < n) {
            Vert vert = this._verts[n2];
            if (!vert._inTour) {
                this._insState = 0;
                this.forwardFindBestInsert(vert);
                this.reverseFindBestInsert(vert);
                this.addToTour(vert);
                this.addNeighbor(vert);
            }
            ++n2;
        }
        this._bestTour = this.calcTour();
        this._bestCost = this.calcCost();
        this._tail = null;
        this._head = null;
    }

    public double constructClosedTour() throws TourNotFoundException {
        if (this._graph == null) {
            throw new TSPError("The graph has not been set.");
        }
        this._p = this._neighborhood;
        this._closed = true;
        this.initVertices(-1, -1);
        this.initTourGENI(0, 0);
        this.construct();
        return this.getCost();
    }

    public double constructOpenTour() throws TourNotFoundException {
        this._closed = false;
        this._p = this._neighborhood + 2;
        this.initVertices(-1, -1);
        this.initTourGENI(-1, -1);
        this.construct();
        return this.getCost();
    }

    public double constructOpenTour(Object object, Object object2) throws TourNotFoundException, VertexNotFoundException {
        if (this._graph == null) {
            throw new TSPError("The graph has not been set.");
        }
        if (object.equals(object2)) {
            throw new TSPError("The origin and destination keys are equal, use 'constructClosedTour' instead.");
        }
        VertexI vertexI = this._graph.getVertex(object);
        if (vertexI == null) {
            throw new VertexNotFoundException("The origin vertex does not exist");
        }
        VertexI vertexI2 = this._graph.getVertex(object2);
        if (vertexI2 == null) {
            throw new VertexNotFoundException("The destination vertex does not exist");
        }
        this._closed = vertexI == vertexI2;
        this._p = this._neighborhood;
        this.initVertices(vertexI.getIndex(), vertexI2.getIndex());
        this.initTourGENI(this._fromSelectedIdx, this._toSelectedIdx);
        this.construct();
        return this.getCost();
    }

    public double constructOpenTourFrom(Object object) throws TourNotFoundException, VertexNotFoundException {
        if (this._graph == null) {
            throw new TSPError("The graph has not been set.");
        }
        VertexI vertexI = this._graph.getVertex(object);
        if (vertexI == null) {
            throw new VertexNotFoundException("The origin vertex does not exist");
        }
        this._closed = false;
        this._p = this._neighborhood + 1;
        this.initVertices(vertexI.getIndex(), -1);
        this.initTourGENI(this._fromSelectedIdx, -1);
        this.construct();
        return this.getCost();
    }

    public double constructOpenTourTo(Object object) throws TourNotFoundException, VertexNotFoundException {
        if (this._graph == null) {
            throw new TSPError("The graph has not been set.");
        }
        VertexI vertexI = this._graph.getVertex(object);
        if (vertexI == null) {
            throw new VertexNotFoundException("The destination vertex does not exist");
        }
        this._closed = false;
        this._p = this._neighborhood + 1;
        this.initVertices(-1, vertexI.getIndex());
        this.initTourGENI(-1, this._toSelectedIdx);
        this.construct();
        return this.getCost();
    }

    protected void costOfType0(int n, Vert vert) {
        Vert vert2 = vert._next;
        double d = this.forwardCost(vert._idx, n) + this.forwardCost(n, vert2._idx) - vert._nextCost;
        if (this._insState == 0 || d < this._insMin) {
            this._insMin = d;
            this._insState = 1;
            this._insVi = vert;
            this._newMin = true;
        }
    }

    protected void forwardCostOfInsertType1(int n, Vert vert, Vert vert2, Vert vert3) {
        Vert vert4 = vert._next;
        Vert vert5 = vert2._next;
        Vert vert6 = vert3._next;
        double d = 0.0;
        if (!this._symmetric) {
            d -= vert2._nextSumCost - vert4._nextSumCost;
            d -= vert3._nextSumCost - vert5._nextSumCost;
            d += vert2._prevSumCost - vert4._prevSumCost;
            d += vert3._prevSumCost - vert5._prevSumCost;
        }
        d -= vert._nextCost + vert2._nextCost + vert3._nextCost;
        d += this.forwardCost(vert._idx, n);
        d += this.forwardCost(n, vert2._idx);
        d += this.forwardCost(vert4._idx, vert3._idx);
        d += this.forwardCost(vert5._idx, vert6._idx);
        if (this._insState == 0 || d < this._insMin) {
            this._insMin = d;
            this._insState = (byte)2;
            this._insVi = vert;
            this._insVj = vert2;
            this._insVk = vert3;
            this._newMin = true;
        }
    }

    protected void forwardCostOfInsertType2(int n, Vert vert, Vert vert2, Vert vert3, Vert vert4) {
        Vert vert5 = vert._next;
        Vert vert6 = vert2._next;
        Vert vert7 = vert3._prev;
        Vert vert8 = vert4._prev;
        double d = 0.0;
        if (!this._symmetric) {
            d -= vert8._nextSumCost - vert5._nextSumCost;
            d -= vert2._nextSumCost - vert4._nextSumCost;
            d += vert8._prevSumCost - vert5._prevSumCost;
            d += vert2._prevSumCost - vert4._prevSumCost;
        }
        d -= vert._nextCost + vert2._nextCost + vert7._nextCost + vert8._nextCost;
        d += this.forwardCost(vert._idx, n);
        d += this.forwardCost(n, vert2._idx);
        d += this.forwardCost(vert4._idx, vert6._idx);
        d += this.forwardCost(vert7._idx, vert8._idx);
        d += this.forwardCost(vert6._idx, vert3._idx);
        if (this._insState == 0 || d < this._insMin) {
            this._insMin = d;
            this._insState = (byte)3;
            this._insVi = vert;
            this._insVj = vert2;
            this._insVk = vert3;
            this._insVl = vert4;
            this._newMin = true;
        }
    }

    protected void forwardFindBestInsert(Vert vert) {
        if (!this._closed) {
            this.forwardSequenceInsert(this._head);
        }
        int n = 0;
        while (n < vert._nIn) {
            Vert vert2 = vert._neighborsIn[n];
            if (vert2._inTour) {
                Vert vert3;
                if (this._closed) {
                    this.forwardSequenceInsert(vert2);
                }
                if ((vert3 = vert2._next) != null) {
                    this.costOfType0(vert._idx, vert2);
                    int n2 = 0;
                    while (n2 < vert._nOut) {
                        Vert vert4;
                        Vert vert5 = vert._neighborsOut[n2];
                        if (vert5._inTour && vert5._insSeq > vert2._insSeq && (vert4 = vert5._next) != null) {
                            int n3 = 0;
                            while (n3 < vert3._nOut) {
                                Vert vert6 = vert3._neighborsOut[n3];
                                if (vert6._inTour && vert6._insSeq > vert5._insSeq) {
                                    if (vert6._next != null) {
                                        this.forwardCostOfInsertType1(vert._idx, vert2, vert5, vert6);
                                    }
                                    if (vert6._insSeq > vert4._insSeq) {
                                        int n4 = 0;
                                        while (n4 < vert4._nIn) {
                                            Vert vert7 = vert4._neighborsIn[n4];
                                            if (vert7._inTour && vert7._insSeq > vert3._insSeq && vert7._insSeq <= vert5._insSeq) {
                                                this.forwardCostOfInsertType2(vert._idx, vert2, vert5, vert6, vert7);
                                            }
                                            ++n4;
                                        }
                                    }
                                }
                                ++n3;
                            }
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    protected void forwardFlip(Vert vert, Vert vert2) {
        if (vert == vert2) {
            return;
        }
        Vert vert3 = vert;
        Vert vert4 = vert3._next;
        Vert vert5 = vert4._next;
        double d = vert3._nextCost;
        while (vert3 != vert2) {
            vert3._prev = vert4;
            vert3._prevCost = d;
            vert4._next = vert3;
            d = vert4._nextCost;
            vert4._nextCost = vert4._prevCost;
            vert3 = vert4;
            vert4 = vert5;
            vert5 = vert4._next;
        }
    }

    protected void forwardSequenceInsert(Vert vert) {
        if (vert == null) {
            return;
        }
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        vert._insSeq = n++;
        vert._nextSumCost = d;
        vert._prevSumCost = d2;
        d += vert._nextCost;
        Vert vert2 = vert._next;
        while (vert2 != null && vert2 != vert) {
            vert2._insSeq = n++;
            vert2._prevSumCost = d2 += vert2._prevCost;
            vert2._nextSumCost = d;
            d += vert2._nextCost;
            vert2 = vert2._next;
        }
    }

    protected void initTourGENI(int n, int n2) {
        if (this._graph == null) {
            throw new TSPError("The graph has not been set.");
        }
        int n3 = this._size;
        this._verts = new Vert[n3];
        int n4 = 0;
        while (n4 < n3) {
            this._verts[n4] = new Vert(n4);
            ++n4;
        }
        this._virtualHead = n == -1 ? new Vert(-1) : null;
        this._virtualTail = n2 == -1 ? new Vert(-1) : null;
        int n5 = 0;
        int n6 = 0;
        double d = Double.POSITIVE_INFINITY;
        int n7 = 0;
        block1: while (n7 < n3) {
            if (n7 != n && n7 != n2) {
                int n8 = 0;
                while (n8 < n3) {
                    double d2;
                    double d3;
                    double d4;
                    double d5;
                    if (n7 != n8 && n8 != n && n8 != n2 && (d5 = this.forwardCost(n, n7)) != Double.POSITIVE_INFINITY && (d4 = this.forwardCost(n7, n8)) != Double.POSITIVE_INFINITY && (d3 = this.forwardCost(n8, n2)) != Double.POSITIVE_INFINITY && (d2 = d5 + d4 + d3) < d) {
                        d = d2;
                        n5 = n7;
                        n6 = n8;
                        if (n3 > 4) break block1;
                    }
                    ++n8;
                }
            }
            ++n7;
        }
        if (d == Double.POSITIVE_INFINITY) {
            throw new TSPError("Can't find an initial solution");
        }
        Vert vert = this._head = n == -1 ? this._virtualHead : this._verts[n];
        this._tail = this._closed ? this._head : (n2 == -1 ? this._virtualTail : this._verts[n2]);
        Vert vert2 = this._verts[n5];
        Vert vert3 = this._verts[n6];
        this._head._inTour = true;
        this._tail._inTour = true;
        vert2._inTour = true;
        vert3._inTour = true;
        this.addNeighbor(this._head);
        if (!this._closed) {
            this.addNeighbor(this._tail);
        }
        this.addNeighbor(vert2);
        this.addNeighbor(vert3);
        this.newForwardEdge(this._head, vert2);
        this.newForwardEdge(vert2, vert3);
        this.newForwardEdge(vert3, this._tail);
    }

    protected void newForwardEdge(Vert vert, Vert vert2) {
        vert._next = vert2;
        vert._nextCost = this.forwardCost(vert._idx, vert2._idx);
        vert2._prev = vert;
        vert2._prevCost = this.forwardCost(vert2._idx, vert._idx);
    }

    protected void newReverseEdge(Vert vert, Vert vert2) {
        vert2._next = vert;
        vert2._nextCost = this.forwardCost(vert2._idx, vert._idx);
        vert._prev = vert2;
        vert._prevCost = this.forwardCost(vert._idx, vert2._idx);
    }

    protected void reverseCostOfInsertType1(int n, Vert vert, Vert vert2, Vert vert3) {
        Vert vert4 = vert._prev;
        Vert vert5 = vert2._prev;
        Vert vert6 = vert3._prev;
        double d = 0.0;
        if (!this._symmetric) {
            d -= vert2._nextSumCost - vert4._nextSumCost;
            d -= vert3._nextSumCost - vert5._nextSumCost;
            d += vert2._prevSumCost - vert4._prevSumCost;
            d += vert3._prevSumCost - vert5._prevSumCost;
        }
        d -= vert._prev._nextCost + vert2._prev._nextCost + vert3._prev._nextCost;
        d += this.reverseCost(vert._idx, n);
        d += this.reverseCost(n, vert2._idx);
        d += this.reverseCost(vert4._idx, vert3._idx);
        d += this.reverseCost(vert5._idx, vert6._idx);
        if (this._insState == 0 || d < this._insMin) {
            this._insMin = d;
            this._insState = (byte)4;
            this._insVi = vert;
            this._insVj = vert2;
            this._insVk = vert3;
            this._newMin = true;
        }
    }

    protected void reverseCostOfInsertType2(int n, Vert vert, Vert vert2, Vert vert3, Vert vert4) {
        Vert vert5 = vert._prev;
        Vert vert6 = vert2._prev;
        Vert vert7 = vert3._next;
        Vert vert8 = vert4._next;
        double d = 0.0;
        if (!this._symmetric) {
            d -= vert8._nextSumCost - vert5._nextSumCost;
            d -= vert2._nextSumCost - vert4._nextSumCost;
            d += vert8._prevSumCost - vert5._prevSumCost;
            d += vert2._prevSumCost - vert4._prevSumCost;
        }
        d -= vert5._nextCost + vert6._nextCost + vert3._nextCost + vert4._nextCost;
        d += this.reverseCost(vert._idx, n);
        d += this.reverseCost(n, vert2._idx);
        d += this.reverseCost(vert4._idx, vert6._idx);
        d += this.reverseCost(vert7._idx, vert8._idx);
        d += this.reverseCost(vert6._idx, vert3._idx);
        if (this._insState == 0 || d < this._insMin) {
            this._insMin = d;
            this._insState = (byte)5;
            this._insVi = vert;
            this._insVj = vert2;
            this._insVk = vert3;
            this._insVl = vert4;
            this._newMin = true;
        }
    }

    protected void reverseFindBestInsert(Vert vert) {
        if (!this._closed) {
            this.reverseSequenceInsert(this._tail);
        }
        int n = 0;
        while (n < vert._nOut) {
            Vert vert2 = vert._neighborsOut[n];
            if (vert2._inTour) {
                Vert vert3;
                if (this._closed) {
                    this.reverseSequenceInsert(vert2);
                }
                if ((vert3 = vert2._prev) != null) {
                    int n2 = 0;
                    while (n2 < vert._nIn) {
                        Vert vert4;
                        Vert vert5 = vert._neighborsIn[n2];
                        if (vert5._inTour && vert5._insSeq > vert2._insSeq && (vert4 = vert5._prev) != null) {
                            int n3 = 0;
                            while (n3 < vert3._nIn) {
                                Vert vert6 = vert3._neighborsIn[n3];
                                if (vert6._inTour && vert6._insSeq > vert5._insSeq) {
                                    if (vert6._prev != null) {
                                        this.reverseCostOfInsertType1(vert._idx, vert2, vert5, vert6);
                                    }
                                    if (vert6._insSeq > vert4._insSeq) {
                                        int n4 = 0;
                                        while (n4 < vert4._nOut) {
                                            Vert vert7 = vert4._neighborsOut[n4];
                                            if (vert7._inTour && vert7._insSeq > vert3._insSeq && vert7._insSeq <= vert5._insSeq) {
                                                this.reverseCostOfInsertType2(vert._idx, vert2, vert5, vert6, vert7);
                                            }
                                            ++n4;
                                        }
                                    }
                                }
                                ++n3;
                            }
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
    }

    protected void reverseFlip(Vert vert, Vert vert2) {
        if (vert2 == vert) {
            return;
        }
        Vert vert3 = vert2;
        Vert vert4 = vert3._next;
        Vert vert5 = vert4._next;
        double d = vert3._nextCost;
        while (vert3 != vert) {
            vert3._prev = vert4;
            vert3._prevCost = d;
            vert4._next = vert3;
            d = vert4._nextCost;
            vert4._nextCost = vert4._prevCost;
            vert3 = vert4;
            vert4 = vert5;
            vert5 = vert4._next;
        }
    }

    protected void reverseSequenceInsert(Vert vert) {
        if (vert == null) {
            return;
        }
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        vert._insSeq = n++;
        vert._nextSumCost = d;
        vert._prevSumCost = d2;
        d2 += vert._prevCost;
        Vert vert2 = vert._prev;
        while (vert2 != null && vert2 != vert) {
            vert2._insSeq = n++;
            vert2._nextSumCost = d += vert2._nextCost;
            vert2._prevSumCost = d2;
            d2 += vert2._prevCost;
            vert2 = vert2._prev;
        }
    }

    public void selectVertex(Object object, boolean bl) throws VertexNotFoundException {
        if (this._graph == null) {
            throw new TSPError("The graph is not set.");
        }
        this.checkChangeCount();
        VertexI vertexI = this._graph.getVertex(object);
        if (vertexI == null) {
            throw new VertexNotFoundException();
        }
        this._selected[vertexI.getIndex()] = bl;
    }

    public void selectVertex(boolean bl) {
        if (this._graph == null) {
            throw new TSPError("The graph is not set.");
        }
        this.checkChangeCount();
        int n = 0;
        while (n < this._selected.length) {
            this._selected[n] = bl;
            ++n;
        }
    }

    public void selectVertex(boolean[] blArray) {
        if (this._graph == null) {
            throw new TSPError("The graph is not set.");
        }
        this.checkChangeCount();
        if (blArray.length != this._graph.sizeOfVertices()) {
            throw new TSPError("The size of the select array  must equal the number of vertices in the graph.");
        }
        int n = 0;
        while (n < this._selected.length) {
            this._selected[n] = blArray[n];
            ++n;
        }
    }

    public String toString() {
        String string = String.valueOf(this._head.toString()) + "\n";
        Vert vert = this._head._next;
        while (vert != null && vert != this._head) {
            string = String.valueOf(string) + vert.toString() + "\n";
            vert = vert._next;
        }
        return string;
    }

    class Vert {
        int _idx;
        int _nIn;
        int _nOut;
        int _insSeq;
        int _rmvSeq;
        Vert _prev;
        Vert _next;
        Vert _reverse;
        boolean _inTour;
        double _prevCost;
        double _nextCost;
        double _prevSumCost;
        double _nextSumCost;
        double[] _neighborCostIn;
        double[] _neighborCostOut;
        Vert[] _neighborsIn;
        Vert[] _neighborsOut;

        Vert(int n) {
            this._idx = n;
            this._next = null;
            this._prev = null;
            this._nOut = 0;
            this._nIn = 0;
            this._inTour = false;
            this._neighborsIn = new Vert[Geni.this._neighborhood + 2];
            this._neighborsOut = new Vert[Geni.this._neighborhood + 2];
            this._neighborCostIn = new double[Geni.this._neighborhood + 2];
            this._neighborCostOut = new double[Geni.this._neighborhood + 2];
        }

        Vert(Vert vert) {
            this._idx = vert._idx;
            this._next = null;
            this._prev = null;
            this._nIn = vert._nIn;
            this._nOut = vert._nOut;
            this._inTour = vert._inTour;
            this._neighborsIn = vert._neighborsIn;
            this._neighborsOut = vert._neighborsOut;
            this._neighborCostIn = vert._neighborCostIn;
            this._neighborCostOut = vert._neighborCostOut;
        }

        public void addNeighbor(Vert vert) {
            if (vert._idx == this._idx) {
                return;
            }
            this.addNeighborIn(vert);
            this.addNeighborOut(vert);
        }

        public void addNeighborIn(Vert vert) {
            double d = Geni.this.forwardCost(vert._idx, this._idx);
            if (d == Double.POSITIVE_INFINITY) {
                return;
            }
            if (this._nIn < Geni.this._p) {
                this._neighborsIn[this._nIn] = vert;
                this._neighborCostIn[this._nIn++] = d;
            } else {
                int n = 0;
                double d2 = this._neighborCostIn[0];
                int n2 = 1;
                while (n2 < this._nIn) {
                    double d3;
                    double d4 = this._neighborCostIn[n2];
                    if (d3 > d2) {
                        n = n2;
                        d2 = d4;
                    }
                    ++n2;
                }
                if (d2 > d) {
                    this._neighborsIn[n] = vert;
                    this._neighborCostIn[n] = d;
                }
            }
        }

        public void addNeighborOut(Vert vert) {
            double d = Geni.this.forwardCost(this._idx, vert._idx);
            if (d == Double.POSITIVE_INFINITY) {
                return;
            }
            if (this._nOut < Geni.this._p) {
                this._neighborsOut[this._nOut] = vert;
                this._neighborCostOut[this._nOut++] = d;
            } else {
                int n = 0;
                double d2 = this._neighborCostOut[0];
                int n2 = 1;
                while (n2 < this._nOut) {
                    double d3;
                    double d4 = this._neighborCostOut[n2];
                    if (d3 > d2) {
                        n = n2;
                        d2 = d4;
                    }
                    ++n2;
                }
                if (d2 > d) {
                    this._neighborsOut[n] = vert;
                    this._neighborCostOut[n] = d;
                }
            }
        }

        void setReverse(Vert vert) {
            this._prev = vert._next;
            this._next = vert._prev;
            this._prevCost = vert._nextCost;
            this._nextCost = vert._prevCost;
            this._prevSumCost = vert._nextSumCost;
            this._nextSumCost = vert._prevSumCost;
        }

        public String toString() {
            return this._idx + ", " + this._prevCost + ", " + this._nextCost;
        }
    }
}

