/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph.color;

import drasys.or.CompareI;
import drasys.or.alg.QuickSort;
import drasys.or.graph.EdgeI;
import drasys.or.graph.GraphError;
import drasys.or.graph.GraphException;
import drasys.or.graph.GraphI;
import drasys.or.graph.InvalidGraphError;
import drasys.or.graph.VertexI;
import drasys.or.graph.color.ColoringI;
import java.util.Enumeration;

public class WelshPowell
implements ColoringI {
    int _sizeOfEdgeColors;
    int _sizeOfVertexColors;
    int[] _edgeColors;
    int[] _vertexColors;
    GraphI _graph;
    boolean _edgesColored;
    boolean _verticesColored;

    public WelshPowell(GraphI graphI) {
        this._graph = graphI;
        this._edgesColored = false;
        this._verticesColored = false;
    }

    public int colorEdges() {
        Object object;
        int n;
        this._sizeOfEdgeColors = 0;
        int n2 = this._graph.sizeOfEdges();
        if (n2 == 0) {
            return 0;
        }
        Object[] objectArray = new Object[n2];
        Edge[] edgeArray = new Edge[n2];
        Enumeration enumeration = this._graph.edges();
        while (enumeration.hasMoreElements()) {
            EdgeI edgeI = (EdgeI)enumeration.nextElement();
            n = edgeI.getIndex();
            VertexI vertexI = edgeI.getToVertex();
            object = edgeI.getFromVertex();
            int n3 = vertexI.getInDegree() + vertexI.getOutDegree() + object.getInDegree() + object.getOutDegree() - 2;
            edgeArray[n] = new Edge(edgeI, n3);
            objectArray[n] = edgeArray[n];
        }
        new QuickSort(true, new CmpEdge()).sort(objectArray);
        boolean bl = true;
        n = 0;
        while (bl && n < n2) {
            bl = false;
            int n4 = 0;
            while (n4 < n2) {
                block10: {
                    object = (Edge)objectArray[n4];
                    if (((Edge)object)._color == -1) {
                        Object object2;
                        Object object3;
                        Object object4;
                        EdgeI edgeI = ((Edge)object)._edge;
                        VertexI vertexI = edgeI.getToVertex();
                        Enumeration enumeration2 = vertexI.inEdges();
                        while (enumeration2.hasMoreElements()) {
                            object4 = (EdgeI)enumeration2.nextElement();
                            if (edgeArray[object4.getIndex()]._color != this._sizeOfEdgeColors) continue;
                            bl = true;
                            break block10;
                        }
                        object4 = vertexI.outEdges();
                        while (object4.hasMoreElements()) {
                            object3 = (EdgeI)object4.nextElement();
                            if (edgeArray[object3.getIndex()]._color != this._sizeOfEdgeColors) continue;
                            bl = true;
                            break block10;
                        }
                        vertexI = edgeI.getFromVertex();
                        object3 = vertexI.inEdges();
                        while (object3.hasMoreElements()) {
                            object2 = (EdgeI)object3.nextElement();
                            if (edgeArray[object2.getIndex()]._color != this._sizeOfEdgeColors) continue;
                            bl = true;
                            break block10;
                        }
                        object2 = vertexI.outEdges();
                        while (object2.hasMoreElements()) {
                            EdgeI edgeI2 = (EdgeI)object2.nextElement();
                            if (edgeArray[edgeI2.getIndex()]._color != this._sizeOfEdgeColors) continue;
                            bl = true;
                            break block10;
                        }
                        ((Edge)object)._color = this._sizeOfEdgeColors;
                    }
                }
                ++n4;
            }
            ++this._sizeOfEdgeColors;
            ++n;
        }
        this._edgesColored = true;
        this._edgeColors = new int[n2];
        int n5 = 0;
        while (n5 < n2) {
            this._edgeColors[n5] = edgeArray[n5]._color;
            ++n5;
        }
        return this._sizeOfEdgeColors;
    }

    public int colorVertices() {
        int n;
        int n2;
        this._sizeOfVertexColors = 0;
        int n3 = this._graph.sizeOfVertices();
        if (n3 == 0) {
            return 0;
        }
        Object[] objectArray = new Object[n3];
        Vertex[] vertexArray = new Vertex[n3];
        Enumeration enumeration = this._graph.vertices();
        while (enumeration.hasMoreElements()) {
            VertexI vertexI = (VertexI)enumeration.nextElement();
            n2 = vertexI.getIndex();
            vertexArray[n2] = new Vertex(vertexI, vertexI.getInDegree() + vertexI.getOutDegree());
            objectArray[n2] = vertexArray[n2];
        }
        new QuickSort(true, new CmpVert()).sort(objectArray);
        boolean bl = true;
        n2 = 0;
        while (bl && n2 < n3) {
            bl = false;
            n = 0;
            while (n < n3) {
                block8: {
                    Vertex vertex = (Vertex)objectArray[n];
                    if (vertex._color == -1) {
                        Object object;
                        VertexI vertexI = vertex._vertex;
                        Enumeration enumeration2 = vertexI.inEdges();
                        while (enumeration2.hasMoreElements()) {
                            object = ((EdgeI)enumeration2.nextElement()).getFromVertex();
                            if (vertexArray[object.getIndex()]._color != this._sizeOfVertexColors) continue;
                            bl = true;
                            break block8;
                        }
                        object = vertexI.outEdges();
                        while (object.hasMoreElements()) {
                            VertexI vertexI2 = ((EdgeI)object.nextElement()).getToVertex();
                            if (vertexArray[vertexI2.getIndex()]._color != this._sizeOfVertexColors) continue;
                            bl = true;
                            break block8;
                        }
                        vertex._color = this._sizeOfVertexColors;
                    }
                }
                ++n;
            }
            ++this._sizeOfVertexColors;
            ++n2;
        }
        this._verticesColored = true;
        this._vertexColors = new int[n3];
        n = 0;
        while (n < n3) {
            this._vertexColors[n] = vertexArray[n]._color;
            ++n;
        }
        return this._sizeOfVertexColors;
    }

    public int getEdgeColor(EdgeI edgeI) throws GraphException {
        if (!this._edgesColored) {
            throw new GraphException("The edges have not been colored");
        }
        if (edgeI.getGraph() != this._graph) {
            throw new GraphError("The edge is not owned by the graph");
        }
        if (this._edgeColors.length != this._graph.sizeOfEdges()) {
            throw new InvalidGraphError("The number of edges in the graph has changed since they were colored.");
        }
        int n = edgeI.getIndex();
        if (n >= this._edgeColors.length) {
            throw new InvalidGraphError("The number of edges in the graph has changed since the edge was obtained.");
        }
        return this._edgeColors[n];
    }

    public int[] getEdgeColors() throws GraphException {
        if (!this._edgesColored) {
            throw new GraphException("The edges have not been colored");
        }
        if (this._edgeColors.length != this._graph.sizeOfEdges()) {
            throw new InvalidGraphError("The number of edges in the graph has changed since they were colored");
        }
        int[] nArray = new int[this._edgeColors.length];
        int n = 0;
        while (n < this._edgeColors.length) {
            nArray[n] = this._edgeColors[n];
            ++n;
        }
        return nArray;
    }

    public int getVertexColor(VertexI vertexI) throws GraphException {
        if (!this._verticesColored) {
            throw new GraphException("The vertices have not been colored");
        }
        if (vertexI.getGraph() != this._graph) {
            throw new GraphError("The vertex is not owned by the graph");
        }
        if (this._vertexColors.length != this._graph.sizeOfVertices()) {
            throw new InvalidGraphError("The number of vertices in the graph has changed since they were colored");
        }
        int n = vertexI.getIndex();
        if (n >= this._vertexColors.length) {
            throw new InvalidGraphError("The number of vertices in the graph has changed since the edge was obtained.");
        }
        return this._vertexColors[n];
    }

    public int[] getVertexColors() throws GraphException {
        if (!this._verticesColored) {
            throw new GraphException("The vertices have not been colored");
        }
        if (this._vertexColors.length != this._graph.sizeOfVertices()) {
            throw new InvalidGraphError("The number of vertices in the graph has changed since they were colored");
        }
        int[] nArray = new int[this._vertexColors.length];
        int n = 0;
        while (n < this._vertexColors.length) {
            nArray[n] = this._vertexColors[n];
            ++n;
        }
        return nArray;
    }

    public int sizeOfEdgeColors() throws GraphException {
        if (!this._edgesColored) {
            throw new GraphException("The edges have not been colored");
        }
        if (this._edgeColors.length != this._graph.sizeOfEdges()) {
            throw new InvalidGraphError("The number of edges in the graph has changed since they were colored");
        }
        return this._sizeOfEdgeColors;
    }

    public int sizeOfVertexColors() throws GraphException {
        if (!this._verticesColored) {
            throw new GraphException("The vertices have not been colored");
        }
        if (this._vertexColors.length != this._graph.sizeOfVertices()) {
            throw new InvalidGraphError("The number of vertices in the graph has changed since they were colored");
        }
        return this._sizeOfVertexColors;
    }

    static class CmpVert
    implements CompareI {
        CmpVert() {
        }

        public int compare(Object object, Object object2) {
            int n = ((Vertex)object)._degree;
            int n2 = ((Vertex)object2)._degree;
            return n == n2 ? 0 : (n < n2 ? -1 : 1);
        }
    }

    static class Vertex {
        VertexI _vertex;
        int _color = -1;
        int _degree;

        Vertex(VertexI vertexI, int n) {
            this._vertex = vertexI;
            this._degree = n;
        }
    }

    static class CmpEdge
    implements CompareI {
        CmpEdge() {
        }

        public int compare(Object object, Object object2) {
            int n = ((Edge)object)._degree;
            int n2 = ((Edge)object2)._degree;
            return n == n2 ? 0 : (n < n2 ? -1 : 1);
        }
    }

    static class Edge {
        EdgeI _edge;
        int _color = -1;
        int _degree;

        Edge(EdgeI edgeI, int n) {
            this._edge = edgeI;
            this._degree = n;
        }
    }
}

