/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.graph;

import drasys.or.graph.DuplicateVertexException;
import drasys.or.graph.EdgeI;
import drasys.or.graph.EdgePropertiesI;
import drasys.or.graph.Graph;
import drasys.or.graph.GraphError;
import drasys.or.graph.GraphI;
import drasys.or.graph.ParallelEdgeException;
import drasys.or.graph.PropertiesAdapter;
import drasys.or.graph.VertexBase;
import drasys.or.graph.VertexI;
import drasys.or.matrix.MatrixI;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MatrixGraph
extends Graph
implements GraphI {
    int _sizeOfEdges;
    Edge _theEdge;
    boolean _isSymmetric;
    Hashtable _vertexHashtable;
    Vertex[] _toVertices;
    Vertex[] _fromVertices;

    public MatrixGraph(GraphI graphI, Object object) {
        this.construct(graphI, object, null);
    }

    public MatrixGraph(GraphI graphI, Object object, EdgePropertiesI edgePropertiesI) {
        this.construct(graphI, object, edgePropertiesI);
    }

    public MatrixGraph(MatrixI matrixI, MatrixI matrixI2, MatrixI matrixI3) {
        if (matrixI.sizeOfRows() != matrixI.sizeOfColumns()) {
            throw new GraphError("The matrix must be square.");
        }
        Vector<Integer> vector = new Vector<Integer>(matrixI.sizeOfRows());
        int n = 0;
        while (n < matrixI.sizeOfRows()) {
            vector.addElement(new Integer(n));
            ++n;
        }
        try {
            this.construct(matrixI, matrixI2, matrixI3, vector, null);
        }
        catch (DuplicateVertexException duplicateVertexException) {
            throw new GraphError("Internal Error");
        }
    }

    public MatrixGraph(MatrixI matrixI, MatrixI matrixI2, MatrixI matrixI3, Vector vector) throws DuplicateVertexException {
        if (matrixI != null && matrixI.sizeOfRows() != matrixI.sizeOfColumns()) {
            throw new GraphError("The matrix is not square.");
        }
        if (matrixI2 != null && matrixI2.sizeOfRows() != matrixI2.sizeOfColumns()) {
            throw new GraphError("The matrix is not square.");
        }
        if (matrixI3 != null && matrixI3.sizeOfRows() != matrixI3.sizeOfColumns()) {
            throw new GraphError("The matrix is not square.");
        }
        if (matrixI != null && matrixI.sizeOfRows() != vector.size()) {
            throw new GraphError("The size of 'fromVertices' must equal the rows in 'matrix'");
        }
        if (matrixI2 != null && matrixI2.sizeOfRows() != vector.size()) {
            throw new GraphError("The size of 'fromVertices' must equal the rows in 'matrix'");
        }
        if (matrixI3 != null && matrixI3.sizeOfRows() != vector.size()) {
            throw new GraphError("The size of 'fromVertices' must equal the rows in 'matrix'");
        }
        this.construct(matrixI, matrixI2, matrixI3, vector, null);
    }

    public MatrixGraph(MatrixI matrixI, MatrixI matrixI2, MatrixI matrixI3, Vector vector, Vector vector2) throws DuplicateVertexException {
        if (matrixI != null && matrixI.sizeOfRows() != matrixI.sizeOfColumns()) {
            throw new GraphError("The matrix is not square.");
        }
        if (matrixI2 != null && matrixI2.sizeOfRows() != matrixI2.sizeOfColumns()) {
            throw new GraphError("The matrix is not square.");
        }
        if (matrixI3 != null && matrixI3.sizeOfRows() != matrixI3.sizeOfColumns()) {
            throw new GraphError("The matrix is not square.");
        }
        if (matrixI != null && matrixI.sizeOfRows() != vector.size()) {
            throw new GraphError("The size of 'fromVertices' must equal the rows in 'matrix'");
        }
        if (matrixI2 != null && matrixI2.sizeOfRows() != vector.size()) {
            throw new GraphError("The size of 'fromVertices' must equal the rows in 'matrix'");
        }
        if (matrixI3 != null && matrixI3.sizeOfRows() != vector.size()) {
            throw new GraphError("The size of 'fromVertices' must equal the rows in 'matrix'");
        }
        this.construct(matrixI, matrixI2, matrixI3, vector, vector2);
    }

    public MatrixGraph(MatrixI matrixI, MatrixI matrixI2, MatrixI matrixI3, VertexI[] vertexIArray, VertexI[] vertexIArray2) throws ParallelEdgeException {
        if (matrixI != null && matrixI.sizeOfRows() != vertexIArray.length) {
            throw new GraphError("The size of 'fromVertices' must equal the rows in 'matrix'");
        }
        if (matrixI != null && matrixI.sizeOfColumns() != vertexIArray2.length) {
            throw new GraphError("The size of 'toVertices' must equal the columns in 'matrix'");
        }
        if (matrixI2 != null && matrixI2.sizeOfRows() != vertexIArray.length) {
            throw new GraphError("The size of 'fromVertices' must equal the rows in 'matrix'");
        }
        if (matrixI2 != null && matrixI2.sizeOfColumns() != vertexIArray2.length) {
            throw new GraphError("The size of 'toVertices' must equal the columns in 'matrix'");
        }
        if (matrixI3 != null && matrixI3.sizeOfRows() != vertexIArray.length) {
            throw new GraphError("The size of 'fromVertices' must equal the rows in 'matrix'");
        }
        if (matrixI3 != null && matrixI3.sizeOfColumns() != vertexIArray2.length) {
            throw new GraphError("The size of 'toVertices' must equal the columns in 'matrix'");
        }
        this.construct(matrixI, matrixI2, matrixI3, vertexIArray, vertexIArray2);
    }

    private void construct(GraphI graphI, Object object, EdgePropertiesI edgePropertiesI) {
        int n;
        int n2;
        Object object2;
        Object object3;
        Object object4;
        this._isSymmetric = graphI.isSymmetric();
        if (edgePropertiesI == null) {
            edgePropertiesI = new PropertiesAdapter();
        }
        int n3 = graphI.sizeOfVertices();
        double[][] dArray = new double[n3][n3];
        double[][] dArray2 = new double[n3][n3];
        double[][] dArray3 = new double[n3][n3];
        int n4 = 0;
        while (n4 < n3) {
            object4 = dArray3[n4];
            object3 = dArray[n4];
            object2 = dArray2[n4];
            n2 = 0;
            while (n2 < n3) {
                object4[n2] = Double.POSITIVE_INFINITY;
                object3[n2] = Double.POSITIVE_INFINITY;
                object2[n2] = Double.POSITIVE_INFINITY;
                ++n2;
            }
            ++n4;
        }
        this._theEdge = new Edge();
        this._vertexHashtable = new Hashtable();
        object4 = graphI.mutableEdges();
        while (object4.hasMoreElements()) {
            object3 = (EdgeI)object4.nextElement();
            object2 = object3.getKey();
            if (object != object2 && (object == null || object2 == null || !object.equals(object2))) continue;
            n2 = object3.getToVertex().getIndex();
            n = object3.getFromVertex().getIndex();
            if (!edgePropertiesI.isEdgeRestricted((EdgeI)object3, false)) {
                dArray3[n][n2] = edgePropertiesI.getEdgeCost((EdgeI)object3, false);
                dArray[n][n2] = edgePropertiesI.getEdgeTime((EdgeI)object3, false);
                dArray2[n][n2] = edgePropertiesI.getEdgeDistance((EdgeI)object3, false);
            }
            if (object3.isDirected() || edgePropertiesI.isEdgeRestricted((EdgeI)object3, true)) continue;
            dArray3[n2][n] = edgePropertiesI.getEdgeCost((EdgeI)object3, true);
            dArray[n2][n] = edgePropertiesI.getEdgeTime((EdgeI)object3, true);
            dArray2[n2][n] = edgePropertiesI.getEdgeDistance((EdgeI)object3, true);
        }
        this._toVertices = new Vertex[n3];
        this._fromVertices = new Vertex[n3];
        object3 = graphI.vertices();
        while (object3.hasMoreElements()) {
            object2 = (VertexI)object3.nextElement();
            n2 = object2.getIndex();
            double[] dArray4 = dArray3[n2];
            double[] dArray5 = dArray[n2];
            double[] dArray6 = dArray2[n2];
            Vertex vertex = new Vertex(n2, (VertexI)object2, dArray4, dArray5, dArray6);
            this._vertexHashtable.put(vertex._key, vertex);
            vertex._fromIndex = vertex._toIndex = n2;
            this._fromVertices[n2] = this._toVertices[n2] = vertex;
        }
        this._sizeOfEdges = 0;
        int n5 = 0;
        while (n5 < n3) {
            Vertex vertex = this._fromVertices[n5];
            n = 0;
            while (n < n3) {
                if (vertex._edgeCosts[n] != Double.POSITIVE_INFINITY) {
                    ++this._sizeOfEdges;
                    ++vertex._outDegree;
                    ++this._toVertices[n]._inDegree;
                }
                ++n;
            }
            ++n5;
        }
    }

    private void construct(MatrixI matrixI, MatrixI matrixI2, MatrixI matrixI3, Vector vector, Vector vector2) throws DuplicateVertexException {
        int n = vector.size();
        VertexI[] vertexIArray = new Vertex[n];
        int n2 = 0;
        while (n2 < n) {
            vertexIArray[n2] = new Vertex(n2, vector.elementAt(n2), vector2 == null ? null : vector2.elementAt(n2), null);
            ++n2;
        }
        try {
            this.construct(matrixI, matrixI2, matrixI3, vertexIArray, vertexIArray);
        }
        catch (ParallelEdgeException parallelEdgeException) {
            throw new DuplicateVertexException();
        }
    }

    private void construct(MatrixI matrixI, MatrixI matrixI2, MatrixI matrixI3, VertexI[] vertexIArray, VertexI[] vertexIArray2) throws ParallelEdgeException {
        Object object;
        VertexI vertexI;
        this._isSymmetric = false;
        int n = 0;
        double[][] dArray = matrixI.getArray();
        double[][] dArray2 = matrixI2 == null ? null : matrixI2.getArray();
        double[][] dArray3 = matrixI3 == null ? null : matrixI3.getArray();
        int n2 = vertexIArray.length;
        int n3 = vertexIArray2.length;
        this._theEdge = new Edge();
        this._vertexHashtable = new Hashtable();
        this._fromVertices = new Vertex[n2];
        int n4 = 0;
        while (n4 < n2) {
            VertexI vertexI2 = vertexIArray[n4];
            vertexI = (Vertex)this._vertexHashtable.get(vertexI2.getKey());
            if (vertexI != null) {
                throw new ParallelEdgeException("Parallel Edge From - " + vertexI2.getKey().toString());
            }
            object = dArray[n4];
            double[] dArray4 = dArray2 == null ? null : dArray2[n4];
            double[] dArray5 = dArray3 == null ? null : dArray3[n4];
            vertexI = new Vertex(n++, vertexI2, (double[])object, dArray4, dArray5);
            this._vertexHashtable.put(((VertexBase)vertexI)._key, vertexI);
            ((Vertex)vertexI)._fromIndex = n4;
            this._fromVertices[n4] = vertexI;
            ++n4;
        }
        this._toVertices = new Vertex[n3];
        int n5 = 0;
        while (n5 < n3) {
            vertexI = vertexIArray2[n5];
            object = (Vertex)this._vertexHashtable.get(vertexI.getKey());
            if (object != null) {
                if (object._toIndex != -1) {
                    throw new ParallelEdgeException("Parallel Edge To - " + vertexI.getKey().toString());
                }
            } else {
                object = new Vertex(n++, vertexI, null, null, null);
                this._vertexHashtable.put(object._key, object);
            }
            object._toIndex = n5;
            this._toVertices[n5] = object;
            ++n5;
        }
        this._sizeOfEdges = 0;
        int n6 = 0;
        while (n6 < n2) {
            object = this._fromVertices[n6];
            int n7 = 0;
            while (n7 < n3) {
                if (object._edgeCosts[n7] != Double.POSITIVE_INFINITY) {
                    ++this._sizeOfEdges;
                    ++object._outDegree;
                    ++this._toVertices[n7]._inDegree;
                }
                ++n7;
            }
            ++n6;
        }
    }

    public int getChangeCount() {
        return 0;
    }

    public EdgeI getEdge(VertexI vertexI, VertexI vertexI2, Object object) {
        if (object != null) {
            return null;
        }
        if (vertexI2.getGraph() != this) {
            throw new GraphError("The to vertex is not contained in this graph");
        }
        if (vertexI.getGraph() != this) {
            throw new GraphError("The from vertex is not contained in this graph");
        }
        return ((Vertex)vertexI).getEdgeTo((Vertex)vertexI2, new Edge());
    }

    public EdgeI getMutableEdge(VertexI vertexI, VertexI vertexI2, Object object) {
        if (object != null) {
            return null;
        }
        if (vertexI2.getGraph() != this) {
            throw new GraphError("The to vertex is not contained in this graph");
        }
        if (vertexI.getGraph() != this) {
            throw new GraphError("The from vertex is not contained in this graph");
        }
        return ((Vertex)vertexI).getEdgeTo((Vertex)vertexI2, this._theEdge);
    }

    public VertexI getVertex(Object object) {
        return (VertexI)this._vertexHashtable.get(object);
    }

    public boolean isSymmetric() {
        if (this._symmetric != null) {
            return this._symmetric;
        }
        return this._isSymmetric;
    }

    public int sizeOfDirectedEdges() {
        return this.sizeOfEdges();
    }

    public int sizeOfEdges() {
        return this._sizeOfEdges;
    }

    public int sizeOfVertices() {
        return this._vertexHashtable.size();
    }

    public Enumeration vertices() {
        return this._vertexHashtable.elements();
    }

    class Vertex
    extends VertexBase
    implements VertexI,
    Serializable {
        int _fromIndex = -1;
        int _toIndex = -1;
        double[] _edgeCosts;
        double[] _edgeTimes;
        double[] _edgeDists;

        Vertex(int n, VertexI vertexI, double[] dArray, double[] dArray2, double[] dArray3) {
            super(n, vertexI.getKey(), vertexI.getValue());
            this._edgeCosts = dArray;
            this._edgeTimes = dArray2;
            this._edgeDists = dArray3;
        }

        Vertex(int n, Object object, Object object2, double[] dArray) {
            super(n, object, object2);
            this._edgeCosts = dArray;
        }

        Vertex(int n, Object object, Object object2, double[] dArray, double[] dArray2, double[] dArray3) {
            super(n, object, object2);
            this._edgeCosts = dArray;
            this._edgeTimes = dArray2;
            this._edgeDists = dArray3;
        }

        public Edge getEdgeTo(Vertex vertex, Edge edge) {
            if (this._edgeCosts == null || vertex._toIndex == -1) {
                return null;
            }
            int n = vertex._toIndex;
            double d = this._edgeCosts[n];
            if (d == Double.POSITIVE_INFINITY) {
                return null;
            }
            edge._cost = d;
            edge._time = this._edgeCosts == null ? 0.0 : this._edgeCosts[n];
            edge._dist = this._edgeDists == null ? 0.0 : this._edgeDists[n];
            edge._index = this._index * MatrixGraph.this.sizeOfVertices() + n;
            edge._fromVertex = this;
            edge._toVertex = vertex;
            return edge;
        }

        public GraphI getGraph() {
            return MatrixGraph.this;
        }

        public Enumeration inEdges() {
            return new InEdgeEnumeration(this, MatrixGraph.this._fromVertices, MatrixGraph.this._toVertices, false);
        }

        public Enumeration mutableInEdges() {
            return new InEdgeEnumeration(this, MatrixGraph.this._fromVertices, MatrixGraph.this._toVertices, true);
        }

        public Enumeration mutableOutEdges() {
            return new OutEdgeEnumeration(this, MatrixGraph.this._fromVertices, MatrixGraph.this._toVertices, true);
        }

        Edge newEdge() {
            return new Edge();
        }

        public Enumeration outEdges() {
            return new OutEdgeEnumeration(this, MatrixGraph.this._fromVertices, MatrixGraph.this._toVertices, false);
        }

        public String toString() {
            return String.valueOf(String.valueOf(this._key)) + ", " + this._value;
        }

        class OutEdgeEnumeration
        implements Enumeration {
            Edge _edge = null;
            Vertex _from;
            Vertex[] _toVerts;
            boolean _mutable;
            int _indexBase;
            int _i;

            public OutEdgeEnumeration(Vertex vertex2, Vertex[] vertexArray, Vertex[] vertexArray2, boolean bl) {
                if (vertex2._fromIndex == -1) {
                    return;
                }
                this._from = vertex2;
                this._mutable = bl;
                this._toVerts = vertexArray2;
                this._indexBase = vertex2._fromIndex * vertexArray.length;
                this._i = 0;
                while (this._i < this._toVerts.length) {
                    double d = this._from._edgeCosts[this._i];
                    if (d != Double.POSITIVE_INFINITY) {
                        double d2 = this._from._edgeTimes == null ? 0.0 : this._from._edgeTimes[this._i];
                        double d3 = this._from._edgeDists == null ? 0.0 : this._from._edgeDists[this._i];
                        this._edge = this._from.newEdge();
                        this._edge._fromVertex = this._from;
                        this._edge._toVertex = this._toVerts[this._i];
                        this._edge._cost = d;
                        this._edge._time = d2;
                        this._edge._dist = d3;
                        this._edge._index = this._indexBase + this._i;
                        ++this._i;
                        return;
                    }
                    ++this._i;
                }
            }

            public boolean hasMoreElements() {
                return this._edge != null;
            }

            public Object nextElement() {
                if (this._edge == null) {
                    return null;
                }
                Edge edge = this._edge;
                while (this._i < this._toVerts.length) {
                    double d = this._from._edgeCosts[this._i];
                    if (d != Double.POSITIVE_INFINITY) {
                        if (!this._mutable) {
                            this._edge = this._from.newEdge();
                            this._edge._fromVertex = this._from;
                        }
                        this._edge._toVertex = this._toVerts[this._i];
                        this._edge._cost = d;
                        this._edge._time = this._from._edgeTimes == null ? 0.0 : this._from._edgeTimes[this._i];
                        this._edge._dist = this._from._edgeDists == null ? 0.0 : this._from._edgeDists[this._i];
                        this._edge._index = this._indexBase + this._i;
                        ++this._i;
                        return edge;
                    }
                    ++this._i;
                }
                this._edge = null;
                return edge;
            }
        }

        class InEdgeEnumeration
        implements Enumeration {
            Edge _edge = null;
            Vertex _to;
            Vertex[] _fromVerts;
            boolean _mutable;
            int _i;

            public InEdgeEnumeration(Vertex vertex2, Vertex[] vertexArray, Vertex[] vertexArray2, boolean bl) {
                if (vertex2._toIndex == -1) {
                    return;
                }
                this._to = vertex2;
                this._mutable = bl;
                this._fromVerts = vertexArray;
                this._i = 0;
                while (this._i < this._fromVerts.length) {
                    Vertex vertex3 = this._fromVerts[this._i];
                    double d = vertex3._edgeCosts[this._to._toIndex];
                    if (d != Double.POSITIVE_INFINITY) {
                        double d2 = vertex3._edgeTimes == null ? 0.0 : vertex3._edgeTimes[this._to._toIndex];
                        double d3 = vertex3._edgeDists == null ? 0.0 : vertex3._edgeDists[this._to._toIndex];
                        this._edge = this._to.newEdge();
                        this._edge._toVertex = this._to;
                        this._edge._fromVertex = vertex3;
                        this._edge._cost = d;
                        this._edge._time = d2;
                        this._edge._dist = d3;
                        this._edge._index = this._to._toIndex + this._i * this._fromVerts.length;
                        ++this._i;
                        return;
                    }
                    ++this._i;
                }
            }

            public boolean hasMoreElements() {
                return this._edge != null;
            }

            public Object nextElement() {
                if (this._edge == null) {
                    return null;
                }
                Edge edge = this._edge;
                while (this._i < this._fromVerts.length) {
                    Vertex vertex = this._fromVerts[this._i];
                    double d = vertex._edgeCosts[this._to._toIndex];
                    if (d != Double.POSITIVE_INFINITY) {
                        if (!this._mutable) {
                            this._edge = this._to.newEdge();
                            this._edge._toVertex = this._to;
                        }
                        this._edge._fromVertex = vertex;
                        this._edge._cost = d;
                        this._edge._time = vertex._edgeCosts == null ? 0.0 : vertex._edgeCosts[this._to._toIndex];
                        this._edge._dist = vertex._edgeDists == null ? 0.0 : vertex._edgeDists[this._to._toIndex];
                        this._edge._index = this._to._toIndex + this._i * this._fromVerts.length;
                        ++this._i;
                        return edge;
                    }
                    ++this._i;
                }
                this._edge = null;
                return edge;
            }
        }
    }

    class Edge
    implements EdgeI,
    Serializable {
        int _index;
        double _cost;
        double _time;
        double _dist;
        Vertex _toVertex;
        Vertex _fromVertex;

        Edge() {
        }

        public double getCost(boolean bl) {
            return this._cost;
        }

        public double getDistance(boolean bl) {
            return this._dist;
        }

        public VertexI getFromVertex() {
            return this._fromVertex;
        }

        public GraphI getGraph() {
            return MatrixGraph.this;
        }

        public int getIndex() {
            return this._index;
        }

        public Object getKey() {
            return null;
        }

        public GraphI getSubgraph() {
            return null;
        }

        public double getTime(boolean bl) {
            return this._time;
        }

        public VertexI getToVertex() {
            return this._toVertex;
        }

        public Object getValue() {
            return null;
        }

        public boolean isDirected() {
            return true;
        }

        public boolean isEdge() {
            return true;
        }

        public boolean isVertex() {
            return false;
        }

        public String toString() {
            return String.valueOf(String.valueOf(this._fromVertex._key)) + "--> " + this._toVertex._key + ", null, " + this._cost;
        }
    }
}

