/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.geom.rect3;

import drasys.or.geom.rect3.LineSegmentI;
import drasys.or.geom.rect3.Point;
import drasys.or.geom.rect3.PointI;
import drasys.or.geom.rect3.Range;
import drasys.or.geom.rect3.RangeI;
import drasys.or.geom.rect3.Rect3;
import java.io.Serializable;

public class LineSegment
extends Rect3
implements LineSegmentI,
Serializable {
    PointI _point1;
    PointI _point2;
    double _length;

    public LineSegment(double d, double d2, double d3, double d4, double d5, double d6) {
        this(new Point(d, d2, d3), new Point(d4, d5, d6));
    }

    public LineSegment(PointI pointI, PointI pointI2) {
        this._point2 = new Point(pointI2);
        this._point1 = new Point(pointI);
        this._length = pointI.distanceTo(pointI2);
    }

    public PointI centroid() {
        return new Point((this.x1() + this.x2()) * 0.5, (this.y1() + this.y2()) * 0.5, (this.z1() + this.z2()) * 0.5);
    }

    public double distanceProxyTo(PointI pointI) {
        double d;
        double d2;
        double d3 = this._point2.x() - this._point1.x();
        double d4 = this._point2.y() - this._point1.y();
        double d5 = this._point2.z() - this._point1.z();
        double d6 = pointI.x() - this._point1.x();
        double d7 = d3 * d6 + d4 * (d2 = pointI.y() - this._point1.y()) + d5 * (d = pointI.z() - this._point1.z());
        if (d7 < 0.0) {
            return d6 * d6 + d2 * d2 + d * d;
        }
        double d8 = d7 / this._length;
        if (d8 > this._length) {
            double d9 = pointI.x() - this._point2.x();
            double d10 = pointI.y() - this._point2.y();
            double d11 = pointI.z() - this._point2.z();
            return d9 * d9 + d10 * d10 + d11 * d11;
        }
        return d6 * d6 + d2 * d2 + d * d - d8 * d8;
    }

    public double distanceTo(PointI pointI) {
        return Math.sqrt(this.distanceProxyTo(pointI));
    }

    public boolean equals(Object object) {
        if (!(object instanceof LineSegmentI)) {
            return false;
        }
        LineSegmentI lineSegmentI = (LineSegmentI)object;
        if (!Point.equals(this._point1, lineSegmentI.point1(), this.coordinateSystem().getAccuracy())) {
            return false;
        }
        return Point.equals(this._point2, lineSegmentI.point2(), this.coordinateSystem().getAccuracy());
    }

    public drasys.or.geom.PointI from() {
        return this._point1;
    }

    public drasys.or.geom.PointI getPoint1() {
        return this._point1;
    }

    public drasys.or.geom.PointI getPoint2() {
        return this._point2;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this._point1.x()) + Double.doubleToLongBits(this._point1.y()) + Double.doubleToLongBits(this._point1.z()) + Double.doubleToLongBits(this._point2.x()) + Double.doubleToLongBits(this._point2.y()) + Double.doubleToLongBits(this._point2.z());
        return (int)(l ^ l >> 32);
    }

    public double length() {
        return this._length;
    }

    public PointI nearestPointTo(PointI pointI) {
        double d;
        double d2;
        double d3 = this._point2.x() - this._point1.x();
        double d4 = this._point2.y() - this._point1.y();
        double d5 = this._point2.z() - this._point1.z();
        double d6 = pointI.x() - this._point1.x();
        double d7 = d3 * d6 + d4 * (d2 = pointI.y() - this._point1.y()) + d5 * (d = pointI.z() - this._point1.z());
        if (d7 < 0.0) {
            return this._point1;
        }
        double d8 = d7 / this._length;
        if (d8 > this._length) {
            return this._point2;
        }
        return new Point(this._point1.x() + (d8 /= this._length) * d3, this._point1.y() + d8 * d4, this._point1.z() + d8 * d5);
    }

    public PointI point1() {
        return this._point1;
    }

    public PointI point2() {
        return this._point2;
    }

    public RangeI range() {
        return new Range(this._point1, this._point2);
    }

    public drasys.or.geom.PointI to() {
        return this._point2;
    }

    public String toString() {
        return "rect3.LineSegment{" + this._point1 + "; " + this._point2 + "}";
    }

    public double x1() {
        return this._point1.x();
    }

    public double x2() {
        return this._point2.x();
    }

    public double y1() {
        return this._point1.y();
    }

    public double y2() {
        return this._point2.y();
    }

    public double z1() {
        return this._point1.z();
    }

    public double z2() {
        return this._point2.z();
    }
}

