/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.geom.geo;

import drasys.or.geom.GeomError;
import drasys.or.geom.geo.CoordinateSystem;
import drasys.or.geom.geo.Geo;
import drasys.or.geom.geo.PointI;
import drasys.or.geom.geo.Range;
import drasys.or.geom.geo.RangeI;
import drasys.or.matrix.VectorI;
import java.io.Serializable;

public class Point
extends Geo
implements drasys.or.geom.PointI,
PointI,
Serializable {
    private double _longitude;
    private double _latitude;

    public Point(double d, double d2) {
        if (d2 < -90.0) {
            throw new GeomError("The latitude can't be less than -90.0");
        }
        if (d2 > 90.0) {
            throw new GeomError("The latitude can't be greater than +90.0");
        }
        this._longitude = Math.IEEEremainder(d, 360.0);
        this._latitude = d2;
    }

    public Point(PointI pointI) {
        this(pointI.longitude(), pointI.latitude());
    }

    public Point(VectorI vectorI) {
        this(vectorI.elementAt(0), vectorI.elementAt(1));
    }

    public Point(double[] dArray) {
        this(dArray[0], dArray[1]);
    }

    public PointI centroid() {
        return this;
    }

    public double directionTo(PointI pointI) {
        double d = pointI.longitude() - this._longitude;
        if (d > 180.0) {
            d -= 360.0;
        }
        if (d < -180.0) {
            d += 360.0;
        }
        double d2 = Math.atan2(d, pointI.latitude() - this._latitude);
        return d2;
    }

    public double distanceProxyTo(PointI pointI) {
        return this.ellipsoid().greatCircleSphericalDistance(this, pointI);
    }

    public double distanceTo(PointI pointI) {
        return this.ellipsoid().greatCircleSphericalDistance(this, pointI);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PointI)) {
            return false;
        }
        double d = CoordinateSystem.getInstance().getAccuracy();
        if (Math.abs(this._latitude - ((PointI)object).latitude()) > d) {
            return false;
        }
        double d2 = Math.IEEEremainder(this._longitude - ((PointI)object).longitude(), 360.0);
        return !(Math.abs(d2) > d);
    }

    public double getCoordinate(int n) {
        return n == 0 ? this._longitude : this._latitude;
    }

    public double getDirectionTo(drasys.or.geom.PointI pointI) {
        PointI pointI2 = (PointI)pointI;
        double d = Math.atan2(pointI2.longitude() - this._longitude, pointI2.latitude() - this._latitude);
        return d;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this._longitude) + Double.doubleToLongBits(this._latitude);
        return (int)(l ^ l >> 32);
    }

    public double latitude() {
        return this._latitude;
    }

    public double longitude() {
        return this._longitude;
    }

    public PointI nearestPointTo(PointI pointI) {
        return this;
    }

    public RangeI range() {
        return new Range(this, this);
    }

    public String toString() {
        return "geo.Point(longitude = " + this._longitude + ", latitude = " + this._latitude + ")";
    }
}

