/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.geom;

import drasys.or.CompareNumber;
import drasys.or.PairI;
import drasys.or.cont.PriorityQueue;
import drasys.or.cont.PriorityQueueI;
import drasys.or.geom.CoordinateSystemI;
import drasys.or.geom.PointI;
import drasys.or.geom.PointIndexI;
import drasys.or.geom.RangeI;
import java.util.Enumeration;

public class KDTree
implements PointIndexI {
    int _dim = -1;
    int _size;
    int _sizeOfSelected;
    Node _root;
    Node _list;
    Node _selected;
    RangeI _range;
    RangeI _selectRange;
    CoordinateSystemI _coordinateSystem;
    PriorityQueueI _priorityQueue;

    public KDTree() {
        this(new PriorityQueue(new CompareNumber()));
    }

    public KDTree(PriorityQueueI priorityQueueI) {
        this.removeAllElements();
        this._coordinateSystem = null;
        this._priorityQueue = priorityQueueI;
        this._priorityQueue.setCompare(new CompareNumber());
    }

    private void _selectRange(Node node, int n) {
        if (node == null) {
            return;
        }
        if (this._selectRange.includes(node._key)) {
            node._nextSel = this._selected;
            this._selected = node;
            ++this._sizeOfSelected;
        }
        int n2 = n % this._dim;
        double d = node._key.getCoordinate(n2);
        if (this._selectRange.getMin().getCoordinate(n2) <= d) {
            this._selectRange(node._left, n + 1);
        }
        if (this._selectRange.getMax().getCoordinate(n2) >= d) {
            this._selectRange(node._right, n + 1);
        }
    }

    public CoordinateSystemI coordinateSystem() {
        return this._coordinateSystem;
    }

    public Enumeration elements() {
        return new Enum(this._list);
    }

    public Object get(PointI pointI) {
        int n = 0;
        Node node = this._root;
        while (node != null) {
            if (pointI.equals(node._key)) break;
            int n2 = n % this._dim;
            node = pointI.getCoordinate(n2) <= node._key.getCoordinate(n2) ? node._left : node._right;
            ++n;
        }
        return node._value;
    }

    public PairI getNearestNeighborTo(PointI pointI) {
        if (this._list == null) {
            return null;
        }
        Node node = null;
        double d = Double.MAX_VALUE;
        Node node2 = this._list;
        while (node2 != null) {
            double d2 = pointI.getDistanceProxyTo(node2._key);
            if (d2 < d) {
                d = d2;
                node = node2;
            }
            node2 = node2._next;
        }
        return node;
    }

    public void put(PointI pointI, Object object) {
        if (this._coordinateSystem == null) {
            this.setCoordinateSystem(pointI.coordinateSystem());
        }
        this._range = this._range == null ? this._coordinateSystem.getRangeInstance(pointI, pointI) : this._range.getExpandedRange(pointI);
        Node node = new Node(pointI, object);
        node._next = this._list;
        this._list = node;
        ++this._size;
        if (this._root == null) {
            this._root = node;
            return;
        }
        int n = 0;
        Node node2 = this._root;
        while (node2 != null) {
            int n2 = n % this._dim;
            if (node._key.getCoordinate(n2) <= node2._key.getCoordinate(n2)) {
                if (node2._left == null) {
                    node2._left = node;
                    break;
                }
                node2 = node2._left;
            } else {
                if (node2._right == null) {
                    node2._right = node;
                    break;
                }
                node2 = node2._right;
            }
            ++n;
        }
    }

    public RangeI range() {
        return this._range;
    }

    public void removeAllElements() {
        this._sizeOfSelected = 0;
        this._size = 0;
        this._selected = null;
        this._root = null;
        this._list = null;
        this._range = null;
    }

    public int selectNearestNeighbors(PointI pointI, int n) {
        this._selected = null;
        this._sizeOfSelected = 0;
        if (this._list == null || n <= 0) {
            return 0;
        }
        int n2 = 0;
        double d = Double.MAX_VALUE;
        this._priorityQueue.removeAllElements();
        Node node = this._list;
        while (node != null) {
            double d2 = pointI.getDistanceProxyTo(node._key);
            if (n2 < n) {
                this._priorityQueue.insert(new Double(d2), node);
                d = (Double)this._priorityQueue.getHead().getFirst();
                ++n2;
            } else if (d2 < d) {
                this._priorityQueue.popHead();
                this._priorityQueue.insert(new Double(d2), node);
                d = (Double)this._priorityQueue.getHead().getFirst();
            }
            node = node._next;
        }
        Enumeration enumeration = this._priorityQueue.elements();
        while (enumeration.hasMoreElements()) {
            Node node2 = (Node)((PairI)enumeration.nextElement()).getSecond();
            node2._nextSel = this._selected;
            this._selected = node2;
            ++this._sizeOfSelected;
        }
        this._priorityQueue.removeAllElements();
        return this._sizeOfSelected;
    }

    public int selectRange(RangeI rangeI) {
        this._selected = null;
        this._sizeOfSelected = 0;
        this._selectRange = rangeI;
        this._selectRange(this._root, 0);
        return this._sizeOfSelected;
    }

    public Enumeration selectedElements() {
        return new SelEnum(this._selected);
    }

    public void setCoordinateSystem(CoordinateSystemI coordinateSystemI) {
        this.removeAllElements();
        this._coordinateSystem = coordinateSystemI;
        this._dim = this._coordinateSystem == null ? -1 : this._coordinateSystem.sizeOfDimensions();
    }

    public int size() {
        return this._size;
    }

    public int sizeOfSelected() {
        return this._sizeOfSelected;
    }

    public boolean supportsDuplicateKeys() {
        return true;
    }

    static class Enum
    implements Enumeration {
        Node _node;

        Enum(Node node) {
            this._node = node;
        }

        public boolean hasMoreElements() {
            return this._node != null;
        }

        public Object nextElement() {
            if (this._node == null) {
                return null;
            }
            Node node = this._node;
            this._node = this._node._next;
            return node;
        }
    }

    static class SelEnum
    implements Enumeration {
        Node _node;

        SelEnum(Node node) {
            this._node = node;
        }

        public boolean hasMoreElements() {
            return this._node != null;
        }

        public Object nextElement() {
            if (this._node == null) {
                return null;
            }
            Node node = this._node;
            this._node = this._node._nextSel;
            return node;
        }
    }

    static class Node
    implements PairI {
        Object _value;
        PointI _key;
        Node _left;
        Node _right;
        Node _next;
        Node _nextSel;

        Node(PointI pointI, Object object) {
            this._key = pointI;
            this._value = object;
            this._nextSel = null;
            this._next = null;
            this._right = null;
            this._left = null;
        }

        public Object getFirst() {
            return this._key;
        }

        public Object getSecond() {
            return this._value;
        }
    }
}

