/*
 * Decompiled with CFR 0.152.
 */
package drasys.or.cont;

import drasys.or.CompareI;
import drasys.or.InvalidPriorityException;
import drasys.or.PairI;
import drasys.or.cont.PriorityQueueI;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class BinaryHeap
implements PriorityQueueI,
Serializable {
    CompareI _compare;
    Vector _elements;

    public BinaryHeap(CompareI compareI) {
        this._compare = compareI;
        this._elements = new Vector();
    }

    public BinaryHeap(CompareI compareI, int n) {
        this._compare = compareI;
        this._elements = new Vector(n);
    }

    private PairI _insert(_Elem _Elem2) {
        int n;
        _Elem2._idx = n = this._elements.size();
        this._elements.addElement(_Elem2);
        this._moveUp(_Elem2);
        return _Elem2;
    }

    private void _moveDown(_Elem _Elem2) {
        int n = this._elements.size();
        _Elem _Elem3 = null;
        while (_Elem3 != _Elem2) {
            int n2;
            _Elem3 = _Elem2;
            int n3 = _Elem2._idx;
            int n4 = 2 * n3 + 1;
            if (n4 < n) {
                _Elem _Elem4 = (_Elem)this._elements.elementAt(n4);
                if (this._compare.compare(_Elem4._priority, _Elem3._priority) == 1) {
                    _Elem3 = _Elem4;
                }
            }
            if ((n2 = n4 + 1) < n) {
                _Elem _Elem5 = (_Elem)this._elements.elementAt(n2);
                if (this._compare.compare(_Elem5._priority, _Elem3._priority) == 1) {
                    _Elem3 = _Elem5;
                }
            }
            if (_Elem3 == _Elem2) continue;
            _Elem2._idx = _Elem3._idx;
            _Elem3._idx = n3;
            this._elements.setElementAt(_Elem3, _Elem3._idx);
            this._elements.setElementAt(_Elem2, _Elem2._idx);
        }
    }

    private void _moveUp(_Elem _Elem2) {
        int n = _Elem2._idx;
        int n2 = (n - 1) / 2;
        _Elem _Elem3 = (_Elem)this._elements.elementAt(n2);
        while (n > 0 && this._compare.compare(_Elem2._priority, _Elem3._priority) == 1) {
            _Elem3._idx = n;
            this._elements.setElementAt(_Elem3, _Elem3._idx);
            n = n2;
            n2 = (n - 1) / 2;
            _Elem3 = (_Elem)this._elements.elementAt(n2);
        }
        _Elem2._idx = n;
        this._elements.setElementAt(_Elem2, _Elem2._idx);
    }

    public void changePriority(PairI pairI, Object object) throws InvalidPriorityException {
        _Elem _Elem2 = (_Elem)pairI;
        if (this._elements.size() == 1) {
            _Elem2._priority = object;
            return;
        }
        int n = this._compare.compare(object, _Elem2._priority);
        if (n == 0) {
            return;
        }
        _Elem2._priority = object;
        if (n == -1) {
            this._moveDown(_Elem2);
        } else {
            this._moveUp(_Elem2);
        }
    }

    public boolean check() {
        int n = 0;
        while (n < this._elements.size()) {
            if (((_Elem)this._elements.elementAt((int)n))._idx != n) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public PairI elementAt(int n) {
        return (PairI)this._elements.elementAt(n);
    }

    public Enumeration elements() {
        return new _Enum(this);
    }

    public void ensureCapacity(int n) {
        this._elements.ensureCapacity(n);
    }

    public PairI getHead() {
        if (this._elements.size() == 0) {
            return null;
        }
        return (PairI)this._elements.elementAt(0);
    }

    public PairI insert(Object object) {
        return this._insert(new _Elem(object, object));
    }

    public PairI insert(Object object, Object object2) {
        return this._insert(new _Elem(object, object2));
    }

    public PairI popHead() {
        int n = this._elements.size();
        if (n == 0) {
            return null;
        }
        _Elem _Elem2 = (_Elem)this._elements.elementAt(0);
        _Elem _Elem3 = (_Elem)this._elements.elementAt(n - 1);
        this._elements.removeElementAt(n - 1);
        if (n == 1) {
            return _Elem2;
        }
        this._elements.setElementAt(_Elem3, 0);
        if (n == 2) {
            return _Elem2;
        }
        _Elem3._idx = 0;
        this._moveDown(_Elem3);
        return _Elem2;
    }

    public void removeAllElements() {
        this._elements.removeAllElements();
    }

    public void setCompare(CompareI compareI) {
        this.removeAllElements();
        this._compare = compareI;
    }

    public int size() {
        return this._elements.size();
    }

    class _Enum
    implements Enumeration {
        int _idx = 0;
        BinaryHeap _heap;

        _Enum(BinaryHeap binaryHeap2) {
            this._heap = binaryHeap2;
        }

        public boolean hasMoreElements() {
            return this._idx < this._heap.size();
        }

        public Object nextElement() {
            if (this._idx >= this._heap.size()) {
                return null;
            }
            return this._heap.elementAt(this._idx++);
        }
    }

    class _Elem
    implements PairI,
    Serializable {
        int _idx;
        Object _priority = null;
        Object _value = null;

        _Elem(Object object, Object object2) {
            this._priority = object;
            this._value = object2;
        }

        public Object getFirst() {
            return this._priority;
        }

        public Object getSecond() {
            return this._value;
        }

        public String toString() {
            return "Element[idx=" + String.valueOf(this._idx) + ",priority=" + this._priority.toString() + "]";
        }
    }
}

