/*
 * Decompiled with CFR 0.152.
 */
package omx.hdf5;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import omx.hdf5.AbstractOmxGroup;
import omx.hdf5.OmxDataset;
import omx.hdf5.OmxGroup;
import omx.hdf5.OmxModifiableDataset;
import omx.hdf5.OmxMutableGroup;

public class OmxModifiableGroup
extends AbstractOmxGroup
implements OmxMutableGroup {
    private String name = null;
    private Map<String, OmxDataset> datasets = null;
    private Map<String, OmxGroup> groups = null;
    private Map<String, Object> attributes = null;
    private boolean modified = false;
    private boolean attributesModified = false;
    private final OmxGroup parentGroup;

    public OmxModifiableGroup(OmxGroup parentGroup) {
        this.parentGroup = parentGroup;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.modified = true;
    }

    @Override
    public void setDatasets(Collection<OmxDataset> datasets) {
        this.datasets = new HashMap<String, OmxDataset>();
        for (OmxDataset dataset : datasets) {
            this.setDataset(dataset);
        }
        this.modified = true;
    }

    @Override
    public void setGroups(Collection<OmxGroup> groups) {
        this.groups = new HashMap<String, OmxGroup>();
        for (OmxGroup group : groups) {
            this.setGroup(group);
        }
        this.modified = true;
    }

    @Override
    public void setDataset(OmxDataset dataset) {
        if (this.datasets == null) {
            this.setDatasets(this.parentGroup.getDatasets());
        }
        OmxModifiableDataset mutableDataset = new OmxModifiableDataset(dataset);
        String groupName = mutableDataset.getName();
        String baseName = groupName.substring(groupName.lastIndexOf("/") + 1);
        mutableDataset.setName(String.valueOf(this.getName()) + "/" + baseName);
        this.datasets.put(baseName, dataset);
        this.modified = true;
    }

    @Override
    public void deleteDataset(String name) {
        if (this.datasets == null) {
            this.setDatasets(this.parentGroup.getDatasets());
        }
        if (!this.datasets.containsKey(name)) {
            throw new IllegalArgumentException("Dataset name not found: " + name);
        }
        this.datasets.remove(name);
        this.modified = true;
    }

    @Override
    public void setGroup(OmxGroup group) {
        if (this.groups == null) {
            this.setGroups(this.parentGroup.getGroups());
        }
        OmxModifiableGroup mutableGroup = new OmxModifiableGroup(group);
        String groupName = mutableGroup.getName();
        String baseName = groupName.substring(groupName.lastIndexOf("/") + 1);
        mutableGroup.setName(String.valueOf(this.getName()) + "/" + baseName);
        this.groups.put(baseName, group);
        this.modified = true;
    }

    @Override
    public void deleteGroup(String name) {
        if (this.groups == null) {
            this.setGroups(this.parentGroup.getGroups());
        }
        if (!this.groups.containsKey(name)) {
            throw new IllegalArgumentException("Group name not found: " + name);
        }
        this.groups.remove(name);
        this.modified = true;
    }

    @Override
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = new HashMap<String, Object>(attributes);
        this.modified = true;
        this.attributesModified = true;
    }

    @Override
    public void setAttribute(String key, Object attribute) {
        if (this.attributes == null) {
            this.setAttributes(this.parentGroup.getAttributes());
        }
        this.attributes.put(key, attribute);
        this.modified = true;
        this.attributesModified = true;
    }

    @Override
    public void deleteAttribute(String key) {
        if (this.attributes == null) {
            this.setAttributes(this.parentGroup.getAttributes());
        }
        if (!this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Attribute key not found: " + key);
        }
        this.attributes.remove(key);
        this.modified = true;
        this.attributesModified = true;
    }

    @Override
    public boolean isMutated() {
        return this.modified;
    }

    @Override
    public boolean areAttributesMutated() {
        return this.attributesModified;
    }

    @Override
    public String getName() {
        return this.name == null ? this.parentGroup.getName() : this.name;
    }

    @Override
    public Collection<OmxDataset> getDatasets() {
        return this.datasets == null ? this.parentGroup.getDatasets() : Collections.unmodifiableCollection(this.datasets.values());
    }

    @Override
    public Collection<OmxGroup> getGroups() {
        return this.groups == null ? this.parentGroup.getGroups() : Collections.unmodifiableCollection(this.groups.values());
    }

    @Override
    public Collection<String> getDatasetNames() {
        return this.datasets == null ? this.parentGroup.getDatasetNames() : Collections.unmodifiableCollection(this.datasets.keySet());
    }

    @Override
    public Collection<String> getGroupNames() {
        return this.groups == null ? this.parentGroup.getGroupNames() : Collections.unmodifiableCollection(this.groups.keySet());
    }

    @Override
    public OmxDataset getDataset(String name) {
        return this.datasets == null ? this.parentGroup.getDataset(name) : this.getDataset(name, this.datasets);
    }

    @Override
    public OmxGroup getGroup(String name) {
        return this.groups == null ? this.parentGroup.getGroup(name) : this.getGroup(name, this.groups);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes == null ? this.parentGroup.getAttributes() : Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public List<String> getNamedDatatypes() {
        return this.parentGroup.getNamedDatatypes();
    }

    @Override
    public List<String> getNtypes() {
        return this.parentGroup.getNtypes();
    }

    @Override
    public List<String> getUnknownTypes() {
        return this.parentGroup.getUnknownTypes();
    }

    @Override
    public OmxMutableGroup getMutableGroup() {
        return this;
    }

    @Override
    public boolean hasGroup(String name) {
        if (this.groups != null) {
            return this.hasGroup(name, this.groups);
        }
        return this.parentGroup.hasGroup(name);
    }

    @Override
    public boolean hasDataset(String name) {
        if (this.datasets != null) {
            return this.hasDataset(name, this.datasets);
        }
        return this.parentGroup.hasDataset(name);
    }
}

