/*
 * Decompiled with CFR 0.152.
 */
package omx.hdf5;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import omx.hdf5.OmxDataset;
import omx.hdf5.OmxHdf5Datatype;
import omx.hdf5.OmxMutableDataset;

public class OmxModifiableDataset
implements OmxMutableDataset {
    private String name = null;
    private int[] shape = null;
    private OmxHdf5Datatype datatype = null;
    private Map<String, Object> attributes = null;
    private Object data = null;
    private boolean modified = false;
    private boolean dataModified = false;
    private boolean attributesModified = false;
    private final OmxDataset parentDataset;

    public OmxModifiableDataset(OmxDataset parentDataset) {
        this.parentDataset = parentDataset;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.modified = true;
    }

    @Override
    public void setShape(int[] shape) {
        this.shape = Arrays.copyOf(shape, shape.length);
        this.modified = true;
    }

    @Override
    public void setDatatype(OmxHdf5Datatype datatype) {
        this.datatype = datatype;
        this.modified = true;
    }

    @Override
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = new HashMap<String, Object>(attributes);
        this.modified = true;
        this.attributesModified = true;
    }

    @Override
    public void setAttribute(String key, Object attribute) {
        if (this.attributes == null) {
            this.setAttributes(this.parentDataset.getAttributes());
        }
        this.attributes.put(key, attribute);
        this.modified = true;
        this.attributesModified = true;
    }

    @Override
    public void deleteAttribute(String key) {
        if (this.attributes == null) {
            this.setAttributes(this.parentDataset.getAttributes());
        }
        if (!this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Attribute key not found: " + key);
        }
        this.attributes.remove(key);
        this.modified = true;
        this.attributesModified = true;
    }

    @Override
    public void setData(Object data) {
        this.data = data;
        this.modified = true;
        this.dataModified = true;
    }

    @Override
    public boolean isMutated() {
        return this.modified;
    }

    @Override
    public boolean isDataMutated() {
        return this.dataModified;
    }

    @Override
    public boolean areAttributesMutated() {
        return this.attributesModified;
    }

    @Override
    public String getName() {
        return this.name == null ? this.parentDataset.getName() : this.name;
    }

    @Override
    public int[] getShape() {
        return this.shape == null ? this.parentDataset.getShape() : Arrays.copyOf(this.shape, this.shape.length);
    }

    @Override
    public OmxHdf5Datatype getDatatype() {
        return this.datatype == null ? this.parentDataset.getDatatype() : this.datatype;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes == null ? this.parentDataset.getAttributes() : Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public Object getData() {
        return this.data == null ? this.parentDataset.getData() : this.data;
    }

    @Override
    public OmxMutableDataset getMutableDataset() {
        return this;
    }
}

