/*
 * Decompiled with CFR 0.152.
 */
package omx.hdf5;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import omx.hdf5.AbstractOmxGroup;
import omx.hdf5.OmxDataset;
import omx.hdf5.OmxGroup;
import omx.hdf5.OmxModifiableGroup;
import omx.hdf5.OmxMutableGroup;

public class OmxMemoryGroup
extends AbstractOmxGroup {
    private final String name;
    private final Map<String, OmxDataset> datasets;
    private final Map<String, OmxGroup> groups;
    private final List<String> namedDatatypes = new LinkedList<String>();
    private final List<String> ntypes = new LinkedList<String>();
    private final List<String> unknownTypes = new LinkedList<String>();
    private final Map<String, Object> attributes;
    private final OmxMutableGroup mutableGroup;

    public OmxMemoryGroup(String name, Map<String, OmxDataset> datasets, Map<String, OmxGroup> groups, Map<String, Object> attributes) {
        this.name = name;
        this.datasets = datasets;
        this.groups = groups;
        this.attributes = attributes;
        this.mutableGroup = new OmxModifiableGroup(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<OmxDataset> getDatasets() {
        return Collections.unmodifiableCollection(this.datasets.values());
    }

    @Override
    public Collection<OmxGroup> getGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    @Override
    public Collection<String> getDatasetNames() {
        return Collections.unmodifiableCollection(this.datasets.keySet());
    }

    @Override
    public Collection<String> getGroupNames() {
        return Collections.unmodifiableCollection(this.groups.keySet());
    }

    @Override
    public OmxDataset getDataset(String name) {
        return this.getDataset(name, this.datasets);
    }

    @Override
    public OmxGroup getGroup(String name) {
        return this.getGroup(name, this.groups);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public List<String> getNamedDatatypes() {
        return Collections.unmodifiableList(this.namedDatatypes);
    }

    @Override
    public List<String> getNtypes() {
        return Collections.unmodifiableList(this.ntypes);
    }

    @Override
    public List<String> getUnknownTypes() {
        return Collections.unmodifiableList(this.unknownTypes);
    }

    @Override
    public OmxMutableGroup getMutableGroup() {
        return this.mutableGroup;
    }

    @Override
    public boolean hasGroup(String name) {
        return this.hasGroup(name, this.groups);
    }

    @Override
    public boolean hasDataset(String name) {
        return this.hasDataset(name, this.datasets);
    }
}

