/*
 * Decompiled with CFR 0.152.
 */
package omx.hdf5;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import omx.hdf5.OmxDataset;
import omx.hdf5.OmxHdf5Datatype;
import omx.hdf5.OmxModifiableDataset;
import omx.hdf5.OmxMutableDataset;

public class OmxMemoryDataset
implements OmxDataset {
    private final String name;
    private final int[] shape;
    private final OmxHdf5Datatype datatype;
    private final Map<String, Object> attributes;
    private final Object data;
    private final OmxMutableDataset mutableDataset;

    public OmxMemoryDataset(String name, int[] shape, OmxHdf5Datatype datatype, Map<String, Object> attributes, Object data) {
        this.name = name;
        this.shape = shape;
        this.datatype = datatype;
        this.attributes = attributes;
        this.data = data;
        this.mutableDataset = new OmxModifiableDataset(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int[] getShape() {
        return Arrays.copyOf(this.shape, this.shape.length);
    }

    @Override
    public OmxHdf5Datatype getDatatype() {
        return this.datatype;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public OmxMutableDataset getMutableDataset() {
        return this.mutableDataset;
    }
}

