/*
 * Decompiled with CFR 0.152.
 */
package omx.hdf5;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import omx.hdf5.AbstractOmxGroup;
import omx.hdf5.Hdf5Util;
import omx.hdf5.OmxDataset;
import omx.hdf5.OmxGroup;
import omx.hdf5.OmxHdf5Dataset;
import omx.hdf5.OmxModifiableGroup;
import omx.hdf5.OmxMutableGroup;

public class OmxHdf5Group
extends AbstractOmxGroup {
    private final String name;
    private final Map<String, OmxDataset> datasets = new HashMap<String, OmxDataset>();
    private final Map<String, OmxGroup> groups = new HashMap<String, OmxGroup>();
    private final List<String> namedDatatypes = new LinkedList<String>();
    private final List<String> ntypes = new LinkedList<String>();
    private final List<String> unknownTypes = new LinkedList<String>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final OmxMutableGroup mutableGroup;

    protected OmxHdf5Group(int fileId, String groupName, String parentName, boolean loadInfo) {
        this.name = String.valueOf(parentName) + (parentName.endsWith("/") ? "" : "/") + groupName;
        if (loadInfo) {
            this.loadGroupInformation(fileId);
        }
        this.mutableGroup = new OmxModifiableGroup(this);
    }

    public void loadGroupInformation(int fileId) {
        int groupId = -1;
        this.datasets.clear();
        this.groups.clear();
        this.namedDatatypes.clear();
        this.ntypes.clear();
        this.unknownTypes.clear();
        this.attributes.clear();
        try {
            try {
                String groupName = this.getName();
                int count = H5.H5Gn_members(fileId, groupName);
                if (count > 0) {
                    String[] oname = new String[count];
                    int[] otype = new int[count];
                    int[] ltype = new int[count];
                    long[] orefs = new long[count];
                    H5.H5Gget_obj_info_all(fileId, groupName, oname, otype, ltype, orefs, HDF5Constants.H5_INDEX_NAME);
                    int i = 0;
                    while (i < otype.length) {
                        String s = oname[i];
                        switch (Hdf5Util.H5O_type.get(otype[i])) {
                            case H5O_TYPE_UNKNOWN: {
                                break;
                            }
                            case H5O_TYPE_GROUP: {
                                this.groups.put(s, new OmxHdf5Group(fileId, s, groupName, true));
                                break;
                            }
                            case H5O_TYPE_DATASET: {
                                this.datasets.put(s, new OmxHdf5Dataset(fileId, s, groupName));
                                break;
                            }
                            case H5O_TYPE_NAMED_DATATYPE: {
                                this.namedDatatypes.add(s);
                                break;
                            }
                            case H5O_TYPE_NTYPES: {
                                this.ntypes.add(s);
                            }
                        }
                        ++i;
                    }
                }
                groupId = H5.H5Gopen(fileId, groupName, HDF5Constants.H5P_DEFAULT);
                this.attributes.putAll(Hdf5Util.getAttributes(groupId));
            }
            catch (HDF5LibraryException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (groupId > -1) {
                try {
                    H5.H5Gclose(groupId);
                }
                catch (HDF5LibraryException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<OmxDataset> getDatasets() {
        return Collections.unmodifiableCollection(this.datasets.values());
    }

    @Override
    public Collection<OmxGroup> getGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    @Override
    public Collection<String> getDatasetNames() {
        return Collections.unmodifiableCollection(this.datasets.keySet());
    }

    @Override
    public Collection<String> getGroupNames() {
        return Collections.unmodifiableCollection(this.groups.keySet());
    }

    @Override
    public OmxDataset getDataset(String name) {
        return this.getDataset(name, this.datasets);
    }

    @Override
    public OmxGroup getGroup(String name) {
        return this.getGroup(name, this.groups);
    }

    @Override
    public List<String> getNamedDatatypes() {
        return Collections.unmodifiableList(this.namedDatatypes);
    }

    @Override
    public List<String> getNtypes() {
        return Collections.unmodifiableList(this.ntypes);
    }

    @Override
    public List<String> getUnknownTypes() {
        return this.unknownTypes;
    }

    @Override
    public OmxMutableGroup getMutableGroup() {
        return this.mutableGroup;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public boolean hasGroup(String name) {
        return this.hasGroup(name, this.groups);
    }

    @Override
    public boolean hasDataset(String name) {
        return this.hasDataset(name, this.datasets);
    }
}

