/*
 * Decompiled with CFR 0.152.
 */
package omx.hdf5;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import omx.hdf5.FileMode;
import omx.hdf5.Hdf5Util;
import omx.hdf5.OmxConstants;
import omx.hdf5.OmxDataset;
import omx.hdf5.OmxGroup;
import omx.hdf5.OmxHdf5Datatype;
import omx.hdf5.OmxHdf5Group;
import omx.hdf5.OmxMutableDataset;
import omx.hdf5.OmxMutableGroup;

public class OmxHdf5File
implements AutoCloseable {
    private final Path filePath;
    private final AtomicBoolean opened;
    private final AtomicBoolean writable;
    private volatile OmxGroup baseGroup;
    private volatile int fileId;

    public OmxHdf5File(Path filePath) {
        this.filePath = filePath;
        this.opened = new AtomicBoolean(false);
        this.writable = new AtomicBoolean(false);
    }

    public OmxHdf5File(String filePath) {
        this(Paths.get(filePath, new String[0]));
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public OmxGroup getBaseGroup() {
        return this.baseGroup;
    }

    public void openReadOnly() {
        this.open(FileMode.READ, null);
    }

    public void openReadWrite() {
        this.open(FileMode.WRITE, null);
    }

    public void openNew(int[] shape) {
        if (!this.isValidShape(shape)) {
            throw new IllegalStateException("Invalid shape: " + Arrays.toString(shape));
        }
        this.open(FileMode.NEW, shape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(FileMode mode, int[] shape) {
        if (this.opened.get()) {
            throw new IllegalStateException("File already opened: " + this.filePath);
        }
        AtomicBoolean atomicBoolean = this.opened;
        synchronized (atomicBoolean) {
            int accessMode = -1;
            switch (mode) {
                case READ: {
                    if (!Files.exists(this.filePath, new LinkOption[0])) {
                        throw new IllegalArgumentException("File path not found to read: " + this.filePath);
                    }
                    accessMode = HDF5Constants.H5F_ACC_RDONLY;
                    this.writable.set(false);
                    break;
                }
                case WRITE: {
                    if (!Files.exists(this.filePath, new LinkOption[0])) {
                        throw new IllegalArgumentException("File path not found to read: " + this.filePath);
                    }
                    accessMode = HDF5Constants.H5F_ACC_RDWR;
                    this.writable.set(true);
                    break;
                }
                case NEW: {
                    accessMode = HDF5Constants.H5F_ACC_RDWR;
                    this.writable.set(true);
                }
            }
            if (mode == FileMode.NEW) {
                try {
                    this.fileId = H5.H5Fcreate(this.filePath.toString(), HDF5Constants.H5F_ACC_TRUNC, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
                    this.setupNewFile(shape);
                    H5.H5Fclose(this.fileId);
                }
                catch (HDF5LibraryException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                this.fileId = H5.H5Fopen(this.filePath.toString(), accessMode, HDF5Constants.H5P_DEFAULT);
            }
            catch (HDF5LibraryException e) {
                throw new RuntimeException(e);
            }
            this.baseGroup = new OmxHdf5Group(this.fileId, "", "", true);
            this.checkForConsistency();
            this.opened.set(true);
        }
    }

    private void checkForConsistency() {
        OmxConstants.OmxVersion version = this.getOmxVersion();
        this.getShape(version);
        this.checkDatasetsForConsistency(version);
        this.checkLookupsForConsistency(version);
    }

    public OmxConstants.OmxVersion getOmxVersion() {
        Map<String, Object> attributes = this.getBaseGroup().getAttributes();
        if (!attributes.containsKey(OmxConstants.OmxNames.OMX_VERSION_KEY.getKey())) {
            throw new IllegalStateException("OMX file missing version attribute: " + OmxConstants.OmxNames.OMX_VERSION_KEY.getKey());
        }
        return OmxConstants.OmxVersion.getVersion((String)attributes.get(OmxConstants.OmxNames.OMX_VERSION_KEY.getKey()));
    }

    public int[] getShape() {
        return this.getShape(this.getOmxVersion());
    }

    private int[] getShape(OmxConstants.OmxVersion version) {
        Map<String, Object> attributes = this.getBaseGroup().getAttributes();
        if (!attributes.containsKey(OmxConstants.OmxNames.OMX_SHAPE_KEY.getKey())) {
            throw new IllegalStateException("OMX file missing shape attribute: " + OmxConstants.OmxNames.OMX_SHAPE_KEY.getKey());
        }
        int[] shape = (int[])attributes.get(OmxConstants.OmxNames.OMX_SHAPE_KEY.getKey());
        if (!this.isValidShape(shape)) {
            throw new IllegalStateException("OMX file has invalid shape attribute: " + Arrays.toString(shape));
        }
        return shape;
    }

    private void checkDatasetsForConsistency(OmxConstants.OmxVersion version) {
        if (!this.getBaseGroup().getGroupNames().contains(OmxConstants.OmxNames.OMX_DATA_GROUP.getKey())) {
            throw new IllegalStateException("OMX file missing 'data' group.");
        }
        int[] shape = this.getShape(version);
        for (OmxDataset dataset : this.getBaseGroup().getGroup(OmxConstants.OmxNames.OMX_DATA_GROUP.getKey()).getDatasets()) {
            this.checkDatasetShapeForConsistency(shape, dataset);
        }
    }

    private void checkDatasetShapeForConsistency(int[] shape, OmxDataset dataset) {
        if (!Arrays.equals(shape, dataset.getShape())) {
            throw new IllegalStateException("The shape of dataset '" + dataset.getName() + "' does not match OMX file's specified shape (" + Arrays.toString(shape) + "): " + Arrays.toString(dataset.getShape()));
        }
    }

    private void checkLookupsForConsistency(OmxConstants.OmxVersion version) {
        if (!this.getBaseGroup().getGroupNames().contains(OmxConstants.OmxNames.OMX_LOOKUP_GROUP.getKey())) {
            throw new IllegalStateException("OMX file missing 'lookup' group.");
        }
        for (OmxDataset dataset : this.getBaseGroup().getGroup(OmxConstants.OmxNames.OMX_LOOKUP_GROUP.getKey()).getDatasets()) {
            int[] lookupShape = dataset.getShape();
            if (lookupShape.length != 1) {
                throw new IllegalStateException("OMX lookup '" + dataset.getName() + "' shape is not that of a vector: " + Arrays.toString(lookupShape));
            }
            int lookupLength = lookupShape[0];
            int[] shape = this.getShape(version);
            if (lookupLength == shape[0] || lookupLength == shape[1]) continue;
            throw new IllegalStateException("OMX lookup '" + dataset.getName() + "' length (" + lookupLength + ") " + "does not match to either matrix dimension (" + Arrays.toString(shape) + ")");
        }
    }

    private boolean isValidShape(int[] shape) {
        return shape.length == 2 || shape[0] > 0 || shape[1] > 0;
    }

    @Override
    public void close() {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean withSave) {
        AtomicBoolean atomicBoolean = this.opened;
        synchronized (atomicBoolean) {
            if (this.opened.compareAndSet(true, false)) {
                if (this.writable.get() && withSave) {
                    this.save(false);
                }
                try {
                    H5.H5Fclose(this.fileId);
                }
                catch (HDF5LibraryException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public boolean isOpened() {
        return this.opened.get();
    }

    private void setupNewFile(int[] shape) {
        try {
            int rootGroup = H5.H5Gopen(this.fileId, "/", HDF5Constants.H5P_DEFAULT);
            byte[] version = Hdf5Util.getData(OmxConstants.OmxVersion.VERSION_02.getVersionString());
            int datatype = H5.H5Tcopy(OmxHdf5Datatype.OmxJavaType.STRING.getHdf5NativeId());
            H5.H5Tset_size(datatype, version.length);
            int dataspace = H5.H5Screate_simple(1, new long[]{1L}, null);
            int attribute = H5.H5Acreate(rootGroup, OmxConstants.OmxNames.OMX_VERSION_KEY.getKey(), datatype, dataspace, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
            H5.H5Awrite(attribute, datatype, version);
            H5.H5Tclose(datatype);
            H5.H5Sclose(dataspace);
            H5.H5Aclose(attribute);
            datatype = H5.H5Tcopy(OmxHdf5Datatype.OmxJavaType.INT.getHdf5NativeId());
            dataspace = H5.H5Screate_simple(1, new long[]{2L}, null);
            attribute = H5.H5Acreate(rootGroup, OmxConstants.OmxNames.OMX_SHAPE_KEY.getKey(), datatype, dataspace, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
            H5.H5Awrite(attribute, datatype, Hdf5Util.getData(shape));
            H5.H5Tclose(datatype);
            H5.H5Sclose(dataspace);
            H5.H5Aclose(attribute);
            int group = H5.H5Gcreate(this.fileId, "/" + OmxConstants.OmxNames.OMX_DATA_GROUP.getKey(), HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
            H5.H5Gclose(group);
            group = H5.H5Gcreate(this.fileId, "/" + OmxConstants.OmxNames.OMX_LOOKUP_GROUP.getKey(), HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
            H5.H5Gclose(group);
            H5.H5Gclose(rootGroup);
        }
        catch (HDF5Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeDataset(OmxGroup baseGroup, OmxMutableDataset dataset) {
        boolean newDataset;
        boolean bl = newDataset = !baseGroup.hasDataset(dataset.getName());
        if (newDataset || dataset.isMutated()) {
            int datasetId = -1;
            try {
                try {
                    if (newDataset) {
                        int datatype = H5.H5Tcopy(dataset.getDatatype().getNativeDatatypeId());
                        int[] shape = dataset.getShape();
                        long[] space = new long[shape.length];
                        int i = 0;
                        while (i < shape.length) {
                            space[i] = shape[i];
                            ++i;
                        }
                        int dataspace = H5.H5Screate_simple(space.length, space, null);
                        int plist = H5.H5Pcreate(HDF5Constants.H5P_DATASET_CREATE);
                        long[] chunksize = new long[]{1L, shape[0]};
                        H5.H5Pset_chunk(plist, space.length, chunksize);
                        H5.H5Pset_deflate(plist, 7);
                        datasetId = H5.H5Dcreate(this.fileId, dataset.getName(), datatype, dataspace, HDF5Constants.H5P_DEFAULT, plist, HDF5Constants.H5P_DEFAULT);
                        H5.H5Tclose(datatype);
                        H5.H5Sclose(dataspace);
                    } else {
                        datasetId = H5.H5Dopen(this.fileId, dataset.getName(), HDF5Constants.H5P_DEFAULT);
                    }
                    if (newDataset || dataset.isDataMutated()) {
                        int[] shape = dataset.getShape();
                        if (shape.length > 1) {
                            long[] count = new long[2];
                            long[] offset = new long[2];
                            count[0] = 1L;
                            count[1] = shape[1];
                            int memspace = H5.H5Screate_simple(2, count, null);
                            int dataspace = H5.H5Dget_space(datasetId);
                            int i = 0;
                            while (i < shape[0]) {
                                offset[0] = i;
                                offset[1] = 0L;
                                Object[] rowdata = null;
                                OmxHdf5Datatype.OmxJavaType ojt = dataset.getDatatype().getOmxJavaType();
                                if (ojt.equals((Object)OmxHdf5Datatype.OmxJavaType.INT)) {
                                    rowdata = ((int[][])dataset.getData())[i];
                                } else if (ojt.equals((Object)OmxHdf5Datatype.OmxJavaType.SHORT)) {
                                    rowdata = ((short[][])dataset.getData())[i];
                                } else if (ojt.equals((Object)OmxHdf5Datatype.OmxJavaType.FLOAT)) {
                                    rowdata = ((float[][])dataset.getData())[i];
                                } else if (ojt.equals((Object)OmxHdf5Datatype.OmxJavaType.DOUBLE)) {
                                    rowdata = ((double[][])dataset.getData())[i];
                                } else if (ojt.equals((Object)OmxHdf5Datatype.OmxJavaType.BYTE)) {
                                    rowdata = ((byte[][])dataset.getData())[i];
                                } else if (ojt.equals((Object)OmxHdf5Datatype.OmxJavaType.STRING)) {
                                    rowdata = ((String[][])dataset.getData())[i];
                                }
                                H5.H5Sselect_hyperslab(dataspace, HDF5Constants.H5S_SELECT_SET, offset, null, count, null);
                                H5.H5Dwrite(datasetId, dataset.getDatatype().getNativeDatatypeId(), memspace, dataspace, HDF5Constants.H5P_DEFAULT, rowdata);
                                ++i;
                            }
                        } else {
                            H5.H5Dwrite(datasetId, dataset.getDatatype().getNativeDatatypeId(), HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, dataset.getData());
                        }
                    }
                    if (newDataset || dataset.areAttributesMutated()) {
                        Hdf5Util.deleteAttributes(datasetId);
                        Map<String, Object> attributes = dataset.getAttributes();
                        for (String attributeName : attributes.keySet()) {
                            Hdf5Util.writeAttribute(datasetId, attributeName, attributes.get(attributeName));
                        }
                    }
                }
                catch (HDF5Exception e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                if (datasetId > -1) {
                    try {
                        H5.H5Dclose(datasetId);
                    }
                    catch (HDF5LibraryException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    private void writeNestedGroups(OmxGroup baseGroup, OmxMutableGroup group, OmxGroup originalGroup) {
        boolean newGroup;
        String name = group.getName();
        boolean bl = newGroup = !name.equals("/") && !baseGroup.hasGroup(name);
        if (newGroup || group.isMutated()) {
            int groupId = -1;
            try {
                try {
                    groupId = newGroup ? H5.H5Gcreate(this.fileId, name, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT) : H5.H5Gopen(this.fileId, name, HDF5Constants.H5P_DEFAULT);
                    for (OmxGroup subGroup : group.getGroups()) {
                        this.writeNestedGroups(baseGroup, subGroup.getMutableGroup(), subGroup);
                    }
                    if (newGroup || group.areAttributesMutated()) {
                        Hdf5Util.deleteAttributes(groupId);
                        Map<String, Object> attributes = group.getAttributes();
                        for (String attributeName : attributes.keySet()) {
                            Hdf5Util.writeAttribute(groupId, attributeName, attributes.get(attributeName));
                        }
                    }
                    for (OmxDataset dataset : group.getDatasets()) {
                        this.writeDataset(originalGroup, dataset.getMutableDataset());
                    }
                    if (!newGroup) {
                        for (OmxGroup oldGroup : originalGroup.getGroups()) {
                            if (group.hasGroup(oldGroup.getName())) continue;
                            H5.H5Ldelete(this.fileId, oldGroup.getName(), HDF5Constants.H5P_DEFAULT);
                        }
                        for (OmxDataset oldDataset : originalGroup.getDatasets()) {
                            if (group.hasDataset(oldDataset.getName())) continue;
                            H5.H5Ldelete(this.fileId, oldDataset.getName(), HDF5Constants.H5P_DEFAULT);
                        }
                    }
                }
                catch (HDF5LibraryException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                if (groupId > -1) {
                    try {
                        H5.H5Gclose(groupId);
                    }
                    catch (HDF5LibraryException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    public void save() {
        this.save(true);
    }

    private void save(boolean checkOpened) {
        if (checkOpened && !this.opened.get()) {
            throw new IllegalStateException("Cannot save unopened file: " + this.filePath);
        }
        if (!this.writable.get()) {
            throw new IllegalStateException("Cannot save read-only file: " + this.filePath);
        }
        OmxGroup rootGroup = this.getBaseGroup();
        this.writeNestedGroups(rootGroup, rootGroup.getMutableGroup(), rootGroup);
        this.reload(checkOpened, false);
    }

    private void reload(boolean checkOpened, boolean withSave) {
        if (checkOpened && !this.opened.get()) {
            throw new IllegalStateException("Cannot reload unopened file: " + this.filePath);
        }
        this.close(withSave);
        if (checkOpened) {
            if (this.writable.get()) {
                this.openReadWrite();
            } else {
                this.openReadOnly();
            }
        }
    }

    public void reload() {
        this.reload(true, true);
    }
}

