/*
 * Decompiled with CFR 0.152.
 */
package omx.hdf5;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import omx.hdf5.Hdf5Util;
import omx.hdf5.OmxDataset;
import omx.hdf5.OmxHdf5Datatype;
import omx.hdf5.OmxModifiableDataset;
import omx.hdf5.OmxMutableDataset;

public class OmxHdf5Dataset
implements OmxDataset {
    private final int fileId;
    private final String name;
    private final int[] shape;
    private final OmxHdf5Datatype datatype;
    private final Map<String, Object> attributes;
    private final OmxMutableDataset mutableDataset;

    OmxHdf5Dataset(int fileId, String datasetName, String parentName) {
        this.fileId = fileId;
        this.name = String.valueOf(parentName) + (parentName.endsWith("/") ? "" : "/") + datasetName;
        int datasetId = -1;
        try {
            try {
                datasetId = H5.H5Dopen(fileId, this.name, HDF5Constants.H5P_DEFAULT);
                this.datatype = new OmxHdf5Datatype(H5.H5Dget_type(datasetId));
                int dataspaceId = H5.H5Dget_space(datasetId);
                long nDims = H5.H5Sget_simple_extent_ndims(dataspaceId);
                long[] dimSize = new long[(int)nDims];
                long[] maxDimSize = new long[(int)nDims];
                H5.H5Sget_simple_extent_dims(dataspaceId, dimSize, maxDimSize);
                this.shape = new int[dimSize.length];
                int i = 0;
                while (i < dimSize.length) {
                    this.shape[i] = (int)dimSize[i];
                    ++i;
                }
                this.attributes = Hdf5Util.getAttributes(datasetId);
            }
            catch (HDF5Exception e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            if (datasetId > -1) {
                try {
                    H5.H5Dclose(datasetId);
                }
                catch (HDF5LibraryException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.mutableDataset = new OmxModifiableDataset(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int[] getShape() {
        return Arrays.copyOf(this.shape, this.shape.length);
    }

    @Override
    public OmxHdf5Datatype getDatatype() {
        return this.datatype;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    private Object copyData() {
        int datasetId = -1;
        Object arrayForData = Array.newInstance(this.getDatatype().getOmxJavaType().getJavaClass(), this.getShape());
        try {
            datasetId = H5.H5Dopen(this.fileId, this.name, HDF5Constants.H5P_DEFAULT);
            if (this.shape.length > 1) {
                Object tempData;
                Object[] matrixData = new Object[this.shape[0]];
                long[] count = new long[2];
                long[] offset = new long[2];
                count[0] = 1L;
                count[1] = this.shape[1];
                int memspace = H5.H5Screate_simple(2, count, null);
                int dataspace = H5.H5Dget_space(datasetId);
                int i = 0;
                while (i < this.shape[0]) {
                    offset[0] = i;
                    offset[1] = 0L;
                    H5.H5Sselect_hyperslab(dataspace, HDF5Constants.H5S_SELECT_SET, offset, null, count, null);
                    Object rowdata = Array.newInstance(this.getDatatype().getOmxJavaType().getJavaClass(), this.shape[0]);
                    H5.H5Dread(datasetId, this.getDatatype().getOmxJavaType().getHdf5NativeId(), memspace, dataspace, HDF5Constants.H5P_DEFAULT, rowdata);
                    matrixData[i] = rowdata;
                    ++i;
                }
                OmxHdf5Datatype.OmxJavaType ojt = this.getDatatype().getOmxJavaType();
                if (ojt.equals((Object)OmxHdf5Datatype.OmxJavaType.INT)) {
                    tempData = new int[this.shape[0]][this.shape[1]];
                    int i2 = 0;
                    while (i2 < this.shape[0]) {
                        tempData[i2] = (int[])matrixData[i2];
                        ++i2;
                    }
                    arrayForData = tempData;
                } else if (ojt.equals((Object)OmxHdf5Datatype.OmxJavaType.SHORT)) {
                    tempData = new short[this.shape[0]][this.shape[1]];
                    int i3 = 0;
                    while (i3 < this.shape[0]) {
                        tempData[i3] = (short[])matrixData[i3];
                        ++i3;
                    }
                    arrayForData = tempData;
                } else if (ojt.equals((Object)OmxHdf5Datatype.OmxJavaType.FLOAT)) {
                    tempData = new float[this.shape[0]][this.shape[1]];
                    int i4 = 0;
                    while (i4 < this.shape[0]) {
                        tempData[i4] = (int[])((float[])matrixData[i4]);
                        ++i4;
                    }
                    arrayForData = tempData;
                } else if (ojt.equals((Object)OmxHdf5Datatype.OmxJavaType.DOUBLE)) {
                    tempData = new double[this.shape[0]][this.shape[1]];
                    int i5 = 0;
                    while (i5 < this.shape[0]) {
                        tempData[i5] = (int[])((double[])matrixData[i5]);
                        ++i5;
                    }
                    arrayForData = tempData;
                } else if (ojt.equals((Object)OmxHdf5Datatype.OmxJavaType.BYTE)) {
                    tempData = new byte[this.shape[0]][this.shape[1]];
                    int i6 = 0;
                    while (i6 < this.shape[0]) {
                        tempData[i6] = (byte[])matrixData[i6];
                        ++i6;
                    }
                    arrayForData = tempData;
                } else if (ojt.equals((Object)OmxHdf5Datatype.OmxJavaType.STRING)) {
                    tempData = new String[this.shape[0]][this.shape[1]];
                    int i7 = 0;
                    while (i7 < this.shape[0]) {
                        tempData[i7] = (int[])((String[])matrixData[i7]);
                        ++i7;
                    }
                    arrayForData = tempData;
                }
            } else {
                H5.H5Dread(datasetId, this.getDatatype().getOmxJavaType().getHdf5NativeId(), HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, arrayForData);
            }
            Object object = arrayForData;
            return object;
        }
        catch (HDF5Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (datasetId > -1) {
                try {
                    H5.H5Dclose(datasetId);
                }
                catch (HDF5LibraryException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public Object getData() {
        Object arrayForData = this.copyData();
        return arrayForData;
    }

    @Override
    public OmxMutableDataset getMutableDataset() {
        return this.mutableDataset;
    }
}

