/*
 * Decompiled with CFR 0.152.
 */
package omx.hdf5;

import java.util.HashMap;
import java.util.Map;

public class OmxConstants {

    public static enum OmxNames {
        OMX_VERSION_KEY("OMX_VERSION"),
        OMX_SHAPE_KEY("SHAPE"),
        OMX_DATASET_DIM_KEY("dims"),
        OMX_DATASET_TITLE_KEY("title"),
        OMX_DATASET_NA_KEY("NA"),
        OMX_DATA_GROUP("data"),
        OMX_LOOKUP_GROUP("lookup");

        private final String key;

        private OmxNames(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static enum OmxVersion {
        VERSION_02("0.2");

        private final String versionString;
        private static final Map<String, OmxVersion> versionMap;

        static {
            versionMap = new HashMap<String, OmxVersion>();
            OmxVersion[] omxVersionArray = OmxVersion.values();
            int n = omxVersionArray.length;
            int n2 = 0;
            while (n2 < n) {
                OmxVersion version = omxVersionArray[n2];
                versionMap.put(version.getVersionString(), version);
                ++n2;
            }
        }

        private OmxVersion(String versionString) {
            this.versionString = versionString;
        }

        public String getVersionString() {
            return this.versionString;
        }

        public static OmxVersion getVersion(String versionString) {
            if (versionMap.containsKey(versionString = versionString.trim())) {
                return versionMap.get(versionString);
            }
            throw new IllegalArgumentException("Unknown/unsupported OMX version (valid set = " + versionMap.keySet() + "): '" + versionString + "'");
        }
    }
}

