/*
 * Decompiled with CFR 0.152.
 */
package omx.hdf5;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.hdf5lib.exceptions.HDF5LibraryException;
import ncsa.hdf.hdf5lib.structs.H5O_info_t;
import omx.hdf5.OmxHdf5Datatype;

public class Hdf5Util {
    public static Map<String, Object> getAttributes(int id) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        try {
            H5O_info_t info = H5.H5Oget_info(id);
            int i = 0;
            while ((long)i < info.num_attrs) {
                int attributeId = H5.H5Aopen_by_idx(id, ".", HDF5Constants.H5_INDEX_CRT_ORDER, HDF5Constants.H5_ITER_INC, i, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
                String[] attributeNameHolder = new String[1];
                H5.H5Aget_name(attributeId, 256L, attributeNameHolder);
                int size = (int)H5.H5Aget_storage_size(attributeId);
                byte[] data = new byte[size];
                int attributeType = H5.H5Aget_type(attributeId);
                H5.H5Aread(attributeId, attributeType, data);
                attributes.put(attributeNameHolder[0], Hdf5Util.readData(attributeType, data));
                H5.H5Aclose(attributeId);
                ++i;
            }
        }
        catch (HDF5LibraryException e) {
            throw new RuntimeException(e);
        }
        return attributes;
    }

    public static void deleteAttributes(int id) {
        try {
            H5O_info_t info = H5.H5Oget_info(id);
            int i = 0;
            while ((long)i < info.num_attrs) {
                int attributeId = H5.H5Aopen_by_idx(id, ".", HDF5Constants.H5_INDEX_CRT_ORDER, HDF5Constants.H5_ITER_INC, 0L, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
                String[] attributeNameHolder = new String[1];
                H5.H5Aget_name(attributeId, 256L, attributeNameHolder);
                H5.H5Aclose(attributeId);
                H5.H5Adelete(id, attributeNameHolder[0]);
                ++i;
            }
        }
        catch (HDF5LibraryException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getDatatype(Object o) {
        Class<?> c = o.getClass();
        while (c.isArray()) {
            c = c.getComponentType();
        }
        try {
            if (c == Byte.TYPE || c == Byte.class) {
                return H5.H5Tcopy(OmxHdf5Datatype.OmxJavaType.BYTE.getHdf5NativeId());
            }
            if (c == Short.TYPE || c == Short.class) {
                return H5.H5Tcopy(OmxHdf5Datatype.OmxJavaType.SHORT.getHdf5NativeId());
            }
            if (c == Integer.TYPE || c == Integer.class) {
                return H5.H5Tcopy(OmxHdf5Datatype.OmxJavaType.INT.getHdf5NativeId());
            }
            if (c == Float.TYPE || c == Float.class) {
                return H5.H5Tcopy(OmxHdf5Datatype.OmxJavaType.FLOAT.getHdf5NativeId());
            }
            if (c == Double.TYPE || c == Double.class) {
                return H5.H5Tcopy(OmxHdf5Datatype.OmxJavaType.DOUBLE.getHdf5NativeId());
            }
            if (c == String.class) {
                return H5.H5Tcopy(OmxHdf5Datatype.OmxJavaType.STRING.getHdf5NativeId());
            }
        }
        catch (HDF5LibraryException e) {
            throw new RuntimeException(e);
        }
        throw new IllegalArgumentException("Object cannot be saved to HDF5 datatype (" + c + "): " + o);
    }

    public static long[] getDataspaceDimensions(Object o) {
        LinkedList<Integer> size = new LinkedList<Integer>();
        Class<?> c = o.getClass();
        if (c.isArray()) {
            while (c.isArray()) {
                size.add(Array.getLength(o));
                o = Array.get(o, 0);
                c = o.getClass();
            }
        } else {
            size.add(1);
        }
        long[] space = new long[size.size()];
        int counter = 0;
        Iterator iterator = size.iterator();
        while (iterator.hasNext()) {
            int s = (Integer)iterator.next();
            space[counter++] = s;
        }
        return space;
    }

    public static int getDataspace(long[] space) {
        try {
            return H5.H5Screate_simple(space.length, space, null);
        }
        catch (HDF5Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeAttribute(int id, String attributeName, Object attributeValue) {
        try {
            long[] dataspaceDimension = Hdf5Util.getDataspaceDimensions(attributeValue);
            int datatype = Hdf5Util.getDatatype(attributeValue);
            byte[] data = Hdf5Util.getData(attributeValue, dataspaceDimension);
            if (attributeValue.getClass() == String.class) {
                H5.H5Tset_size(datatype, data.length);
            }
            int dataspace = Hdf5Util.getDataspace(dataspaceDimension);
            int attribute = H5.H5Acreate(id, attributeName, datatype, dataspace, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT);
            H5.H5Awrite(attribute, datatype, data);
            H5.H5Tclose(datatype);
            H5.H5Sclose(dataspace);
            H5.H5Aclose(attribute);
        }
        catch (HDF5LibraryException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object readData(int h5AttributeType, byte[] data) {
        OmxHdf5Datatype.OmxJavaType javaType = OmxHdf5Datatype.OmxJavaType.getJavaTypeForHdf5Id(h5AttributeType);
        if (javaType == null) {
            return data;
        }
        int dataLength = javaType.getDataLength();
        if (dataLength > 0) assert (data.length % dataLength == 0);
        switch (javaType) {
            case INT: {
                ByteBuffer byteBuffer = ByteBuffer.wrap(data);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                if (data.length > dataLength) {
                    int[] result = new int[data.length / dataLength];
                    int i = 0;
                    while (i < result.length) {
                        result[i] = byteBuffer.getInt();
                        ++i;
                    }
                    return result;
                }
                return byteBuffer.getInt();
            }
            case SHORT: {
                ByteBuffer byteBuffer = ByteBuffer.wrap(data);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                if (data.length > dataLength) {
                    short[] result = new short[data.length / dataLength];
                    int i = 0;
                    while (i < result.length) {
                        result[i] = byteBuffer.getShort();
                        ++i;
                    }
                    return result;
                }
                return byteBuffer.getShort();
            }
            case FLOAT: {
                ByteBuffer byteBuffer = ByteBuffer.wrap(data);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                if (data.length > dataLength) {
                    float[] result = new float[data.length / dataLength];
                    int i = 0;
                    while (i < result.length) {
                        result[i] = byteBuffer.getFloat();
                        ++i;
                    }
                    return result;
                }
                return Float.valueOf(byteBuffer.getFloat());
            }
            case DOUBLE: {
                ByteBuffer byteBuffer = ByteBuffer.wrap(data);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                if (data.length > dataLength) {
                    double[] result = new double[data.length / dataLength];
                    int i = 0;
                    while (i < result.length) {
                        result[i] = byteBuffer.getDouble();
                        ++i;
                    }
                    return result;
                }
                return byteBuffer.getDouble();
            }
            case BYTE: {
                ByteBuffer byteBuffer = ByteBuffer.wrap(data);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                if (data.length > dataLength) {
                    byte[] result = new byte[data.length / dataLength];
                    int i = 0;
                    while (i < result.length) {
                        result[i] = byteBuffer.get();
                        ++i;
                    }
                    return result;
                }
                return byteBuffer.get();
            }
            case STRING: {
                return new String(data);
            }
        }
        return data;
    }

    public static byte[] getData(Object o, long[] size) {
        Class<?> c = o.getClass();
        if (!c.isArray()) {
            if (c == Byte.class) {
                return Hdf5Util.getData((Byte)o);
            }
            if (c == Short.class) {
                return Hdf5Util.getData((Short)o);
            }
            if (c == Integer.class) {
                return Hdf5Util.getData((Integer)o);
            }
            if (c == Float.class) {
                return Hdf5Util.getData(((Float)o).floatValue());
            }
            if (c == Double.class) {
                return Hdf5Util.getData((Double)o);
            }
            if (c == String.class) {
                return Hdf5Util.getData((String)o);
            }
            throw new IllegalArgumentException("Object cannot be saved to HDF5 datatype (" + c + "): " + o);
        }
        if (size.length == 1) {
            if ((c = c.getComponentType()) == Byte.TYPE) {
                return Hdf5Util.getData((byte[])o);
            }
            if (c == Short.TYPE) {
                return Hdf5Util.getData((short[])o);
            }
            if (c == Integer.TYPE) {
                return Hdf5Util.getData((int[])o);
            }
            if (c == Float.TYPE) {
                return Hdf5Util.getData((float[])o);
            }
            if (c == Double.TYPE) {
                return Hdf5Util.getData((double[])o);
            }
            throw new IllegalArgumentException("Object array (" + c + "[]) cannot be saved to HDF5 datatype: " + o);
        }
        int sizeCounter = 0;
        long[] subSize = new long[size.length - 1];
        System.arraycopy(size, 1, subSize, 0, size.length - 1);
        LinkedList<byte[]> data = new LinkedList<byte[]>();
        Object[] objectArray = (Object[])o;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object oo = objectArray[n2];
            byte[] byteData = Hdf5Util.getData(oo, subSize);
            sizeCounter += byteData.length;
            data.add(byteData);
            ++n2;
        }
        byte[] finalData = new byte[sizeCounter];
        sizeCounter = 0;
        for (byte[] d : data) {
            System.arraycopy(d, 0, finalData, sizeCounter, d.length);
            sizeCounter += d.length;
        }
        return finalData;
    }

    public static byte[] getData(byte data) {
        return Hdf5Util.getData(new byte[]{data});
    }

    public static byte[] getData(short data) {
        return Hdf5Util.getData(new short[]{data});
    }

    public static byte[] getData(int data) {
        return Hdf5Util.getData(new int[]{data});
    }

    public static byte[] getData(float data) {
        return Hdf5Util.getData(new float[]{data});
    }

    public static byte[] getData(double data) {
        return Hdf5Util.getData(new double[]{data});
    }

    public static byte[] getData(byte[] data) {
        return data;
    }

    public static byte[] getData(short[] data) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(OmxHdf5Datatype.OmxJavaType.SHORT.getDataLength() * data.length);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        short[] sArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            short i = sArray[n2];
            byteBuffer.putShort(i);
            ++n2;
        }
        return byteBuffer.array();
    }

    public static byte[] getData(int[] data) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(OmxHdf5Datatype.OmxJavaType.INT.getDataLength() * data.length);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int[] nArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            byteBuffer.putInt(i);
            ++n2;
        }
        return byteBuffer.array();
    }

    public static byte[] getData(float[] data) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(OmxHdf5Datatype.OmxJavaType.FLOAT.getDataLength() * data.length);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        float[] fArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2];
            byteBuffer.putFloat(f);
            ++n2;
        }
        return byteBuffer.array();
    }

    public static byte[] getData(double[] data) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(OmxHdf5Datatype.OmxJavaType.DOUBLE.getDataLength() * data.length);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        double[] dArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            byteBuffer.putDouble(d);
            ++n2;
        }
        return byteBuffer.array();
    }

    public static byte[] getData(String data) {
        return data.getBytes();
    }

    public static String getBaseName(String name) {
        int lastSeparatorLocation = name.lastIndexOf("/");
        return lastSeparatorLocation == -1 ? name : name.substring(lastSeparatorLocation + 1);
    }

    public static enum H5O_type {
        H5O_TYPE_UNKNOWN(-1),
        H5O_TYPE_GROUP(0),
        H5O_TYPE_DATASET(1),
        H5O_TYPE_NAMED_DATATYPE(2),
        H5O_TYPE_NTYPES(3);

        private static final Map<Integer, H5O_type> lookup;
        private int code;

        static {
            lookup = new HashMap<Integer, H5O_type>();
            for (H5O_type s : EnumSet.allOf(H5O_type.class)) {
                lookup.put(s.getCode(), s);
            }
        }

        private H5O_type(int layout_type) {
            this.code = layout_type;
        }

        public int getCode() {
            return this.code;
        }

        public static H5O_type get(int code) {
            return lookup.get(code);
        }
    }
}

