/*
 * Decompiled with CFR 0.152.
 */
package omx.hdf5;

import java.util.Map;
import omx.hdf5.OmxDataset;
import omx.hdf5.OmxGroup;

public abstract class AbstractOmxGroup
implements OmxGroup {
    protected OmxDataset getDataset(String name, Map<String, OmxDataset> datasets) {
        String[] groupsPlusName;
        if (name.indexOf("/") == 0) {
            name = name.substring(1);
        }
        if ((groupsPlusName = name.split("/")).length == 1 && datasets.containsKey(groupsPlusName[0])) {
            return datasets.get(groupsPlusName[0]);
        }
        if (groupsPlusName.length > 1) {
            return this.getGroup(groupsPlusName[0]).getDataset(name.replaceFirst(groupsPlusName[0], "").replace("//", "/"));
        }
        throw new IllegalArgumentException("Dataset not found: " + name);
    }

    protected OmxGroup getGroup(String name, Map<String, OmxGroup> groups) {
        String[] groupsPlusName = name.split("/");
        if (groupsPlusName[0].length() == 0) {
            return this;
        }
        if (!groups.containsKey(groupsPlusName[0])) {
            throw new IllegalArgumentException("group not found: " + groupsPlusName[0] + " (in " + this.getName() + ")");
        }
        return groups.get(groupsPlusName[0]).getGroup(name.replaceFirst(groupsPlusName[0], "").replace("//", "/"));
    }

    public boolean hasGroup(String name, Map<String, OmxGroup> groups) {
        if (name.contains(this.getName())) {
            return groups.containsKey(name.replaceFirst(this.getName(), "").replace("/", ""));
        }
        return false;
    }

    public boolean hasDataset(String name, Map<String, OmxDataset> datasets) {
        if (name.contains(this.getName())) {
            return datasets.containsKey(name.replaceFirst(this.getName(), "").replace("/", ""));
        }
        return false;
    }
}

