/*
 * Decompiled with CFR 0.152.
 */
package omx;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import omx.AttributedElement;
import omx.hdf5.Hdf5Util;
import omx.hdf5.OmxConstants;
import omx.hdf5.OmxDataset;
import omx.hdf5.OmxHdf5Dataset;
import omx.hdf5.OmxHdf5Datatype;
import omx.hdf5.OmxMutableDataset;

public class OmxMatrix<D, C>
extends AttributedElement {
    private final String name;
    private final D data;
    private final int[] shape;
    private final Class<?> componentClass;
    private final Class<C> objectEquivalentClass;
    private volatile C missingValue;
    private final int initialHashcode;
    private static final Map<Class<?>, Class<?>> ALLOWED_CLASS_TO_OBJECT_MAP = new HashMap();

    static {
        ALLOWED_CLASS_TO_OBJECT_MAP.put(Byte.TYPE, Byte.class);
        ALLOWED_CLASS_TO_OBJECT_MAP.put(Short.TYPE, Short.class);
        ALLOWED_CLASS_TO_OBJECT_MAP.put(Integer.TYPE, Integer.class);
        ALLOWED_CLASS_TO_OBJECT_MAP.put(Float.TYPE, Float.class);
        ALLOWED_CLASS_TO_OBJECT_MAP.put(Double.TYPE, Double.class);
        ALLOWED_CLASS_TO_OBJECT_MAP.put(String.class, String.class);
    }

    public OmxMatrix(String name, D data, C missingValue) {
        this.name = name;
        if (!data.getClass().isArray()) {
            throw new IllegalArgumentException("Data must be a two dimensional array");
        }
        int dim0 = Array.getLength(data);
        if (dim0 == 0) {
            throw new IllegalArgumentException("Data array cannot be empty");
        }
        Object subD = Array.get(data, 0);
        if (!subD.getClass().isArray()) {
            throw new IllegalArgumentException("Data must be a two dimensional array");
        }
        int dim1 = Array.getLength(subD);
        if (dim1 == 0) {
            throw new IllegalArgumentException("Data array cannot be empty");
        }
        this.componentClass = subD.getClass().getComponentType();
        if (!ALLOWED_CLASS_TO_OBJECT_MAP.containsKey(this.componentClass)) {
            throw new IllegalArgumentException("Component class invalid: " + this.componentClass);
        }
        Class<?> objectEquivalentClass = ALLOWED_CLASS_TO_OBJECT_MAP.get(this.componentClass);
        this.objectEquivalentClass = objectEquivalentClass;
        this.data = data;
        this.shape = new int[]{dim0, dim1};
        this.missingValue = missingValue;
        if (missingValue != null && missingValue.getClass() != objectEquivalentClass) {
            throw new IllegalStateException("Object equivalent component class (" + objectEquivalentClass + ") does not match missing value class: " + missingValue.getClass());
        }
        if (missingValue != null && !this.getAttributeKeys().contains(OmxConstants.OmxNames.OMX_DATASET_NA_KEY.getKey())) {
            this.setAttribute(OmxConstants.OmxNames.OMX_DATASET_NA_KEY.getKey(), missingValue);
        }
        this.initialHashcode = this.dataHashcode();
    }

    private int dataHashcode() {
        return Arrays.deepHashCode((Object[])this.data);
    }

    public boolean isDataModified() {
        return this.initialHashcode != this.dataHashcode();
    }

    public String getName() {
        return this.name;
    }

    public D getData() {
        return this.data;
    }

    public int[] getShape() {
        return Arrays.copyOf(this.shape, this.shape.length);
    }

    public Class<?> getComponentClass() {
        return this.componentClass;
    }

    public C getMissingValue() {
        return this.missingValue;
    }

    public void setMissingValue(C missingValue) {
        this.missingValue = missingValue;
        this.setAttribute(OmxConstants.OmxNames.OMX_DATASET_NA_KEY.getKey(), missingValue);
    }

    public OmxHdf5Datatype.OmxJavaType getOmxJavaType() {
        if (this.componentClass == Byte.TYPE) {
            return OmxHdf5Datatype.OmxJavaType.BYTE;
        }
        if (this.componentClass == Short.TYPE) {
            return OmxHdf5Datatype.OmxJavaType.SHORT;
        }
        if (this.componentClass == Integer.TYPE) {
            return OmxHdf5Datatype.OmxJavaType.INT;
        }
        if (this.componentClass == Float.TYPE) {
            return OmxHdf5Datatype.OmxJavaType.FLOAT;
        }
        if (this.componentClass == Double.TYPE) {
            return OmxHdf5Datatype.OmxJavaType.DOUBLE;
        }
        if (this.componentClass == String.class) {
            return OmxHdf5Datatype.OmxJavaType.STRING;
        }
        throw new IllegalStateException("Should not be here!");
    }

    public void transfer(OmxMutableDataset dataset) {
        this.transferAttributes(dataset);
        this.transferData(dataset);
    }

    private void transferData(OmxMutableDataset dataset) {
        if (dataset instanceof OmxHdf5Dataset && !this.isDataModified()) {
            return;
        }
        dataset.setData(this.getData());
    }

    public static OmxMatrix getMatrix(OmxDataset dataset) {
        OmxHdf5Datatype datatype = dataset.getDatatype();
        Map<String, Object> attributes = dataset.getAttributes();
        Object missingValue = null;
        if (attributes.containsKey(OmxConstants.OmxNames.OMX_DATASET_NA_KEY.getKey())) {
            missingValue = attributes.get(OmxConstants.OmxNames.OMX_DATASET_NA_KEY.getKey());
        }
        String name = Hdf5Util.getBaseName(dataset.getName());
        OmxMatrix matrix = null;
        switch (datatype.getOmxJavaType()) {
            case BYTE: {
                Object data = (byte[][])dataset.getData();
                matrix = new OmxByteMatrix(name, (byte[][])data, (Byte)missingValue);
                break;
            }
            case SHORT: {
                Object data = (short[][])dataset.getData();
                matrix = new OmxShortMatrix(name, (short[][])data, (Short)missingValue);
                break;
            }
            case INT: {
                Object data = (int[][])dataset.getData();
                matrix = new OmxIntMatrix(name, (int[][])data, (Integer)missingValue);
                break;
            }
            case FLOAT: {
                Object data = (float[][])dataset.getData();
                matrix = new OmxFloatMatrix(name, (float[][])data, (Float)missingValue);
                break;
            }
            case DOUBLE: {
                Object data = (double[][])dataset.getData();
                matrix = new OmxDoubleMatrix(name, (double[][])data, (Double)missingValue);
                break;
            }
            case STRING: {
                Object data = (String[][])dataset.getData();
                matrix = new OmxStringMatrix(name, (String[][])data, (String)missingValue);
            }
        }
        for (String key : attributes.keySet()) {
            matrix.setAttribute(key, attributes.get(key));
        }
        return matrix;
    }

    public static class OmxByteMatrix
    extends OmxMatrix<byte[][], Byte> {
        public OmxByteMatrix(String name, byte[][] data, Byte missingValue) {
            super(name, data, missingValue);
        }
    }

    public static class OmxDoubleMatrix
    extends OmxMatrix<double[][], Double> {
        public OmxDoubleMatrix(String name, double[][] data, Double missingValue) {
            super(name, data, missingValue);
        }
    }

    public static class OmxFloatMatrix
    extends OmxMatrix<float[][], Float> {
        public OmxFloatMatrix(String name, float[][] data, Float missingValue) {
            super(name, data, missingValue);
        }
    }

    public static class OmxIntMatrix
    extends OmxMatrix<int[][], Integer> {
        public OmxIntMatrix(String name, int[][] data, Integer missingValue) {
            super(name, data, missingValue);
        }
    }

    public static class OmxShortMatrix
    extends OmxMatrix<short[][], Short> {
        public OmxShortMatrix(String name, short[][] data, Short missingValue) {
            super(name, data, missingValue);
        }
    }

    public static class OmxStringMatrix
    extends OmxMatrix<String[][], String> {
        public OmxStringMatrix(String name, String[][] data, String missingValue) {
            super(name, data, missingValue);
        }
    }
}

