/*
 * Decompiled with CFR 0.152.
 */
package omx;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import omx.AttributedElement;
import omx.hdf5.Hdf5Util;
import omx.hdf5.OmxConstants;
import omx.hdf5.OmxDataset;
import omx.hdf5.OmxHdf5Dataset;
import omx.hdf5.OmxHdf5Datatype;
import omx.hdf5.OmxMutableDataset;

public class OmxLookup<D, C>
extends AttributedElement {
    private final String name;
    private final D lookup;
    private final int length;
    private final Class<?> componentClass;
    private final Class<C> objectEquivalentClass;
    private volatile C missingLookupValue;
    private final int initialHashcode;
    private static final Map<Class<?>, Class<?>> ALLOWED_CLASS_TO_OBJECT_MAP = new HashMap();

    static {
        ALLOWED_CLASS_TO_OBJECT_MAP.put(Byte.TYPE, Byte.class);
        ALLOWED_CLASS_TO_OBJECT_MAP.put(Short.TYPE, Short.class);
        ALLOWED_CLASS_TO_OBJECT_MAP.put(Integer.TYPE, Integer.class);
        ALLOWED_CLASS_TO_OBJECT_MAP.put(Float.TYPE, Float.class);
        ALLOWED_CLASS_TO_OBJECT_MAP.put(Double.TYPE, Double.class);
        ALLOWED_CLASS_TO_OBJECT_MAP.put(String.class, String.class);
    }

    public OmxLookup(String name, D lookup, C missingLookupValue) {
        this.name = name;
        if (!lookup.getClass().isArray()) {
            throw new IllegalArgumentException("Lookup must be a one dimensional array");
        }
        this.length = Array.getLength(lookup);
        if (this.length == 0) {
            throw new IllegalArgumentException("Lookup array cannot be empty");
        }
        this.componentClass = lookup.getClass().getComponentType();
        if (!ALLOWED_CLASS_TO_OBJECT_MAP.containsKey(this.componentClass)) {
            throw new IllegalArgumentException("Component class invalid: " + this.componentClass);
        }
        Class<?> objectEquivalentClass = ALLOWED_CLASS_TO_OBJECT_MAP.get(this.componentClass);
        this.objectEquivalentClass = objectEquivalentClass;
        this.missingLookupValue = missingLookupValue;
        if (missingLookupValue != null && missingLookupValue.getClass() != objectEquivalentClass) {
            throw new IllegalStateException("Object equivalent component class (" + objectEquivalentClass + ") does not match missing lookup value class: " + missingLookupValue.getClass());
        }
        if (missingLookupValue != null && !this.getAttributeKeys().contains(OmxConstants.OmxNames.OMX_DATASET_NA_KEY.getKey())) {
            this.setAttribute(OmxConstants.OmxNames.OMX_DATASET_NA_KEY.getKey(), missingLookupValue);
        }
        this.checkLookupValidity(lookup, missingLookupValue);
        this.lookup = lookup;
        this.initialHashcode = this.lookupHashcode();
    }

    private void checkLookupValidity(D lookup, C missingLookupValue) {
        boolean nullMissing = missingLookupValue == null;
        HashSet<Object> lookups = new HashSet<Object>();
        int i = 0;
        while (i < this.getLength()) {
            Object value = Array.get(lookup, i);
            if (!(!nullMissing && missingLookupValue.equals(value) || lookups.add(value))) {
                throw new IllegalArgumentException("Lookup is invalid because it has a repeated value: " + value);
            }
            ++i;
        }
    }

    private int lookupHashcode() {
        if (this.componentClass == Byte.TYPE) {
            return Arrays.hashCode((byte[])this.lookup);
        }
        if (this.componentClass == Short.TYPE) {
            return Arrays.hashCode((short[])this.lookup);
        }
        if (this.componentClass == Integer.TYPE) {
            return Arrays.hashCode((int[])this.lookup);
        }
        if (this.componentClass == Float.TYPE) {
            return Arrays.hashCode((float[])this.lookup);
        }
        if (this.componentClass == Double.TYPE) {
            return Arrays.hashCode((double[])this.lookup);
        }
        if (this.componentClass == String.class) {
            return Arrays.hashCode((String[])this.lookup);
        }
        throw new IllegalStateException("Should not be here...");
    }

    public boolean isDataModified() {
        return this.initialHashcode != this.lookupHashcode();
    }

    public String getName() {
        return this.name;
    }

    public D getLookup() {
        return this.lookup;
    }

    public int getLength() {
        return this.length;
    }

    public C getMissingValue() {
        return this.missingLookupValue;
    }

    public void setMissingValue(C missingLookupValue) {
        this.missingLookupValue = missingLookupValue;
        this.setAttribute(OmxConstants.OmxNames.OMX_DATASET_NA_KEY.getKey(), missingLookupValue);
    }

    public Class<?> getComponentClass() {
        return this.componentClass;
    }

    public OmxHdf5Datatype.OmxJavaType getOmxJavaType() {
        if (this.componentClass == Byte.TYPE) {
            return OmxHdf5Datatype.OmxJavaType.BYTE;
        }
        if (this.componentClass == Short.TYPE) {
            return OmxHdf5Datatype.OmxJavaType.SHORT;
        }
        if (this.componentClass == Integer.TYPE) {
            return OmxHdf5Datatype.OmxJavaType.INT;
        }
        if (this.componentClass == Float.TYPE) {
            return OmxHdf5Datatype.OmxJavaType.FLOAT;
        }
        if (this.componentClass == Double.TYPE) {
            return OmxHdf5Datatype.OmxJavaType.DOUBLE;
        }
        if (this.componentClass == String.class) {
            return OmxHdf5Datatype.OmxJavaType.STRING;
        }
        throw new IllegalStateException("Should not be here!");
    }

    public void transfer(OmxMutableDataset dataset) {
        this.transferAttributes(dataset);
        this.transferData(dataset);
    }

    private void transferData(OmxMutableDataset dataset) {
        if (dataset instanceof OmxHdf5Dataset && !this.isDataModified()) {
            return;
        }
        dataset.setData(this.getLookup());
    }

    public static OmxLookup getLookup(OmxDataset dataset) {
        OmxHdf5Datatype datatype = dataset.getDatatype();
        Map<String, Object> attributes = dataset.getAttributes();
        Object missingValue = null;
        if (attributes.containsKey(OmxConstants.OmxNames.OMX_DATASET_NA_KEY.getKey())) {
            missingValue = attributes.get(OmxConstants.OmxNames.OMX_DATASET_NA_KEY.getKey());
        }
        String name = Hdf5Util.getBaseName(dataset.getName());
        OmxLookup lookup = null;
        switch (datatype.getOmxJavaType()) {
            case BYTE: {
                Object[] data = (byte[])dataset.getData();
                lookup = new OmxByteLookup(name, (byte[])data, (Byte)missingValue);
                break;
            }
            case SHORT: {
                Object[] data = (short[])dataset.getData();
                lookup = new OmxShortLookup(name, (short[])data, (Short)missingValue);
                break;
            }
            case INT: {
                Object[] data = (int[])dataset.getData();
                lookup = new OmxIntLookup(name, (int[])data, (Integer)missingValue);
                break;
            }
            case FLOAT: {
                Object[] data = (float[])dataset.getData();
                lookup = new OmxFloatLookup(name, (float[])data, (Float)missingValue);
                break;
            }
            case DOUBLE: {
                Object[] data = (double[])dataset.getData();
                lookup = new OmxDoubleLookup(name, (double[])data, (Double)missingValue);
                break;
            }
            case STRING: {
                Object[] data = (String[])dataset.getData();
                lookup = new OmxStringLookup(name, (String[])data, (String)missingValue);
            }
        }
        for (String key : attributes.keySet()) {
            lookup.setAttribute(key, attributes.get(key));
        }
        return lookup;
    }

    public static class OmxByteLookup
    extends OmxLookup<byte[], Byte> {
        public OmxByteLookup(String name, byte[] lookup, Byte missingLookupValue) {
            super(name, lookup, missingLookupValue);
        }
    }

    public static class OmxDoubleLookup
    extends OmxLookup<double[], Double> {
        public OmxDoubleLookup(String name, double[] lookup, Double missingLookupValue) {
            super(name, lookup, missingLookupValue);
        }
    }

    public static class OmxFloatLookup
    extends OmxLookup<float[], Float> {
        public OmxFloatLookup(String name, float[] lookup, Float missingLookupValue) {
            super(name, lookup, missingLookupValue);
        }
    }

    public static class OmxIntLookup
    extends OmxLookup<int[], Integer> {
        public OmxIntLookup(String name, int[] lookup, Integer missingLookupValue) {
            super(name, lookup, missingLookupValue);
        }
    }

    public static class OmxShortLookup
    extends OmxLookup<short[], Short> {
        public OmxShortLookup(String name, short[] lookup, Short missingLookupValue) {
            super(name, lookup, missingLookupValue);
        }
    }

    public static class OmxStringLookup
    extends OmxLookup<String[], String> {
        public OmxStringLookup(String name, String[] data, String missingLookupValue) {
            super(name, data, missingLookupValue);
        }
    }
}

