/*
 * Decompiled with CFR 0.152.
 */
package omx;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import omx.AttributedElement;
import omx.OmxLookup;
import omx.OmxMatrix;
import omx.hdf5.OmxConstants;
import omx.hdf5.OmxGroup;
import omx.hdf5.OmxHdf5File;
import omx.hdf5.OmxMemoryDataset;
import omx.hdf5.OmxMutableGroup;
import omx.hdf5.OmxUtil;

public class OmxFile
extends AttributedElement
implements AutoCloseable {
    private final Path filePath;
    private final OmxHdf5File hdf5File;
    private int[] shape = null;
    private final Map<String, OmxMatrix<?, ?>> matrices;
    private final Map<String, OmxLookup<?, ?>> lookups;
    private boolean writable = false;

    public OmxFile(Path filePath) {
        this.filePath = filePath;
        this.hdf5File = new OmxHdf5File(filePath);
        this.matrices = new HashMap();
        this.lookups = new HashMap();
    }

    public OmxFile(String filePath) {
        this(Paths.get(filePath, new String[0]));
    }

    public Path getFilePath() {
        return this.filePath;
    }

    public int[] getShape() {
        return Arrays.copyOf(this.shape, this.shape.length);
    }

    public void openReadOnly() {
        this.writable = false;
        this.hdf5File.openReadOnly();
        this.reload(false);
    }

    public void openReadWrite() {
        this.writable = true;
        this.hdf5File.openReadWrite();
        this.reload(false);
    }

    public void openNew(int[] shape) {
        this.writable = true;
        this.hdf5File.openNew(shape);
        this.reload(false);
    }

    private void checkOpened() {
        if (!this.hdf5File.isOpened()) {
            throw new IllegalStateException("File not opened: " + this.filePath);
        }
    }

    private void checkWritable() {
        if (!this.writable) {
            throw new IllegalStateException("File not writable: " + this.filePath);
        }
    }

    public void reload() {
        this.reload(true);
    }

    private void reload(boolean reloadHdf5File) {
        this.checkOpened();
        if (reloadHdf5File) {
            this.hdf5File.reload();
        }
        this.shape = this.hdf5File.getShape();
        OmxGroup baseGroup = this.hdf5File.getBaseGroup();
        Map<String, Object> attributes = baseGroup.getAttributes();
        for (String attribute : attributes.keySet()) {
            this.setAttribute(attribute, attributes.get(attribute));
        }
    }

    public void save() {
        this.checkOpened();
        this.checkWritable();
        OmxMutableGroup baseGroup = this.hdf5File.getBaseGroup().getMutableGroup();
        this.transferAttributes(baseGroup);
        OmxMutableGroup dataGroup = baseGroup.getGroup(OmxConstants.OmxNames.OMX_DATA_GROUP.getKey()).getMutableGroup();
        Collection<String> datasetNames = dataGroup.getDatasetNames();
        for (String name : this.matrices.keySet()) {
            if (datasetNames.contains(name)) {
                this.matrices.get(name).transfer(dataGroup.getDataset(name).getMutableDataset());
                continue;
            }
            OmxMatrix<?, ?> newMatrix = this.matrices.get(name);
            OmxMemoryDataset newDataset = new OmxMemoryDataset("/" + OmxConstants.OmxNames.OMX_DATA_GROUP.getKey() + "/" + name, this.shape, newMatrix.getOmxJavaType().getOmxHdf5Datatype(), newMatrix.getAttributes(), newMatrix.getData());
            dataGroup.setDataset(newDataset);
        }
        OmxMutableGroup lookupGroup = baseGroup.getGroup(OmxConstants.OmxNames.OMX_LOOKUP_GROUP.getKey()).getMutableGroup();
        Collection<String> lookupNames = lookupGroup.getDatasetNames();
        for (String name : this.lookups.keySet()) {
            if (lookupNames.contains(name)) {
                this.lookups.get(name).transfer(lookupGroup.getDataset(name).getMutableDataset());
                continue;
            }
            OmxLookup<?, ?> newLookup = this.lookups.get(name);
            OmxMemoryDataset newDataset = new OmxMemoryDataset("/" + OmxConstants.OmxNames.OMX_LOOKUP_GROUP.getKey() + "/" + name, new int[]{newLookup.getLength()}, newLookup.getOmxJavaType().getOmxHdf5Datatype(), newLookup.getAttributes(), newLookup.getLookup());
            lookupGroup.setDataset(newDataset);
        }
        this.hdf5File.save();
        this.reload(false);
    }

    @Override
    public void close() {
        if (this.writable) {
            this.save();
        }
        this.hdf5File.close();
        this.writable = false;
        this.shape = null;
        this.matrices.clear();
        this.lookups.clear();
    }

    public OmxMatrix<?, ?> getMatrix(String name) {
        this.checkOpened();
        OmxGroup baseGroup = this.hdf5File.getBaseGroup();
        OmxGroup dataGroup = baseGroup.getGroup(OmxConstants.OmxNames.OMX_DATA_GROUP.getKey());
        if (!this.matrices.containsKey(name)) {
            this.matrices.put(name, OmxMatrix.getMatrix(dataGroup.getDataset(name)));
        }
        if (!this.matrices.containsKey(name)) {
            throw new IllegalArgumentException("Matrix not found: " + name);
        }
        return this.matrices.get(name);
    }

    public Set<String> getMatrixNames() {
        this.checkOpened();
        OmxGroup baseGroup = this.hdf5File.getBaseGroup();
        OmxGroup dataGroup = baseGroup.getGroup(OmxConstants.OmxNames.OMX_DATA_GROUP.getKey());
        return new HashSet<String>(dataGroup.getDatasetNames());
    }

    public void addMatrix(OmxMatrix<?, ?> matrix) {
        this.checkOpened();
        this.checkWritable();
        int[] matrixShape = matrix.getShape();
        if (matrixShape[0] != this.shape[0] || matrixShape[1] != this.shape[1]) {
            throw new IllegalArgumentException("Matrix dimension (" + Arrays.toString(matrixShape) + ") does not match file dimensions (" + Arrays.toString(this.shape) + ")");
        }
        this.matrices.put(matrix.getName(), matrix);
    }

    public void deleteMatrix(String name) {
        this.checkOpened();
        this.checkWritable();
        if (!this.matrices.containsKey(name)) {
            throw new IllegalArgumentException("Matrix not found: " + name);
        }
        this.matrices.remove(name);
        OmxMutableGroup baseGroup = this.hdf5File.getBaseGroup().getMutableGroup();
        OmxMutableGroup dataGroup = baseGroup.getGroup(OmxConstants.OmxNames.OMX_DATA_GROUP.getKey()).getMutableGroup();
        if (!dataGroup.getDatasetNames().contains(name)) {
            throw new IllegalArgumentException("Matrix not found: " + name);
        }
        dataGroup.deleteDataset(name);
    }

    public OmxLookup<?, ?> getLookup(String name) {
        this.checkOpened();
        OmxGroup baseGroup = this.hdf5File.getBaseGroup();
        OmxGroup lookupGroup = baseGroup.getGroup(OmxConstants.OmxNames.OMX_LOOKUP_GROUP.getKey());
        if (!this.lookups.containsKey(name)) {
            this.lookups.put(name, OmxLookup.getLookup(lookupGroup.getDataset(name)));
        }
        if (!this.lookups.containsKey(name)) {
            throw new IllegalArgumentException("Lookup not found: " + name);
        }
        return this.lookups.get(name);
    }

    public Set<String> getLookupNames() {
        this.checkOpened();
        OmxGroup baseGroup = this.hdf5File.getBaseGroup();
        OmxGroup lookupGroup = baseGroup.getGroup(OmxConstants.OmxNames.OMX_LOOKUP_GROUP.getKey());
        return new HashSet<String>(lookupGroup.getDatasetNames());
    }

    public void addLookup(OmxLookup<?, ?> lookup) {
        this.checkOpened();
        this.checkWritable();
        int lookupLength = lookup.getLength();
        if (lookupLength != this.shape[0] && lookupLength != this.shape[1]) {
            throw new IllegalArgumentException("Lookup length (" + lookupLength + ") does not match to either file dimension (" + Arrays.toString(this.shape) + ")");
        }
        this.lookups.put(lookup.getName(), lookup);
    }

    public void deleteLookup(String name) {
        this.checkOpened();
        this.checkWritable();
        if (!this.lookups.containsKey(name)) {
            throw new IllegalArgumentException("Lookup not found: " + name);
        }
        this.lookups.remove(name);
        OmxMutableGroup baseGroup = this.hdf5File.getBaseGroup().getMutableGroup();
        OmxMutableGroup lookupGroup = baseGroup.getGroup(OmxConstants.OmxNames.OMX_LOOKUP_GROUP.getKey()).getMutableGroup();
        if (!lookupGroup.getDatasetNames().contains(name)) {
            throw new IllegalArgumentException("Lookup not found: " + name);
        }
        lookupGroup.deleteDataset(name);
    }

    public String summary() {
        this.checkOpened();
        StringBuilder sb = new StringBuilder();
        sb.append("OMX file: ").append(this.filePath).append("\n");
        sb.append("\tshape: ").append(Arrays.toString(this.shape)).append("\n");
        sb.append("\tmatrices:\n");
        int count = 1;
        for (String name : this.getMatrixNames()) {
            sb.append("\t\tmatrix ").append(count++).append(": ").append(name).append("\n");
            OmxMatrix<?, ?> matrix = this.getMatrix(name);
            sb.append("\t\t\tshape: ").append(Arrays.toString(matrix.getShape())).append("\n");
            sb.append("\t\t\ttype: ").append((Object)matrix.getOmxJavaType()).append("\n");
            sb.append("\t\t\tattributes:").append("\n");
            for (String attribute : matrix.getAttributeKeys()) {
                sb.append("\t\t\t\t").append(attribute).append(" : ").append(OmxUtil.objectToString(matrix.getAttribute(attribute))).append("\n");
            }
        }
        sb.append("\tlookups:\n");
        count = 1;
        for (String name : this.getLookupNames()) {
            sb.append("\t\tlookup ").append(count++).append(": ").append(name).append("\n");
            OmxLookup<?, ?> lookup = this.getLookup(name);
            sb.append("\t\t\tlength: ").append(lookup.getLength()).append("\n");
            sb.append("\t\t\ttype: ").append((Object)lookup.getOmxJavaType()).append("\n");
            sb.append("\t\t\tattributes:").append("\n");
            for (String attribute : lookup.getAttributeKeys()) {
                sb.append("\t\t\t\t").append(attribute).append(" : ").append(OmxUtil.objectToString(lookup.getAttribute(attribute))).append("\n");
            }
        }
        return sb.toString();
    }

    public static void repack(String sourceFile, String destinationFile) {
        OmxFile.repack(Paths.get(sourceFile, new String[0]), Paths.get(destinationFile, new String[0]));
    }

    public static void repack(Path sourceFile, Path destinationFile) {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            OmxFile sourceOmxFile = new OmxFile(sourceFile);
            try {
                try (OmxFile destinationOmxFile = new OmxFile(destinationFile);){
                    sourceOmxFile.openReadOnly();
                    destinationOmxFile.openNew(sourceOmxFile.getShape());
                    for (String attribute : sourceOmxFile.getAttributeKeys()) {
                        if (destinationOmxFile.hasAttribute(attribute)) continue;
                        destinationOmxFile.setAttribute(attribute, sourceOmxFile.getAttribute(attribute));
                    }
                    for (String matrixName : sourceOmxFile.getMatrixNames()) {
                        destinationOmxFile.addMatrix(sourceOmxFile.getMatrix(matrixName));
                    }
                    for (String lookupName : sourceOmxFile.getLookupNames()) {
                        destinationOmxFile.addLookup(sourceOmxFile.getLookup(lookupName));
                    }
                }
                if (sourceOmxFile != null) {
                    sourceOmxFile.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (sourceOmxFile != null) {
                    sourceOmxFile.close();
                }
                throw throwable;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void repack(String file) {
        OmxFile.repack(Paths.get(file, new String[0]));
    }

    public static void repack(Path file) {
        Path tempFile = Paths.get(String.valueOf(file.toString()) + new Random().nextInt(100) + ".tmp", new String[0]);
        OmxFile.repack(file, tempFile);
        try {
            Files.copy(tempFile, file, StandardCopyOption.REPLACE_EXISTING);
            Files.delete(tempFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String ... args) {
        OmxFile omxFile;
        Random r = new Random();
        String f = "example.omx";
        Throwable throwable = null;
        Object var4_6 = null;
        try {
            omxFile = new OmxFile(f);
            try {
                int dim0;
                int dim1 = dim0 = 2000;
                int[] shape = new int[]{dim0, dim1};
                double mat1NA = -1.0;
                double[][] mat1Data = new double[dim0][dim1];
                int i = 0;
                while (i < dim0) {
                    int j = 0;
                    while (j < dim1) {
                        mat1Data[i][j] = i + j;
                        ++j;
                    }
                    ++i;
                }
                OmxMatrix.OmxDoubleMatrix mat1 = new OmxMatrix.OmxDoubleMatrix("mat1", mat1Data, mat1NA);
                mat1.setAttribute(OmxConstants.OmxNames.OMX_DATASET_TITLE_KEY.getKey(), "an int matrix");
                double lookup2NA = -99999.0;
                double[] lookup2Data = new double[dim1];
                HashSet<Double> lookup2Used = new HashSet<Double>();
                int i2 = 0;
                while (i2 < lookup2Data.length) {
                    double lookup = i2 + 1;
                    lookup2Data[i2] = lookup2Used.add(lookup) ? lookup : lookup2NA;
                    ++i2;
                }
                OmxLookup.OmxDoubleLookup lookup2 = new OmxLookup.OmxDoubleLookup("lookup2", lookup2Data, lookup2NA);
                omxFile.openNew(shape);
                omxFile.addMatrix(mat1);
                omxFile.addLookup(lookup2);
                omxFile.save();
                System.out.println(omxFile.summary());
            }
            finally {
                if (omxFile != null) {
                    omxFile.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        throwable = null;
        var4_6 = null;
        try {
            omxFile = new OmxFile(f);
            try {
                omxFile.openReadWrite();
                System.out.println(omxFile.summary());
                omxFile.deleteMatrix("mat1");
                omxFile.deleteLookup("lookup2");
                System.out.println(omxFile.summary());
            }
            finally {
                if (omxFile != null) {
                    omxFile.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }
}

