/*
 * Decompiled with CFR 0.152.
 */
package omx;

import omx.OmxFile;
import omx.OmxLookup;
import omx.OmxMatrix;

public class OMXTest {
    private OMXTest() {
    }

    public static void main(String[] args) {
        int numzones = 5000;
        long start = System.nanoTime();
        OmxFile omxfile = new OmxFile("test.omx");
        int[] shape = new int[]{numzones, numzones};
        omxfile.openNew(shape);
        double[][] valuesDouble = new double[shape[0]][shape[1]];
        int i = 0;
        while (i < valuesDouble.length) {
            int j = 0;
            while (j < valuesDouble[0].length) {
                valuesDouble[i][j] = i * j;
                ++j;
            }
            ++i;
        }
        OmxMatrix.OmxDoubleMatrix mat = new OmxMatrix.OmxDoubleMatrix("test", valuesDouble, 99999.0);
        omxfile.addMatrix(mat);
        int[] zoneNames = new int[shape[0]];
        int j = 0;
        while (j < zoneNames.length) {
            zoneNames[j] = j + 100;
            ++j;
        }
        OmxLookup.OmxIntLookup omxZoneNums = new OmxLookup.OmxIntLookup("NO", zoneNames, 0);
        omxfile.addLookup(omxZoneNums);
        long diff = System.nanoTime() - start;
        double diffsec = (double)diff / 1.0E9;
        System.out.println("Create matrix " + String.valueOf(shape[0]) + " x " + String.valueOf(shape[1]) + ": " + String.valueOf(diffsec));
        start = System.nanoTime();
        omxfile.save();
        diff = System.nanoTime() - start;
        diffsec = (double)diff / 1.0E9;
        System.out.println("Write matrix " + String.valueOf(shape[0]) + " x " + String.valueOf(shape[1]) + ": " + String.valueOf(diffsec));
        start = System.nanoTime();
        OmxFile omxfileIn = new OmxFile("test.omx");
        omxfileIn.openReadOnly();
        OmxMatrix.OmxDoubleMatrix omxMat = (OmxMatrix.OmxDoubleMatrix)omxfileIn.getMatrix("test");
        double[][] values = (double[][])omxMat.getData();
        diff = System.nanoTime() - start;
        diffsec = (double)diff / 1.0E9;
        System.out.println("Read matrix " + String.valueOf(shape[0]) + " x " + String.valueOf(shape[1]) + ": " + String.valueOf(diffsec));
    }
}

