/*
 * Decompiled with CFR 0.152.
 */
package omx;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import omx.hdf5.OmxMutableDataset;
import omx.hdf5.OmxMutableGroup;

public class AttributedElement {
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public Object getAttribute(String key) {
        if (!this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Attribute key not found: " + key);
        }
        return this.attributes.get(key);
    }

    public Set<String> getAttributeKeys() {
        return this.attributes.keySet();
    }

    public void deleteAttribute(String key) {
        if (!this.attributes.containsKey(key)) {
            throw new IllegalArgumentException("Attribute key not found: " + key);
        }
        this.attributes.remove(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    public Map<String, Object> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    protected void transferAttributes(OmxMutableDataset dataset) {
        Set<String> attributes = this.getAttributeKeys();
        Map<String, Object> datasetAttributes = dataset.getAttributes();
        for (String key : datasetAttributes.keySet()) {
            if (attributes.contains(key)) {
                if (datasetAttributes.get(key).equals(this.getAttribute(key))) continue;
                dataset.setAttribute(key, this.getAttribute(key));
                continue;
            }
            dataset.deleteAttribute(key);
        }
        for (String key : attributes) {
            if (datasetAttributes.containsKey(key)) continue;
            dataset.setAttribute(key, this.getAttribute(key));
        }
    }

    protected void transferAttributes(OmxMutableGroup group) {
        Set<String> attributes = this.getAttributeKeys();
        Map<String, Object> groupAttributes = group.getAttributes();
        for (String key : groupAttributes.keySet()) {
            if (attributes.contains(key)) {
                if (!groupAttributes.get(key).equals(this.getAttribute(key))) continue;
                group.setAttribute(key, this.getAttribute(key));
                continue;
            }
            group.deleteAttribute(key);
        }
        for (String key : attributes) {
            if (groupAttributes.containsKey(key)) continue;
            group.setAttribute(key, this.getAttribute(key));
        }
    }
}

