/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.UndefinedData;
import nom.tam.util.ArrayFuncs;

public class UndefinedHDU
extends BasicHDU {
    public UndefinedHDU(Header header, Data data) throws FitsException {
        this.myData = data;
        this.myHeader = header;
    }

    public static boolean isHeader(Header header) {
        return header.getStringValue("XTENSION") != null && header.getIntValue("NAXIS", -1) >= 0;
    }

    public static boolean isData(Object object) {
        return ArrayFuncs.computeSize(object) > 0;
    }

    public Data manufactureData() throws FitsException {
        return UndefinedHDU.manufactureData(this.myHeader);
    }

    public static Data manufactureData(Header header) throws FitsException {
        return new UndefinedData(header);
    }

    public static Header manufactureHeader(Data data) throws FitsException {
        Header header = new Header();
        data.fillHeader(header);
        return header;
    }

    public static Data encapsulate(Object object) throws FitsException {
        return new UndefinedData(object);
    }

    public void info() {
        System.out.println("  Unhandled/Undefined/Unknown Type");
        System.out.println("  XTENSION=" + this.myHeader.getStringValue("XTENSION").trim());
        System.out.println("  Apparent size:" + this.myData.getTrueSize());
    }
}

