/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import nom.tam.fits.Data;
import nom.tam.fits.FitsElement;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.HeaderCard;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.TruncatedFileException;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.Cursor;
import nom.tam.util.HashedList;
import nom.tam.util.RandomAccess;

public class Header
implements FitsElement {
    private HashedList cards = new HashedList();
    private Cursor iter = this.cards.iterator(0);
    private long fileOffset = -1L;
    private int oldSize;
    private ArrayDataInput input;

    public Header() {
    }

    public Header(ArrayDataInput arrayDataInput) throws TruncatedFileException, IOException {
        this.read(arrayDataInput);
    }

    public Header(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            HeaderCard headerCard = new HeaderCard(stringArray[n]);
            if (headerCard.getValue() == null) {
                this.cards.add(headerCard);
            } else {
                this.cards.add(headerCard.getKey(), headerCard);
            }
            ++n;
        }
    }

    public Header(Data data) throws FitsException {
        data.fillHeader(this);
    }

    public Data makeData() throws FitsException {
        return FitsFactory.dataFactory(this);
    }

    public int getNumberOfCards() {
        return this.cards.size();
    }

    public Cursor iterator() {
        return this.cards.iterator(0);
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    int trueDataSize() {
        if (!this.isValidHeader()) {
            return 0;
        }
        int n = this.getIntValue("NAXIS", 0);
        int n2 = this.getIntValue("BITPIX");
        int[] nArray = new int[n];
        int n3 = 1;
        while (n3 <= n) {
            nArray[n3 - 1] = this.getIntValue("NAXIS" + n3, 0);
            ++n3;
        }
        boolean bl = this.getBooleanValue("GROUPS", false);
        int n4 = this.getIntValue("PCOUNT", 0);
        int n5 = this.getIntValue("GCOUNT", 1);
        int n6 = 0;
        if (bl && n > 1 && nArray[0] == 0) {
            n6 = 1;
        }
        int n7 = 1;
        int n8 = n6;
        while (n8 < n) {
            n7 *= nArray[n8];
            ++n8;
        }
        n7 += n4;
        n7 *= n5;
        return n7 *= Math.abs(this.getIntValue("BITPIX", 0)) / 8;
    }

    public long getDataSize() {
        return FitsUtil.addPadding(this.trueDataSize());
    }

    public long getSize() {
        return this.headerSize();
    }

    int headerSize() {
        if (!this.isValidHeader()) {
            return 0;
        }
        return FitsUtil.addPadding(this.cards.size() * 80);
    }

    /*
     * Unable to fully structure code
     */
    boolean isValidHeader() {
        if (this.getNumberOfCards() < 4) {
            return false;
        }
        this.iter = this.iterator();
        var1_1 = ((HeaderCard)this.iter.next()).getKey();
        if (!var1_1.equals("SIMPLE") && !var1_1.equals("XTENSION")) {
            return false;
        }
        var1_1 = ((HeaderCard)this.iter.next()).getKey();
        if (!var1_1.equals("BITPIX")) {
            return false;
        }
        var1_1 = ((HeaderCard)this.iter.next()).getKey();
        if (var1_1.equals("NAXIS")) ** GOTO lbl14
        return false;
lbl-1000:
        // 1 sources

        {
            var1_1 = ((HeaderCard)this.iter.next()).getKey();
lbl14:
            // 2 sources

            ** while (this.iter.hasNext())
        }
lbl15:
        // 1 sources

        return var1_1.equals("END") != false;
    }

    public HeaderCard findCard(String string) {
        HeaderCard headerCard = (HeaderCard)this.cards.get(string);
        if (headerCard != null) {
            this.iter.setKey(string);
        }
        return headerCard;
    }

    public int getIntValue(String string, int n) {
        return (int)this.getLongValue(string, n);
    }

    public int getIntValue(String string) {
        return (int)this.getLongValue(string);
    }

    public long getLongValue(String string) {
        return this.getLongValue(string, 0L);
    }

    public long getLongValue(String string, long l) {
        HeaderCard headerCard = this.findCard(string);
        if (headerCard == null) {
            return l;
        }
        try {
            String string2 = headerCard.getValue();
            if (string2 != null) {
                return Long.parseLong(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l;
    }

    public float getFloatValue(String string, float f) {
        return (float)this.getDoubleValue(string, f);
    }

    public float getFloatValue(String string) {
        return (float)this.getDoubleValue(string);
    }

    public double getDoubleValue(String string) {
        return this.getDoubleValue(string, 0.0);
    }

    public double getDoubleValue(String string, double d) {
        HeaderCard headerCard = this.findCard(string);
        if (headerCard == null) {
            return d;
        }
        try {
            String string2 = headerCard.getValue();
            if (string2 != null) {
                return new Double(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    public boolean getBooleanValue(String string) {
        return this.getBooleanValue(string, false);
    }

    public boolean getBooleanValue(String string, boolean bl) {
        HeaderCard headerCard = this.findCard(string);
        if (headerCard == null) {
            return bl;
        }
        String string2 = headerCard.getValue();
        if (string2 == null) {
            return bl;
        }
        if (string2.equals("T")) {
            return true;
        }
        if (string2.equals("F")) {
            return false;
        }
        return bl;
    }

    public String getStringValue(String string) {
        HeaderCard headerCard = this.findCard(string);
        if (headerCard == null || !headerCard.isStringValue()) {
            return null;
        }
        return headerCard.getValue();
    }

    protected void addLine(HeaderCard headerCard) {
        if (headerCard != null) {
            if (headerCard.isKeyValuePair()) {
                this.iter.add(headerCard.getKey(), headerCard);
            } else {
                this.iter.add(headerCard);
            }
        }
    }

    protected void addLine(String string) throws HeaderCardException {
        this.addLine(new HeaderCard(string));
    }

    public static Header readHeader(ArrayDataInput arrayDataInput) throws TruncatedFileException, IOException {
        Header header = new Header();
        try {
            header.read(arrayDataInput);
        }
        catch (EOFException eOFException) {
            return null;
        }
        return header;
    }

    public void read(ArrayDataInput arrayDataInput) throws TruncatedFileException, IOException {
        String string;
        this.fileOffset = arrayDataInput instanceof RandomAccess ? FitsUtil.findOffset(arrayDataInput) : -1L;
        byte[] byArray = new byte[80];
        boolean bl = true;
        int n = 0;
        do {
            String string2;
            int n2 = 80;
            try {
                while (n2 > 0) {
                    int n3 = arrayDataInput.read(byArray, 80 - n2, n2);
                    ++n;
                    if (n3 == 0) {
                        throw new TruncatedFileException();
                    }
                    n2 -= n3;
                }
            }
            catch (EOFException eOFException) {
                if (bl && n2 == 80) {
                    throw eOFException;
                }
                throw new TruncatedFileException(eOFException.getMessage());
            }
            string = new String(byArray);
            HeaderCard headerCard = new HeaderCard(string);
            if (bl) {
                string2 = headerCard.getKey();
                if (string2 == null || !string2.equals("SIMPLE") && !string2.equals("XTENSION")) {
                    throw new IOException("Not FITS format at " + this.fileOffset + ":" + string);
                }
                bl = false;
            }
            if ((string2 = headerCard.getKey()) != null && this.cards.containsKey(string2)) {
                System.err.println("Warning: multiple occurrences of key:" + string2);
            }
            this.addLine(headerCard);
        } while (!string.substring(0, 8).equals("END     "));
        if (this.fileOffset >= 0L) {
            this.oldSize = this.cards.size();
            this.input = arrayDataInput;
        }
        try {
            arrayDataInput.skipBytes(FitsUtil.padding(n * 80));
        }
        catch (IOException iOException) {
            throw new TruncatedFileException(iOException.getMessage());
        }
    }

    public String findKey(String string) {
        HeaderCard headerCard = this.findCard(string);
        if (headerCard == null) {
            return null;
        }
        return headerCard.toString();
    }

    boolean replaceKey(String string, String string2) throws HeaderCardException {
        HeaderCard headerCard = this.findCard(string);
        if (headerCard == null) {
            return false;
        }
        if (!this.cards.replaceKey(string, string2)) {
            throw new HeaderCardException("Duplicate key in replace");
        }
        headerCard.setKey(string2);
        return true;
    }

    public void write(ArrayDataOutput arrayDataOutput) throws FitsException {
        this.fileOffset = FitsUtil.findOffset(arrayDataOutput);
        this.checkBeginning();
        this.checkEnd();
        if (this.cards.size() <= 0) {
            return;
        }
        HashedList.HashedListIterator hashedListIterator = this.cards.iterator(0);
        try {
            Object object;
            while (hashedListIterator.hasNext()) {
                object = (HeaderCard)hashedListIterator.next();
                byte[] byArray = ((HeaderCard)object).toString().getBytes();
                arrayDataOutput.write(byArray);
            }
            object = new byte[FitsUtil.padding(this.getNumberOfCards() * 80)];
            int n = 0;
            while (n < ((Object)object).length) {
                object[n] = 32;
                ++n;
            }
            arrayDataOutput.write((byte[])object);
        }
        catch (IOException iOException) {
            throw new FitsException("IO Error writing header: " + iOException);
        }
        try {
            arrayDataOutput.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void rewrite() throws FitsException, IOException {
        ArrayDataOutput arrayDataOutput = (ArrayDataOutput)((Object)this.input);
        if (!this.rewriteable()) {
            throw new FitsException("Invalid attempt to rewrite Header.");
        }
        FitsUtil.reposition(arrayDataOutput, this.fileOffset);
        this.write(arrayDataOutput);
        arrayDataOutput.flush();
    }

    public boolean rewriteable() {
        return this.fileOffset >= 0L && this.input instanceof ArrayDataOutput && (this.cards.size() + 35) / 36 == (this.oldSize + 35) / 36;
    }

    public void addValue(String string, boolean bl, String string2) throws HeaderCardException {
        this.removeCard(string);
        this.iter.add(string, new HeaderCard(string, bl, string2));
    }

    public void addValue(String string, double d, String string2) throws HeaderCardException {
        this.removeCard(string);
        this.iter.add(string, new HeaderCard(string, d, string2));
    }

    public void addValue(String string, String string2, String string3) throws HeaderCardException {
        this.removeCard(string);
        this.iter.add(string, new HeaderCard(string, string2, string3));
    }

    public void addValue(String string, long l, String string2) throws HeaderCardException {
        this.removeCard(string);
        this.iter.add(string, new HeaderCard(string, l, string2));
    }

    public void removeCard(String string) throws HeaderCardException {
        if (this.cards.containsKey(string)) {
            this.iter.setKey(string);
            if (this.iter.hasNext()) {
                this.iter.next();
                this.iter.remove();
            }
        }
    }

    public void insertCommentStyle(String string, String string2) {
        try {
            this.iter.add(new HeaderCard(string, null, string2));
        }
        catch (HeaderCardException headerCardException) {
            System.err.println("Impossible Exception for comment style:" + string + ":" + string2);
        }
    }

    public void insertComment(String string) throws HeaderCardException {
        this.insertCommentStyle("COMMENT", string);
    }

    public void insertHistory(String string) throws HeaderCardException {
        this.insertCommentStyle("HISTORY", string);
    }

    public void deleteKey(String string) {
        this.iter.setKey(string);
        if (this.iter.hasNext()) {
            this.iter.next();
            this.iter.remove();
        }
    }

    public final boolean containsKey(String string) {
        return this.cards.containsKey(string);
    }

    void nullImage() {
        this.iter = this.iterator();
        try {
            this.addValue("SIMPLE", true, "Null Image Header");
            this.addValue("BITPIX", 8L, (String)null);
            this.addValue("NAXIS", 0L, (String)null);
            this.addValue("EXTEND", true, "Extensions are permitted");
        }
        catch (HeaderCardException headerCardException) {
            // empty catch block
        }
    }

    public void setSimple(boolean bl) {
        this.deleteKey("SIMPLE");
        this.deleteKey("XTENSION");
        this.iter = this.iterator();
        try {
            this.iter.add("SIMPLE", new HeaderCard("SIMPLE", bl, "Java FITS: " + new Date()));
        }
        catch (HeaderCardException headerCardException) {
            System.err.println("Impossible exception at setSimple " + headerCardException);
        }
    }

    public void setXtension(String string) {
        this.deleteKey("SIMPLE");
        this.deleteKey("XTENSION");
        this.iter = this.iterator();
        try {
            this.iter.add("XTENSION", new HeaderCard("XTENSION", string, "Java FITS: " + new Date()));
        }
        catch (HeaderCardException headerCardException) {
            System.err.println("Impossible exception at setXtension " + headerCardException);
        }
    }

    public void setBitpix(int n) {
        this.iter = this.iterator();
        this.iter.next();
        try {
            this.iter.add("BITPIX", new HeaderCard("BITPIX", n, null));
        }
        catch (HeaderCardException headerCardException) {
            System.err.println("Impossible exception at setBitpix " + headerCardException);
        }
    }

    public void setNaxes(int n) {
        this.iter.setKey("BITPIX");
        if (this.iter.hasNext()) {
            this.iter.next();
        }
        try {
            this.iter.add("NAXIS", new HeaderCard("NAXIS", n, "Dimensionality"));
        }
        catch (HeaderCardException headerCardException) {
            System.err.println("Impossible exception at setNaxes " + headerCardException);
        }
    }

    public void setNaxis(int n, int n2) {
        if (n <= 0) {
            return;
        }
        if (n == 1) {
            this.iter.setKey("NAXIS");
        } else if (n > 1) {
            this.iter.setKey("NAXIS" + (n - 1));
        }
        if (this.iter.hasNext()) {
            this.iter.next();
        }
        try {
            this.iter.add("NAXIS" + n, new HeaderCard("NAXIS" + n, n2, null));
        }
        catch (HeaderCardException headerCardException) {
            System.err.println("Impossible exception at setNaxis " + headerCardException);
        }
    }

    void checkBeginning() throws FitsException {
        this.iter = this.iterator();
        if (!this.iter.hasNext()) {
            throw new FitsException("Empty Header");
        }
        HeaderCard headerCard = (HeaderCard)this.iter.next();
        String string = headerCard.getKey();
        if (!string.equals("SIMPLE") && !string.equals("XTENSION")) {
            throw new FitsException("No SIMPLE or XTENSION at beginning of Header");
        }
        boolean bl = false;
        boolean bl2 = false;
        if (string.equals("XTENSION")) {
            String string2 = headerCard.getValue();
            if (string2 == null) {
                throw new FitsException("Empty XTENSION keyword");
            }
            bl2 = true;
            if (string2.equals("BINTABLE") || string2.equals("A3DTABLE") || string2.equals("TABLE")) {
                bl = true;
            }
        }
        this.cardCheck("BITPIX");
        this.cardCheck("NAXIS");
        int n = this.getIntValue("NAXIS");
        this.iter.next();
        int n2 = 1;
        while (n2 <= n) {
            this.cardCheck("NAXIS" + n2);
            ++n2;
        }
        if (bl2) {
            this.cardCheck("PCOUNT");
            this.cardCheck("GCOUNT");
            if (bl) {
                this.cardCheck("TFIELDS");
            }
        }
    }

    private void cardCheck(String string) throws FitsException {
        if (!this.iter.hasNext()) {
            throw new FitsException("Header terminates before " + string);
        }
        HeaderCard headerCard = (HeaderCard)this.iter.next();
        if (!headerCard.getKey().equals(string)) {
            throw new FitsException("Key " + string + " not found where expected." + "Found " + headerCard.getKey());
        }
    }

    void checkEnd() {
        this.iter = this.iterator();
        while (this.iter.hasNext()) {
            HeaderCard headerCard = (HeaderCard)this.iter.next();
            if (headerCard.isKeyValuePair() || !headerCard.getKey().equals("END")) continue;
            this.iter.remove();
        }
        try {
            this.iter.add(new HeaderCard("END", null, null));
        }
        catch (HeaderCardException headerCardException) {
            // empty catch block
        }
    }

    protected void dumpHeader(PrintStream printStream) {
        this.iter = this.iterator();
        while (this.iter.hasNext()) {
            printStream.println((HashedList)this.iter.next());
        }
    }

    public int size() {
        return this.cards.size();
    }

    public String getCard(int n) {
        if (n >= 0 && n < this.cards.size()) {
            this.iter = this.cards.iterator(n);
            HeaderCard headerCard = (HeaderCard)this.iter.next();
            return headerCard.toString();
        }
        return null;
    }

    public String getKey(int n) {
        String string = this.getCard(n);
        if (string == null) {
            return null;
        }
        String string2 = string.substring(0, 8);
        if (string2.charAt(0) == ' ') {
            return "";
        }
        if (string2.indexOf(32) >= 1) {
            string2 = string2.substring(0, string2.indexOf(32));
        }
        return string2;
    }

    public void pointToData(Data data) throws FitsException {
        data.fillHeader(this);
    }

    Cursor positionAfterIndex(String string, int n) {
        String string2 = "" + n;
        this.iter.setKey(string + string2);
        if (this.iter.hasNext()) {
            while (this.iter.hasNext()) {
                String string3 = ((HeaderCard)this.iter.next()).getKey().trim();
                if (string3 == null || string3.length() <= string2.length() || !string3.substring(string3.length() - string2.length()).equals(string2)) break;
            }
            if (this.iter.hasNext()) {
                this.iter.prev();
            }
        }
        return this.iter;
    }
}

