/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import ncsa.hdf.object.FileFormat;

public class ViewProperties
extends Properties {
    private static final long serialVersionUID = -6411465283887959066L;
    public static final String VERSION = "2.8";
    private static final String USER_PROPERTY_FILE = ".hdfview" + "2.8".substring(0, 3);
    public static final int MAX_RECENT_FILES = 15;
    public static final String DELIMITER_TAB = "Tab";
    public static final String DELIMITER_COMMA = "Comma";
    public static final String DELIMITER_SPACE = "Space";
    public static final String DELIMITER_COLON = "Colon";
    public static final String ORIGIN_UL = "UpperLeft";
    public static final String ORIGIN_LL = "LowerLeft";
    public static final String ORIGIN_UR = "UpperRight";
    public static final String ORIGIN_LR = "LowerRight";
    public static final String DELIMITER_SEMI_COLON = "Semi-Colon";
    private static String usersGuide = System.getProperty("user.dir") + "/UsersGuide/index.html";
    private static int fontSize = 12;
    private static String fontType = null;
    private static String h4toh5 = "";
    private static String delimiter = "Tab";
    private static String origin = "UpperLeft";
    private static Vector<String> mrf;
    private static String rootDir;
    private static String workDir;
    private static String fileExt;
    private static ClassLoader extClassLoader;
    private static Vector<String[]> srbAccountList;
    private static boolean isAutoContrast;
    private static boolean showImageValues;
    private static boolean isReadOnly;
    private static Vector<String> paletteList;
    private static boolean convertEnum;
    private static boolean isIndexBase1;
    private static int max_members;
    private static int start_members;
    private static ImageIcon hdfIcon;
    private static ImageIcon h4Icon;
    private static ImageIcon h5Icon;
    private static ImageIcon largeHdfIcon;
    private static ImageIcon blankIcon;
    private static ImageIcon helpIcon;
    private static ImageIcon fileopenIcon;
    private static ImageIcon filesaveIcon;
    private static ImageIcon filenewIcon;
    private static ImageIcon filecloseIcon;
    private static ImageIcon foldercloseIcon;
    private static ImageIcon folderopenIcon;
    private static ImageIcon foldercloseIconA;
    private static ImageIcon folderopenIconA;
    private static ImageIcon datasetIcon;
    private static ImageIcon imageIcon;
    private static ImageIcon tableIcon;
    private static ImageIcon textIcon;
    private static ImageIcon datasetIconA;
    private static ImageIcon imageIconA;
    private static ImageIcon tableIconA;
    private static ImageIcon textIconA;
    private static ImageIcon zoominIcon;
    private static ImageIcon zoomoutIcon;
    private static ImageIcon paletteIcon;
    private static ImageIcon chartIcon;
    private static ImageIcon brightIcon;
    private static ImageIcon autocontrastIcon;
    private static ImageIcon copyIcon;
    private static ImageIcon cutIcon;
    private static ImageIcon pasteIcon;
    private static ImageIcon previousIcon;
    private static ImageIcon nextIcon;
    private static ImageIcon firstIcon;
    private static ImageIcon lastIcon;
    private static ImageIcon animationIcon;
    private static ImageIcon datatypeIcon;
    private static ImageIcon datatypeIconA;
    private static ImageIcon linkIcon;
    private static ImageIcon iconAPPS;
    private static ImageIcon iconURL;
    private static ImageIcon iconVIDEO;
    private static ImageIcon iconXLS;
    private static ImageIcon iconPDF;
    private static ImageIcon iconAUDIO;
    private static ImageIcon questionIcon;
    private static String propertyFile;
    private static Vector<String> moduleListTreeView;
    private static Vector<String> moduleListMetaDataView;
    private static Vector<String> moduleListTextView;
    private static Vector<String> moduleListTableView;
    private static Vector<String> moduleListImageView;
    private static Vector<String> moduleListPaletteView;
    private static Vector<String> moduleListHelpView;

    public ViewProperties(String viewRoot) {
        rootDir = viewRoot;
        mrf = new Vector(20);
        String uh = "";
        String ud = "";
        String h5v = "";
        String fn = USER_PROPERTY_FILE;
        uh = System.getProperty("user.home") + File.separator + fn;
        ud = System.getProperty("user.dir") + File.separator + fn;
        h5v = viewRoot + File.separator + "lib" + File.separator + fn;
        if (new File(uh).exists()) {
            propertyFile = uh;
        } else if (new File(ud).exists()) {
            propertyFile = ud;
        } else {
            propertyFile = uh;
            File pFile = new File(uh);
            try {
                pFile.createNewFile();
            }
            catch (Exception ex) {
                propertyFile = null;
            }
        }
    }

    @Override
    public synchronized Enumeration keys() {
        Enumeration<Object> keysEnum = super.keys();
        Vector<Object> keyList = new Vector<Object>(50);
        while (keysEnum.hasMoreElements()) {
            keyList.add(keysEnum.nextElement());
        }
        Collections.sort(keyList);
        return keyList.elements();
    }

    public static ClassLoader loadExtClass() {
        String dirname;
        File extdir;
        String[] jars;
        if (extClassLoader != null) {
            return extClassLoader;
        }
        extClassLoader = ClassLoader.getSystemClassLoader();
        String rootPath = System.getProperty("hdfview.root");
        if (rootPath == null) {
            rootPath = System.getProperty("user.dir");
        }
        if ((jars = (extdir = new File(dirname = rootPath + File.separator + "lib" + File.separator + "ext" + File.separator)).list()) == null || jars.length <= 0) {
            return extClassLoader;
        }
        Vector<String> jarList = new Vector<String>(50);
        Vector<String> classList = new Vector<String>(50);
        for (int i = 0; i < jars.length; ++i) {
            if (!jars[i].endsWith(".jar")) continue;
            jarList.add(jars[i]);
            File tmpFile = new File(extdir, jars[i]);
            try {
                JarFile jarFile = new JarFile(tmpFile, false, 1);
                Enumeration<JarEntry> emu = jarFile.entries();
                while (emu.hasMoreElements()) {
                    JarEntry jarEntry = emu.nextElement();
                    String entryName = jarEntry.getName();
                    int idx = entryName.indexOf(".class");
                    if (idx <= 0 || entryName.indexOf(36) > 0) continue;
                    entryName = entryName.replace('/', '.');
                    classList.add(entryName.substring(0, idx));
                }
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        int n = jarList.size();
        if (n <= 0) {
            return extClassLoader;
        }
        URL[] urls = new URL[n];
        for (int i = 0; i < n; ++i) {
            try {
                urls[i] = new URL("file:///" + rootPath + "/lib/ext/" + (String)jarList.get(i));
                continue;
            }
            catch (MalformedURLException mfu) {
                // empty catch block
            }
        }
        try {
            extClassLoader = URLClassLoader.newInstance(urls);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        n = classList.size();
        block13: for (int i = 0; i < n; ++i) {
            String theName = (String)classList.get(i);
            try {
                Class<?> theClass = null;
                try {
                    theClass = Class.forName(theName);
                }
                catch (Exception ex) {
                    theClass = extClassLoader.loadClass(theName);
                }
                Class<?>[] interfaces = theClass.getInterfaces();
                if (interfaces == null) continue;
                for (int j = 0; j < interfaces.length; ++j) {
                    String interfaceName = interfaces[j].getName();
                    if ("ncsa.hdf.view.TreeView".equals(interfaceName) && !moduleListTreeView.contains(theName)) {
                        moduleListTreeView.add(theName);
                        continue block13;
                    }
                    if ("ncsa.hdf.view.MetaDataView".equals(interfaceName) && !moduleListMetaDataView.contains(theName)) {
                        moduleListMetaDataView.add(theName);
                        continue block13;
                    }
                    if ("ncsa.hdf.view.TextView".equals(interfaceName) && !moduleListTextView.contains(theName)) {
                        moduleListTextView.add(theName);
                        continue block13;
                    }
                    if ("ncsa.hdf.view.TableView".equals(interfaceName) && !moduleListTableView.contains(theName)) {
                        moduleListTableView.add(theName);
                        continue block13;
                    }
                    if ("ncsa.hdf.view.ImageView".equals(interfaceName) && !moduleListImageView.contains(theName)) {
                        moduleListImageView.add(theName);
                        continue block13;
                    }
                    if ("ncsa.hdf.view.PaletteView".equals(interfaceName) && !moduleListPaletteView.contains(theName)) {
                        moduleListPaletteView.add(theName);
                        continue block13;
                    }
                    if (!"ncsa.hdf.view.HelpView".equals(interfaceName) || moduleListHelpView.contains(theName)) continue;
                    moduleListHelpView.add(theName);
                    continue block13;
                }
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return extClassLoader;
    }

    public static String getViewRoot() {
        return rootDir;
    }

    public static Icon getFoldercloseIcon() {
        return foldercloseIcon;
    }

    public static Icon getFoldercloseIconA() {
        return foldercloseIconA;
    }

    public static Icon getFolderopenIcon() {
        return folderopenIcon;
    }

    public static Icon getFolderopenIconA() {
        return folderopenIconA;
    }

    public static Icon getHdfIcon() {
        return hdfIcon;
    }

    public static Icon getH4Icon() {
        return h4Icon;
    }

    public static Icon getH5Icon() {
        return h5Icon;
    }

    public static Icon getDatasetIcon() {
        return datasetIcon;
    }

    public static Icon getDatasetIconA() {
        return datasetIconA;
    }

    public static Icon getDatatypeIcon() {
        return datatypeIcon;
    }

    public static Icon getDatatypeIconA() {
        return datatypeIconA;
    }

    public static Icon getLinkIcon() {
        return linkIcon;
    }

    public static Icon getFileopenIcon() {
        return fileopenIcon;
    }

    public static Icon getFilesaveIcon() {
        return filesaveIcon;
    }

    public static Icon getFilenewIcon() {
        return filenewIcon;
    }

    public static Icon getFilecloseIcon() {
        return filecloseIcon;
    }

    public static Icon getPaletteIcon() {
        return paletteIcon;
    }

    public static Icon getBrightIcon() {
        return brightIcon;
    }

    public static Icon getAutocontrastIcon() {
        return autocontrastIcon;
    }

    public static Icon getImageIcon() {
        return imageIcon;
    }

    public static Icon getTableIcon() {
        return tableIcon;
    }

    public static Icon getTextIcon() {
        return textIcon;
    }

    public static Icon getImageIconA() {
        return imageIconA;
    }

    public static Icon getTableIconA() {
        return tableIconA;
    }

    public static Icon getTextIconA() {
        return textIconA;
    }

    public static Icon getZoominIcon() {
        return zoominIcon;
    }

    public static Icon getZoomoutIcon() {
        return zoomoutIcon;
    }

    public static Icon getBlankIcon() {
        return blankIcon;
    }

    public static Icon getHelpIcon() {
        return helpIcon;
    }

    public static Icon getCopyIcon() {
        return copyIcon;
    }

    public static Icon getCutIcon() {
        return cutIcon;
    }

    public static Icon getPasteIcon() {
        return pasteIcon;
    }

    public static Icon getLargeHdfIcon() {
        return largeHdfIcon;
    }

    public static Icon getPreviousIcon() {
        return previousIcon;
    }

    public static Icon getNextIcon() {
        return nextIcon;
    }

    public static Icon getFirstIcon() {
        return firstIcon;
    }

    public static Icon getLastIcon() {
        return lastIcon;
    }

    public static Icon getChartIcon() {
        return chartIcon;
    }

    public static Icon getAnimationIcon() {
        return animationIcon;
    }

    public static ImageIcon getAppsIcon() {
        return iconAPPS;
    }

    public static ImageIcon getUrlIcon() {
        return iconURL;
    }

    public static ImageIcon getVideoIcon() {
        return iconVIDEO;
    }

    public static ImageIcon getXlsIcon() {
        return iconXLS;
    }

    public static ImageIcon getPdfIcon() {
        return iconPDF;
    }

    public static ImageIcon getAudioIcon() {
        return iconAUDIO;
    }

    public static Icon getQuestionIcon() {
        return questionIcon;
    }

    public static void loadIcons(String rootPath) {
        URL u = null;
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        if (hdfIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/hdf.gif")) != null) {
            hdfIcon = new ImageIcon(u);
        }
        if (h4Icon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/hdf4.gif")) != null) {
            h4Icon = new ImageIcon(u);
        }
        if (h5Icon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/hdf5.gif")) != null) {
            h5Icon = new ImageIcon(u);
        }
        if (foldercloseIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/folderclose.gif")) != null) {
            foldercloseIcon = new ImageIcon(u);
        }
        if (foldercloseIconA == null && (u = classLoader.getResource("ncsa/hdf/view/icons/foldercloseA.gif")) != null) {
            foldercloseIconA = new ImageIcon(u);
        }
        if (folderopenIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/folderopen.gif")) != null) {
            folderopenIcon = new ImageIcon(u);
        }
        if (folderopenIconA == null && (u = classLoader.getResource("ncsa/hdf/view/icons/folderopenA.gif")) != null) {
            folderopenIconA = new ImageIcon(u);
        }
        if (datasetIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/dataset.gif")) != null) {
            datasetIcon = new ImageIcon(u);
        }
        if (datasetIconA == null && (u = classLoader.getResource("ncsa/hdf/view/icons/datasetA.gif")) != null) {
            datasetIconA = new ImageIcon(u);
        }
        if (datatypeIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/datatype.gif")) != null) {
            datatypeIcon = new ImageIcon(u);
        }
        if (datatypeIconA == null && (u = classLoader.getResource("ncsa/hdf/view/icons/datatypeA.gif")) != null) {
            datatypeIconA = new ImageIcon(u);
        }
        if (linkIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/link.gif")) != null) {
            linkIcon = new ImageIcon(u);
        }
        if (fileopenIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/fileopen.gif")) != null) {
            fileopenIcon = new ImageIcon(u);
        }
        if (filesaveIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/filesave.gif")) != null) {
            filesaveIcon = new ImageIcon(u);
        }
        if (filenewIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/filenew.gif")) != null) {
            filenewIcon = new ImageIcon(u);
        }
        if (filecloseIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/fileclose.gif")) != null) {
            filecloseIcon = new ImageIcon(u);
        }
        if (paletteIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/palette.gif")) != null) {
            paletteIcon = new ImageIcon(u);
        }
        if (brightIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/brightness.gif")) != null) {
            brightIcon = new ImageIcon(u);
        }
        if (autocontrastIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/autocontrast.gif")) != null) {
            autocontrastIcon = new ImageIcon(u);
        }
        if (imageIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/image.gif")) != null) {
            imageIcon = new ImageIcon(u);
        }
        if (imageIconA == null && (u = classLoader.getResource("ncsa/hdf/view/icons/imageA.gif")) != null) {
            imageIconA = new ImageIcon(u);
        }
        if (tableIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/table.gif")) != null) {
            tableIcon = new ImageIcon(u);
        }
        if (tableIconA == null && (u = classLoader.getResource("ncsa/hdf/view/icons/tableA.gif")) != null) {
            tableIconA = new ImageIcon(u);
        }
        if (textIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/text.gif")) != null) {
            textIcon = new ImageIcon(u);
        }
        if (textIconA == null && (u = classLoader.getResource("ncsa/hdf/view/icons/textA.gif")) != null) {
            textIconA = new ImageIcon(u);
        }
        if (zoominIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/zoomin.gif")) != null) {
            zoominIcon = new ImageIcon(u);
        }
        if (zoomoutIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/zoomout.gif")) != null) {
            zoomoutIcon = new ImageIcon(u);
        }
        if (blankIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/blank.gif")) != null) {
            blankIcon = new ImageIcon(u);
        }
        if (helpIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/help.gif")) != null) {
            helpIcon = new ImageIcon(u);
        }
        if (copyIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/copy.gif")) != null) {
            copyIcon = new ImageIcon(u);
        }
        if (cutIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/cut.gif")) != null) {
            cutIcon = new ImageIcon(u);
        }
        if (pasteIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/paste.gif")) != null) {
            pasteIcon = new ImageIcon(u);
        }
        if (largeHdfIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/hdf_large.gif")) != null) {
            largeHdfIcon = new ImageIcon(u);
        }
        if (previousIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/previous.gif")) != null) {
            previousIcon = new ImageIcon(u);
        }
        if (nextIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/next.gif")) != null) {
            nextIcon = new ImageIcon(u);
        }
        if (firstIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/first.gif")) != null) {
            firstIcon = new ImageIcon(u);
        }
        if (lastIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/last.gif")) != null) {
            lastIcon = new ImageIcon(u);
        }
        if (chartIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/chart.gif")) != null) {
            chartIcon = new ImageIcon(u);
        }
        if (animationIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/animation.gif")) != null) {
            animationIcon = new ImageIcon(u);
        }
        if (questionIcon == null && (u = classLoader.getResource("ncsa/hdf/view/icons/question.gif")) != null) {
            questionIcon = new ImageIcon(u);
        }
        try {
            u = classLoader.getResource("ncsa/hdf/view/icons/audio.gif");
            iconAUDIO = new ImageIcon(u);
        }
        catch (Exception ex) {
            iconAUDIO = null;
        }
        try {
            u = classLoader.getResource("ncsa/hdf/view/icons/xls.gif");
            iconXLS = new ImageIcon(u);
        }
        catch (Exception ex) {
            iconXLS = null;
        }
        try {
            u = classLoader.getResource("ncsa/hdf/view/icons/pdf.gif");
            iconPDF = new ImageIcon(u);
        }
        catch (Exception ex) {
            iconPDF = null;
        }
        try {
            u = classLoader.getResource("ncsa/hdf/view/icons/apps.gif");
            iconAPPS = new ImageIcon(u);
        }
        catch (Exception ex) {
            iconAPPS = null;
        }
        try {
            u = classLoader.getResource("ncsa/hdf/view/icons/url.gif");
            iconURL = new ImageIcon(u);
        }
        catch (Exception ex) {
            iconURL = null;
        }
        try {
            u = classLoader.getResource("ncsa/hdf/view/icons/video.gif");
            iconVIDEO = new ImageIcon(u);
        }
        catch (Exception ex) {
            iconVIDEO = null;
        }
    }

    public void load() throws Exception {
        int i;
        int i2;
        int i3;
        String propVal = null;
        if (propertyFile == null) {
            return;
        }
        String[] moduleKeys = new String[]{"module.treeview", "module.metadataview", "module.textview", "module.tableview", "module.imageview", "module.paletteview"};
        Vector[] moduleList = new Vector[]{moduleListTreeView, moduleListMetaDataView, moduleListTextView, moduleListTableView, moduleListImageView, moduleListPaletteView};
        String[] moduleNames = new String[]{"ncsa.hdf.view.DefaultTreeView", "ncsa.hdf.view.DefaultMetaDataView", "ncsa.hdf.view.DefaultTextView", "ncsa.hdf.view.DefaultTableView", "ncsa.hdf.view.DefaultImageView", "ncsa.hdf.view.DefaultPaletteView"};
        for (i3 = 0; i3 < 6; ++i3) {
            if (moduleList[i3].contains(moduleNames[i3])) continue;
            moduleList[i3].addElement(moduleNames[i3]);
        }
        if (extClassLoader == null) {
            ViewProperties.loadExtClass();
        }
        for (i3 = 0; i3 < 6; ++i3) {
            Vector theList = moduleList[i3];
            propVal = (String)this.get(moduleKeys[i3]);
            if (propVal != null) {
                theList.remove(propVal);
                theList.add(0, propVal);
                continue;
            }
            theList.remove(moduleNames[i3]);
            theList.add(0, moduleNames[i3]);
        }
        try {
            FileInputStream fis = new FileInputStream(propertyFile);
            this.load(fis);
            fis.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        Enumeration local_enum = this.keys();
        String theKey = null;
        String fExt = null;
        while (local_enum.hasMoreElements()) {
            theKey = (String)local_enum.nextElement();
            if (!theKey.startsWith("module.fileformat")) continue;
            fExt = theKey.substring(18);
            try {
                Object theObject;
                String className = (String)this.get(theKey);
                Class<?> theClass = null;
                try {
                    theClass = Class.forName(className);
                }
                catch (Exception ex) {
                    try {
                        theClass = extClassLoader.loadClass(className);
                    }
                    catch (Exception ex2) {
                        // empty catch block
                    }
                }
                if (!((theObject = theClass.newInstance()) instanceof FileFormat)) continue;
                FileFormat.addFileFormat(fExt, (FileFormat)theObject);
            }
            catch (Throwable err) {}
        }
        propVal = (String)this.get("users.guide");
        if (propVal != null) {
            usersGuide = propVal;
        }
        if ((propVal = (String)this.get("image.contrast")) != null) {
            isAutoContrast = "auto".equalsIgnoreCase(propVal);
        }
        if ((propVal = (String)this.get("image.showvalues")) != null) {
            showImageValues = "true".equalsIgnoreCase(propVal);
        }
        if ((propVal = (String)this.get("file.mode")) != null) {
            isReadOnly = "r".equalsIgnoreCase(propVal);
        }
        if ((propVal = (String)this.get("enum.conversion")) != null) {
            convertEnum = "true".equalsIgnoreCase(propVal);
        }
        if ((propVal = (String)this.get("index.base1")) != null) {
            isIndexBase1 = "true".equalsIgnoreCase(propVal);
        }
        if ((propVal = (String)this.get("data.delimiter")) != null && propVal.length() > 0) {
            delimiter = propVal;
        }
        if ((propVal = (String)this.get("image.origin")) != null && propVal.length() > 0) {
            origin = propVal;
        }
        if ((propVal = (String)this.get("h4toh5.converter")) != null && propVal.length() > 0) {
            h4toh5 = propVal;
        }
        if ((propVal = (String)this.get("work.dir")) != null && propVal.length() > 0) {
            workDir = propVal;
        }
        if ((propVal = (String)this.get("file.extension")) != null && propVal.length() > 0) {
            fileExt = propVal;
            FileFormat.addFileExtension(fileExt);
        }
        if ((propVal = (String)this.get("font.size")) != null && propVal.length() > 0) {
            try {
                fontSize = Integer.parseInt(propVal);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if ((propVal = (String)this.get("font.type")) != null && propVal.length() > 0) {
            fontType = propVal.trim();
        }
        if ((propVal = (String)this.get("max.members")) != null && propVal.length() > 0) {
            try {
                max_members = Integer.parseInt(propVal);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        String theFile = null;
        for (i2 = 0; i2 < 15; ++i2) {
            theFile = this.getProperty("recent.file" + i2);
            if (theFile != null && !mrf.contains(theFile)) {
                if (!theFile.startsWith("http://") && !theFile.startsWith("ftp://") && !new File(theFile).exists()) continue;
                mrf.addElement(theFile);
                continue;
            }
            this.remove("recent.file" + i2);
        }
        theFile = null;
        for (i2 = 0; i2 < 15; ++i2) {
            theFile = this.getProperty("palette.file" + i2);
            if (theFile != null) {
                theFile = theFile.trim();
            }
            if (theFile != null && theFile.length() > 0 && !paletteList.contains(theFile)) {
                if (!new File(theFile).exists()) continue;
                paletteList.addElement(theFile);
                continue;
            }
            this.remove("palette.file" + i2);
        }
        propVal = null;
        String[] srbaccount = new String[7];
        for (i = 0; i < 15; ++i) {
            srbaccount[0] = this.getProperty("srbaccount" + i + ".host");
            if (null == srbaccount[0] || null == (srbaccount[1] = this.getProperty("srbaccount" + i + ".port")) || null == (srbaccount[2] = this.getProperty("srbaccount" + i + ".user")) || null == (srbaccount[3] = this.getProperty("srbaccount" + i + ".password")) || null == (srbaccount[4] = this.getProperty("srbaccount" + i + ".home")) || null == (srbaccount[5] = this.getProperty("srbaccount" + i + ".domain")) || null == (srbaccount[6] = this.getProperty("srbaccount" + i + ".resource"))) continue;
            srbAccountList.add(srbaccount);
            srbaccount = new String[7];
        }
        for (i = 0; i < 6; ++i) {
            String moduleName = (String)this.get(moduleKeys[i]);
            if (moduleName == null || moduleName.length() <= 0) continue;
            if (moduleList[i].contains(moduleName)) {
                moduleList[i].remove(moduleName);
            }
            moduleList[i].add(0, moduleName);
        }
    }

    public void save() {
        String theFile;
        int i;
        if (propertyFile == null) {
            return;
        }
        this.clear();
        if (delimiter == null) {
            this.put("data.delimiter", DELIMITER_TAB);
        } else {
            this.put("data.delimiter", delimiter);
        }
        if (origin == null) {
            this.put("image.origin", ORIGIN_UL);
        } else {
            this.put("image.origin", origin);
        }
        if (usersGuide != null) {
            this.put("users.guide", usersGuide);
        }
        if (workDir != null) {
            this.put("work.dir", workDir);
        }
        if (fileExt != null) {
            this.put("file.extension", fileExt);
        }
        if (h4toh5 != null) {
            this.put("h4toh5.converter", h4toh5);
        }
        this.put("font.size", String.valueOf(fontSize));
        if (fontType != null) {
            this.put("font.type", fontType);
        }
        this.put("max.members", String.valueOf(max_members));
        if (isAutoContrast) {
            this.put("image.contrast", "auto");
        } else {
            this.put("image.contrast", "general");
        }
        if (showImageValues) {
            this.put("image.showvalues", "true");
        } else {
            this.put("image.showvalues", "false");
        }
        if (isReadOnly) {
            this.put("file.mode", "r");
        } else {
            this.put("file.mode", "rw");
        }
        this.put("enum.conversion", String.valueOf(convertEnum));
        this.put("index.base1", String.valueOf(isIndexBase1));
        int size = mrf.size();
        int minSize = Math.min(size, 15);
        for (i = 0; i < minSize; ++i) {
            theFile = mrf.elementAt(i);
            if (theFile == null || theFile.length() <= 0) continue;
            this.put("recent.file" + i, theFile);
        }
        size = paletteList.size();
        minSize = Math.min(size, 15);
        for (i = 0; i < minSize; ++i) {
            theFile = paletteList.elementAt(i);
            if (theFile == null || theFile.length() <= 0) continue;
            this.put("palette.file" + i, theFile);
        }
        String[] srbaccount = null;
        size = srbAccountList.size();
        minSize = Math.min(size, 15);
        for (int i2 = 0; i2 < minSize; ++i2) {
            srbaccount = srbAccountList.get(i2);
            if (srbaccount[0] == null || srbaccount[1] == null || srbaccount[2] == null || srbaccount[3] == null || srbaccount[4] == null || srbaccount[5] == null || srbaccount[6] == null) continue;
            this.put("srbaccount" + i2 + ".host", srbaccount[0]);
            this.put("srbaccount" + i2 + ".port", srbaccount[1]);
            this.put("srbaccount" + i2 + ".user", srbaccount[2]);
            this.put("srbaccount" + i2 + ".password", srbaccount[3]);
            this.put("srbaccount" + i2 + ".home", srbaccount[4]);
            this.put("srbaccount" + i2 + ".domain", srbaccount[5]);
            this.put("srbaccount" + i2 + ".resource", srbaccount[6]);
        }
        String moduleName = moduleListTreeView.elementAt(0);
        if (moduleName != null && moduleName.length() > 0) {
            this.put("module.treeview", moduleName);
        }
        if ((moduleName = moduleListMetaDataView.elementAt(0)) != null && moduleName.length() > 0) {
            this.put("module.metadataview", moduleName);
        }
        if ((moduleName = moduleListTextView.elementAt(0)) != null && moduleName.length() > 0) {
            this.put("module.textview", moduleName);
        }
        if ((moduleName = moduleListTableView.elementAt(0)) != null && moduleName.length() > 0) {
            this.put("module.tableview", moduleName);
        }
        if ((moduleName = moduleListImageView.elementAt(0)) != null && moduleName.length() > 0) {
            this.put("module.imageview", moduleName);
        }
        if ((moduleName = moduleListPaletteView.elementAt(0)) != null && moduleName.length() > 0) {
            this.put("module.paletteview", moduleName);
        }
        Enumeration keys = FileFormat.getFileFormatKeys();
        String theKey = null;
        while (keys.hasMoreElements()) {
            theKey = (String)keys.nextElement();
            FileFormat theformat = FileFormat.getFileFormat(theKey);
            this.put("module.fileformat." + theKey, theformat.getClass().getName());
        }
        try {
            FileOutputStream fos = new FileOutputStream(propertyFile);
            this.store(fos, "User properties modified on ");
            fos.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static String getPropertyFile() {
        return propertyFile;
    }

    public static String getWorkDir() {
        if (workDir.equals("user.dir")) {
            workDir = System.getProperty("user.dir");
        }
        return workDir;
    }

    public static int getMaxRecentFiles() {
        return 15;
    }

    public static String getUsersGuide() {
        return usersGuide;
    }

    public static String getDataDelimiter() {
        return delimiter;
    }

    public static String getImageOrigin() {
        return origin;
    }

    public static int getFontSize() {
        return fontSize;
    }

    public static String getFontType() {
        return fontType;
    }

    public static String getFileExtension() {
        return fileExt;
    }

    public static void setFontSize(int fsize) {
        fontSize = fsize / 2 * 2;
        if (fontSize < 8) {
            fontSize = 8;
        }
    }

    public static void setFontType(String ftype) {
        if (ftype != null) {
            fontType = ftype.trim();
        }
    }

    public static String getH4toH5() {
        return h4toh5;
    }

    public static Vector<String> getMRF() {
        return mrf;
    }

    public static Vector<String> getPaletteList() {
        return paletteList;
    }

    public static Vector<String[]> getSrbAccount() {
        return srbAccountList;
    }

    public static Vector<String> getTreeViewList() {
        return moduleListTreeView;
    }

    public static Vector<String> getMetaDataViewList() {
        return moduleListMetaDataView;
    }

    public static Vector<String> getTextViewList() {
        return moduleListTextView;
    }

    public static Vector<String> getTableViewList() {
        return moduleListTableView;
    }

    public static Vector<String> getImageViewList() {
        return moduleListImageView;
    }

    public static Vector<String> getPaletteViewList() {
        return moduleListPaletteView;
    }

    public static Vector<String> getHelpViewList() {
        return moduleListHelpView;
    }

    public static void setUsersGuide(String str) {
        if (str == null || str.length() <= 0) {
            return;
        }
        usersGuide = str;
    }

    public static void setH4toH5(String tool) {
        h4toh5 = tool;
    }

    public static void setWorkDir(String wDir) {
        workDir = wDir;
    }

    public static void setFileExtension(String ext) {
        fileExt = ext;
    }

    public static void setDataDelimiter(String delim) {
        delimiter = delim;
    }

    public static void setImageOrigin(String o) {
        origin = o;
    }

    public static void setMaxMembers(int n) {
        max_members = n;
    }

    public static void setStartMembers(int idx) {
        if (idx < 0) {
            idx = 0;
        }
        start_members = idx;
    }

    public static int getMaxMembers() {
        return max_members;
    }

    public static int getStartMembers() {
        return start_members;
    }

    public static boolean isAutoContrast() {
        return isAutoContrast;
    }

    public static boolean showImageValues() {
        return showImageValues;
    }

    public static void setAutoContrast(boolean b) {
        isAutoContrast = b;
    }

    public static void setShowImageValue(boolean b) {
        showImageValues = b;
    }

    public static boolean isReadOnly() {
        return isReadOnly;
    }

    public static void setReadOnly(boolean b) {
        isReadOnly = b;
    }

    public static boolean isConvertEnum() {
        return convertEnum;
    }

    public static boolean isIndexBase1() {
        return isIndexBase1;
    }

    public static void setConvertEnum(boolean convertEnum) {
        ViewProperties.convertEnum = convertEnum;
    }

    public static void setIndexBase1(boolean b) {
        isIndexBase1 = b;
    }

    static {
        workDir = "user.dir";
        fileExt = "hdf, h4, hdf4, h5, hdf5, he4, he5";
        extClassLoader = null;
        srbAccountList = new Vector(5);
        isAutoContrast = false;
        showImageValues = false;
        isReadOnly = false;
        paletteList = new Vector(5);
        convertEnum = true;
        isIndexBase1 = false;
        max_members = 10000;
        start_members = 0;
        moduleListTreeView = new Vector(5);
        moduleListMetaDataView = new Vector(5);
        moduleListTextView = new Vector(5);
        moduleListTableView = new Vector(5);
        moduleListImageView = new Vector(5);
        moduleListPaletteView = new Vector(5);
        moduleListHelpView = new Vector(5);
    }

    public static enum BITMASK_OP {
        AND,
        EXTRACT;

    }

    public static enum DATA_VIEW_KEY {
        CHAR,
        CONVERTBYTE,
        TRANSPOSED,
        READONLY,
        OBJECT,
        BITMASK,
        BITMASKOP,
        BORDER,
        INFO,
        INDEXBASE1;

    }
}

