/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.Toolkit;
import java.io.File;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.view.DefaultFileFilter;
import ncsa.hdf.view.Tools;

public class NewFileDialog
extends JFileChooser {
    private static final long serialVersionUID = 4796246032789504234L;
    private String fileType;
    private String currentDir;
    private String viewDir;
    private boolean fileCreated;
    private List fileList;
    private final Toolkit toolkit;
    private final JFrame viewer;
    private boolean isH5 = false;
    private boolean isH4 = false;

    public NewFileDialog(JFrame owner, String dir, String type, List openFiles) {
        super(dir);
        this.currentDir = dir;
        this.viewer = owner;
        this.viewDir = dir;
        this.fileType = type;
        this.fileCreated = false;
        this.fileList = openFiles;
        this.toolkit = Toolkit.getDefaultToolkit();
        this.currentDir = this.currentDir != null ? this.currentDir + File.separator : "";
        if (this.fileType == "HDF4") {
            this.isH4 = true;
            this.setSelectedFile(Tools.checkNewFile(this.currentDir, ".hdf"));
            this.setFileFilter(DefaultFileFilter.getFileFilterHDF4());
        } else if (this.fileType == "HDF5") {
            this.isH5 = true;
            this.setSelectedFile(Tools.checkNewFile(this.currentDir, ".h5"));
            this.setFileFilter(DefaultFileFilter.getFileFilterHDF5());
        }
        this.showSaveDialog(owner);
    }

    @Override
    protected void fireActionPerformed(String command) {
        super.fireActionPerformed(command);
        this.fileCreated = command.equals("ApproveSelection") ? this.createNewFile() : false;
    }

    private boolean createNewFile() {
        File f = this.getSelectedFile();
        if (f == null) {
            return false;
        }
        String fname = f.getAbsolutePath();
        if (fname == null) {
            return false;
        }
        if ((fname = fname.trim()) == null || fname.length() == 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Invalid file name.", this.viewer.getTitle(), 0);
            return false;
        }
        String extensions = FileFormat.getFileExtensions();
        boolean noExtension = true;
        if (extensions != null && extensions.length() > 0) {
            StringTokenizer currentExt = new StringTokenizer(extensions, ",");
            String extension = "";
            String tmpFilename = fname.toLowerCase();
            while (currentExt.hasMoreTokens() && noExtension) {
                extension = currentExt.nextToken().trim().toLowerCase();
                noExtension = !tmpFilename.endsWith("." + extension);
            }
        }
        if (noExtension) {
            if (this.isH4) {
                fname = fname + ".hdf";
                f = new File(fname);
                this.setSelectedFile(f);
            } else if (this.isH5) {
                fname = fname + ".h5";
                f = new File(fname);
                this.setSelectedFile(f);
            }
        }
        if (f.exists() && f.isDirectory()) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "File is a directory.", this.viewer.getTitle(), 0);
            return false;
        }
        File pfile = f.getParentFile();
        if (pfile == null) {
            fname = this.viewDir + File.separator + fname;
            f = new File(fname);
        } else if (!pfile.exists()) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "File path does not exist at\n" + pfile.getPath(), this.viewer.getTitle(), 0);
            return false;
        }
        if (this.fileList != null) {
            FileFormat theFile2 = null;
            for (FileFormat theFile2 : this.fileList) {
                if (!theFile2.getFilePath().equals(fname)) continue;
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Unable to create the new file. \nThe file is being used.", this.viewer.getTitle(), 0);
                return false;
            }
        }
        int newFileFlag = -1;
        if (f.exists() && (newFileFlag = JOptionPane.showConfirmDialog(this, "File exists. Do you want to replace it ?", this.viewer.getTitle(), 0)) == 1) {
            return false;
        }
        this.currentDir = f.getParent();
        try {
            FileFormat.getFileFormat(this.fileType).create(fname);
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.viewer.getTitle(), 0);
            return false;
        }
        return true;
    }

    public boolean isFileCreated() {
        return this.fileCreated;
    }

    public String getFile() {
        String fname = null;
        File f = this.getSelectedFile();
        if (f != null) {
            fname = f.getAbsolutePath();
        }
        return fname;
    }
}

