/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import ncsa.hdf.object.DataFormat;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.DataView;
import ncsa.hdf.view.ImageView;
import ncsa.hdf.view.TableView;
import ncsa.hdf.view.ViewProperties;

public class NewDatasetDialog
extends JDialog
implements ActionListener,
ItemListener,
HyperlinkListener {
    private static final long serialVersionUID = 5381164938654184532L;
    private JTextField nameField;
    private JTextField currentSizeField;
    private JTextField maxSizeField;
    private JTextField chunkSizeField;
    private JTextField stringLengthField;
    private JTextField fillValueField;
    private JComboBox parentChoice;
    private JComboBox classChoice;
    private JComboBox sizeChoice;
    private JComboBox endianChoice;
    private JComboBox rankChoice;
    private JComboBox compressionLevel;
    private JCheckBox checkUnsigned;
    private JCheckBox checkCompression;
    private JCheckBox checkFillValue;
    private JRadioButton checkContinguous;
    private JRadioButton checkChunked;
    private JDialog helpDialog = null;
    private boolean isH5;
    private List groupList;
    private HObject newObject = null;
    private FileFormat fileFormat;
    private final Toolkit toolkit;
    private final DataView dataView;

    public NewDatasetDialog(JFrame owner, Group pGroup, List objs) {
        super(owner, "New Dataset...", true);
        this.dataView = null;
        this.fileFormat = pGroup.getFileFormat();
        this.toolkit = Toolkit.getDefaultToolkit();
        this.isH5 = pGroup.getFileFormat().isThisType(FileFormat.getFileFormat("HDF5"));
        this.parentChoice = new JComboBox();
        this.groupList = new Vector();
        Object obj2 = null;
        for (Object obj2 : objs) {
            if (!(obj2 instanceof Group)) continue;
            Group g = (Group)obj2;
            this.groupList.add(obj2);
            if (g.isRoot()) {
                this.parentChoice.addItem("/");
                continue;
            }
            this.parentChoice.addItem(g.getPath() + g.getName() + "/");
        }
        if (pGroup.isRoot()) {
            this.parentChoice.setSelectedItem("/");
        } else {
            this.parentChoice.setSelectedItem(pGroup.getPath() + pGroup.getName() + "/");
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout(5, 5));
        contentPane.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int w = 600 + (ViewProperties.getFontSize() - 12) * 15;
        int h = 350 + (ViewProperties.getFontSize() - 12) * 10;
        contentPane.setPreferredSize(new Dimension(w, h));
        JButton okButton = new JButton("   Ok   ");
        okButton.setName("OK");
        okButton.setActionCommand("Ok");
        okButton.setMnemonic(79);
        okButton.addActionListener(this);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setName("Cancel");
        cancelButton.setMnemonic(67);
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        JButton helplButton = new JButton("Help");
        helplButton.setName("Help");
        helplButton.setMnemonic(72);
        helplButton.setActionCommand("Show help");
        helplButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        buttonPanel.add(helplButton);
        contentPane.add((Component)buttonPanel, "South");
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BorderLayout(5, 5));
        JPanel tmpP = new JPanel();
        tmpP.setLayout(new GridLayout(2, 1));
        tmpP.add(new JLabel("Dataset name: "));
        tmpP.add(new JLabel("Parent group: "));
        namePanel.add((Component)tmpP, "West");
        tmpP = new JPanel();
        tmpP.setLayout(new GridLayout(2, 1));
        this.nameField = new JTextField();
        tmpP.add(this.nameField);
        this.nameField.setName("datasetname");
        tmpP.add(this.parentChoice);
        namePanel.add((Component)tmpP, "Center");
        contentPane.add((Component)namePanel, "North");
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new GridLayout(2, 4, 15, 3));
        TitledBorder border = new TitledBorder("Datatype");
        border.setTitleColor(Color.gray);
        typePanel.setBorder(border);
        this.stringLengthField = new JTextField("String length");
        this.stringLengthField.setEnabled(false);
        this.endianChoice = new JComboBox();
        this.classChoice = new JComboBox();
        this.sizeChoice = new JComboBox();
        this.endianChoice.setEnabled(this.isH5);
        this.classChoice.addItem("INTEGER");
        this.classChoice.addItem("FLOAT");
        this.classChoice.addItem("CHAR");
        if (this.isH5) {
            this.classChoice.addItem("STRING");
            this.classChoice.addItem("REFERENCE");
            this.classChoice.addItem("ENUM");
            this.sizeChoice.addItem("NATIVE");
            this.endianChoice.addItem("NATIVE");
            this.endianChoice.addItem("LITTLE ENDIAN");
            this.endianChoice.addItem("BIG ENDIAN");
        } else {
            this.sizeChoice.addItem("DEFAULT");
            this.endianChoice.addItem("DEFAULT");
        }
        this.sizeChoice.addItem("8");
        this.sizeChoice.addItem("16");
        this.sizeChoice.addItem("32");
        this.sizeChoice.addItem("64");
        typePanel.add(new JLabel("Datatype class"));
        typePanel.add(new JLabel("Size (bits)"));
        typePanel.add(new JLabel("Byte ordering"));
        this.checkUnsigned = new JCheckBox("Unsigned");
        typePanel.add(this.checkUnsigned);
        typePanel.add(this.classChoice);
        typePanel.add(this.sizeChoice);
        typePanel.add(this.endianChoice);
        typePanel.add(this.stringLengthField);
        JPanel spacePanel = new JPanel();
        spacePanel.setLayout(new GridLayout(2, 3, 15, 3));
        border = new TitledBorder("Dataspace");
        border.setTitleColor(Color.gray);
        spacePanel.setBorder(border);
        this.rankChoice = new JComboBox();
        for (int i = 1; i < 33; ++i) {
            this.rankChoice.addItem(String.valueOf(i));
        }
        this.rankChoice.setSelectedIndex(1);
        this.currentSizeField = new JTextField("1 x 1");
        this.currentSizeField.setName("currentsize");
        this.maxSizeField = new JTextField("");
        spacePanel.add(new JLabel("No. of dimensions"));
        spacePanel.add(new JLabel("Current size"));
        spacePanel.add(new JLabel(""));
        spacePanel.add(this.rankChoice);
        spacePanel.add(this.currentSizeField);
        JButton jb = new JButton("Set Max Size");
        jb.setActionCommand("Set max size");
        jb.addActionListener(this);
        spacePanel.add(jb);
        JPanel layoutPanel = new JPanel();
        layoutPanel.setLayout(new BorderLayout());
        border = new TitledBorder("Storage Properties");
        border.setTitleColor(Color.gray);
        layoutPanel.setBorder(border);
        this.checkContinguous = new JRadioButton("Contiguous");
        this.checkContinguous.setSelected(true);
        this.checkChunked = new JRadioButton("Chunked (size) ");
        ButtonGroup bgroup = new ButtonGroup();
        bgroup.add(this.checkChunked);
        bgroup.add(this.checkContinguous);
        this.chunkSizeField = new JTextField("1 x 1");
        this.chunkSizeField.setEnabled(false);
        this.checkCompression = new JCheckBox("gzip (level) ");
        this.compressionLevel = new JComboBox();
        for (int i = 0; i < 10; ++i) {
            this.compressionLevel.addItem(String.valueOf(i));
        }
        this.compressionLevel.setSelectedIndex(6);
        this.compressionLevel.setEnabled(false);
        tmpP = new JPanel();
        tmpP.setLayout(new GridLayout(2, 1));
        tmpP.add(new JLabel("Storage layout:  "));
        tmpP.add(new JLabel("Compression:  "));
        layoutPanel.add((Component)tmpP, "West");
        tmpP = new JPanel();
        tmpP.setLayout(new GridLayout(2, 1));
        JPanel tmpP0 = new JPanel();
        tmpP0.setLayout(new GridLayout(1, 3, 0, 5));
        tmpP0.add(this.checkContinguous);
        JPanel tmpP00 = new JPanel();
        tmpP00.setLayout(new BorderLayout());
        tmpP00.add((Component)this.checkChunked, "West");
        tmpP00.add((Component)this.chunkSizeField, "Center");
        tmpP0.add(tmpP00);
        tmpP0.add(new JLabel(""));
        tmpP.add(tmpP0);
        tmpP0 = new JPanel();
        tmpP0.setLayout(new GridLayout(1, 2, 30, 5));
        tmpP00 = new JPanel();
        tmpP00.setLayout(new BorderLayout());
        tmpP00.add((Component)this.checkCompression, "West");
        tmpP00.add((Component)this.compressionLevel, "Center");
        tmpP0.add(tmpP00);
        this.checkFillValue = new JCheckBox("Fill Value ");
        this.fillValueField = new JTextField("0");
        this.fillValueField.setEnabled(false);
        this.checkFillValue.setSelected(false);
        tmpP00 = new JPanel();
        tmpP00.setLayout(new BorderLayout());
        tmpP00.add((Component)this.checkFillValue, "West");
        tmpP00.add((Component)this.fillValueField, "Center");
        if (this.isH5) {
            tmpP0.add(tmpP00);
        } else {
            tmpP0.add(new JLabel(""));
        }
        tmpP.add(tmpP0);
        layoutPanel.add((Component)tmpP, "Center");
        JPanel infoPanel = new JPanel();
        infoPanel.setLayout(new GridLayout(3, 1, 5, 10));
        infoPanel.add(typePanel);
        infoPanel.add(spacePanel);
        infoPanel.add(layoutPanel);
        contentPane.add((Component)infoPanel, "Center");
        this.classChoice.addItemListener(this);
        this.sizeChoice.addItemListener(this);
        this.rankChoice.addItemListener(this);
        this.checkCompression.addItemListener(this);
        this.checkFillValue.addItemListener(this);
        this.checkContinguous.addItemListener(this);
        this.checkChunked.addItemListener(this);
        Point l = owner.getLocation();
        l.x += 250;
        l.y += 80;
        this.setLocation(l);
        this.validate();
        this.pack();
    }

    public NewDatasetDialog(JFrame owner, Group pGroup, List objs, DataView observer) {
        super(owner, "New Dataset...", true);
        this.dataView = observer;
        this.fileFormat = pGroup.getFileFormat();
        this.toolkit = Toolkit.getDefaultToolkit();
        this.isH5 = pGroup.getFileFormat().isThisType(FileFormat.getFileFormat("HDF5"));
        this.parentChoice = new JComboBox();
        this.groupList = new Vector();
        Object obj2 = null;
        for (Object obj2 : objs) {
            if (!(obj2 instanceof Group)) continue;
            Group g = (Group)obj2;
            this.groupList.add(obj2);
            if (g.isRoot()) {
                this.parentChoice.addItem("/");
                continue;
            }
            this.parentChoice.addItem(g.getPath() + g.getName() + "/");
        }
        if (pGroup.isRoot()) {
            this.parentChoice.setSelectedItem("/");
        } else {
            this.parentChoice.setSelectedItem(pGroup.getPath() + pGroup.getName() + "/");
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout(5, 5));
        contentPane.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int w = 400 + (ViewProperties.getFontSize() - 12) * 15;
        int h = 120 + (ViewProperties.getFontSize() - 12) * 10;
        contentPane.setPreferredSize(new Dimension(w, h));
        JButton okButton = new JButton("   Ok   ");
        okButton.setActionCommand("Ok");
        okButton.setMnemonic(79);
        okButton.addActionListener(this);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setMnemonic(67);
        cancelButton.setActionCommand("Cancel");
        cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        contentPane.add((Component)buttonPanel, "South");
        JPanel namePanel = new JPanel();
        namePanel.setLayout(new BorderLayout(5, 5));
        JPanel tmpP = new JPanel();
        tmpP.setLayout(new GridLayout(2, 1));
        tmpP.add(new JLabel("Dataset name: "));
        tmpP.add(new JLabel("Parent group: "));
        namePanel.add((Component)tmpP, "West");
        tmpP = new JPanel();
        tmpP.setLayout(new GridLayout(2, 1));
        this.nameField = new JTextField(observer.getDataObject().getName() + "~copy", 40);
        tmpP.add(this.nameField);
        tmpP.add(this.parentChoice);
        namePanel.add((Component)tmpP, "Center");
        contentPane.add((Component)namePanel, "Center");
        Point l = owner.getLocation();
        l.x += 250;
        l.y += 80;
        this.setLocation(l);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String cmd = e.getActionCommand();
        if (cmd.equals("Ok")) {
            if (this.dataView instanceof TableView) {
                this.newObject = this.createFromTable();
            } else if (this.dataView instanceof ImageView) {
                this.newObject = this.createFromImage();
            } else if (this.dataView == null) {
                this.newObject = this.createFromScratch();
            }
            if (this.newObject != null) {
                this.dispose();
            }
        }
        if (cmd.equals("Cancel")) {
            this.newObject = null;
            this.dispose();
            ((Vector)this.groupList).setSize(0);
        } else if (cmd.equals("Show help")) {
            if (this.helpDialog == null) {
                this.createHelpDialog();
            }
            this.helpDialog.setVisible(true);
        } else if (cmd.equals("Hide help")) {
            if (this.helpDialog != null) {
                this.helpDialog.setVisible(false);
            }
        } else if (cmd.equals("Set max size")) {
            String msg;
            String strMax = this.maxSizeField.getText();
            if (strMax == null || strMax.length() < 1) {
                strMax = this.currentSizeField.getText();
            }
            if ((msg = JOptionPane.showInputDialog(this, "Enter max dimension sizes. \nUse \"unlimited\" for unlimited dimension size.\n\nFor example,\n    200 x 100\n    100 x unlimited\n\n", strMax)) == null || msg.length() < 1) {
                this.maxSizeField.setText(this.currentSizeField.getText());
            } else {
                this.maxSizeField.setText(msg);
            }
            this.checkMaxSize();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source.equals(this.classChoice)) {
            int idx = this.classChoice.getSelectedIndex();
            this.sizeChoice.setSelectedIndex(0);
            this.endianChoice.setSelectedIndex(0);
            this.stringLengthField.setEnabled(false);
            if (idx == 0) {
                this.sizeChoice.setEnabled(true);
                this.endianChoice.setEnabled(this.isH5);
                this.checkUnsigned.setEnabled(true);
                if (this.sizeChoice.getItemCount() == 3) {
                    this.sizeChoice.removeItem("32");
                    this.sizeChoice.removeItem("64");
                    this.sizeChoice.addItem("8");
                    this.sizeChoice.addItem("16");
                    this.sizeChoice.addItem("32");
                    this.sizeChoice.addItem("64");
                }
                if (this.sizeChoice.getSelectedItem().equals("64")) {
                    this.checkUnsigned.setSelected(false);
                    this.checkUnsigned.setEnabled(false);
                }
            } else if (idx == 1) {
                this.sizeChoice.setEnabled(true);
                this.endianChoice.setEnabled(this.isH5);
                this.checkUnsigned.setEnabled(false);
                if (this.sizeChoice.getItemCount() == 5) {
                    this.sizeChoice.removeItem("16");
                    this.sizeChoice.removeItem("8");
                }
            } else if (idx == 2) {
                this.sizeChoice.setEnabled(false);
                this.endianChoice.setEnabled(this.isH5);
                this.checkUnsigned.setEnabled(true);
            } else if (idx == 3) {
                this.sizeChoice.setEnabled(false);
                this.endianChoice.setEnabled(false);
                this.checkUnsigned.setEnabled(false);
                this.stringLengthField.setEnabled(true);
                this.stringLengthField.setText("String length");
            } else if (idx == 4) {
                this.sizeChoice.setEnabled(false);
                this.endianChoice.setEnabled(false);
                this.checkUnsigned.setEnabled(false);
                this.stringLengthField.setEnabled(false);
            } else if (idx == 5) {
                this.sizeChoice.setEnabled(true);
                this.checkUnsigned.setEnabled(true);
                this.stringLengthField.setEnabled(true);
                this.stringLengthField.setText("R=0,G=1,B=2,...");
            }
        } else if (source.equals(this.sizeChoice)) {
            if (this.classChoice.getSelectedIndex() == 0) {
                if (this.sizeChoice.getSelectedItem().equals("64")) {
                    this.checkUnsigned.setSelected(false);
                    this.checkUnsigned.setEnabled(false);
                } else {
                    this.checkUnsigned.setEnabled(true);
                }
            }
        } else if (source.equals(this.rankChoice)) {
            int rank = this.rankChoice.getSelectedIndex() + 1;
            String currentSizeStr = "1";
            String maxSizeStr = "0";
            for (int i = 1; i < rank; ++i) {
                currentSizeStr = currentSizeStr + " x 1";
                maxSizeStr = maxSizeStr + " x 0";
            }
            this.currentSizeField.setText(currentSizeStr);
            this.maxSizeField.setText(maxSizeStr);
            String currentStr = this.currentSizeField.getText();
            int idx = currentStr.lastIndexOf("x");
            String chunkStr = "1";
            if (rank <= 1) {
                chunkStr = currentStr;
            } else {
                for (int i = 1; i < rank - 1; ++i) {
                    chunkStr = chunkStr + " x 1";
                }
                if (idx > 0) {
                    chunkStr = chunkStr + " x " + currentStr.substring(idx + 1);
                }
            }
            this.chunkSizeField.setText(chunkStr);
        } else if (source.equals(this.checkContinguous)) {
            this.chunkSizeField.setEnabled(false);
        } else if (source.equals(this.checkChunked)) {
            this.chunkSizeField.setEnabled(true);
            String chunkStr = "";
            StringTokenizer st = new StringTokenizer(this.currentSizeField.getText(), "x");
            int rank = this.rankChoice.getSelectedIndex() + 1;
            while (st.hasMoreTokens()) {
                long l = Math.max(1L, Long.valueOf(st.nextToken().trim()) / (long)(2 * rank));
                chunkStr = chunkStr + String.valueOf(l) + "x";
            }
            chunkStr = chunkStr.substring(0, chunkStr.lastIndexOf(120));
            this.chunkSizeField.setText(chunkStr);
        } else if (source.equals(this.checkCompression)) {
            boolean isCompressed = this.checkCompression.isSelected();
            if (isCompressed && this.isH5) {
                if (!this.checkChunked.isSelected()) {
                    String currentStr = this.currentSizeField.getText();
                    int idx = currentStr.lastIndexOf("x");
                    String chunkStr = "1";
                    int rank = this.rankChoice.getSelectedIndex() + 1;
                    if (rank <= 1) {
                        chunkStr = currentStr;
                    } else {
                        for (int i = 1; i < rank - 1; ++i) {
                            chunkStr = chunkStr + " x 1";
                        }
                        if (idx > 0) {
                            chunkStr = chunkStr + " x " + currentStr.substring(idx + 1);
                        }
                    }
                    this.chunkSizeField.setText(chunkStr);
                }
                this.compressionLevel.setEnabled(true);
                this.checkContinguous.setEnabled(false);
                this.checkChunked.setSelected(true);
                this.chunkSizeField.setEnabled(true);
            } else {
                this.compressionLevel.setEnabled(isCompressed);
                this.checkContinguous.setEnabled(true);
            }
        } else if (source.equals(this.checkFillValue)) {
            this.fillValueField.setEnabled(this.checkFillValue.isSelected());
        }
    }

    private void checkMaxSize() {
        int i;
        boolean isChunkNeeded = false;
        String dimStr = this.currentSizeField.getText();
        String maxStr = this.maxSizeField.getText();
        StringTokenizer stMax = new StringTokenizer(maxStr, "x");
        StringTokenizer stDim = new StringTokenizer(dimStr, "x");
        if (stMax.countTokens() != stDim.countTokens()) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Wrong number of values in the max dimension size " + maxStr, this.getTitle(), 0);
            this.maxSizeField.setText(null);
            return;
        }
        int rank = stDim.countTokens();
        long max = 0L;
        long dim = 0L;
        long[] maxdims = new long[rank];
        for (i = 0; i < rank; ++i) {
            String token = stMax.nextToken().trim();
            if ((token = token.toLowerCase()).startsWith("u")) {
                max = -1L;
                isChunkNeeded = true;
            } else {
                try {
                    max = Long.parseLong(token);
                }
                catch (NumberFormatException ex) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Invalid max dimension size: " + maxStr, this.getTitle(), 0);
                    this.maxSizeField.setText(null);
                    return;
                }
            }
            token = stDim.nextToken().trim();
            try {
                dim = Long.parseLong(token);
            }
            catch (NumberFormatException ex) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Invalid dimension size: " + dimStr, this.getTitle(), 0);
                return;
            }
            if (max != -1L && max < dim) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Invalid max dimension size: " + maxStr, this.getTitle(), 0);
                this.maxSizeField.setText(null);
                return;
            }
            if (max > dim) {
                isChunkNeeded = true;
            }
            maxdims[i] = max;
        }
        if (this.isH5) {
            if (isChunkNeeded && !this.checkChunked.isSelected()) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Chunking is required for the max dimensions of " + maxStr, this.getTitle(), 0);
                this.checkChunked.setSelected(true);
            }
        } else {
            for (i = 1; i < rank; ++i) {
                if (maxdims[i] > 0L) continue;
                this.maxSizeField.setText(this.currentSizeField.getText());
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Only dim[0] can be unlimited." + maxStr, this.getTitle(), 0);
                return;
            }
        }
    }

    private void createHelpDialog() {
        this.helpDialog = new JDialog((Dialog)this, "Create New Dataset");
        JPanel contentPane = (JPanel)this.helpDialog.getContentPane();
        contentPane.setLayout(new BorderLayout(5, 5));
        contentPane.setBorder(BorderFactory.createEmptyBorder(15, 5, 5, 5));
        int w = 500 + (ViewProperties.getFontSize() - 12) * 15;
        int h = 400 + (ViewProperties.getFontSize() - 12) * 10;
        contentPane.setPreferredSize(new Dimension(w, h));
        JButton b = new JButton("  Ok  ");
        b.addActionListener(this);
        b.setActionCommand("Hide help");
        JPanel tmpP = new JPanel();
        tmpP.add(b);
        contentPane.add((Component)tmpP, "South");
        JEditorPane infoPane = new JEditorPane();
        infoPane.setEditable(false);
        JScrollPane editorScrollPane = new JScrollPane(infoPane);
        contentPane.add((Component)editorScrollPane, "Center");
        try {
            URL url = null;
            URL url2 = null;
            URL url3 = null;
            String rootPath = ViewProperties.getViewRoot();
            try {
                url = new URL("file:" + rootPath + "/lib/jhdfview.jar");
            }
            catch (MalformedURLException mfu) {
                // empty catch block
            }
            try {
                url2 = new URL("file:" + rootPath + "/");
            }
            catch (MalformedURLException mfu) {
                // empty catch block
            }
            try {
                url3 = new URL("file:" + rootPath + "/src/");
            }
            catch (MalformedURLException mfu) {
                // empty catch block
            }
            URL[] uu = new URL[]{url, url2, url3};
            URLClassLoader cl = new URLClassLoader(uu);
            URL u = cl.findResource("ncsa/hdf/view/NewDatasetHelp.html");
            infoPane.setPage(u);
            infoPane.addHyperlinkListener(this);
        }
        catch (Exception e) {
            infoPane.setContentType("text/html");
            StringBuffer buff = new StringBuffer();
            buff.append("<html>");
            buff.append("<body>");
            buff.append("ERROR: cannot load help information.");
            buff.append("</body>");
            buff.append("</html>");
            infoPane.setText(buff.toString());
        }
        Point l = this.helpDialog.getOwner().getLocation();
        l.x += 50;
        l.y += 80;
        this.helpDialog.setLocation(l);
        this.helpDialog.validate();
        this.helpDialog.pack();
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane)e.getSource();
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                try {
                    pane.setPage(e.getURL());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private HObject createFromScratch() {
        int i;
        String name = null;
        Group pgroup = null;
        int rank = -1;
        int gzip = -1;
        int tclass = -1;
        int tsize = -1;
        int torder = -1;
        int tsign = -1;
        long[] maxdims = null;
        long[] chunks = null;
        name = this.nameField.getText().trim();
        if (name == null || name.length() < 1) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Dataset name is not specified.", this.getTitle(), 0);
            return null;
        }
        if (name.indexOf("/") >= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Dataset name cannot contain path.", this.getTitle(), 0);
            return null;
        }
        pgroup = (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
        if (pgroup == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Parent group is null.", this.getTitle(), 0);
            return null;
        }
        int idx = this.classChoice.getSelectedIndex();
        if (idx == 0) {
            tclass = 0;
            if (this.checkUnsigned.isSelected()) {
                tsign = 0;
            }
        } else if (idx == 1) {
            tclass = 1;
        } else if (idx == 2) {
            tclass = 2;
            if (this.checkUnsigned.isSelected()) {
                tsign = 0;
            }
        } else if (idx == 3) {
            tclass = 3;
        } else if (idx == 4) {
            tclass = 7;
        } else if (idx == 5) {
            tclass = 8;
        }
        idx = this.sizeChoice.getSelectedIndex();
        if (tclass == 3) {
            int stringLength = 0;
            try {
                stringLength = Integer.parseInt(this.stringLengthField.getText());
            }
            catch (NumberFormatException ex) {
                stringLength = -1;
            }
            if (stringLength <= 0) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Invalid string length: " + this.stringLengthField.getText(), this.getTitle(), 0);
                return null;
            }
            tsize = stringLength;
        } else if (tclass == 8) {
            String enumStr = this.stringLengthField.getText();
            if (enumStr == null || enumStr.length() < 1 || enumStr.endsWith("...")) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Invalid member values: " + this.stringLengthField.getText(), this.getTitle(), 0);
                return null;
            }
        } else {
            tsize = tclass == 7 ? 1 : (idx == 0 ? -1 : (tclass == 1 ? idx * 4 : 1 << idx - 1));
        }
        if (tsize == 8 && !this.isH5 && tclass == 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "HDF4 does not support 64-bit integer.", this.getTitle(), 0);
            return null;
        }
        idx = this.endianChoice.getSelectedIndex();
        torder = idx == 0 ? -1 : (idx == 1 ? 0 : 1);
        rank = this.rankChoice.getSelectedIndex() + 1;
        StringTokenizer st = new StringTokenizer(this.currentSizeField.getText(), "x");
        if (st.countTokens() < rank) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Number of values in the current dimension size is less than " + rank, this.getTitle(), 0);
            return null;
        }
        long l = 0L;
        long[] dims = new long[rank];
        String token = null;
        for (int i2 = 0; i2 < rank; ++i2) {
            token = st.nextToken().trim();
            try {
                l = Long.parseLong(token);
            }
            catch (NumberFormatException ex) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Invalid dimension size: " + this.currentSizeField.getText(), this.getTitle(), 0);
                return null;
            }
            if (l <= 0L) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Dimension size must be greater than zero.", this.getTitle(), 0);
                return null;
            }
            dims[i2] = l;
        }
        String maxFieldStr = this.maxSizeField.getText();
        if (maxFieldStr != null && maxFieldStr.length() > 1) {
            st = new StringTokenizer(maxFieldStr, "x");
            if (st.countTokens() < rank) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Number of values in the max dimension size is less than " + rank, this.getTitle(), 0);
                return null;
            }
            l = 0L;
            maxdims = new long[rank];
            for (i = 0; i < rank; ++i) {
                token = st.nextToken().trim();
                if ((token = token.toLowerCase()).startsWith("u")) {
                    l = -1L;
                } else {
                    try {
                        l = Long.parseLong(token);
                    }
                    catch (NumberFormatException ex) {
                        this.toolkit.beep();
                        JOptionPane.showMessageDialog(this, "Invalid max dimension size: " + this.maxSizeField.getText(), this.getTitle(), 0);
                        return null;
                    }
                }
                if (l < -1L) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Dimension size cannot be less than -1.", this.getTitle(), 0);
                    return null;
                }
                if (l == 0L) {
                    l = dims[i];
                }
                maxdims[i] = l;
            }
        }
        chunks = null;
        if (this.checkChunked.isSelected()) {
            int status;
            st = new StringTokenizer(this.chunkSizeField.getText(), "x");
            if (st.countTokens() < rank) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Number of values in the chunk size is less than " + rank, this.getTitle(), 0);
                return null;
            }
            l = 0L;
            chunks = new long[rank];
            for (i = 0; i < rank; ++i) {
                token = st.nextToken().trim();
                try {
                    l = Long.parseLong(token);
                }
                catch (NumberFormatException ex) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Invalid chunk dimension size: " + this.chunkSizeField.getText(), this.getTitle(), 0);
                    return null;
                }
                if (l < 1L) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Chunk size cannot be less than 1.", this.getTitle(), 0);
                    return null;
                }
                chunks[i] = l;
            }
            long tchunksize = 1L;
            long tdimsize = 1L;
            for (int i3 = 0; i3 < rank; ++i3) {
                tchunksize *= chunks[i3];
                tdimsize *= dims[i3];
            }
            if (tchunksize >= tdimsize) {
                this.toolkit.beep();
                status = JOptionPane.showConfirmDialog(this, "Chunk size is equal/greater than the current size. \nAre you sure you want to set chunk size to " + this.chunkSizeField.getText() + "?", this.getTitle(), 0);
                if (status == 1) {
                    return null;
                }
            }
            if (tchunksize == 1L) {
                this.toolkit.beep();
                status = JOptionPane.showConfirmDialog(this, "Chunk size is one, which may cause large memory overhead for large dataset.\nAre you sure you want to set chunk size to " + this.chunkSizeField.getText() + "?", this.getTitle(), 0);
                if (status == 1) {
                    return null;
                }
            }
        }
        gzip = this.checkCompression.isSelected() ? this.compressionLevel.getSelectedIndex() : 0;
        Dataset obj = null;
        try {
            Datatype datatype = this.fileFormat.createDatatype(tclass, tsize, torder, tsign);
            if (tclass == 8) {
                datatype.setEnumMembers(this.stringLengthField.getText());
            }
            String fillValue = null;
            if (this.fillValueField.isEnabled()) {
                fillValue = this.fillValueField.getText();
            }
            obj = this.fileFormat.createScalarDS(name, pgroup, datatype, dims, maxdims, chunks, gzip, fillValue, null);
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex, this.getTitle(), 0);
            return null;
        }
        return obj;
    }

    private HObject createFromTable() {
        ScalarDS sd;
        Dataset obj = null;
        String name = null;
        Group pgroup = null;
        name = this.nameField.getText();
        if (name == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Dataset name is not specified.", this.getTitle(), 0);
            return null;
        }
        if (name.indexOf("/") >= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Dataset name cannot contain path.", this.getTitle(), 0);
            return null;
        }
        pgroup = (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
        if (pgroup == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Parent group is null.", this.getTitle(), 0);
            return null;
        }
        TableView tableView = (TableView)this.dataView;
        Object theData = tableView.getSelectedData();
        if (theData == null) {
            return null;
        }
        int w = tableView.getTable().getSelectedColumnCount();
        int h = tableView.getTable().getSelectedRowCount();
        Dataset dataset = (Dataset)tableView.getDataObject();
        if (dataset instanceof ScalarDS && (sd = (ScalarDS)dataset).isUnsigned()) {
            theData = Dataset.convertToUnsignedC(theData);
        }
        try {
            long[] dims = new long[]{h, w};
            obj = dataset.copy(pgroup, name, dims, theData);
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            return null;
        }
        return obj;
    }

    private HObject createFromImage() {
        Dataset obj = null;
        String name = null;
        Group pgroup = null;
        name = this.nameField.getText();
        if (name == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Dataset name is not specified.", this.getTitle(), 0);
            return null;
        }
        if (name.indexOf("/") >= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Dataset name cannot contain path.", this.getTitle(), 0);
            return null;
        }
        pgroup = (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
        if (pgroup == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Parent group is null.", this.getTitle(), 0);
            return null;
        }
        ImageView imageView = (ImageView)this.dataView;
        ScalarDS dataset = (ScalarDS)imageView.getDataObject();
        Object theData = imageView.getSelectedData();
        if (theData == null) {
            return null;
        }
        if (dataset.isUnsigned()) {
            theData = Dataset.convertToUnsignedC(theData);
        }
        int w = imageView.getSelectedArea().width;
        int h = imageView.getSelectedArea().height;
        try {
            long[] dims = null;
            if (this.isH5) {
                if (imageView.isTrueColor()) {
                    dims = new long[3];
                    if (imageView.isPlaneInterlace()) {
                        dims[0] = 3L;
                        dims[1] = h;
                        dims[2] = w;
                    } else {
                        dims[0] = h;
                        dims[1] = w;
                        dims[2] = 3L;
                    }
                } else {
                    dims = new long[]{h, w};
                }
            } else {
                dims = new long[]{w, h};
            }
            obj = dataset.copy(pgroup, name, dims, theData);
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex.getMessage(), this.getTitle(), 0);
            return null;
        }
        return obj;
    }

    public DataFormat getObject() {
        return this.newObject;
    }

    public Group getParentGroup() {
        return (Group)this.groupList.get(this.parentChoice.getSelectedIndex());
    }
}

