/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.FontUIResource;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.DataView;
import ncsa.hdf.view.DefaultFileFilter;
import ncsa.hdf.view.DefaultTreeView;
import ncsa.hdf.view.FileConversionDialog;
import ncsa.hdf.view.HelpView;
import ncsa.hdf.view.NewFileDialog;
import ncsa.hdf.view.TableView;
import ncsa.hdf.view.TextView;
import ncsa.hdf.view.Tools;
import ncsa.hdf.view.TreeView;
import ncsa.hdf.view.UserOptionsDialog;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class HDFView
extends JFrame
implements ViewManager,
ActionListener,
ChangeListener,
DropTargetListener {
    private static final long serialVersionUID = 2211017444445918998L;
    private static List<String> treeViews;
    private static List<String> imageViews;
    private static List tableViews;
    private static List textViews;
    private static List metaDataViews;
    private static List paletteViews;
    private static List helpViews;
    private static final String aboutHDFView;
    private static final String JAVA_COMPILER = "jdk 1.6";
    private String rootDir;
    private String currentDir;
    private String currentFile;
    private ViewProperties props;
    private TreeView treeView;
    private int frameOffset;
    private final JDesktopPane contentPane;
    private final JTextArea statusArea;
    private final JTextArea attributeArea;
    private final JTabbedPane infoTabbedPane;
    private JMenuBar menuBar;
    private final JMenu windowMenu;
    private final JMenu fileMenu;
    private final StringBuffer message;
    private final StringBuffer metadata;
    private final Toolkit toolkit;
    private final List editGUIs;
    private final List<JMenuItem> h5GUIs;
    private final List<JMenuItem> h4GUIs;
    private JComboBox urlBar;
    private UserOptionsDialog userOptionDialog;
    private Constructor ctrSrbFileDialog = null;
    private JDialog srbFileDialog = null;

    public HDFView(String root, List<File> flist, int width, int height, int x, int y) {
        super("HDFView");
        this.setName("hdfview");
        this.setDefaultCloseOperation(2);
        this.rootDir = root;
        this.currentFile = null;
        this.frameOffset = 0;
        this.userOptionDialog = null;
        this.ctrSrbFileDialog = null;
        this.toolkit = Toolkit.getDefaultToolkit();
        ViewProperties.loadIcons(this.rootDir);
        ViewProperties.loadExtClass();
        this.editGUIs = new Vector();
        this.h4GUIs = new Vector<JMenuItem>();
        this.h5GUIs = new Vector<JMenuItem>();
        this.props = new ViewProperties(this.rootDir);
        try {
            this.props.load();
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.currentDir = ViewProperties.getWorkDir();
        if (this.currentDir == null) {
            this.currentDir = System.getProperty("user.dir");
        }
        treeViews = ViewProperties.getTreeViewList();
        metaDataViews = ViewProperties.getMetaDataViewList();
        textViews = ViewProperties.getTextViewList();
        tableViews = ViewProperties.getTableViewList();
        imageViews = ViewProperties.getImageViewList();
        paletteViews = ViewProperties.getPaletteViewList();
        helpViews = ViewProperties.getHelpViewList();
        this.statusArea = new JTextArea();
        this.statusArea.setEditable(false);
        this.statusArea.setBackground(new Color(240, 240, 240));
        this.statusArea.setLineWrap(true);
        this.statusArea.setName("status");
        this.message = new StringBuffer();
        this.metadata = new StringBuffer();
        this.showStatus("HDFView root - " + this.rootDir);
        this.showStatus("User property file - " + ViewProperties.getPropertyFile());
        this.attributeArea = new JTextArea();
        this.attributeArea.setEditable(false);
        this.attributeArea.setBackground(new Color(240, 240, 240));
        this.attributeArea.setLineWrap(true);
        this.attributeArea.setName("attributes");
        this.infoTabbedPane = new JTabbedPane(3);
        this.infoTabbedPane.addChangeListener(this);
        this.infoTabbedPane.setName("tabpane");
        this.contentPane = new JDesktopPane();
        this.contentPane.setName("contentpane");
        this.windowMenu = new JMenu("Window");
        this.windowMenu.setName("windowmenu");
        this.fileMenu = new JMenu("File");
        this.fileMenu.setName("filemenu");
        int n = treeViews.size();
        Class<?> theClass = null;
        for (int i = 0; i < n; ++i) {
            String className = treeViews.get(i);
            try {
                theClass = Class.forName(className);
            }
            catch (Exception ex) {
                try {
                    theClass = ViewProperties.loadExtClass().loadClass(className);
                }
                catch (Exception ex2) {
                    theClass = null;
                }
            }
            if (theClass != null) break;
        }
        if (theClass != null) {
            try {
                Class[] paramClass = new Class[]{Class.forName("ncsa.hdf.view.ViewManager")};
                Constructor<?> constructor = theClass.getConstructor(paramClass);
                Object[] paramObj = new Object[]{this};
                this.treeView = (TreeView)constructor.newInstance(paramObj);
            }
            catch (Exception ex) {
                this.treeView = null;
            }
        }
        if (this.treeView == null) {
            this.treeView = new DefaultTreeView(this);
        }
        this.createMainWindow(width, height, x, y);
        try {
            Font font = null;
            String ftype = ViewProperties.getFontType();
            int fsize = ViewProperties.getFontSize();
            try {
                font = new Font(ftype, 0, fsize);
            }
            catch (Exception ex) {
                font = null;
            }
            if (font != null) {
                this.updateFontSize(font);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.pack();
        new DropTarget(this, this);
        int nfiles = flist.size();
        File theFile = null;
        for (int i = 0; i < nfiles; ++i) {
            theFile = flist.get(i);
            if (theFile.isFile()) {
                this.currentDir = theFile.getParentFile().getAbsolutePath();
                this.currentFile = theFile.getAbsolutePath();
                try {
                    this.treeView.openFile(this.currentFile, 1);
                    try {
                        this.urlBar.removeItem(this.currentFile);
                        this.urlBar.insertItemAt(this.currentFile, 0);
                        this.urlBar.setSelectedIndex(0);
                    }
                    catch (Exception ex2) {
                    }
                }
                catch (Exception ex) {
                    this.showStatus(ex.toString());
                }
                continue;
            }
            this.currentDir = theFile.getAbsolutePath();
        }
        if (FileFormat.getFileFormat("HDF4") == null) {
            HDFView.setEnabled(this.h4GUIs, false);
        }
        if (FileFormat.getFileFormat("HDF5") == null) {
            HDFView.setEnabled(this.h5GUIs, false);
        }
    }

    private void updateFontSize(Font font) {
        if (font == null) {
            return;
        }
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        for (Object key : defaults.keySet()) {
            if (defaults.getFont(key) == null) continue;
            UIManager.put(key, new FontUIResource(font));
        }
        SwingUtilities.updateComponentTreeUI(this);
    }

    private void createMainWindow(int width, int height, int x, int y) {
        JScrollPane treeScroller = new JScrollPane((Component)((Object)this.treeView));
        treeScroller.setName("treescroller");
        JScrollPane contentScroller = new JScrollPane(this.contentPane);
        contentScroller.setName("contentscroller");
        JSplitPane topSplitPane = new JSplitPane(1, treeScroller, contentScroller);
        topSplitPane.setDividerLocation(200);
        topSplitPane.setName("topsplitpane");
        this.infoTabbedPane.addTab("Log Info", new JScrollPane(this.statusArea));
        this.infoTabbedPane.addTab("Metadata ", new JScrollPane(this.attributeArea));
        this.infoTabbedPane.setSelectedIndex(1);
        topSplitPane.setBorder(null);
        JSplitPane splitPane = new JSplitPane(0, topSplitPane, this.infoTabbedPane);
        splitPane.setName("splitpane");
        float inset = 0.04f;
        Dimension d = this.toolkit.getScreenSize();
        d.height = height > 300 ? height : (int)((1.0f - 2.0f * inset) * (float)d.height);
        d.width = width > 300 ? width : (int)(0.9 * (double)d.height);
        if (this.treeView.getClass().getName().startsWith("ext.erdc")) {
            topSplitPane.setDividerLocation(500);
            d.width = (int)(0.9 * (double)this.toolkit.getScreenSize().width);
            d.height = (int)((double)d.width * 0.618);
        }
        splitPane.setDividerLocation(d.height - 180);
        this.setLocation(x, y);
        try {
            this.setIconImage(((ImageIcon)ViewProperties.getHdfIcon()).getImage());
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.menuBar = this.createMenuBar();
        this.setJMenuBar(this.menuBar);
        JToolBar toolBar = this.createToolBar();
        this.urlBar = new JComboBox<String>(ViewProperties.getMRF());
        this.urlBar.setMaximumRowCount(15);
        this.urlBar.setEditable(true);
        this.urlBar.addActionListener(this);
        this.urlBar.setActionCommand("Open file: from file bar");
        this.urlBar.setSelectedIndex(-1);
        JPanel urlPane = new JPanel();
        urlPane.setLayout(new BorderLayout());
        urlPane.setName("urlpane");
        JButton b = new JButton("Clear Text");
        b.setActionCommand("Clear current selection");
        b.setToolTipText("Clear current selection");
        b.setMargin(new Insets(1, 3, 1, 3));
        b.addActionListener(this);
        urlPane.add((Component)b, "East");
        b = new JButton("Recent Files");
        b.addActionListener(this);
        b.setActionCommand("Popup URL list");
        b.setToolTipText("List of recent files");
        b.setMargin(new Insets(1, 3, 1, 3));
        urlPane.add((Component)b, "West");
        urlPane.add((Component)this.urlBar, "Center");
        JPanel toolPane = new JPanel();
        toolPane.setLayout(new GridLayout(2, 1, 0, 0));
        toolPane.add(toolBar);
        toolPane.add(urlPane);
        toolPane.setName("toolpane");
        JPanel mainPane = (JPanel)this.getContentPane();
        mainPane.setLayout(new BorderLayout());
        mainPane.add((Component)toolPane, "North");
        mainPane.add((Component)splitPane, "Center");
        mainPane.setPreferredSize(d);
        mainPane.setName("mainpane");
    }

    private JMenuBar createMenuBar() {
        JMenuBar mbar = new JMenuBar();
        mbar.setName("mbar");
        JMenu menu = null;
        this.fileMenu.setMnemonic('f');
        mbar.add(this.fileMenu);
        JMenuItem item = new JMenuItem("Open");
        item.setMnemonic(79);
        item.addActionListener(this);
        item.setActionCommand("Open file");
        item.setAccelerator(KeyStroke.getKeyStroke(79, 2, true));
        this.fileMenu.add(item);
        item = new JMenuItem("Open Read-Only");
        item.setMnemonic(82);
        item.addActionListener(this);
        item.setActionCommand("Open file read-only");
        if (!ViewProperties.isReadOnly()) {
            this.fileMenu.add(item);
        }
        this.fileMenu.addSeparator();
        JMenu newFileMenu = new JMenu("New");
        item = new JMenuItem("HDF4");
        item.setActionCommand("New HDF4 file");
        item.setMnemonic(52);
        item.addActionListener(this);
        this.h4GUIs.add(item);
        newFileMenu.add(item);
        item = new JMenuItem("HDF5");
        item.setActionCommand("New HDF5 file");
        item.setMnemonic(53);
        item.addActionListener(this);
        this.h5GUIs.add(item);
        newFileMenu.add(item);
        this.fileMenu.add(newFileMenu);
        this.fileMenu.addSeparator();
        item = new JMenuItem("Close");
        item.setMnemonic(67);
        item.addActionListener(this);
        item.setActionCommand("Close file");
        this.fileMenu.add(item);
        item = new JMenuItem("Close All");
        item.setMnemonic(65);
        item.addActionListener(this);
        item.setActionCommand("Close all file");
        this.fileMenu.add(item);
        this.fileMenu.addSeparator();
        item = new JMenuItem("Save");
        item.setMnemonic(83);
        item.addActionListener(this);
        item.setActionCommand("Save current file");
        this.fileMenu.add(item);
        item = new JMenuItem("Save As");
        item.setMnemonic(65);
        item.addActionListener(this);
        item.setActionCommand("Save current file as");
        this.fileMenu.add(item);
        this.fileMenu.addSeparator();
        item = new JMenuItem("Exit");
        item.setMnemonic(88);
        item.addActionListener(this);
        item.setActionCommand("Exit");
        item.setAccelerator(KeyStroke.getKeyStroke(81, 2, true));
        this.fileMenu.add(item);
        this.fileMenu.addSeparator();
        this.windowMenu.setMnemonic('w');
        mbar.add(this.windowMenu);
        item = new JMenuItem("Cascade");
        item.setMnemonic(67);
        item.setActionCommand("Cascade all windows");
        item.addActionListener(this);
        this.windowMenu.add(item);
        item = new JMenuItem("Tile");
        item.setMnemonic(84);
        item.setActionCommand("Tile all windows");
        item.addActionListener(this);
        this.windowMenu.add(item);
        this.windowMenu.addSeparator();
        item = new JMenuItem("Close Window");
        item.setMnemonic(87);
        item.setActionCommand("Close a window");
        item.addActionListener(this);
        this.windowMenu.add(item);
        item = new JMenuItem("Close All");
        item.setMnemonic(65);
        item.setActionCommand("Close all windows");
        item.addActionListener(this);
        this.windowMenu.add(item);
        this.windowMenu.addSeparator();
        menu = new JMenu("Tools");
        menu.setMnemonic('T');
        mbar.add(menu);
        JMenu imageSubmenu = new JMenu("Convert Image To");
        item = new JMenuItem("HDF4");
        item.setActionCommand("Convert image file: Image to HDF4");
        item.addActionListener(this);
        this.h4GUIs.add(item);
        imageSubmenu.add(item);
        item = new JMenuItem("HDF5");
        item.setActionCommand("Convert image file: Image to HDF5");
        item.addActionListener(this);
        this.h5GUIs.add(item);
        imageSubmenu.add(item);
        menu.add(imageSubmenu);
        menu.addSeparator();
        item = new JMenuItem("User Options");
        item.setMnemonic(79);
        item.setActionCommand("User options");
        item.addActionListener(this);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Register File Format");
        item.setMnemonic(82);
        item.setActionCommand("Register file format");
        item.addActionListener(this);
        menu.add(item);
        item = new JMenuItem("Unregister File Format");
        item.setMnemonic(85);
        item.setActionCommand("Unregister file format");
        item.addActionListener(this);
        menu.add(item);
        menu = new JMenu("Help");
        menu.setMnemonic('H');
        mbar.add(menu);
        item = new JMenuItem("User's Guide");
        item.setMnemonic(85);
        item.setActionCommand("Users guide");
        item.addActionListener(this);
        menu.add(item);
        menu.addSeparator();
        if (helpViews != null && helpViews.size() > 0) {
            int n = helpViews.size();
            for (int i = 0; i < n; ++i) {
                HelpView theView = (HelpView)helpViews.get(i);
                item = new JMenuItem(theView.getLabel());
                item.setActionCommand(theView.getActionCommand());
                item.addActionListener(this);
                menu.add(item);
            }
            menu.addSeparator();
        }
        item = new JMenuItem("HDF4 Library Version");
        item.setMnemonic(52);
        item.setActionCommand("HDF4 library");
        item.addActionListener(this);
        this.h4GUIs.add(item);
        menu.add(item);
        item = new JMenuItem("HDF5 Library Version");
        item.setMnemonic(53);
        item.setActionCommand("HDF5 library");
        item.addActionListener(this);
        this.h5GUIs.add(item);
        menu.add(item);
        item = new JMenuItem("Java Version");
        item.setMnemonic(53);
        item.setActionCommand("Java version");
        item.addActionListener(this);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Supported File Formats");
        item.setMnemonic(76);
        item.setActionCommand("File format list");
        item.addActionListener(this);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("About...");
        item.setMnemonic(65);
        item.setActionCommand("About");
        item.addActionListener(this);
        menu.add(item);
        return mbar;
    }

    private JToolBar createToolBar() {
        JToolBar tbar = new JToolBar();
        tbar.setFloatable(false);
        tbar.setName("tbar");
        JButton button = new JButton(ViewProperties.getFileopenIcon());
        tbar.add(button);
        button.setName("Open");
        button.setToolTipText("Open");
        button.addActionListener(this);
        button.setActionCommand("Open file");
        button = new JButton(ViewProperties.getFilecloseIcon());
        tbar.add(button);
        button.setName("Close");
        button.setToolTipText("Close");
        button.addActionListener(this);
        button.setActionCommand("Close file");
        tbar.addSeparator(new Dimension(20, 20));
        button = new JButton(ViewProperties.getHelpIcon());
        tbar.add(button);
        button.setName("Help");
        button.setToolTipText("Help");
        button.addActionListener(this);
        button.setActionCommand("Users guide");
        button = new JButton(ViewProperties.getH4Icon());
        tbar.add(button);
        button.setName("HDF4 library");
        button.setToolTipText("HDF4 Library Version");
        button.addActionListener(this);
        button.setActionCommand("HDF4 library");
        if (FileFormat.getFileFormat("HDF4") == null) {
            button.setEnabled(false);
        }
        button = new JButton(ViewProperties.getH5Icon());
        tbar.add(button);
        button.setName("HDF5 library");
        button.setToolTipText("HDF5 Library Version");
        button.addActionListener(this);
        button.setActionCommand("HDF5 library");
        if (FileFormat.getFileFormat("HDF5") == null) {
            button.setEnabled(false);
        }
        return tbar;
    }

    private void showWindow(String name) {
        int n = this.contentPane.getComponentCount();
        if (n <= 0) {
            return;
        }
        Component comp = null;
        JInternalFrame jif = null;
        for (int i = 0; i < n; ++i) {
            comp = this.contentPane.getComponent(i);
            if (!(comp instanceof JInternalFrame) || !(jif = (JInternalFrame)this.contentPane.getComponent(i)).getName().equals(name)) continue;
            jif.toFront();
            return;
        }
    }

    private void cascadeWindow() {
        int y = 2;
        int x = 2;
        JInternalFrame jif = null;
        Component[] clist = this.contentPane.getComponents();
        if (clist == null || clist.length <= 0) {
            return;
        }
        Dimension d = this.contentPane.getSize();
        int w = Math.max(50, d.width - 100);
        int h = Math.max(50, d.height - 100);
        for (int i = 0; i < clist.length; ++i) {
            jif = (JInternalFrame)clist[i];
            jif.setBounds(x, y, w, h);
            this.contentPane.moveToFront(jif);
            x += 20;
            y += 20;
        }
    }

    private void tileWindow() {
        int y = 0;
        int x = 0;
        int idx = 0;
        JInternalFrame jif = null;
        Component[] clist = this.contentPane.getComponents();
        if (clist == null || clist.length <= 0) {
            return;
        }
        int n = clist.length;
        int cols = (int)Math.sqrt(n);
        int rows = (int)Math.ceil((double)n / (double)cols);
        Dimension d = this.contentPane.getSize();
        int w = d.width / cols;
        int h = d.height / rows;
        for (int i = 0; i < rows; ++i) {
            x = 0;
            for (int j = 0; j < cols; ++j) {
                idx = i * cols + j;
                if (idx >= n) {
                    return;
                }
                jif = (JInternalFrame)clist[idx];
                jif.setBounds(x, y, w, h);
                x += w;
            }
            y += h;
        }
    }

    private void closeAllWindow() {
        JInternalFrame jif = null;
        Component[] clist = this.contentPane.getComponents();
        if (clist == null || clist.length <= 0) {
            return;
        }
        for (int i = 0; i < clist.length; ++i) {
            jif = (JInternalFrame)clist[i];
            jif.dispose();
            jif = null;
        }
    }

    private static void setEnabled(List<JMenuItem> list, boolean b) {
        Object var2_2 = null;
        for (Component component : list) {
            component.setEnabled(b);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Exit")) {
            this.dispose();
            return;
        }
        if (cmd.startsWith("Open file")) {
            int fileAccessID = 1;
            String filename = null;
            if (ViewProperties.isReadOnly()) {
                fileAccessID = 0;
            }
            if (cmd.equals("Open file: from file bar")) {
                filename = (String)this.urlBar.getSelectedItem();
                if (filename == null) return;
                if (filename.length() < 1) {
                    return;
                }
                if (!filename.startsWith("http://") && !filename.startsWith("ftp://")) {
                    File tmpFile = new File(filename);
                    if (!tmpFile.exists()) {
                        return;
                    }
                    if (tmpFile.isDirectory()) {
                        this.currentDir = filename;
                        filename = this.openLocalFile();
                    }
                }
            } else if (cmd.equals("Open file read-only")) {
                fileAccessID = 0;
                filename = this.openLocalFile();
            } else {
                filename = cmd.startsWith("Open file://") ? cmd.substring(12) : this.openLocalFile();
            }
            if (filename == null) {
                return;
            }
            if (filename.startsWith("http://") || filename.startsWith("ftp://")) {
                filename = this.openRemoteFile(filename);
            }
            if (filename == null) return;
            if (filename.length() < 1) return;
            if (filename.equals(this.currentFile)) {
                return;
            }
            this.currentFile = filename;
            try {
                this.urlBar.removeItem(filename);
                this.urlBar.insertItemAt(filename, 0);
                this.urlBar.setSelectedIndex(0);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.treeView.openFile(filename, fileAccessID);
                return;
            }
            catch (Throwable ex) {
                try {
                    this.treeView.openFile(filename, 0);
                    return;
                }
                catch (Throwable ex2) {
                    String msg = "Failed to open file " + filename + "\n" + ex2;
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, msg, this.getTitle(), 0);
                }
            }
            return;
        }
        if (cmd.equals("Open from irods")) {
            try {
                this.openFromSRB();
                return;
            }
            catch (Exception ex) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, ex, this.getTitle(), 0);
            }
            return;
        }
        if (cmd.startsWith("New HDF")) {
            String ftype = "HDF5";
            if (cmd.equals("New HDF4 file")) {
                ftype = "HDF4";
            }
            NewFileDialog dialog = new NewFileDialog(this, this.currentDir, ftype, this.treeView.getCurrentFiles());
            dialog.setName("newfiledialog");
            if (!dialog.isFileCreated()) {
                return;
            }
            String filename = dialog.getFile();
            if (filename == null) {
                return;
            }
            try {
                this.treeView.openFile(filename, 1);
                this.currentFile = filename;
                try {
                    this.urlBar.removeItem(filename);
                    this.urlBar.insertItemAt(filename, 0);
                    this.urlBar.setSelectedIndex(0);
                    return;
                }
                catch (Exception ex2) {
                    return;
                }
            }
            catch (Exception ex) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, ex.getMessage() + "\n" + filename, this.getTitle(), 0);
            }
            return;
        }
        if (cmd.equals("Close file")) {
            FileFormat theFile = this.treeView.getSelectedFile();
            if (theFile == null) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Select a file to close", this.getTitle(), 0);
                return;
            }
            JInternalFrame[] frames = this.contentPane.getAllFrames();
            if (frames != null) {
                for (int i = 0; i < frames.length; ++i) {
                    HObject obj = ((DataView)((Object)frames[i])).getDataObject();
                    if (obj == null || !obj.getFileFormat().equals(theFile)) continue;
                    frames[i].dispose();
                    frames[i] = null;
                }
            }
            String fname = (String)this.urlBar.getSelectedItem();
            if (theFile.getFilePath().equals(fname)) {
                this.currentFile = null;
                this.urlBar.setSelectedIndex(-1);
            }
            try {
                this.treeView.closeFile(theFile);
            }
            catch (Exception ex) {
                // empty catch block
            }
            theFile = null;
            this.attributeArea.setText("");
            System.gc();
            return;
        }
        if (cmd.equals("Close all file")) {
            this.closeAllWindow();
            List<FileFormat> files = this.treeView.getCurrentFiles();
            while (!files.isEmpty()) {
                try {
                    this.treeView.closeFile(files.get(0));
                }
                catch (Exception ex) {}
            }
            this.currentFile = null;
            this.attributeArea.setText("");
            return;
        }
        if (cmd.equals("Save current file as")) {
            try {
                this.treeView.saveFile(this.treeView.getSelectedFile());
                return;
            }
            catch (Exception ex) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, ex, this.getTitle(), 0);
            }
            return;
        }
        if (cmd.equals("Save current file")) {
            try {
                FileFormat file = this.treeView.getSelectedFile();
                List<JInternalFrame> views = this.getDataViews();
                JInternalFrame theView = null;
                TableView tableView = null;
                TextView textView = null;
                FileFormat theFile = null;
                if (views == null) return;
                int n = views.size();
                int i = 0;
                while (i < n) {
                    theView = views.get(i);
                    if (theView instanceof TableView) {
                        tableView = (TableView)((Object)theView);
                        theFile = tableView.getDataObject().getFileFormat();
                        if (file.equals(theFile)) {
                            tableView.updateValueInFile();
                        }
                    } else if (theView instanceof TextView && file.equals(theFile = (textView = (TextView)((Object)theView)).getDataObject().getFileFormat())) {
                        textView.updateValueInFile();
                    }
                    ++i;
                }
                return;
            }
            catch (Exception ex) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, ex, this.getTitle(), 0);
                return;
            }
        }
        if (cmd.equals("Cascade all windows")) {
            this.cascadeWindow();
            return;
        }
        if (cmd.equals("Tile all windows")) {
            this.tileWindow();
            return;
        }
        if (cmd.equals("Close a window")) {
            JInternalFrame frame = this.contentPane.getSelectedFrame();
            if (frame == null) return;
            frame.dispose();
            return;
        }
        if (cmd.equals("Close all windows")) {
            this.closeAllWindow();
            return;
        }
        if (cmd.startsWith("SHOW WINDOW")) {
            this.showWindow(cmd);
            return;
        }
        if (cmd.startsWith("Convert image file:")) {
            String typeFrom = null;
            String typeTo = null;
            if (cmd.equals("Convert image file: Image to HDF5")) {
                typeFrom = "IMG";
                typeTo = "HDF5";
            } else {
                if (!cmd.equals("Convert image file: Image to HDF4")) return;
                typeFrom = "IMG";
                typeTo = "HDF4";
            }
            FileConversionDialog dialog = new FileConversionDialog(this, typeFrom, typeTo, this.currentDir, this.treeView.getCurrentFiles());
            dialog.setVisible(true);
            if (!dialog.isFileConverted()) return;
            String filename = dialog.getConvertedFile();
            File theFile = new File(filename);
            if (!theFile.exists()) return;
            if (!theFile.exists()) {
                return;
            }
            this.currentDir = theFile.getParentFile().getAbsolutePath();
            this.currentFile = theFile.getAbsolutePath();
            try {
                this.treeView.openFile(filename, 1);
                try {
                    this.urlBar.removeItem(filename);
                    this.urlBar.insertItemAt(filename, 0);
                    this.urlBar.setSelectedIndex(0);
                    return;
                }
                catch (Exception ex2) {
                    return;
                }
            }
            catch (Exception ex) {
                this.showStatus(ex.toString());
            }
            return;
        }
        if (cmd.equals("User options")) {
            if (this.userOptionDialog == null) {
                this.userOptionDialog = new UserOptionsDialog(this, this.rootDir);
            }
            this.userOptionDialog.setVisible(true);
            if (this.userOptionDialog.isWorkDirChanged()) {
                this.currentDir = ViewProperties.getWorkDir();
            }
            if (!this.userOptionDialog.isFontChanged()) return;
            Font font = null;
            try {
                font = new Font(ViewProperties.getFontType(), 0, ViewProperties.getFontSize());
            }
            catch (Exception ex) {
                return;
            }
            if (font == null) return;
            this.updateFontSize(font);
            return;
        }
        if (cmd.equals("Register file format")) {
            String msg = "Register a new file format by \nKEY:FILE_FORMAT:FILE_EXTENSION\nwhere, KEY: the unique identifier for the file format\n           FILE_FORMAT: the full class name of the file format\n           FILE_EXTENSION: the file extension for the file format\n\nFor example, \n\t to add NetCDF, \"NetCDF:ncsa.hdf.object.nc2.NC2File:nc\"\n\t to add FITS, \"FITS:ncsa.hdf.object.fits.FitsFile:fits\"\n\n";
            String str = (String)JOptionPane.showInputDialog(this, msg, "Register a file format", -1, ViewProperties.getLargeHdfIcon(), null, null);
            if (str == null) return;
            if (str.length() < 1) {
                return;
            }
            int idx1 = str.indexOf(58);
            int idx2 = str.lastIndexOf(58);
            if (idx1 < 0 || idx2 <= idx1) {
                JOptionPane.showMessageDialog(this, "Failed to register " + str + "\n\nMust in the form of KEY:FILE_FORMAT:FILE_EXTENSION", "Register File Format", 0);
                return;
            }
            String key = str.substring(0, idx1);
            String className = str.substring(idx1 + 1, idx2);
            String extension = str.substring(idx2 + 1);
            String theKey = null;
            String theClassName = null;
            Enumeration local_enum = FileFormat.getFileFormatKeys();
            while (local_enum.hasMoreElements()) {
                theKey = (String)local_enum.nextElement();
                if (theKey.endsWith(key)) {
                    JOptionPane.showMessageDialog(this, "Invalid key: " + key + " is taken.", "Register File Format", 0);
                    return;
                }
                theClassName = FileFormat.getFileFormat(theKey).getClass().getName();
                if (!theClassName.endsWith(className)) continue;
                JOptionPane.showMessageDialog(this, "The file format has already been registered: " + className, "Register File Format", 0);
                return;
            }
            Class<?> theClass = null;
            try {
                theClass = Class.forName(className);
            }
            catch (Exception ex) {
                try {
                    theClass = ViewProperties.loadExtClass().loadClass(className);
                }
                catch (Exception ex2) {
                    return;
                }
            }
            if (theClass == null) {
                return;
            }
            try {
                Object theObject = theClass.newInstance();
                if (theObject instanceof FileFormat) {
                    FileFormat.addFileFormat(key, (FileFormat)theObject);
                }
            }
            catch (Throwable ex) {
                JOptionPane.showMessageDialog(this, "Failed to register " + str + "\n\n" + ex, "Register File Format", 0);
                return;
            }
            if (extension == null) return;
            if (extension.length() <= 0) return;
            extension = extension.trim();
            String ext = ViewProperties.getFileExtension();
            ext = ext + ", " + extension;
            ViewProperties.setFileExtension(ext);
            return;
        }
        if (cmd.equals("Unregister file format")) {
            Enumeration keys = FileFormat.getFileFormatKeys();
            ArrayList keylist = new ArrayList();
            while (keys.hasMoreElements()) {
                keylist.add(keys.nextElement());
            }
            String theKey = (String)JOptionPane.showInputDialog(this, "Unregister a file format", "Unregister a file format", 2, ViewProperties.getLargeHdfIcon(), keylist.toArray(), null);
            if (theKey == null) {
                return;
            }
            FileFormat.removeFileFormat(theKey);
            return;
        } else if (cmd.equals("Users guide")) {
            String ugPath = ViewProperties.getUsersGuide();
            if (ugPath == null || !ugPath.startsWith("http://")) {
                String sep = File.separator;
                File tmpFile = new File(ugPath);
                if (!tmpFile.exists()) {
                    ugPath = this.rootDir + sep + "UsersGuide" + sep + "index.html";
                    tmpFile = new File(ugPath);
                    if (!tmpFile.exists()) {
                        ugPath = "http://www.hdfgroup.org/hdf-java-html/hdfview/UsersGuide/index.html";
                    }
                    ViewProperties.setUsersGuide(ugPath);
                }
            }
            try {
                Tools.launchBrowser(ugPath);
                return;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "HDFView", 0, ViewProperties.getLargeHdfIcon());
            }
            return;
        } else if (cmd.equals("HDF4 library")) {
            FileFormat thefile = FileFormat.getFileFormat("HDF4");
            if (thefile == null) {
                return;
            }
            JOptionPane.showMessageDialog(this, thefile.getLibversion(), "HDFView", -1, ViewProperties.getLargeHdfIcon());
            return;
        } else if (cmd.equals("HDF5 library")) {
            FileFormat thefile = FileFormat.getFileFormat("HDF5");
            if (thefile == null) {
                return;
            }
            JOptionPane.showMessageDialog(this, thefile.getLibversion(), "HDFView", -1, ViewProperties.getLargeHdfIcon());
            return;
        } else if (cmd.equals("Java version")) {
            String info = "Compiled at jdk 1.6\nRunning at " + System.getProperty("java.vm.version");
            JOptionPane.showMessageDialog(this, info, "HDFView", -1, ViewProperties.getLargeHdfIcon());
            return;
        } else if (cmd.equals("File format list")) {
            Enumeration formatKeys = FileFormat.getFileFormatKeys();
            String str = "\nSupported File Formats: \n";
            while (formatKeys.hasMoreElements()) {
                str = str + "    " + formatKeys.nextElement() + "\n";
            }
            str = str + "\n";
            JOptionPane.showMessageDialog(this, str, "HDFView", -1, ViewProperties.getLargeHdfIcon());
            return;
        } else if (cmd.equals("About")) {
            JOptionPane.showMessageDialog(this, aboutHDFView, "HDFView", -1, ViewProperties.getLargeHdfIcon());
            return;
        } else if (cmd.equals("Popup URL list")) {
            this.urlBar.setPopupVisible(true);
            return;
        } else if (cmd.equals("Clear current selection")) {
            this.urlBar.setSelectedIndex(-1);
            return;
        } else {
            if (helpViews == null) return;
            if (helpViews.size() <= 0) {
                return;
            }
            int n = helpViews.size();
            int i = 0;
            while (i < n) {
                HelpView theView = (HelpView)helpViews.get(i);
                if (cmd.equals(theView.getActionCommand())) {
                    theView.show();
                    return;
                }
                ++i;
            }
            return;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int idx;
        Object src = e.getSource();
        if (src.equals(this.infoTabbedPane) && (idx = this.infoTabbedPane.getSelectedIndex()) == 1) {
            this.attributeArea.setText("");
            this.showMetaData(this.treeView.getCurrentObject());
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent evt) {
    }

    @Override
    public void drop(DropTargetDropEvent evt) {
        block11: {
            try {
                Transferable tr = evt.getTransferable();
                if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    evt.acceptDrop(1);
                    List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                    int n = fileList.size();
                    for (int i = 0; i < n; ++i) {
                        String filename;
                        File file = (File)fileList.get(i);
                        if (file.isDirectory()) continue;
                        this.currentFile = filename = file.getAbsolutePath();
                        try {
                            this.treeView.openFile(filename, 1);
                        }
                        catch (Throwable ex) {
                            try {
                                this.treeView.openFile(filename, 0);
                            }
                            catch (Throwable ex2) {
                                String msg = "Failed to open file " + filename + "\n" + ex2;
                                this.toolkit.beep();
                                JOptionPane.showMessageDialog(this, msg, this.getTitle(), 0);
                                continue;
                            }
                        }
                        try {
                            this.urlBar.removeItem(filename);
                            this.urlBar.insertItemAt(filename, 0);
                            this.urlBar.setSelectedIndex(0);
                            continue;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    evt.getDropTargetContext().dropComplete(true);
                    break block11;
                }
                evt.rejectDrop();
            }
            catch (IOException io) {
                evt.rejectDrop();
            }
            catch (UnsupportedFlavorException ufe) {
                evt.rejectDrop();
            }
        }
    }

    @Override
    public void dragExit(DropTargetEvent evt) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent evt) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dispose() {
        try {
            this.props.save();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.closeAllWindow();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            List<FileFormat> filelist = this.treeView.getCurrentFiles();
            if (filelist != null && filelist.size() > 0) {
                Object[] files = filelist.toArray();
                int n = files.length;
                for (int i = 0; i < n; ++i) {
                    try {
                        this.treeView.closeFile((FileFormat)files[i]);
                        continue;
                    }
                    catch (Throwable ex) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            super.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(0);
    }

    @Override
    public void addDataView(DataView dataView) {
        if (dataView == null) {
            return;
        }
        if (!(dataView instanceof JInternalFrame)) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Unsupported DataView: the dataview is not a JInternalFrame.", this.getTitle(), 0);
            return;
        }
        JInternalFrame[] frames = this.contentPane.getAllFrames();
        JInternalFrame theFrame = null;
        if (frames != null) {
            for (int i = 0; i < frames.length; ++i) {
                if (!dataView.equals(frames[i])) continue;
                theFrame = frames[i];
                break;
            }
        }
        if (theFrame != null) {
            theFrame.toFront();
            try {
                theFrame.setSelected(true);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
            return;
        }
        JInternalFrame frame = (JInternalFrame)((Object)dataView);
        this.contentPane.add(frame);
        HObject dataObject = dataView.getDataObject();
        String fullPath = dataObject.getPath() + dataObject.getName();
        String cmd = "SHOW WINDOW" + dataObject.getFID() + fullPath;
        frame.setName(cmd);
        frame.setMaximizable(true);
        frame.setClosable(true);
        frame.setResizable(true);
        JMenuItem item = new JMenuItem(fullPath);
        item.setActionCommand(cmd);
        item.addActionListener(this);
        if (this.windowMenu.getMenuComponentCount() == 6) {
            Component[] menuItems = this.windowMenu.getMenuComponents();
            for (int i = 0; i < 6; ++i) {
                menuItems[i].setEnabled(true);
            }
        }
        this.windowMenu.add(item);
        frame.setLocation(this.frameOffset, this.frameOffset);
        this.frameOffset = this.frameOffset < 60 ? (this.frameOffset += 15) : 0;
        Dimension d = this.contentPane.getSize();
        frame.setSize(d.width - 60, d.height - 60);
        frame.show();
    }

    @Override
    public void removeDataView(DataView dataView) {
        if (!(dataView instanceof JInternalFrame)) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "The dataview is not a JInternalFrame.", this.getTitle(), 0);
            return;
        }
        JInternalFrame frame = (JInternalFrame)((Object)dataView);
        String name = frame.getName();
        int n = this.windowMenu.getItemCount();
        JMenuItem theItem = null;
        for (int i = 6; i < n; ++i) {
            theItem = this.windowMenu.getItem(i);
            if (theItem == null || !theItem.getActionCommand().equals(name)) continue;
            this.windowMenu.remove(i);
            theItem = null;
            break;
        }
        if (this.windowMenu.getMenuComponentCount() == 6) {
            Component[] menuItems = this.windowMenu.getMenuComponents();
            for (int i = 0; i < 6; ++i) {
                menuItems[i].setEnabled(false);
            }
        }
    }

    @Override
    public TreeView getTreeView() {
        return this.treeView;
    }

    @Override
    public void mouseEventFired(MouseEvent e) {
        HObject obj = this.treeView.getCurrentObject();
        if (obj == null) {
            return;
        }
        Object src = e.getSource();
        if (src instanceof JComponent) {
            String filename = obj.getFile();
            this.urlBar.setSelectedItem(filename);
            if (this.infoTabbedPane.getSelectedIndex() == 1) {
                this.showMetaData(obj);
            }
        }
    }

    private void showMetaData(HObject obj) {
        int i;
        if (obj == null || this.currentFile == null) {
            return;
        }
        this.metadata.setLength(0);
        this.metadata.append(obj.getName());
        String oidStr = null;
        long[] OID = obj.getOID();
        if (OID != null) {
            oidStr = String.valueOf(OID[0]);
            for (int i2 = 1; i2 < OID.length; ++i2) {
                oidStr = oidStr + ", " + OID[i2];
            }
        }
        this.metadata.append(" (");
        this.metadata.append(oidStr);
        this.metadata.append(")");
        if (obj instanceof Group) {
            Group g = (Group)obj;
            this.metadata.append("\n    Group size = ");
            this.metadata.append(g.getMemberList().size());
        } else if (obj instanceof Dataset) {
            Dataset d = (Dataset)obj;
            if (d.getRank() <= 0) {
                d.init();
            }
            this.metadata.append("\n    ");
            if (d instanceof ScalarDS) {
                Datatype dtype = d.getDatatype();
                if (dtype != null) {
                    this.metadata.append(dtype.getDatatypeDescription());
                }
            } else if (d instanceof CompoundDS) {
                this.metadata.append("Compound/Vdata");
            }
            this.metadata.append(",    ");
            long[] dims = d.getDims();
            if (dims != null) {
                this.metadata.append(dims[0]);
                for (i = 1; i < dims.length; ++i) {
                    this.metadata.append(" x ");
                    this.metadata.append(dims[i]);
                }
            }
        }
        List attrList = null;
        try {
            attrList = obj.getMetadata();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (attrList == null) {
            this.metadata.append("\n    Number of attributes = 0");
        } else {
            int n = attrList.size();
            this.metadata.append("\n    Number of attributes = ");
            this.metadata.append(n);
            for (i = 0; i < n; ++i) {
                Object attrObj = attrList.get(i);
                if (!(attrObj instanceof Attribute)) continue;
                Attribute attr = (Attribute)attrObj;
                this.metadata.append("\n        ");
                this.metadata.append(attr.getName());
                this.metadata.append(" = ");
                this.metadata.append(attr.toString(","));
            }
        }
        this.attributeArea.setText(this.metadata.toString());
        this.attributeArea.setCaretPosition(0);
    }

    @Override
    public DataView getDataView(HObject dataObject) {
        if (dataObject == null) {
            return null;
        }
        JInternalFrame[] frames = this.contentPane.getAllFrames();
        JInternalFrame theFrame = null;
        if (frames == null) {
            return null;
        }
        HObject obj = null;
        for (int i = 0; i < frames.length; ++i) {
            if (!(frames[i] instanceof DataView) || !dataObject.equals(obj = ((DataView)((Object)frames[i])).getDataObject())) continue;
            theFrame = frames[i];
            break;
        }
        return (DataView)((Object)theFrame);
    }

    public List<JInternalFrame> getDataViews() {
        JInternalFrame[] frames = this.contentPane.getAllFrames();
        Object theFrame = null;
        if (frames == null || frames.length <= 0) {
            return null;
        }
        Vector<JInternalFrame> views = new Vector<JInternalFrame>(frames.length);
        Object obj = null;
        for (int i = 0; i < frames.length; ++i) {
            if (!(frames[i] instanceof DataView)) continue;
            views.add(frames[i]);
        }
        return views;
    }

    public static final List<String> getListOfTreeView() {
        return treeViews;
    }

    public static final List<String> getListOfImageView() {
        return imageViews;
    }

    public static final List getListOfTableView() {
        return tableViews;
    }

    public static final List getListOfTextView() {
        return textViews;
    }

    public static final List getListOfMetaDataView() {
        return metaDataViews;
    }

    public static final List getListOfPaletteView() {
        return paletteViews;
    }

    @Override
    public void showStatus(String msg) {
        this.message.append(msg);
        this.message.append("\n");
        this.statusArea.setText(this.message.toString());
    }

    private String openLocalFile() {
        JFileChooser fchooser = new JFileChooser(this.currentDir);
        fchooser.setFileFilter(DefaultFileFilter.getFileFilter());
        int returnVal = fchooser.showOpenDialog(this);
        if (returnVal != 0) {
            return null;
        }
        File choosedFile = fchooser.getSelectedFile();
        if (choosedFile == null) {
            return null;
        }
        this.currentDir = choosedFile.isDirectory() ? choosedFile.getPath() : choosedFile.getParent();
        return choosedFile.getAbsolutePath();
    }

    private String openRemoteFile(String urlStr) {
        String localFile = null;
        if (urlStr == null) {
            return null;
        }
        if (urlStr.startsWith("http://")) {
            localFile = urlStr.substring(7);
        } else if (urlStr.startsWith("ftp://")) {
            localFile = urlStr.substring(6);
        } else {
            return null;
        }
        localFile = localFile.replace('/', '@');
        localFile = localFile.replace('\\', '@');
        String tmpDir = System.getProperty("java.io.tmpdir");
        File tmpFile = new File(tmpDir);
        if (!tmpFile.canWrite()) {
            tmpDir = System.getProperty("user.home");
        }
        if ((tmpFile = new File(localFile = tmpDir + localFile)).exists()) {
            return localFile;
        }
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (Exception ex) {
            url = null;
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex, this.getTitle(), 0);
            return null;
        }
        BufferedInputStream in = null;
        BufferedOutputStream out = null;
        try {
            in = new BufferedInputStream(url.openStream());
            out = new BufferedOutputStream(new FileOutputStream(tmpFile));
        }
        catch (Exception ex) {
            in = null;
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex, this.getTitle(), 0);
            try {
                in.close();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            return null;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        byte[] buff = new byte[512];
        try {
            int n = 0;
            while ((n = in.read(buff)) > 0) {
                out.write(buff, 0, n);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            in.close();
        }
        catch (Exception ex2) {
            // empty catch block
        }
        try {
            out.close();
        }
        catch (Exception ex2) {
            // empty catch block
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        return localFile;
    }

    private void openFromSRB() throws Exception {
        if (this.ctrSrbFileDialog == null) {
            Class<?> theClass = null;
            try {
                theClass = Class.forName("ncsa.hdf.srb.SRBFileDialog");
            }
            catch (Exception ex) {
                theClass = null;
                this.showStatus(ex.toString());
                throw new ClassNotFoundException("Cannot find SRBFileDialog");
            }
            try {
                Class[] paramClass = new Class[]{Class.forName("java.awt.Frame")};
                this.ctrSrbFileDialog = theClass.getConstructor(paramClass);
            }
            catch (Exception ex) {
                this.ctrSrbFileDialog = null;
                throw new InstantiationException("Cannot construct SRBFileDialog");
            }
        }
        if (this.srbFileDialog == null) {
            Object[] paramObj = new Object[]{this};
            this.srbFileDialog = (JDialog)this.ctrSrbFileDialog.newInstance(paramObj);
        } else {
            this.srbFileDialog.setVisible(true);
        }
        this.currentFile = this.srbFileDialog.getName();
    }

    private static final void loadExtModules() throws Exception {
        int i;
        ClassLoader extClassLoader = ViewProperties.loadExtClass();
        Vector<String> moduleListTreeView = ViewProperties.getTreeViewList();
        Vector<String> moduleListImageView = ViewProperties.getImageViewList();
        if (extClassLoader == null || moduleListTreeView == null || moduleListImageView == null) {
            return;
        }
        String[] extTreeViews = new String[]{"ext.erdc.TreeViewERDC", "ext.npoess.TreeViewNPOESS"};
        String[] extImageViews = new String[]{"ext.erdc.ImageViewERDC"};
        for (i = 0; i < extTreeViews.length; ++i) {
            if (moduleListTreeView.contains(extTreeViews[i])) continue;
            try {
                extClassLoader.loadClass(extTreeViews[i]);
                moduleListTreeView.add(extTreeViews[i]);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        for (i = 0; i < extImageViews.length; ++i) {
            if (moduleListImageView.contains(extImageViews[i])) continue;
            try {
                extClassLoader.loadClass(extImageViews[i]);
                moduleListImageView.add(extImageViews[i]);
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception e) {
            // empty catch block
        }
        String rootDir = System.getProperty("user.dir");
        File tmpFile = null;
        int i = 0;
        int j = 0;
        int W = 0;
        int H = 0;
        int X = 0;
        int Y = 0;
        for (i = 0; i < args.length; ++i) {
            if ("-root".equalsIgnoreCase(args[i])) {
                try {
                    tmpFile = new File(args[++i]);
                    j = i;
                    if (tmpFile.isDirectory()) {
                        rootDir = tmpFile.getPath();
                        continue;
                    }
                    if (!tmpFile.isFile()) continue;
                    rootDir = tmpFile.getParent();
                }
                catch (Exception e) {}
                continue;
            }
            if ("-g".equalsIgnoreCase(args[i]) || "-geometry".equalsIgnoreCase(args[i])) {
                try {
                    String geom = args[++i];
                    j = i;
                    int idx = 0;
                    int idx0 = geom.lastIndexOf(45);
                    int idx1 = geom.lastIndexOf(43);
                    idx = Math.max(idx0, idx1);
                    if (idx > 0) {
                        Y = Integer.parseInt(geom.substring(idx + 1));
                        if (idx == idx0) {
                            Y = -Y;
                        }
                        if ((idx = Math.max(idx0 = (geom = geom.substring(0, idx)).lastIndexOf(45), idx1 = geom.lastIndexOf(43))) > 0) {
                            X = Integer.parseInt(geom.substring(idx + 1));
                            if (idx == idx0) {
                                X = -X;
                            }
                            geom = geom.substring(0, idx);
                        }
                    }
                    if ((idx = geom.indexOf(120)) <= 0) continue;
                    W = Integer.parseInt(geom.substring(0, idx));
                    H = Integer.parseInt(geom.substring(idx + 1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (!"-java.vm.version".equalsIgnoreCase(args[i])) continue;
            String info = "Compiled at jdk 1.6\nRunning at " + System.getProperty("java.vm.version");
            JOptionPane.showMessageDialog(new JFrame(), info, "HDFView", -1, ViewProperties.getLargeHdfIcon());
            System.exit(0);
        }
        Vector<File> flist = new Vector<File>();
        tmpFile = null;
        if (j >= 0) {
            for (i = j; i < args.length; ++i) {
                tmpFile = new File(args[i]);
                if (!tmpFile.exists() || !tmpFile.isFile()) continue;
                flist.add(new File(tmpFile.getAbsolutePath()));
            }
        }
        final Vector<File> the_flist = flist;
        final String the_rootDir = rootDir;
        final int the_X = X;
        final int the_Y = Y;
        final int the_W = W;
        final int the_H = H;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                HDFView frame = new HDFView(the_rootDir, the_flist, the_W, the_H, the_X, the_Y);
                frame.setVisible(true);
            }
        });
    }

    static {
        aboutHDFView = "HDF Viewer, Version 2.8\nFor " + System.getProperty("os.name") + "\n\n" + "Copyright " + '\u00a9' + " 2006-2011 The HDF Group.\n" + "All rights reserved.";
    }
}

