/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.DataOptionDialog;
import ncsa.hdf.view.DataView;
import ncsa.hdf.view.HDFView;
import ncsa.hdf.view.MetaDataView;
import ncsa.hdf.view.NewDatasetDialog;
import ncsa.hdf.view.NewDatatypeDialog;
import ncsa.hdf.view.NewFileDialog;
import ncsa.hdf.view.NewGroupDialog;
import ncsa.hdf.view.NewImageDialog;
import ncsa.hdf.view.NewLinkDialog;
import ncsa.hdf.view.NewTableDataDialog;
import ncsa.hdf.view.TableView;
import ncsa.hdf.view.TextView;
import ncsa.hdf.view.Tools;
import ncsa.hdf.view.TreeView;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class DefaultTreeView
extends JPanel
implements TreeView,
ActionListener {
    private static final long serialVersionUID = 4092566164712521186L;
    private ViewManager viewer;
    private final DefaultMutableTreeNode root;
    private final JTree tree;
    private final DefaultTreeModel treeModel;
    private final List<FileFormat> fileList;
    private final Toolkit toolkit;
    private FileFormat selectedFile;
    private DefaultMutableTreeNode selectedNode;
    private TreePath selectedTreePath;
    private HObject selectedObject;
    private boolean isDefaultDisplay;
    private final JPopupMenu popupMenu;
    private JSeparator separator;
    private List<JMenuItem> editGUIs;
    private List<Object> objectsToCopy;
    private JMenuItem addTableMenuItem;
    private JMenuItem addDatasetMenuItem;
    private JMenuItem addDatatypeMenuItem;
    private JMenuItem addLinkMenuItem;
    private JMenuItem setLibVerBoundsItem;
    private String currentSearchPhrase = null;
    private boolean moveFlag;
    private TreePath[] currentSelectionsForMove;
    private boolean isApplyBitmaskOnly = false;

    public DefaultTreeView(ViewManager theView) {
        this.viewer = theView;
        this.root = new DefaultMutableTreeNode(){
            private static final long serialVersionUID = -6829919815424470510L;

            @Override
            public boolean isLeaf() {
                return false;
            }
        };
        this.fileList = new Vector<FileFormat>();
        this.toolkit = Toolkit.getDefaultToolkit();
        this.editGUIs = new Vector<JMenuItem>();
        this.objectsToCopy = null;
        this.isDefaultDisplay = true;
        this.selectedTreePath = null;
        this.selectedNode = null;
        this.moveFlag = false;
        this.currentSelectionsForMove = null;
        this.addDatasetMenuItem = new JMenuItem("Dataset", ViewProperties.getDatasetIcon());
        this.addDatasetMenuItem.addActionListener(this);
        this.addDatasetMenuItem.setActionCommand("Add dataset");
        this.addTableMenuItem = new JMenuItem("Compound DS", ViewProperties.getTableIcon());
        this.addTableMenuItem.addActionListener(this);
        this.addTableMenuItem.setActionCommand("Add table");
        this.addDatatypeMenuItem = new JMenuItem("Datatype", ViewProperties.getDatatypeIcon());
        this.addDatatypeMenuItem.addActionListener(this);
        this.addDatatypeMenuItem.setActionCommand("Add datatype");
        this.addLinkMenuItem = new JMenuItem("Link", ViewProperties.getLinkIcon());
        this.addLinkMenuItem.addActionListener(this);
        this.addLinkMenuItem.setActionCommand("Add link");
        this.setLibVerBoundsItem = new JMenuItem("Set Lib version bounds");
        this.setLibVerBoundsItem.addActionListener(this);
        this.setLibVerBoundsItem.setActionCommand("Set Lib version bounds");
        this.treeModel = new DefaultTreeModel(this.root);
        this.tree = new JTree(this.treeModel);
        this.tree.setLargeModel(true);
        this.tree.setCellRenderer(new HTreeCellRenderer());
        this.tree.addMouseListener(new HTreeMouseAdapter());
        this.tree.setRootVisible(false);
        int rowheight = 23 + (int)((double)(this.tree.getFont().getSize() - 12) * 0.5);
        this.tree.setRowHeight(rowheight);
        this.separator = new JPopupMenu.Separator();
        this.popupMenu = this.createPopupMenu();
        this.setLayout(new BorderLayout());
        this.add((Component)this.tree, "Center");
    }

    private void insertNode(TreeNode node, TreeNode pnode) {
        if (node == null || pnode == null) {
            return;
        }
        this.treeModel.insertNodeInto((DefaultMutableTreeNode)node, (DefaultMutableTreeNode)pnode, pnode.getChildCount());
    }

    private boolean isFileOpen(String filename) {
        boolean isOpen = false;
        FileFormat theFile2 = null;
        for (FileFormat theFile2 : this.fileList) {
            if (!theFile2.getFilePath().equals(filename)) continue;
            isOpen = true;
            break;
        }
        return isOpen;
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem("Open");
        item.setMnemonic(79);
        item.addActionListener(this);
        item.setActionCommand("Open data");
        menu.add(item);
        item = new JMenuItem("Open As");
        item.setMnemonic(65);
        item.addActionListener(this);
        item.setActionCommand("Open data as");
        menu.add(item);
        menu.addSeparator();
        JMenu newOjbectMenu = new JMenu("New");
        menu.add(newOjbectMenu);
        this.editGUIs.add(newOjbectMenu);
        item = new JMenuItem("Group", ViewProperties.getFoldercloseIcon());
        item.addActionListener(this);
        item.setActionCommand("Add group");
        newOjbectMenu.add(item);
        newOjbectMenu.add(this.addDatasetMenuItem);
        item = new JMenuItem("Image", ViewProperties.getImageIcon());
        item.addActionListener(this);
        item.setActionCommand("Add image");
        newOjbectMenu.add(item);
        newOjbectMenu.add(this.addTableMenuItem);
        newOjbectMenu.add(this.addDatatypeMenuItem);
        newOjbectMenu.add(this.addLinkMenuItem);
        menu.addSeparator();
        item = new JMenuItem("Copy");
        item.setMnemonic(67);
        item.addActionListener(this);
        item.setActionCommand("Copy object");
        menu.add(item);
        item = new JMenuItem("Paste");
        item.setMnemonic(80);
        item.addActionListener(this);
        item.setActionCommand("Paste object");
        menu.add(item);
        this.editGUIs.add(item);
        item = new JMenuItem("Delete");
        item.setMnemonic(68);
        item.addActionListener(this);
        item.setActionCommand("Cut object");
        menu.add(item);
        this.editGUIs.add(item);
        item = new JMenuItem("Cut");
        item.setMnemonic(84);
        item.addActionListener(this);
        item.setActionCommand("Move object");
        menu.add(item);
        this.editGUIs.add(item);
        menu.addSeparator();
        item = new JMenuItem("Save to");
        item.setMnemonic(83);
        item.addActionListener(this);
        item.setActionCommand("Save object to file");
        menu.add(item);
        item = new JMenuItem("Rename");
        item.setMnemonic(82);
        item.addActionListener(this);
        item.setActionCommand("Rename object");
        menu.add(item);
        this.editGUIs.add(item);
        menu.addSeparator();
        item = new JMenuItem("Show Properties");
        item.addActionListener(this);
        item.setActionCommand("Show object properties");
        menu.add(item);
        item = new JMenuItem("Show Properties As");
        item.addActionListener(this);
        item.setActionCommand("Show object properties as");
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Find");
        item.setMnemonic(70);
        item.addActionListener(this);
        item.setActionCommand("Find");
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Expand All");
        item.addActionListener(this);
        item.setActionCommand("Expand all");
        menu.add(item);
        item = new JMenuItem("Collapse All");
        item.addActionListener(this);
        item.setActionCommand("Collapse all");
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Close File");
        item.setMnemonic(69);
        item.addActionListener(this);
        item.setActionCommand("Close file");
        menu.add(item);
        menu.add(this.separator);
        menu.add(this.setLibVerBoundsItem);
        return menu;
    }

    private void showPopupMenu(MouseEvent e) {
        boolean state;
        boolean isWritable;
        int x = e.getX();
        int y = e.getY();
        HObject selectedObject = (HObject)this.selectedNode.getUserObject();
        boolean isReadOnly = selectedObject.getFileFormat().isReadOnly();
        DefaultTreeView.setEnabled(this.editGUIs, !isReadOnly);
        boolean bl = isWritable = !selectedObject.getFileFormat().isReadOnly();
        if (selectedObject instanceof Group) {
            this.popupMenu.getComponent(0).setEnabled(false);
            this.popupMenu.getComponent(1).setEnabled(false);
            state = !((Group)selectedObject).isRoot();
            this.popupMenu.getComponent(5).setEnabled(state);
            this.popupMenu.getComponent(6).setEnabled(isWritable);
            this.popupMenu.getComponent(7).setEnabled(state && isWritable);
            this.popupMenu.getComponent(10).setEnabled(state);
            this.popupMenu.getComponent(11).setEnabled(state && isWritable);
            this.popupMenu.getComponent(8).setEnabled(selectedObject.getFileFormat().isThisType(FileFormat.getFileFormat("HDF5")) && state && isWritable);
        } else {
            this.popupMenu.getComponent(0).setEnabled(true);
            this.popupMenu.getComponent(1).setEnabled(true);
            this.popupMenu.getComponent(5).setEnabled(true);
            this.popupMenu.getComponent(6).setEnabled(isWritable);
            this.popupMenu.getComponent(7).setEnabled(isWritable);
            this.popupMenu.getComponent(10).setEnabled(true);
            this.popupMenu.getComponent(11).setEnabled(isWritable);
            this.popupMenu.getComponent(8).setEnabled(selectedObject.getFileFormat().isThisType(FileFormat.getFileFormat("HDF5")) && isWritable);
        }
        if (this.selectedFile != null && this.selectedFile.isThisType(FileFormat.getFileFormat("HDF5"))) {
            this.addDatasetMenuItem.setText("Dataset");
            this.addTableMenuItem.setVisible(true);
            this.addDatatypeMenuItem.setVisible(true);
            this.addLinkMenuItem.setVisible(true);
            if (selectedObject instanceof Group) {
                state = ((Group)selectedObject).isRoot();
                this.separator.setVisible(isWritable && state);
                this.setLibVerBoundsItem.setVisible(isWritable && state);
            } else {
                this.separator.setVisible(false);
                this.setLibVerBoundsItem.setVisible(false);
            }
        } else {
            this.addDatasetMenuItem.setText("SDS");
            this.addTableMenuItem.setVisible(false);
            this.addDatatypeMenuItem.setVisible(false);
            this.addLinkMenuItem.setVisible(false);
            this.separator.setVisible(false);
            this.setLibVerBoundsItem.setVisible(false);
        }
        this.popupMenu.show((JComponent)e.getSource(), x, y);
    }

    private static void setEnabled(List<JMenuItem> list, boolean b) {
        Object var2_2 = null;
        for (Component component : list) {
            component.setEnabled(b);
        }
    }

    private final void saveAsHDF4(FileFormat srcFile) {
        String currentDir;
        if (srcFile == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Select a file to save.", "HDFView", 0);
            return;
        }
        JFrame owner = this.viewer == null ? new JFrame() : (JFrame)((Object)this.viewer);
        NewFileDialog dialog = new NewFileDialog(owner, currentDir = srcFile.getParent(), "HDF4", this.getCurrentFiles());
        if (!dialog.isFileCreated()) {
            return;
        }
        String filename = dialog.getFile();
        int length = 0;
        int bsize = 512;
        BufferedInputStream bi = null;
        BufferedOutputStream bo = null;
        try {
            bi = new BufferedInputStream(new FileInputStream(srcFile.getFilePath()));
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex.getMessage() + "\n" + filename, "HDFView", 0);
            return;
        }
        try {
            bo = new BufferedOutputStream(new FileOutputStream(filename));
        }
        catch (Exception ex) {
            try {
                bi.close();
            }
            catch (Exception ex2) {
                // empty catch block
            }
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex, "HDFView", 0);
            return;
        }
        byte[] buffer = new byte[bsize];
        try {
            length = bi.read(buffer, 0, bsize);
        }
        catch (Exception ex) {
            length = 0;
        }
        while (length > 0) {
            try {
                bo.write(buffer, 0, length);
                length = bi.read(buffer, 0, bsize);
            }
            catch (Exception ex) {
                length = 0;
            }
        }
        try {
            bo.flush();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            bi.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            bo.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            this.openFile(filename, 1);
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex.getMessage() + "\n" + filename, "HDFView", 0);
        }
    }

    private void saveAsHDF5(FileFormat srcFile) {
        if (srcFile == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Select a file to save.", "HDFView", 0);
            return;
        }
        TreeNode root = srcFile.getRootNode();
        if (root == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "The file is empty.", "HDFView", 0);
            return;
        }
        JFrame owner = this.viewer == null ? new JFrame() : (JFrame)((Object)this.viewer);
        NewFileDialog dialog = new NewFileDialog(owner, srcFile.getParent(), "HDF5", this.getCurrentFiles());
        if (!dialog.isFileCreated()) {
            return;
        }
        String filename = dialog.getFile();
        int n = root.getChildCount();
        Vector<Object> objList = new Vector<Object>(n);
        DefaultMutableTreeNode node = null;
        for (int i = 0; i < n; ++i) {
            node = (DefaultMutableTreeNode)root.getChildAt(i);
            objList.add(node.getUserObject());
        }
        FileFormat newFile = null;
        try {
            newFile = this.openFile(filename, 1);
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex.getMessage() + "\n" + filename, "HDFView", 0);
            return;
        }
        if (newFile == null) {
            return;
        }
        TreeNode pnode = newFile.getRootNode();
        this.pasteObject(objList, pnode, newFile);
        objList.setSize(0);
        Group srcGroup = (Group)((DefaultMutableTreeNode)root).getUserObject();
        Group dstGroup = (Group)((DefaultMutableTreeNode)newFile.getRootNode()).getUserObject();
        Object[] parameter = new Object[2];
        Class<?> classHOjbect = null;
        Class[] parameterClass = new Class[2];
        Method method = null;
        try {
            parameter[0] = srcGroup;
            parameter[1] = dstGroup;
            parameterClass[0] = parameterClass[1] = (classHOjbect = Class.forName("ncsa.hdf.object.HObject"));
            method = newFile.getClass().getMethod("copyAttributes", parameterClass);
            method.invoke((Object)newFile, parameter);
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex, "HDFView", 0);
        }
        parameter[0] = srcGroup.getFileFormat();
        parameter[1] = newFile;
        parameterClass[0] = parameterClass[1] = parameter[0].getClass();
        try {
            method = newFile.getClass().getMethod("updateReferenceDataset", parameterClass);
            method.invoke((Object)newFile, parameter);
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex, "HDFView", 0);
        }
    }

    private void copyObject() {
        this.objectsToCopy = this.getSelectedObjects();
        this.moveFlag = false;
    }

    private void moveObject() {
        this.objectsToCopy = this.getSelectedObjects();
        this.moveFlag = true;
        this.currentSelectionsForMove = this.tree.getSelectionPaths();
    }

    private void pasteObject() {
        if (this.moveFlag) {
            HObject theObj = null;
            for (int i = 0; i < this.currentSelectionsForMove.length; ++i) {
                DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)this.currentSelectionsForMove[i].getLastPathComponent();
                theObj = (HObject)currentNode.getUserObject();
                if (!this.isObjectOpen(theObj)) continue;
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Cannot move the selected object: " + theObj + "\nThe dataset or dataset in the group is in use." + "\n\nPlease close the dataset(s) and try again.\n", "HDFView", 0);
                this.moveFlag = false;
                this.currentSelectionsForMove = null;
                this.objectsToCopy = null;
                return;
            }
        }
        TreeNode pnode = this.selectedNode;
        if (this.objectsToCopy == null || this.objectsToCopy.size() <= 0 || pnode == null) {
            return;
        }
        FileFormat srcFile = ((HObject)this.objectsToCopy.get(0)).getFileFormat();
        FileFormat dstFile = this.getSelectedFile();
        FileFormat h5file = FileFormat.getFileFormat("HDF5");
        FileFormat h4file = FileFormat.getFileFormat("HDF4");
        if (srcFile == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Source file is null.", "HDFView", 0);
            return;
        }
        if (dstFile == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Destination file is null.", "HDFView", 0);
            return;
        }
        if (srcFile.isThisType(h4file) && dstFile.isThisType(h5file)) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Unsupported operation: cannot copy HDF4 object to HDF5 file", "HDFView", 0);
            return;
        }
        if (srcFile.isThisType(h5file) && dstFile.isThisType(h4file)) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Unsupported operation: cannot copy HDF5 object to HDF4 file", "HDFView", 0);
            return;
        }
        if (this.moveFlag && srcFile != dstFile) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Cannot move the selected object to different file", "HDFView", 0);
            this.moveFlag = false;
            this.currentSelectionsForMove = null;
            this.objectsToCopy = null;
            return;
        }
        if (pnode.isLeaf()) {
            pnode = pnode.getParent();
        }
        Group pgroup = (Group)pnode.getUserObject();
        String fullPath = pgroup.getPath() + pgroup.getName();
        if (pgroup.isRoot()) {
            fullPath = "/";
        }
        String msg = "";
        int msgType = 3;
        if (srcFile.isThisType(h4file)) {
            msg = "WARNING: object can not be deleted after it is copied.\n\n";
            msgType = 2;
        }
        msg = msg + "Do you want to copy the selected object(s) to \nGroup: " + fullPath + "\nFile: " + dstFile.getFilePath();
        int op = -1;
        if (this.moveFlag) {
            String moveMsg = "Do you want to paste the selected object(s) to \nGroup: " + fullPath + "\nFile: " + dstFile.getFilePath();
            op = JOptionPane.showConfirmDialog(this, moveMsg, "Copy object", 0, msgType);
        } else {
            op = JOptionPane.showConfirmDialog(this, msg, "Copy object", 0, msgType);
        }
        if (op == 1) {
            return;
        }
        this.pasteObject(this.objectsToCopy, pnode, dstFile);
        if (this.moveFlag) {
            this.removeSelectedObjects();
            this.moveFlag = false;
            this.currentSelectionsForMove = null;
            this.objectsToCopy = null;
        }
    }

    private void pasteObject(List<Object> objList, TreeNode pnode, FileFormat dstFile) {
        if (objList == null || objList.size() <= 0 || pnode == null) {
            return;
        }
        ((HObject)objList.get(0)).getFileFormat();
        Group pgroup = (Group)((DefaultMutableTreeNode)pnode).getUserObject();
        HObject theObj = null;
        TreeNode newNode = null;
        Iterator<Object> iterator = objList.iterator();
        while (iterator.hasNext()) {
            newNode = null;
            theObj = (HObject)iterator.next();
            if (theObj instanceof Group && ((Group)theObj).isRoot()) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Unsupported operation: cannot copy the root group", "HDFView", 0);
                return;
            }
            Group pg = pgroup;
            while (!pg.isRoot()) {
                if (theObj.equals(pg)) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Unsupported operation: cannot copy a group to itself.", "HDFView", 0);
                    return;
                }
                pg = pg.getParent();
            }
            try {
                newNode = dstFile.copy(theObj, pgroup);
            }
            catch (Exception ex) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, ex, "HDFView", 0);
            }
            if (newNode == null) continue;
            this.insertNode(newNode, pnode);
        }
    }

    private void removeSelectedObjects() {
        int op;
        FileFormat theFile = this.getSelectedFile();
        if (theFile.isThisType(FileFormat.getFileFormat("HDF4"))) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Unsupported operation: cannot delete HDF4 object.", "HDFView", 0);
            return;
        }
        TreePath[] currentSelections = this.tree.getSelectionPaths();
        if (this.moveFlag) {
            currentSelections = this.currentSelectionsForMove;
        }
        if (currentSelections == null || currentSelections.length <= 0) {
            return;
        }
        if (!this.moveFlag && (op = JOptionPane.showConfirmDialog(this, "Do you want to remove all the selected object(s) ?", "Remove object", 0)) == 1) {
            return;
        }
        HObject theObj = null;
        for (int i = 0; i < currentSelections.length; ++i) {
            Group g;
            DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)currentSelections[i].getLastPathComponent();
            theObj = (HObject)currentNode.getUserObject();
            if (theObj instanceof Group && (g = (Group)theObj).isRoot()) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Unsupported operation: cannot delete the file root.", "HDFView", 0);
                return;
            }
            if (!this.moveFlag && this.isObjectOpen(theObj)) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Cannot delete the selected object: " + theObj + "\nThe dataset or dataset in the group is in use." + "\n\nPlease close the dataset(s) and try again.\n", "HDFView", 0);
                continue;
            }
            try {
                theFile.delete(theObj);
            }
            catch (Exception ex) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, ex, "HDFView", 0);
                continue;
            }
            if (theObj.equals(this.selectedObject)) {
                this.selectedObject = null;
            }
            this.removeNode(currentNode);
        }
    }

    private void removeNode(DefaultMutableTreeNode node) {
        if (node == null) {
            return;
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node.getParent();
        if (parentNode != null) {
            this.treeModel.removeNodeFromParent(node);
            Group pgroup = (Group)parentNode.getUserObject();
            pgroup.removeFromMemberList((HObject)node.getUserObject());
            if (node.equals(this.selectedNode)) {
                this.selectedNode = null;
                this.selectedFile = null;
            }
        }
    }

    private boolean isObjectOpen(HObject obj) {
        boolean isOpen = false;
        if (obj instanceof Group) {
            Group g = (Group)obj;
            List<HObject> members = g.getMemberList();
            if (members == null || members.size() == 0) {
                isOpen = false;
            } else {
                int n = members.size();
                for (int i = 0; i < n; ++i) {
                    HObject theObj = members.get(i);
                    boolean bl = isOpen = this.viewer.getDataView(theObj) != null;
                    if (!isOpen) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            isOpen = this.viewer.getDataView(obj) != null;
        }
        return isOpen;
    }

    private final List<Object> breadthFirstUserObjects(TreeNode node) {
        if (node == null) {
            return null;
        }
        Vector<Object> list = new Vector<Object>();
        DefaultMutableTreeNode theNode = null;
        Enumeration<TreeNode> local_enum = ((DefaultMutableTreeNode)node).breadthFirstEnumeration();
        while (local_enum.hasMoreElements()) {
            theNode = (DefaultMutableTreeNode)local_enum.nextElement();
            list.add(theNode.getUserObject());
        }
        return list;
    }

    private static final HObject find(String objName, TreePath treePath, JTree tree) {
        HObject retObj = null;
        boolean isFound = false;
        boolean isPrefix = false;
        boolean isSuffix = false;
        boolean isContain = false;
        if (objName == null || objName.length() <= 0 || treePath == null) {
            return null;
        }
        if (objName.equals("*")) {
            return null;
        }
        if (objName.startsWith("*")) {
            isSuffix = true;
            objName = objName.substring(1, objName.length());
        }
        if (objName.endsWith("*")) {
            isPrefix = true;
            objName = objName.substring(0, objName.length() - 1);
        }
        if (isPrefix && isSuffix) {
            isContain = true;
            isSuffix = false;
            isPrefix = false;
        }
        if (objName == null || objName.length() <= 0) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        if (node == null) {
            return null;
        }
        HObject obj = null;
        String theName = null;
        DefaultMutableTreeNode theNode = null;
        Enumeration<TreeNode> local_enum = node.breadthFirstEnumeration();
        while (local_enum.hasMoreElements()) {
            theNode = (DefaultMutableTreeNode)local_enum.nextElement();
            obj = (HObject)theNode.getUserObject();
            if (obj == null || (theName = obj.getName()) == null || !(isFound = isPrefix ? theName.startsWith(objName) : (isSuffix ? theName.endsWith(objName) : (isContain ? theName.contains(objName) : theName.equals(objName))))) continue;
            retObj = obj;
            break;
        }
        if (retObj != null) {
            TreePath dstPath = DefaultTreeView.getTreePath(treePath, theNode, 0);
            tree.setSelectionPath(dstPath);
            tree.scrollPathToVisible(dstPath);
        }
        return retObj;
    }

    private static TreePath getTreePath(TreePath parent, TreeNode node, int depth) {
        if (node == null || parent == null || depth < 0) {
            return null;
        }
        TreeNode theNode = (TreeNode)parent.getLastPathComponent();
        if (node == theNode) {
            return parent;
        }
        if (theNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = theNode.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                TreePath result = DefaultTreeView.getTreePath(path, node, depth + 1);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    private void addGroup() {
        if (this.selectedObject == null || this.selectedNode == null) {
            return;
        }
        Group pGroup = null;
        pGroup = this.selectedObject instanceof Group ? (Group)this.selectedObject : (Group)((DefaultMutableTreeNode)this.selectedNode.getParent()).getUserObject();
        NewGroupDialog dialog = new NewGroupDialog((Frame)((JFrame)((Object)this.viewer)), pGroup, this.breadthFirstUserObjects(this.selectedObject.getFileFormat().getRootNode()));
        dialog.setVisible(true);
        HObject obj = (HObject)dialog.getObject();
        if (obj == null) {
            return;
        }
        Group pgroup = dialog.getParentGroup();
        try {
            this.addObject(obj, pgroup);
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex, "HDFView", 0);
            return;
        }
    }

    private void addDataset() {
        if (this.selectedObject == null || this.selectedNode == null) {
            return;
        }
        Group pGroup = null;
        pGroup = this.selectedObject instanceof Group ? (Group)this.selectedObject : (Group)((DefaultMutableTreeNode)this.selectedNode.getParent()).getUserObject();
        NewDatasetDialog dialog = new NewDatasetDialog((JFrame)((Object)this.viewer), pGroup, this.breadthFirstUserObjects(this.selectedObject.getFileFormat().getRootNode()));
        dialog.setVisible(true);
        HObject obj = (HObject)dialog.getObject();
        if (obj == null) {
            return;
        }
        Group pgroup = dialog.getParentGroup();
        try {
            this.addObject(obj, pgroup);
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex, "HDFView", 0);
            return;
        }
    }

    private void addImage() {
        if (this.selectedObject == null || this.selectedNode == null) {
            return;
        }
        Group pGroup = null;
        pGroup = this.selectedObject instanceof Group ? (Group)this.selectedObject : (Group)((DefaultMutableTreeNode)this.selectedNode.getParent()).getUserObject();
        NewImageDialog dialog = new NewImageDialog((Frame)((JFrame)((Object)this.viewer)), pGroup, this.breadthFirstUserObjects(this.selectedObject.getFileFormat().getRootNode()));
        dialog.setVisible(true);
        HObject obj = (HObject)dialog.getObject();
        if (obj == null) {
            return;
        }
        Group pgroup = dialog.getParentGroup();
        try {
            this.addObject(obj, pgroup);
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex, "HDFView", 0);
            return;
        }
    }

    private void addTable() {
        if (this.selectedObject == null || this.selectedNode == null) {
            return;
        }
        Group pGroup = null;
        pGroup = this.selectedObject instanceof Group ? (Group)this.selectedObject : (Group)((DefaultMutableTreeNode)this.selectedNode.getParent()).getUserObject();
        NewTableDataDialog dialog = new NewTableDataDialog((JFrame)((Object)this.viewer), pGroup, this.breadthFirstUserObjects(this.selectedObject.getFileFormat().getRootNode()));
        dialog.setVisible(true);
        HObject obj = (HObject)dialog.getObject();
        if (obj == null) {
            return;
        }
        Group pgroup = dialog.getParentGroup();
        try {
            this.addObject(obj, pgroup);
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex, "HDFView", 0);
            return;
        }
    }

    private void addDatatype() {
        if (this.selectedObject == null || this.selectedNode == null) {
            return;
        }
        Group pGroup = null;
        pGroup = this.selectedObject instanceof Group ? (Group)this.selectedObject : (Group)((DefaultMutableTreeNode)this.selectedNode.getParent()).getUserObject();
        NewDatatypeDialog dialog = new NewDatatypeDialog((JFrame)((Object)this.viewer), pGroup, this.breadthFirstUserObjects(this.selectedObject.getFileFormat().getRootNode()));
        dialog.setVisible(true);
        HObject obj = (HObject)dialog.getObject();
        if (obj == null) {
            return;
        }
        Group pgroup = dialog.getParentGroup();
        try {
            this.addObject(obj, pgroup);
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex, "HDFView", 0);
            return;
        }
    }

    private void addLink() {
        if (this.selectedObject == null || this.selectedNode == null) {
            return;
        }
        Group pGroup = null;
        pGroup = this.selectedObject instanceof Group ? (Group)this.selectedObject : (Group)((DefaultMutableTreeNode)this.selectedNode.getParent()).getUserObject();
        NewLinkDialog dialog = new NewLinkDialog((JFrame)((Object)this.viewer), pGroup, this.breadthFirstUserObjects(this.selectedObject.getFileFormat().getRootNode()));
        dialog.setVisible(true);
        HObject obj = (HObject)dialog.getObject();
        if (obj == null) {
            return;
        }
        Group pgroup = dialog.getParentGroup();
        try {
            this.addObject(obj, pgroup);
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex, "HDFView", 0);
            return;
        }
    }

    private void renameObject() {
        if (this.selectedObject == null) {
            return;
        }
        if (this.selectedObject instanceof Group && ((Group)this.selectedObject).isRoot()) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Cannot rename the root.", "HDFView", 0);
            return;
        }
        boolean isH4 = this.selectedObject.getFileFormat().isThisType(FileFormat.getFileFormat("HDF4"));
        if (isH4) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Cannot rename HDF4 object.", "HDFView", 0);
            return;
        }
        String oldName = this.selectedObject.getName();
        String newName = JOptionPane.showInputDialog(this, "Rename \"" + oldName + "\" to:", "Rename...", 1);
        if (newName == null) {
            return;
        }
        if ((newName = newName.trim()) == null || newName.length() == 0 || newName.equals(oldName)) {
            return;
        }
        try {
            this.selectedObject.setName(newName);
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex.getMessage(), "HDFView", 0);
        }
    }

    private void setLibVersionBounds() {
        Object[] lowValues = new Object[]{"Earliest", "Latest"};
        Object[] highValues = new Object[]{"Latest"};
        JComboBox<Object> lowComboBox = new JComboBox<Object>(lowValues);
        JComboBox<Object> highComboBox = new JComboBox<Object>(highValues);
        Object[] msg = new Object[]{"Earliest Version:", lowComboBox, "Latest Version:", highComboBox};
        Object[] options = new Object[]{"Ok", "Cancel"};
        JOptionPane op = new JOptionPane(msg, -1, 2, null, options);
        JDialog dialog = op.createDialog(this, "Set the library version bounds: ");
        dialog.setVisible(true);
        String result = null;
        try {
            result = (String)op.getValue();
        }
        catch (Exception err) {
            // empty catch block
        }
        if (result != null && result.equals("Ok")) {
            int low = -1;
            int high = 1;
            low = lowComboBox.getSelectedItem().equals("Earliest") ? 0 : 1;
            try {
                this.selectedObject.getFileFormat().setLibBounds(low, high);
            }
            catch (Throwable err) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, err, "Error when setting lib version bounds", 0);
                return;
            }
        } else {
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Close file")) {
            ((HDFView)this.viewer).actionPerformed(e);
        } else if (cmd.equals("Add group")) {
            this.addGroup();
        } else if (cmd.equals("Add dataset")) {
            this.addDataset();
        } else if (cmd.equals("Add image")) {
            this.addImage();
        } else if (cmd.equals("Add table")) {
            this.addTable();
        } else if (cmd.equals("Add datatype")) {
            this.addDatatype();
        } else if (cmd.equals("Add link")) {
            this.addLink();
        } else {
            if (cmd.startsWith("Open data")) {
                this.isDefaultDisplay = cmd.equals("Open data");
                try {
                    this.showDataContent(this.selectedObject);
                }
                catch (Throwable err) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, err, "HDFView", 0);
                    return;
                }
            }
            if (cmd.equals("Copy object")) {
                this.copyObject();
            } else if (cmd.equals("Paste object")) {
                this.pasteObject();
            } else if (cmd.equals("Cut object")) {
                this.removeSelectedObjects();
            } else if (cmd.equals("Move object")) {
                this.moveObject();
            } else if (cmd.equals("Save object to file")) {
                NewFileDialog dialog;
                if (this.selectedObject == null) {
                    return;
                }
                if (this.selectedObject instanceof Group && ((Group)this.selectedObject).isRoot()) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, "Cannot save the root group.\nUse \"Save As\" from file menu to save the whole file", "HDFView", 0);
                    return;
                }
                String filetype = "HDF4";
                boolean isH5 = this.selectedObject.getFileFormat().isThisType(FileFormat.getFileFormat("HDF5"));
                if (isH5) {
                    filetype = "HDF5";
                }
                if (!(dialog = new NewFileDialog((JFrame)((Object)this.viewer), this.selectedObject.getFileFormat().getParent(), filetype, this.fileList)).isFileCreated()) {
                    return;
                }
                String filename = dialog.getFile();
                FileFormat dstFile = null;
                try {
                    dstFile = this.openFile(filename, 1);
                }
                catch (Exception ex) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, ex.getMessage() + "\n" + filename, "HDFView", 0);
                }
                Vector<Object> objList = new Vector<Object>(2);
                objList.add(this.selectedObject);
                this.pasteObject(objList, dstFile.getRootNode(), dstFile);
            } else if (cmd.equals("Rename object")) {
                this.renameObject();
            } else if (cmd.startsWith("Show object properties")) {
                this.isDefaultDisplay = cmd.equals("Show object properties");
                try {
                    this.showMetaData(this.selectedObject);
                }
                catch (Exception ex) {
                    this.toolkit.beep();
                    JOptionPane.showMessageDialog(this, ex, "HDFView", 0);
                }
            } else if (cmd.startsWith("Find")) {
                if (cmd.equals("Find")) {
                    String findStr = this.currentSearchPhrase;
                    if (findStr == null) {
                        findStr = "";
                    }
                    if ((findStr = (String)JOptionPane.showInputDialog(this, "Find (e.g. O3Quality, O3*, or *Quality):", "Find Object by Name", -1, null, null, findStr)) != null && findStr.length() > 0) {
                        this.currentSearchPhrase = findStr;
                    }
                }
                DefaultTreeView.find(this.currentSearchPhrase, this.selectedTreePath, this.tree);
            } else if (cmd.startsWith("Expand all")) {
                for (int row = 0; row < this.tree.getRowCount(); ++row) {
                    this.tree.expandRow(row);
                }
            } else if (cmd.startsWith("Collapse all")) {
                for (int row = this.tree.getRowCount() - 1; row >= 0; --row) {
                    this.tree.collapseRow(row);
                }
            } else if (cmd.startsWith("Set Lib version bounds")) {
                this.setLibVersionBounds();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileFormat openFile(String filename, int accessID) throws Exception {
        FileFormat fileFormat = null;
        MutableTreeNode fileRoot = null;
        if (this.isFileOpen(filename)) {
            this.viewer.showStatus("File is in use");
            return null;
        }
        File tmpFile = new File(filename);
        if (!tmpFile.exists()) {
            throw new UnsupportedOperationException("File does not exist.");
        }
        if (!tmpFile.canWrite()) {
            accessID = 0;
        }
        Enumeration keys = FileFormat.getFileFormatKeys();
        String theKey = null;
        while (keys.hasMoreElements()) {
            theKey = (String)keys.nextElement();
            if (theKey.equals("HDF4")) {
                try {
                    FileFormat h4format = FileFormat.getFileFormat("HDF4");
                    if (h4format == null || !h4format.isThisType(filename)) continue;
                    fileFormat = h4format.open(filename, accessID);
                    break;
                }
                catch (Throwable err) {
                    continue;
                }
            }
            if (theKey.equals("HDF5")) {
                try {
                    FileFormat h5format = FileFormat.getFileFormat("HDF5");
                    if (h5format == null || !h5format.isThisType(filename)) continue;
                    fileFormat = h5format.open(filename, accessID);
                    break;
                }
                catch (Throwable err) {
                    continue;
                }
            }
            try {
                FileFormat theformat = FileFormat.getFileFormat(theKey);
                if (!theformat.isThisType(filename)) continue;
                fileFormat = theformat.open(filename, accessID);
                break;
            }
            catch (Throwable err) {
            }
        }
        if (fileFormat == null) {
            throw new IOException("Unsupported fileformat - " + filename);
        }
        ((JFrame)((Object)this.viewer)).setCursor(Cursor.getPredefinedCursor(3));
        try {
            fileFormat.setMaxMembers(ViewProperties.getMaxMembers());
            fileFormat.setStartMembers(ViewProperties.getStartMembers());
            fileFormat.open();
        }
        finally {
            ((JFrame)((Object)this.viewer)).setCursor(Cursor.getPredefinedCursor(0));
        }
        fileRoot = (MutableTreeNode)fileFormat.getRootNode();
        if (fileRoot != null) {
            this.insertNode(fileRoot, this.root);
            int currentRowCount = this.tree.getRowCount();
            if (currentRowCount > 0) {
                this.tree.expandRow(this.tree.getRowCount() - 1);
            }
            this.fileList.add(fileFormat);
        }
        return fileFormat;
    }

    @Override
    public void closeFile(FileFormat file) throws Exception {
        if (file == null) {
            return;
        }
        FileFormat theFile = null;
        DefaultMutableTreeNode theNode = null;
        Enumeration<TreeNode> enumeration = this.root.children();
        while (enumeration.hasMoreElements()) {
            theNode = (DefaultMutableTreeNode)enumeration.nextElement();
            Group g = (Group)theNode.getUserObject();
            theFile = g.getFileFormat();
            if (!theFile.equals(file)) continue;
            this.treeModel.removeNodeFromParent(theNode);
            try {
                theFile.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.fileList.remove(theFile);
            if (!theFile.equals(this.selectedFile)) break;
            this.selectedFile = null;
            this.selectedNode = null;
            break;
        }
    }

    @Override
    public void saveFile(FileFormat file) throws Exception {
        if (file == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Select a file to save.", "HDFView", 0);
            return;
        }
        boolean isH4 = file.isThisType(FileFormat.getFileFormat("HDF4"));
        boolean isH5 = file.isThisType(FileFormat.getFileFormat("HDF5"));
        if (!isH4 && !isH5) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Saving file is not supported for this file type", "HDFView", 0);
            return;
        }
        List<JInternalFrame> views = ((HDFView)this.viewer).getDataViews();
        JInternalFrame theView = null;
        TableView tableView = null;
        TextView textView = null;
        FileFormat theFile = null;
        if (views != null) {
            int n = views.size();
            for (int i = 0; i < n; ++i) {
                theView = views.get(i);
                if (theView instanceof TableView) {
                    tableView = (TableView)((Object)theView);
                    theFile = tableView.getDataObject().getFileFormat();
                    if (!file.equals(theFile)) continue;
                    tableView.updateValueInFile();
                    continue;
                }
                if (!(theView instanceof TextView) || !file.equals(theFile = (textView = (TextView)((Object)theView)).getDataObject().getFileFormat())) continue;
                textView.updateValueInFile();
            }
        }
        if (isH5) {
            this.saveAsHDF5(file);
        } else if (isH4) {
            this.saveAsHDF4(file);
        }
    }

    @Override
    public FileFormat getSelectedFile() {
        return this.selectedFile;
    }

    public List<Object> getSelectedObjects() {
        TreePath[] paths = this.tree.getSelectionPaths();
        if (paths == null || paths.length <= 0) {
            return null;
        }
        Vector<Object> objs = new Vector<Object>(paths.length);
        HObject theObject = null;
        DefaultMutableTreeNode currentNode = null;
        DefaultMutableTreeNode parentNode = null;
        for (int i = 0; i < paths.length; ++i) {
            currentNode = (DefaultMutableTreeNode)paths[i].getLastPathComponent();
            theObject = (HObject)currentNode.getUserObject();
            if (theObject == null) continue;
            objs.add(theObject);
            parentNode = (DefaultMutableTreeNode)currentNode.getParent();
            HObject parentObject = (HObject)parentNode.getUserObject();
            objs.remove(parentObject);
        }
        return objs;
    }

    @Override
    public HObject getCurrentObject() {
        return this.selectedObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataView showDataContent(HObject dataObject) throws Exception {
        Object[] tmpargs;
        if (dataObject == null || !(dataObject instanceof Dataset)) {
            return null;
        }
        Dataset d = (Dataset)dataObject;
        if (d.getRank() <= 0) {
            d.init();
        }
        boolean isText = d instanceof ScalarDS && ((ScalarDS)d).isText();
        boolean isImage = d instanceof ScalarDS && ((ScalarDS)d).isImage();
        boolean isDisplayTypeChar = false;
        boolean isTransposed = false;
        boolean isIndexBase1 = ViewProperties.isIndexBase1();
        BitSet bitmask = null;
        String dataViewName = null;
        JInternalFrame theFrame = (JInternalFrame)((Object)this.viewer.getDataView(d));
        if (this.isDefaultDisplay) {
            if (theFrame != null) {
                theFrame.toFront();
                return null;
            }
            dataViewName = isText ? (String)HDFView.getListOfTextView().get(0) : (isImage ? HDFView.getListOfImageView().get(0) : (String)HDFView.getListOfTableView().get(0));
        } else {
            DataOptionDialog dialog = new DataOptionDialog(this.viewer, d);
            dialog.setVisible(true);
            if (dialog.isCancelled()) {
                return null;
            }
            isImage = dialog.isImageDisplay();
            isDisplayTypeChar = dialog.isDisplayTypeChar();
            dataViewName = dialog.getDataViewName();
            isTransposed = dialog.isTransposed();
            bitmask = dialog.getBitmask();
            isIndexBase1 = dialog.isIndexBase1();
            this.isApplyBitmaskOnly = dialog.isApplyBitmaskOnly();
        }
        Class<?> theClass = null;
        try {
            theClass = Class.forName(dataViewName);
        }
        catch (Exception ex) {
            try {
                theClass = ViewProperties.loadExtClass().loadClass(dataViewName);
            }
            catch (Exception ex2) {
                theClass = null;
            }
        }
        if (theClass == null) {
            dataViewName = isText ? "ncsa.hdf.view.DefaultTextView" : (isImage ? "ncsa.hdf.view.DefaultImageView" : "ncsa.hdf.view.DefaultTableView");
            try {
                theClass = Class.forName(dataViewName);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        Object theView = null;
        Object[] initargs = new Object[]{this.viewer};
        HashMap<ViewProperties.DATA_VIEW_KEY, Object> map = new HashMap<ViewProperties.DATA_VIEW_KEY, Object>(8);
        map.put(ViewProperties.DATA_VIEW_KEY.INDEXBASE1, new Boolean(isIndexBase1));
        if (bitmask != null) {
            map.put(ViewProperties.DATA_VIEW_KEY.BITMASK, bitmask);
            if (this.isApplyBitmaskOnly) {
                map.put(ViewProperties.DATA_VIEW_KEY.BITMASKOP, (Object)ViewProperties.BITMASK_OP.AND);
            }
            ScalarDS d_copy = null;
            Constructor<?> constructor = null;
            Object[] paramObj = null;
            try {
                Class[] paramClass = new Class[]{FileFormat.class, String.class, String.class, long[].class};
                constructor = d.getClass().getConstructor(paramClass);
                paramObj = new Object[]{d.getFileFormat(), d.getName(), d.getPath(), d.getOID()};
            }
            catch (Exception ex) {
                constructor = null;
            }
            try {
                d_copy = (ScalarDS)constructor.newInstance(paramObj);
            }
            catch (Exception ex) {
                d_copy = null;
            }
            if (d_copy != null) {
                try {
                    d_copy.init();
                    int rank = d.getRank();
                    System.arraycopy(d.getDims(), 0, d_copy.getDims(), 0, rank);
                    System.arraycopy(d.getStartDims(), 0, d_copy.getStartDims(), 0, rank);
                    System.arraycopy(d.getSelectedDims(), 0, d_copy.getSelectedDims(), 0, rank);
                    System.arraycopy(d.getStride(), 0, d_copy.getStride(), 0, rank);
                    System.arraycopy(d.getSelectedIndex(), 0, d_copy.getSelectedIndex(), 0, 3);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
                map.put(ViewProperties.DATA_VIEW_KEY.OBJECT, d_copy);
            }
        }
        if (dataViewName.startsWith("ncsa.hdf.view.DefaultTableView")) {
            map.put(ViewProperties.DATA_VIEW_KEY.CHAR, new Boolean(isDisplayTypeChar));
            map.put(ViewProperties.DATA_VIEW_KEY.TRANSPOSED, new Boolean(isTransposed));
            tmpargs = new Object[]{this.viewer, map};
            initargs = tmpargs;
        } else if (dataViewName.startsWith("ncsa.hdf.view.DefaultImageView")) {
            map.put(ViewProperties.DATA_VIEW_KEY.CONVERTBYTE, new Boolean(bitmask != null));
            tmpargs = new Object[]{this.viewer, map};
            initargs = tmpargs;
        }
        ((JFrame)((Object)this.viewer)).setCursor(Cursor.getPredefinedCursor(3));
        try {
            theView = Tools.newInstance(theClass, initargs);
            this.viewer.addDataView((DataView)theView);
        }
        finally {
            ((JFrame)((Object)this.viewer)).setCursor(Cursor.getPredefinedCursor(0));
        }
        return (DataView)theView;
    }

    @Override
    public MetaDataView showMetaData(HObject dataObject) throws Exception {
        if (dataObject == null) {
            return null;
        }
        List metaDataViewList = HDFView.getListOfMetaDataView();
        if (metaDataViewList == null || metaDataViewList.size() <= 0) {
            return null;
        }
        int n = metaDataViewList.size();
        String className = (String)metaDataViewList.get(0);
        if (!this.isDefaultDisplay && n > 1) {
            className = (String)JOptionPane.showInputDialog(this, "Select MetaDataView", "HDFView", 1, null, metaDataViewList.toArray(), className);
        }
        Class<?> theClass = null;
        try {
            theClass = Class.forName(className);
        }
        catch (Exception ex) {
            theClass = ViewProperties.loadExtClass().loadClass(className);
        }
        Object[] initargs = new Object[]{this.viewer};
        MetaDataView dataView = (MetaDataView)Tools.newInstance(theClass, initargs);
        return dataView;
    }

    @Override
    public void addObject(HObject newObject, Group parentGroup) throws Exception {
        if (newObject == null || parentGroup == null) {
            return;
        }
        TreeNode pnode = this.findTreeNode(parentGroup);
        DefaultMutableTreeNode newnode = null;
        newnode = newObject instanceof Group ? new DefaultMutableTreeNode(newObject){
            private static final long serialVersionUID = -8852535261445958398L;

            @Override
            public boolean isLeaf() {
                return false;
            }
        } : new DefaultMutableTreeNode(newObject);
        this.treeModel.insertNodeInto(newnode, (DefaultMutableTreeNode)pnode, pnode.getChildCount());
    }

    @Override
    public JTree getTree() {
        return this.tree;
    }

    @Override
    public List<FileFormat> getCurrentFiles() {
        return this.fileList;
    }

    @Override
    public TreeNode findTreeNode(HObject obj) {
        if (obj == null) {
            return null;
        }
        TreeNode theFileRoot = obj.getFileFormat().getRootNode();
        if (theFileRoot == null) {
            return null;
        }
        DefaultMutableTreeNode theNode = null;
        HObject theObj = null;
        Enumeration<TreeNode> local_enum = ((DefaultMutableTreeNode)theFileRoot).breadthFirstEnumeration();
        while (local_enum.hasMoreElements()) {
            theNode = (DefaultMutableTreeNode)local_enum.nextElement();
            theObj = (HObject)theNode.getUserObject();
            if (theObj == null || !theObj.equals(obj)) continue;
            return theNode;
        }
        return null;
    }

    private class HTreeMouseAdapter
    extends MouseAdapter {
        private HTreeMouseAdapter() {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TreePath selPath = DefaultTreeView.this.tree.getPathForLocation(e.getX(), e.getY());
            if (selPath == null) {
                return;
            }
            DefaultMutableTreeNode theNode = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            if (!theNode.equals(DefaultTreeView.this.selectedNode)) {
                DefaultTreeView.this.selectedTreePath = selPath;
                DefaultTreeView.this.selectedNode = theNode;
                DefaultTreeView.this.selectedObject = (HObject)DefaultTreeView.this.selectedNode.getUserObject();
                FileFormat theFile = DefaultTreeView.this.selectedObject.getFileFormat();
                if (theFile != null && !theFile.equals(DefaultTreeView.this.selectedFile)) {
                    DefaultTreeView.this.selectedFile = theFile;
                    DefaultTreeView.this.tree.clearSelection();
                    DefaultTreeView.this.tree.setSelectionPath(selPath);
                }
                DefaultTreeView.this.viewer.mouseEventFired(e);
            }
            int eMod = e.getModifiers();
            if (e.isPopupTrigger() || eMod == 4 || System.getProperty("os.name").startsWith("Mac") && eMod == 18) {
                int selRow = DefaultTreeView.this.tree.getRowForLocation(e.getX(), e.getY());
                if (!DefaultTreeView.this.tree.isRowSelected(selRow)) {
                    DefaultTreeView.this.tree.clearSelection();
                    DefaultTreeView.this.tree.setSelectionRow(selRow);
                }
                DefaultTreeView.this.showPopupMenu(e);
            } else if (e.getClickCount() == 2) {
                DefaultTreeView.this.isDefaultDisplay = true;
                try {
                    DefaultTreeView.this.showDataContent(DefaultTreeView.this.selectedObject);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    private class HTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -9030708781106435297L;
        private Icon h4Icon;
        private Icon h5Icon;
        private Icon datasetIcon;
        private Icon imageIcon;
        private Icon tableIcon;
        private Icon textIcon;
        private Icon openFolder = ViewProperties.getFolderopenIcon();
        private Icon closeFolder = ViewProperties.getFoldercloseIcon();
        private Icon datasetIconA;
        private Icon imageIconA;
        private Icon tableIconA;
        private Icon textIconA;
        private Icon openFolderA;
        private Icon closeFolderA;
        private Icon datatypeIcon;
        private Icon datatypeIconA;
        private Icon questionIcon;

        private HTreeCellRenderer() {
            this.datasetIcon = ViewProperties.getDatasetIcon();
            this.imageIcon = ViewProperties.getImageIcon();
            this.h4Icon = ViewProperties.getH4Icon();
            this.h5Icon = ViewProperties.getH5Icon();
            this.tableIcon = ViewProperties.getTableIcon();
            this.textIcon = ViewProperties.getTextIcon();
            this.openFolderA = ViewProperties.getFolderopenIconA();
            this.closeFolderA = ViewProperties.getFoldercloseIconA();
            this.datasetIconA = ViewProperties.getDatasetIconA();
            this.imageIconA = ViewProperties.getImageIconA();
            this.tableIconA = ViewProperties.getTableIconA();
            this.textIconA = ViewProperties.getTextIconA();
            this.datatypeIcon = ViewProperties.getDatatypeIcon();
            this.datatypeIconA = ViewProperties.getDatatypeIconA();
            this.questionIcon = ViewProperties.getQuestionIcon();
            if (this.openFolder != null) {
                this.openIcon = this.openFolder;
            } else {
                this.openFolder = this.openIcon;
            }
            if (this.closeFolder != null) {
                this.closedIcon = this.closeFolder;
            } else {
                this.closeFolder = this.closedIcon;
            }
            if (this.datasetIcon == null) {
                this.datasetIcon = this.leafIcon;
            }
            if (this.imageIcon == null) {
                this.imageIcon = this.leafIcon;
            }
            if (this.tableIcon == null) {
                this.tableIcon = this.leafIcon;
            }
            if (this.textIcon == null) {
                this.textIcon = this.leafIcon;
            }
            if (this.h4Icon == null) {
                this.h4Icon = this.leafIcon;
            }
            if (this.h5Icon == null) {
                this.h5Icon = this.leafIcon;
            }
            if (this.datatypeIcon == null) {
                this.datatypeIcon = this.leafIcon;
            }
            if (this.questionIcon == null) {
                this.questionIcon = this.leafIcon;
            }
            if (this.openFolderA == null) {
                this.openFolderA = this.openFolder;
            }
            if (this.closeFolderA == null) {
                this.closeFolderA = this.closeFolder;
            }
            if (this.datasetIconA == null) {
                this.datasetIconA = this.datasetIcon;
            }
            if (this.imageIconA == null) {
                this.imageIconA = this.imageIcon;
            }
            if (this.tableIconA == null) {
                this.tableIconA = this.tableIcon;
            }
            if (this.textIconA == null) {
                this.textIconA = this.textIcon;
            }
            if (this.datatypeIconA == null) {
                this.datatypeIconA = this.datatypeIcon;
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            HObject theObject = (HObject)((DefaultMutableTreeNode)value).getUserObject();
            boolean hasAttribute = false;
            if (theObject instanceof Dataset) {
                if (theObject instanceof ScalarDS) {
                    ScalarDS sd = (ScalarDS)theObject;
                    hasAttribute = sd.hasAttribute();
                    this.leafIcon = sd.isImage() ? (hasAttribute ? this.imageIconA : this.imageIcon) : (sd.isText() ? (hasAttribute ? this.textIconA : this.textIcon) : (hasAttribute ? this.datasetIconA : this.datasetIcon));
                } else if (theObject instanceof CompoundDS) {
                    this.leafIcon = theObject.hasAttribute() ? this.tableIconA : this.tableIcon;
                }
            } else if (theObject instanceof Group) {
                Group g = (Group)theObject;
                if (g.hasAttribute()) {
                    this.openIcon = this.openFolderA;
                    this.closedIcon = this.closeFolderA;
                } else {
                    this.openIcon = this.openFolder;
                    this.closedIcon = this.closeFolder;
                }
                if (g.isRoot()) {
                    if (g.getFileFormat().isThisType(FileFormat.getFileFormat("HDF5"))) {
                        this.openIcon = this.closedIcon = this.h5Icon;
                    } else if (g.getFileFormat().isThisType(FileFormat.getFileFormat("HDF4"))) {
                        this.openIcon = this.closedIcon = this.h4Icon;
                    }
                }
            } else {
                Datatype t;
                this.leafIcon = theObject instanceof Datatype ? ((t = (Datatype)theObject).hasAttribute() ? this.datatypeIconA : this.datatypeIcon) : this.questionIcon;
            }
            return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
    }
}

