/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.StreamPrintServiceFactory;
import javax.swing.CellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.DefaultFileFilter;
import ncsa.hdf.view.TextView;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class DefaultTextView
extends JInternalFrame
implements TextView,
ActionListener,
KeyListener {
    private static final long serialVersionUID = 3892752752951438428L;
    private final ViewManager viewer;
    private ScalarDS dataset;
    private String[] text;
    private JTable table;
    private boolean isReadOnly = false;
    private boolean isTextChanged = false;
    private TextAreaEditor textEditor = null;
    private RowHeader rowHeaders = null;
    private int indexBase = 0;

    public DefaultTextView(ViewManager theView) {
        this(theView, null);
    }

    public DefaultTextView(ViewManager theView, HashMap map) {
        int i;
        this.viewer = theView;
        this.text = null;
        this.table = null;
        this.dataset = null;
        this.textEditor = new TextAreaEditor(this);
        if (ViewProperties.isIndexBase1()) {
            this.indexBase = 1;
        }
        HObject hobject = null;
        hobject = map != null ? (HObject)map.get((Object)ViewProperties.DATA_VIEW_KEY.OBJECT) : theView.getTreeView().getCurrentObject();
        if (!(hobject instanceof ScalarDS)) {
            return;
        }
        this.dataset = (ScalarDS)hobject;
        if (!this.dataset.isText()) {
            this.viewer.showStatus("Cannot display non-text dataset in text view.");
            this.dataset = null;
            return;
        }
        this.isReadOnly = this.dataset.getFileFormat().isReadOnly();
        try {
            this.text = (String[])this.dataset.getData();
        }
        catch (Exception ex) {
            this.text = null;
        }
        if (this.text == null) {
            this.viewer.showStatus("Loading text dataset failed - " + this.dataset.getName());
            this.dataset = null;
            return;
        }
        String fname = new File(this.dataset.getFile()).getName();
        this.setDefaultCloseOperation(2);
        this.setTitle("TextView  -  " + this.dataset.getName() + "  -  " + this.dataset.getPath() + "  -  " + fname);
        this.setFrameIcon(ViewProperties.getTextIcon());
        int rank = this.dataset.getRank();
        long[] start = this.dataset.getStartDims();
        long[] count = this.dataset.getSelectedDims();
        String colName = "Data selection:   [" + start[0];
        for (i = 1; i < rank; ++i) {
            colName = colName + ", " + start[i];
        }
        colName = colName + "] ~ [" + (start[0] + count[0] - 1L);
        for (i = 1; i < rank; ++i) {
            colName = colName + ", " + (start[i] + count[i] - 1L);
        }
        colName = colName + "]";
        this.table = this.createTable(colName);
        JTableHeader colHeader = this.table.getTableHeader();
        colHeader.setReorderingAllowed(false);
        this.rowHeaders = new RowHeader(this.table, this.dataset);
        JScrollPane scrollingTable = new JScrollPane(this.table);
        scrollingTable.getVerticalScrollBar().setUnitIncrement(100);
        scrollingTable.getHorizontalScrollBar().setUnitIncrement(100);
        JViewport viewp = new JViewport();
        viewp.add(this.rowHeaders);
        viewp.setPreferredSize(this.rowHeaders.getPreferredSize());
        scrollingTable.setRowHeader(viewp);
        TableColumnModel cmodel = this.table.getColumnModel();
        TextAreaRenderer textAreaRenderer = new TextAreaRenderer();
        cmodel.getColumn(0).setCellRenderer(textAreaRenderer);
        cmodel.getColumn(0).setCellEditor(this.textEditor);
        ((JPanel)this.getContentPane()).add(scrollingTable);
        this.setJMenuBar(this.createMenuBar());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        String cmd = e.getActionCommand();
        if (cmd.equals("Close")) {
            this.dispose();
        } else if (cmd.equals("Save to text file")) {
            try {
                this.saveAsText();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), ex, this.getTitle(), 0);
            }
        } else if (cmd.equals("Save changes")) {
            this.updateValueInFile();
        } else if (cmd.equals("Print")) {
            this.print();
        }
    }

    private JTable createTable(final String colName) {
        JTable theTable = null;
        AbstractTableModel tm = new AbstractTableModel(){

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public int getRowCount() {
                return DefaultTextView.this.text.length;
            }

            @Override
            public String getColumnName(int col) {
                return colName;
            }

            @Override
            public Object getValueAt(int row, int column) {
                return DefaultTextView.this.text[row];
            }
        };
        theTable = new JTable(tm){
            private static final long serialVersionUID = -6571266777012522255L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return !DefaultTextView.this.isReadOnly;
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                int row = this.getEditingRow();
                int col = this.getEditingColumn();
                super.editingStopped(e);
                Object source = e.getSource();
                if (source instanceof CellEditor) {
                    String cellValue;
                    CellEditor editor = (CellEditor)source;
                    ((DefaultTextView)DefaultTextView.this).text[row] = cellValue = (String)editor.getCellEditorValue();
                }
            }
        };
        return theTable;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.isTextChanged = true;
    }

    private JMenuBar createMenuBar() {
        JMenuBar bar = new JMenuBar();
        JMenu menu = new JMenu("Text", false);
        menu.setMnemonic('T');
        bar.add(menu);
        JMenuItem item = new JMenuItem("Save To Text File");
        item.addActionListener(this);
        item.setActionCommand("Save to text file");
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Save Changes");
        item.addActionListener(this);
        item.setActionCommand("Save changes");
        menu.add(item);
        menu.addSeparator();
        menu.addSeparator();
        item = new JMenuItem("Close");
        item.addActionListener(this);
        item.setActionCommand("Close");
        menu.add(item);
        return bar;
    }

    @Override
    public void updateValueInFile() {
        if (this.isReadOnly) {
            return;
        }
        if (!(this.dataset instanceof ScalarDS)) {
            return;
        }
        if (!this.isTextChanged) {
            return;
        }
        int row = this.table.getEditingRow();
        if (row >= 0) {
            String cellValue;
            this.text[row] = cellValue = (String)this.textEditor.getCellEditorValue();
        }
        try {
            this.dataset.write();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex, this.getTitle(), 0);
            return;
        }
        this.isTextChanged = false;
    }

    private void saveAsText() throws Exception {
        int newFileFlag;
        JFileChooser fchooser = new JFileChooser(this.dataset.getFile());
        fchooser.setFileFilter(DefaultFileFilter.getFileFilterText());
        fchooser.changeToParentDirectory();
        fchooser.setDialogTitle("Save Current Data To Text File --- " + this.dataset.getName());
        File choosedFile = new File(this.dataset.getName() + ".txt");
        fchooser.setSelectedFile(choosedFile);
        int returnVal = fchooser.showSaveDialog(this);
        if (returnVal != 0) {
            return;
        }
        choosedFile = fchooser.getSelectedFile();
        if (choosedFile == null) {
            return;
        }
        String fname = choosedFile.getAbsolutePath();
        List<FileFormat> fileList = this.viewer.getTreeView().getCurrentFiles();
        if (fileList != null) {
            FileFormat theFile2 = null;
            for (FileFormat theFile2 : fileList) {
                if (!theFile2.getFilePath().equals(fname)) continue;
                JOptionPane.showMessageDialog(this, "Unable to save data to file \"" + fname + "\". \nThe file is being used.", this.getTitle(), 0);
                return;
            }
        }
        if (choosedFile.exists() && (newFileFlag = JOptionPane.showConfirmDialog(this, "File exists. Do you want to replace it ?", this.getTitle(), 0)) == 1) {
            return;
        }
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(choosedFile)));
        int rows = this.text.length;
        for (int i = 0; i < rows; ++i) {
            out.print(this.text[i].trim());
            out.println();
            out.println();
        }
        out.flush();
        out.close();
        this.viewer.showStatus("Data save to: " + fname);
        try {
            RandomAccessFile rf = new RandomAccessFile(choosedFile, "r");
            long size = rf.length();
            rf.close();
            this.viewer.showStatus("File size (bytes): " + size);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    @Override
    public void dispose() {
        int op;
        if (this.isTextChanged && !this.isReadOnly && (op = JOptionPane.showConfirmDialog(this, "\"" + this.dataset.getName() + "\" has changed.\n" + "Do you want to save the changes?", this.getTitle(), 0)) == 0) {
            this.updateValueInFile();
        }
        this.viewer.removeDataView(this);
        super.dispose();
    }

    @Override
    public HObject getDataObject() {
        return this.dataset;
    }

    @Override
    public String[] getText() {
        return this.text;
    }

    private void print() {
        StreamPrintServiceFactory[] spsf = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(null, null);
        for (int i = 0; i < spsf.length; ++i) {
            System.out.println(spsf[i]);
        }
        DocFlavor[] docFlavors = spsf[0].getSupportedDocFlavors();
        for (int i = 0; i < docFlavors.length; ++i) {
            System.out.println(docFlavors[i]);
        }
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream("e:\\temp\\t.html"));
        }
        catch (Exception ex) {
            // empty catch block
        }
        DocFlavor.STRING flavor = DocFlavor.STRING.TEXT_HTML;
        PrintService[] services = PrintServiceLookup.lookupPrintServices(null, null);
        DocPrintJob job = services[0].createPrintJob();
        SimpleDoc doc = new SimpleDoc(is, flavor, null);
        try {
            job.print(doc, null);
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
    }

    private class RowHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 3081275694689434654L;

        public RowHeaderRenderer() {
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setBackground(Color.lightGray);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setFont(table.getFont());
            if (value != null) {
                this.setText(value.toString());
            }
            return this;
        }
    }

    private class RowHeader
    extends JTable {
        private static final long serialVersionUID = 2572539746584274419L;
        private int currentRowIndex;
        private int lastRowIndex;
        private JTable parentTable;

        public RowHeader(JTable pTable, Dataset dset) {
            super(pTable.getRowCount(), 1);
            this.currentRowIndex = -1;
            this.lastRowIndex = -1;
            long[] startArray = dset.getStartDims();
            long[] strideArray = dset.getStride();
            int[] selectedIndex = dset.getSelectedIndex();
            int start = (int)startArray[selectedIndex[0]];
            int stride = (int)strideArray[selectedIndex[0]];
            this.parentTable = pTable;
            int n = this.parentTable.getRowCount();
            for (int i = 0; i < n; ++i) {
                this.setValueAt(new Integer(start + DefaultTextView.this.indexBase + i * stride), i, 0);
            }
            TableColumn col = this.getColumnModel().getColumn(0);
            col.setCellRenderer(new RowHeaderRenderer());
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.parentTable == null) {
                return;
            }
            int[] rows = this.getSelectedRows();
            if (rows == null || rows.length == 0) {
                return;
            }
            this.parentTable.clearSelection();
            this.parentTable.setRowSelectionInterval(rows[0], rows[rows.length - 1]);
            this.parentTable.setColumnSelectionInterval(0, this.parentTable.getColumnCount() - 1);
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
            if (e.getID() == 506) {
                int colEnd = this.rowAtPoint(e.getPoint());
                if (colEnd < 0) {
                    colEnd = 0;
                }
                if (this.currentRowIndex < 0) {
                    this.currentRowIndex = 0;
                }
                this.parentTable.clearSelection();
                if (colEnd > this.currentRowIndex) {
                    this.parentTable.setRowSelectionInterval(this.currentRowIndex, colEnd);
                } else {
                    this.parentTable.setRowSelectionInterval(colEnd, this.currentRowIndex);
                }
                this.parentTable.setColumnSelectionInterval(0, this.parentTable.getColumnCount() - 1);
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            int mouseID = e.getID();
            if (mouseID == 500) {
                if (this.currentRowIndex < 0) {
                    return;
                }
                if (e.isControlDown()) {
                    this.parentTable.addRowSelectionInterval(this.currentRowIndex, this.currentRowIndex);
                } else if (e.isShiftDown()) {
                    if (this.lastRowIndex < 0) {
                        this.parentTable.addRowSelectionInterval(0, this.currentRowIndex);
                    } else if (this.lastRowIndex < this.currentRowIndex) {
                        this.parentTable.addRowSelectionInterval(this.lastRowIndex, this.currentRowIndex);
                    } else {
                        this.parentTable.addRowSelectionInterval(this.currentRowIndex, this.lastRowIndex);
                    }
                } else {
                    this.parentTable.clearSelection();
                    this.parentTable.setRowSelectionInterval(this.currentRowIndex, this.currentRowIndex);
                }
                this.lastRowIndex = this.currentRowIndex;
                this.parentTable.setColumnSelectionInterval(0, this.parentTable.getColumnCount() - 1);
            } else if (mouseID == 501) {
                this.currentRowIndex = this.rowAtPoint(e.getPoint());
            }
        }
    }

    private class TextAreaEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1721646779892184957L;

        public TextAreaEditor(KeyListener keyListener) {
            super(new JTextField());
            final JTextArea textArea = new JTextArea();
            textArea.addKeyListener(keyListener);
            textArea.setWrapStyleWord(true);
            textArea.setLineWrap(true);
            JScrollPane scrollPane = new JScrollPane(textArea);
            scrollPane.setBorder(null);
            this.editorComponent = scrollPane;
            this.delegate = new DefaultCellEditor.EditorDelegate(){
                private static final long serialVersionUID = 7662356579385373160L;

                @Override
                public void setValue(Object value) {
                    textArea.setText(value != null ? value.toString() : "");
                }

                @Override
                public Object getCellEditorValue() {
                    return textArea.getText();
                }
            };
        }
    }

    private class TextAreaRenderer
    extends JTextArea
    implements TableCellRenderer {
        private static final long serialVersionUID = -5869975162678521978L;
        private final DefaultTableCellRenderer adaptee = new DefaultTableCellRenderer();
        private final Map cellSizes = new HashMap();

        public TextAreaRenderer() {
            this.setLineWrap(true);
            this.setWrapStyleWord(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
            this.adaptee.getTableCellRendererComponent(table, obj, isSelected, hasFocus, row, column);
            this.setForeground(this.adaptee.getForeground());
            this.setBackground(this.adaptee.getBackground());
            this.setBorder(this.adaptee.getBorder());
            this.setFont(this.adaptee.getFont());
            this.setText(this.adaptee.getText());
            TableColumnModel columnModel = table.getColumnModel();
            this.setSize(columnModel.getColumn(column).getWidth(), 100000);
            int height_wanted = (int)this.getPreferredSize().getHeight();
            this.addSize(table, row, column, height_wanted);
            height_wanted = this.findTotalMaximumRowSize(table, row);
            if (height_wanted != table.getRowHeight(row)) {
                table.setRowHeight(row, height_wanted);
                DefaultTextView.this.rowHeaders.setRowHeight(row, height_wanted);
            }
            return this;
        }

        private void addSize(JTable table, int row, int column, int height) {
            HashMap<Integer, Integer> rowheights;
            HashMap<Integer, HashMap<Integer, Integer>> rows = (HashMap<Integer, HashMap<Integer, Integer>>)this.cellSizes.get(table);
            if (rows == null) {
                rows = new HashMap<Integer, HashMap<Integer, Integer>>();
                this.cellSizes.put(table, rows);
            }
            if ((rowheights = (HashMap<Integer, Integer>)rows.get(new Integer(row))) == null) {
                rowheights = new HashMap<Integer, Integer>();
                rows.put(new Integer(row), rowheights);
            }
            rowheights.put(new Integer(column), new Integer(height));
        }

        private int findTotalMaximumRowSize(JTable table, int row) {
            int maximum_height = 0;
            Enumeration<TableColumn> columns = table.getColumnModel().getColumns();
            while (columns.hasMoreElements()) {
                TableColumn tc = columns.nextElement();
                TableCellRenderer cellRenderer = tc.getCellRenderer();
                if (!(cellRenderer instanceof TextAreaRenderer)) continue;
                TextAreaRenderer tar = (TextAreaRenderer)cellRenderer;
                maximum_height = Math.max(maximum_height, tar.findMaximumRowSize(table, row));
            }
            return maximum_height;
        }

        private int findMaximumRowSize(JTable table, int row) {
            Map rows = (Map)this.cellSizes.get(table);
            if (rows == null) {
                return 0;
            }
            Map rowheights = (Map)rows.get(new Integer(row));
            if (rowheights == null) {
                return 0;
            }
            int maximum_height = 0;
            for (Map.Entry entry : rowheights.entrySet()) {
                int cellHeight = (Integer)entry.getValue();
                maximum_height = Math.max(maximum_height, cellHeight);
            }
            return maximum_height;
        }
    }
}

