/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.CellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.Chart;
import ncsa.hdf.view.DataView;
import ncsa.hdf.view.DefaultFileFilter;
import ncsa.hdf.view.DefaultImageView;
import ncsa.hdf.view.DefaultTextView;
import ncsa.hdf.view.MathConversionDialog;
import ncsa.hdf.view.NewDatasetDialog;
import ncsa.hdf.view.TableView;
import ncsa.hdf.view.Tools;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class DefaultTableView
extends JInternalFrame
implements TableView,
ActionListener,
MouseListener {
    private static final long serialVersionUID = -7452459299532863847L;
    private final ViewManager viewer;
    private char NT = (char)32;
    private Dataset dataset;
    private Object dataValue;
    private JTable table;
    private JLabel cellLabel;
    private JTextArea cellValueField;
    private boolean isValueChanged;
    private final Toolkit toolkit;
    private boolean isReadOnly;
    private boolean isDisplayTypeChar;
    private boolean isDataTransposed;
    private boolean isRegRef;
    private boolean isObjRef;
    private final JCheckBoxMenuItem checkFixedDataLength;
    private int fixedDataLength;
    private final JCheckBoxMenuItem checkScientificNotation;
    private final JCheckBoxMenuItem checkHex;
    private final JCheckBoxMenuItem checkBin;
    private final DecimalFormat scientificFormat = new DecimalFormat("###.#####E0#");
    private final NumberFormat normalFormat;
    private NumberFormat numberFormat = this.normalFormat = null;
    private boolean showAsHex = false;
    private boolean showAsBin = false;
    private final boolean[] startEditing = new boolean[]{false};
    private JPopupMenu popupMenu;
    private ViewType viewType;
    private JTextField frameField;
    private long curFrame = 0L;
    private long maxFrame = 1L;
    private Object fillValue = null;
    private BitSet bitmask;
    private ViewProperties.BITMASK_OP bitmaskOP = ViewProperties.BITMASK_OP.EXTRACT;
    private int binaryOrder;
    private int indexBase = 0;
    private static final int FLOAT_BUFFER_SIZE = 524288;
    private static final int INT_BUFFER_SIZE = 524288;
    private static final int SHORT_BUFFER_SIZE = 0x100000;
    private static final int LONG_BUFFER_SIZE = 262144;
    private static final int DOUBLE_BUFFER_SIZE = 262144;
    private static final int BYTE_BUFFER_SIZE = 0x200000;
    private Object currentEditingCellValue = null;

    public DefaultTableView(ViewManager theView) {
        this(theView, null);
    }

    public DefaultTableView(ViewManager theView, HashMap map) {
        int i;
        String compression;
        this.setDefaultCloseOperation(2);
        this.viewer = theView;
        this.toolkit = Toolkit.getDefaultToolkit();
        this.isValueChanged = false;
        this.isReadOnly = false;
        this.isRegRef = false;
        this.isObjRef = false;
        this.viewType = ViewType.TABLE;
        this.fixedDataLength = -1;
        HObject hobject = null;
        this.popupMenu = null;
        this.bitmask = null;
        if (ViewProperties.isIndexBase1()) {
            this.indexBase = 1;
        }
        this.checkFixedDataLength = new JCheckBoxMenuItem("Fixed Data Length", false);
        this.checkScientificNotation = new JCheckBoxMenuItem("Show Scientific Notation", false);
        this.checkHex = new JCheckBoxMenuItem("Show Hexadecimal", false);
        this.checkBin = new JCheckBoxMenuItem("Show Binary", false);
        if (map != null) {
            hobject = (HObject)map.get((Object)ViewProperties.DATA_VIEW_KEY.OBJECT);
            this.bitmask = (BitSet)map.get((Object)ViewProperties.DATA_VIEW_KEY.BITMASK);
            this.bitmaskOP = (ViewProperties.BITMASK_OP)((Object)map.get((Object)ViewProperties.DATA_VIEW_KEY.BITMASKOP));
            Boolean b = (Boolean)map.get((Object)ViewProperties.DATA_VIEW_KEY.CHAR);
            if (b != null) {
                this.isDisplayTypeChar = b;
            }
            if ((b = (Boolean)map.get((Object)ViewProperties.DATA_VIEW_KEY.TRANSPOSED)) != null) {
                this.isDataTransposed = b;
            }
            if ((b = (Boolean)map.get((Object)ViewProperties.DATA_VIEW_KEY.INDEXBASE1)) != null) {
                this.indexBase = b != false ? 1 : 0;
            }
        }
        if (hobject == null) {
            hobject = this.viewer.getTreeView().getCurrentObject();
        }
        if (hobject == null || !(hobject instanceof Dataset)) {
            return;
        }
        this.dataset = (Dataset)hobject;
        this.isReadOnly = this.dataset.getFileFormat().isReadOnly();
        long[] dims = this.dataset.getDims();
        long tsize = 1L;
        for (int i2 = 0; i2 < dims.length; ++i2) {
            tsize *= dims[i2];
        }
        if (this.dataset.getHeight() <= 0 || this.dataset.getWidth() <= 0 || tsize <= 0L) {
            return;
        }
        if (this.dataset.getFileFormat().isThisType(FileFormat.getFileFormat("HDF4")) && this.dataset instanceof CompoundDS) {
            this.isReadOnly = true;
        }
        if (!this.isReadOnly && (compression = this.dataset.getCompression()) != null && compression.startsWith("SZIP") && !compression.endsWith("ENCODE_ENABLED")) {
            this.isReadOnly = true;
        }
        Datatype dtype = this.dataset.getDatatype();
        this.isDisplayTypeChar = this.isDisplayTypeChar && (dtype.getDatatypeSize() == 1 || dtype.getDatatypeClass() == 10 && dtype.getBasetype().getDatatypeClass() == 2);
        this.dataset.setEnumConverted(ViewProperties.isConvertEnum());
        if (this.dataset instanceof CompoundDS) {
            this.isDataTransposed = false;
            this.setFrameIcon(ViewProperties.getTableIcon());
            this.table = this.createTable((CompoundDS)this.dataset);
        } else {
            this.setFrameIcon(ViewProperties.getDatasetIcon());
            this.table = this.createTable((ScalarDS)this.dataset);
            if (dtype.getDatatypeClass() == 7) {
                this.table.addMouseListener(this);
                if (dtype.getDatatypeSize() > 8) {
                    this.isReadOnly = true;
                    this.isRegRef = true;
                } else {
                    this.isObjRef = true;
                }
            }
        }
        if (this.table == null) {
            this.viewer.showStatus("Creating table failed - " + this.dataset.getName());
            this.dataset = null;
            return;
        }
        this.table.setName("data");
        ColumnHeader columnHeaders = new ColumnHeader(this.table);
        this.table.setTableHeader(columnHeaders);
        this.table.setCellSelectionEnabled(true);
        this.table.setAutoResizeMode(0);
        this.table.setGridColor(Color.gray);
        JScrollPane scrollingTable = new JScrollPane(this.table);
        scrollingTable.getVerticalScrollBar().setUnitIncrement(100);
        scrollingTable.getHorizontalScrollBar().setUnitIncrement(100);
        RowHeader rowHeaders = new RowHeader(this.table, this.dataset);
        JViewport viewp = new JViewport();
        viewp.add(rowHeaders);
        viewp.setPreferredSize(rowHeaders.getPreferredSize());
        scrollingTable.setRowHeader(viewp);
        this.cellLabel = new JLabel("");
        this.cellLabel.setBorder(new EtchedBorder(1));
        Dimension dim = this.cellLabel.getPreferredSize();
        dim.width = 75;
        this.cellLabel.setPreferredSize(dim);
        this.cellLabel.setHorizontalAlignment(4);
        this.cellValueField = new JTextArea();
        this.cellValueField.setLineWrap(true);
        this.cellValueField.setWrapStyleWord(true);
        this.cellValueField.setEditable(false);
        this.cellValueField.setBackground(new Color(255, 255, 240));
        JScrollPane scrollingcellValue = new JScrollPane(this.cellValueField);
        scrollingcellValue.getVerticalScrollBar().setUnitIncrement(50);
        scrollingcellValue.getHorizontalScrollBar().setUnitIncrement(50);
        JPanel valuePane = new JPanel();
        valuePane.setLayout(new BorderLayout());
        valuePane.add((Component)this.cellLabel, "West");
        valuePane.add((Component)scrollingcellValue, "Center");
        JSplitPane splitPane = new JSplitPane(0, valuePane, scrollingTable);
        splitPane.setDividerLocation(25);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add(splitPane);
        StringBuffer sb = new StringBuffer("TableView  -  ");
        sb.append(hobject.getName());
        sb.append("  -  ");
        sb.append(hobject.getPath());
        sb.append("  -  ");
        sb.append(this.dataset.getFile());
        this.setTitle(sb.toString());
        int rank = this.dataset.getRank();
        int[] selectedIndex = this.dataset.getSelectedIndex();
        long[] count = this.dataset.getSelectedDims();
        long[] stride = this.dataset.getStride();
        long[] start = this.dataset.getStartDims();
        int n = Math.min(3, rank);
        if (rank > 2) {
            this.curFrame = start[selectedIndex[2]] + (long)this.indexBase;
            this.maxFrame = dims[selectedIndex[2]];
        }
        sb.append(" [ dims");
        sb.append(selectedIndex[0]);
        for (i = 1; i < n; ++i) {
            sb.append("x");
            sb.append(selectedIndex[i]);
        }
        sb.append(", start");
        sb.append(start[selectedIndex[0]]);
        for (i = 1; i < n; ++i) {
            sb.append("x");
            sb.append(start[selectedIndex[i]]);
        }
        sb.append(", count");
        sb.append(count[selectedIndex[0]]);
        for (i = 1; i < n; ++i) {
            sb.append("x");
            sb.append(count[selectedIndex[i]]);
        }
        sb.append(", stride");
        sb.append(stride[selectedIndex[0]]);
        for (i = 1; i < n; ++i) {
            sb.append("x");
            sb.append(stride[selectedIndex[i]]);
        }
        sb.append(" ] ");
        this.setJMenuBar(this.createMenuBar());
        this.viewer.showStatus(sb.toString());
        int cellRowHeight = this.table.getFontMetrics(this.table.getFont()).getHeight();
        rowHeaders.setRowHeight(cellRowHeight);
        this.table.setRowHeight(cellRowHeight);
        if (this.isRegRef || this.isObjRef) {
            this.popupMenu = this.createPopupMenu();
        }
    }

    private JMenuBar createMenuBar() {
        JMenuBar bar = new JMenuBar();
        boolean isEditable = !this.isReadOnly;
        boolean is3D = this.dataset.getRank() > 2;
        JMenu menu = new JMenu("Table", false);
        menu.setMnemonic('T');
        bar.add(menu);
        JMenuItem item = new JMenuItem("Export Data to Text File");
        item.addActionListener(this);
        item.setActionCommand("Save table as text");
        menu.add(item);
        JMenu exportAsBinaryMenu = new JMenu("Export Data to Binary File");
        if (this.dataset instanceof ScalarDS) {
            menu.add(exportAsBinaryMenu);
        }
        item = new JMenuItem("Native Order");
        item.addActionListener(this);
        item.setActionCommand("Save table as binary Native Order");
        exportAsBinaryMenu.add(item);
        item = new JMenuItem("Little Endian");
        item.addActionListener(this);
        item.setActionCommand("Save table as binary Little Endian");
        exportAsBinaryMenu.add(item);
        item = new JMenuItem("Big Endian");
        item.addActionListener(this);
        item.setActionCommand("Save table as binary Big Endian");
        exportAsBinaryMenu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Import Data from Text File");
        item.addActionListener(this);
        item.setActionCommand("Import data from file");
        item.setEnabled(isEditable);
        menu.add(item);
        item = this.checkFixedDataLength;
        item.addActionListener(this);
        item.setActionCommand("Fixed data length");
        if (this.dataset instanceof ScalarDS) {
            menu.add(item);
        }
        JMenu importFromBinaryMenu = new JMenu("Import Data from Binary File");
        if (this.dataset instanceof ScalarDS) {
            menu.add(importFromBinaryMenu);
        }
        item = new JMenuItem("Native Order");
        item.addActionListener(this);
        item.setActionCommand("Order as Native Order");
        importFromBinaryMenu.add(item);
        item = new JMenuItem("Little Endian");
        item.addActionListener(this);
        item.setActionCommand("Order as Little Endian");
        importFromBinaryMenu.add(item);
        item = new JMenuItem("Big Endian");
        item.addActionListener(this);
        item.setActionCommand("Order as Big Endian");
        importFromBinaryMenu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Copy");
        item.addActionListener(this);
        item.setActionCommand("Copy data");
        item.setAccelerator(KeyStroke.getKeyStroke(67, 2, true));
        menu.add(item);
        item = new JMenuItem("Paste");
        item.addActionListener(this);
        item.setActionCommand("Paste data");
        item.setAccelerator(KeyStroke.getKeyStroke(86, 2, true));
        item.setEnabled(isEditable);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Copy to New Dataset");
        item.addActionListener(this);
        item.setActionCommand("Write selection to dataset");
        item.setEnabled(isEditable && this.dataset instanceof ScalarDS);
        menu.add(item);
        item = new JMenuItem("Save Changes to File");
        item.addActionListener(this);
        item.setActionCommand("Save dataset");
        item.setEnabled(isEditable);
        item.setAccelerator(KeyStroke.getKeyStroke(85, 2, true));
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Select All");
        item.addActionListener(this);
        item.setActionCommand("Select all data");
        item.setAccelerator(KeyStroke.getKeyStroke(65, 2, true));
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Show Lineplot");
        item.addActionListener(this);
        item.setActionCommand("Show chart");
        menu.add(item);
        item = new JMenuItem("Show Statistics");
        item.addActionListener(this);
        item.setActionCommand("Show statistics");
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Math Conversion");
        item.addActionListener(this);
        item.setActionCommand("Math conversion");
        item.setEnabled(isEditable);
        menu.add(item);
        menu.addSeparator();
        item = this.checkScientificNotation;
        item.addActionListener(this);
        item.setActionCommand("Show scientific notation");
        if (this.dataset instanceof ScalarDS) {
            menu.add(item);
        }
        boolean isInt = this.NT == 'B' || this.NT == 'S' || this.NT == 'I' || this.NT == 'J';
        item = this.checkHex;
        item.addActionListener(this);
        item.setActionCommand("Show hexadecimal");
        if (this.dataset instanceof ScalarDS && isInt) {
            menu.add(item);
        }
        item = this.checkBin;
        item.addActionListener(this);
        item.setActionCommand("Show binary");
        if (this.dataset instanceof ScalarDS && isInt) {
            menu.add(item);
        }
        menu.addSeparator();
        item = new JMenuItem("Close");
        item.addActionListener(this);
        item.setActionCommand("Close");
        menu.add(item);
        bar.add(new JLabel("     "));
        Insets margin = new Insets(0, 2, 0, 2);
        JButton button = new JButton(ViewProperties.getChartIcon());
        bar.add(button);
        button.setToolTipText("Line Plot");
        button.setMargin(margin);
        button.addActionListener(this);
        button.setActionCommand("Show chart");
        if (is3D) {
            bar.add(new JLabel("     "));
            button = new JButton(ViewProperties.getFirstIcon());
            bar.add(button);
            button.setToolTipText("First");
            button.setMargin(margin);
            button.addActionListener(this);
            button.setActionCommand("First page");
            button = new JButton(ViewProperties.getPreviousIcon());
            bar.add(button);
            button.setToolTipText("Previous");
            button.setMargin(margin);
            button.addActionListener(this);
            button.setActionCommand("Previous page");
            this.frameField = new JTextField(String.valueOf(this.curFrame));
            this.frameField.setMaximumSize(new Dimension(50, 30));
            bar.add(this.frameField);
            this.frameField.setMargin(margin);
            this.frameField.addActionListener(this);
            this.frameField.setActionCommand("Go to frame");
            JLabel tmpField = new JLabel(String.valueOf(this.maxFrame), 0);
            tmpField.setMaximumSize(new Dimension(50, 30));
            bar.add(tmpField);
            button = new JButton(ViewProperties.getNextIcon());
            bar.add(button);
            button.setToolTipText("Next");
            button.setMargin(margin);
            button.addActionListener(this);
            button.setActionCommand("Next page");
            button = new JButton(ViewProperties.getLastIcon());
            bar.add(button);
            button.setToolTipText("Last");
            button.setMargin(margin);
            button.addActionListener(this);
            button.setActionCommand("Last page");
        }
        return bar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        block73: {
            block74: {
                this.setCursor(Cursor.getPredefinedCursor(3));
                source = e.getSource();
                cmd = e.getActionCommand();
                if (cmd.equals("Close")) {
                    this.dispose();
                    return;
                }
                if (cmd.equals("Save table as text")) {
                    try {
                        this.saveAsText();
                        return;
                    }
                    catch (Exception ex) {
                        this.toolkit.beep();
                        JOptionPane.showMessageDialog((JFrame)this.viewer, ex, this.getTitle(), 0);
                        return;
                    }
                }
                if (cmd.startsWith("Save table as binary")) {
                    if (cmd.equals("Save table as binary Native Order")) {
                        this.binaryOrder = 1;
                    }
                    if (cmd.equals("Save table as binary Little Endian")) {
                        this.binaryOrder = 2;
                    }
                    if (cmd.equals("Save table as binary Big Endian")) {
                        this.binaryOrder = 3;
                    }
                    try {
                        this.saveAsBinary();
                        return;
                    }
                    catch (Exception ex) {
                        this.toolkit.beep();
                        JOptionPane.showMessageDialog((JFrame)this.viewer, ex, this.getTitle(), 0);
                        return;
                    }
                }
                if (cmd.equals("Copy data")) {
                    this.copyData();
                    return;
                }
                if (cmd.equals("Paste data")) {
                    this.pasteData();
                    return;
                }
                if (!cmd.equals("Import data from file")) ** GOTO lbl55
                currentDir = this.dataset.getFileFormat().getParent();
                fchooser = new JFileChooser(currentDir);
                fchooser.setFileFilter(DefaultFileFilter.getFileFilterText());
                returnVal = fchooser.showOpenDialog(this);
                if (returnVal != 0) {
                }
                ** GOTO lbl-1000
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
lbl-1000:
                // 1 sources

                {
                    choosedFile = fchooser.getSelectedFile();
                    if (choosedFile != null) ** GOTO lbl-1000
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
lbl-1000:
                // 1 sources

                {
                    txtFile = choosedFile.getAbsolutePath();
                    this.importTextData(txtFile);
                    return;
lbl55:
                    // 1 sources

                    if (cmd.startsWith("Order as")) {
                        if (cmd.equals("Order as Native Order")) {
                            this.binaryOrder = 1;
                        }
                        if (cmd.equals("Order as Little Endian")) {
                            this.binaryOrder = 2;
                        }
                        if (cmd.equals("Order as Big Endian")) {
                            this.binaryOrder = 3;
                        }
                        this.importBinaryData();
                        return;
                    }
                    if (!cmd.equals("Write selection to dataset")) ** GOTO lbl97
                    jtable = this.getTable();
                    if (jtable.getSelectedColumnCount() > 0 && jtable.getSelectedRowCount() > 0) ** GOTO lbl-1000
                    JOptionPane.showMessageDialog(this, "Select table cells to write.", "HDFView", 1);
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
lbl-1000:
                // 1 sources

                {
                    treeView = this.viewer.getTreeView();
                    node = this.viewer.getTreeView().findTreeNode(this.dataset);
                    pGroup = (Group)((DefaultMutableTreeNode)node.getParent()).getUserObject();
                    root = this.dataset.getFileFormat().getRootNode();
                    if (root != null) ** GOTO lbl-1000
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
lbl-1000:
                // 1 sources

                {
                    list = new Vector<Object>(this.dataset.getFileFormat().getNumberOfMembers() + 5);
                    theNode = null;
                    local_enum = ((DefaultMutableTreeNode)root).depthFirstEnumeration();
                    while (local_enum.hasMoreElements()) {
                        theNode = (DefaultMutableTreeNode)local_enum.nextElement();
                        list.add(theNode.getUserObject());
                    }
                    dialog = new NewDatasetDialog((JFrame)this.viewer, pGroup, list, this);
                    dialog.setVisible(true);
                    obj = (HObject)dialog.getObject();
                    if (obj != null) {
                        pgroup = dialog.getParentGroup();
                        try {
                            treeView.addObject(obj, pgroup);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    list.setSize(0);
                    return;
lbl97:
                    // 1 sources

                    if (cmd.equals("Save dataset")) {
                        try {
                            this.updateValueInFile();
                            return;
                        }
                        catch (Exception ex) {
                            this.toolkit.beep();
                            JOptionPane.showMessageDialog((JFrame)this.viewer, ex, this.getTitle(), 0);
                            return;
                        }
                    }
                    if (cmd.equals("Select all data")) {
                        try {
                            this.selectAll();
                            return;
                        }
                        catch (Exception ex) {
                            this.toolkit.beep();
                            JOptionPane.showMessageDialog((JFrame)this.viewer, ex, this.getTitle(), 0);
                            return;
                        }
                    }
                    if (cmd.equals("Show chart")) {
                        this.showLineplot();
                        return;
                    }
                    if (cmd.equals("First page")) {
                        this.firstPage();
                        return;
                    }
                    if (cmd.equals("Previous page")) {
                        this.previousPage();
                        return;
                    }
                    if (cmd.equals("Next page")) {
                        this.nextPage();
                        return;
                    }
                    if (cmd.equals("Last page")) {
                        this.lastPage();
                        return;
                    }
                    if (!cmd.equals("Show statistics")) break block73;
                    try {
                        theData = null;
                        if (!(this.dataset instanceof CompoundDS)) ** GOTO lbl151
                        theData = this.getSelectedData();
                        cols = this.table.getSelectedColumnCount();
                        if (this.dataset instanceof CompoundDS && cols > 1) {
                            JOptionPane.showMessageDialog(this, "Please select one colunm a time for compound dataset.", this.getTitle(), 0);
                        }
                        ** GOTO lbl-1000
                    }
                    catch (Exception ex) {
                        this.toolkit.beep();
                        JOptionPane.showMessageDialog((JFrame)this.viewer, ex, this.getTitle(), 0);
                        return;
                    }
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
lbl-1000:
                // 1 sources

                {
                    if (theData != null) break block74;
                    JOptionPane.showMessageDialog(this, "Select a column to show statistics.", this.getTitle(), 0);
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            ** try [egrp 12[TRYBLOCK] [17 : 900->1378)] { 
lbl-1000:
            // 1 sources

            {
                block75: {
                    break block75;
lbl151:
                    // 1 sources

                    theData = this.dataValue;
                }
                minmax = new double[2];
                stat = new double[2];
                Tools.findMinMax(theData, minmax, this.fillValue);
                if (Tools.computeStatistics(theData, stat, this.fillValue) > 0) {
                    statistics = "Min                      = " + minmax[0] + "\nMax                      = " + minmax[1] + "\nMean                     = " + stat[0] + "\nStandard deviation = " + stat[1];
                    JOptionPane.showMessageDialog(this, statistics, "Statistics", 1);
                }
                theData = null;
                System.gc();
                return;
            }
        }
        if (cmd.equals("Math conversion")) {
            try {
                this.mathConversion();
                return;
            }
            catch (Exception ex) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog((JFrame)this.viewer, ex, this.getTitle(), 0);
                return;
            }
        }
        if (cmd.startsWith("Go to frame")) {
            page = 0;
            try {
                page = Integer.parseInt(this.frameField.getText().trim()) - this.indexBase;
            }
            catch (Exception ex) {
                page = -1;
            }
            this.gotoPage(page);
            return;
        }
        if (cmd.equals("Show scientific notation")) {
            if (this.checkScientificNotation.isSelected()) {
                this.numberFormat = this.scientificFormat;
                this.checkHex.setSelected(false);
                this.checkBin.setSelected(false);
                this.showAsHex = false;
                this.showAsBin = false;
            } else {
                this.numberFormat = this.normalFormat;
            }
            this.updateUI();
            return;
        }
        if (cmd.equals("Show hexadecimal")) {
            this.showAsHex = this.checkHex.isSelected();
            if (this.showAsHex) {
                this.checkScientificNotation.setSelected(false);
                this.checkBin.setSelected(false);
                this.showAsBin = false;
                this.numberFormat = this.normalFormat;
            }
            this.updateUI();
            return;
        }
        if (cmd.equals("Show binary")) {
            this.showAsBin = this.checkBin.isSelected();
            if (this.showAsBin) {
                this.checkScientificNotation.setSelected(false);
                this.checkHex.setSelected(false);
                this.showAsHex = false;
                this.numberFormat = this.normalFormat;
            }
            this.updateUI();
            return;
        }
        if (cmd.equals("Fixed data length")) {
            if (!this.checkFixedDataLength.isSelected()) {
                this.fixedDataLength = -1;
                this.updateUI();
                return;
            }
            str = JOptionPane.showInputDialog(this, "Enter fixed data length when importing text data\n\nFor example, for a text string of \"12345678\"\n\t\tenter 2, the data will be 12, 34, 56, 78\n\t\tenter 4, the data will be 1234, 5678\n", "");
            if (str == null || str.length() < 1) {
                this.checkFixedDataLength.setSelected(false);
                return;
            }
            try {
                this.fixedDataLength = Integer.parseInt(str);
            }
            catch (Exception ex) {
                this.fixedDataLength = -1;
            }
            if (this.fixedDataLength >= 1) return;
            this.checkFixedDataLength.setSelected(false);
            return;
        }
        if (cmd.startsWith("Show data as") == false) return;
        this.viewType = cmd.endsWith("table") != false ? ViewType.TABLE : (cmd.endsWith("image") != false ? ViewType.IMAGE : ViewType.TABLE);
        theData = this.getSelectedData();
        if (theData == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "No data selected.", this.getTitle(), 0);
            return;
        }
        len = Array.getLength(theData);
        i = 0;
        while (i < len) {
            if (this.isRegRef) {
                this.showRegRefData((String)Array.get(theData, i));
            } else if (this.isObjRef) {
                this.showObjRefData(Array.getLong(theData, i));
            }
            ++i;
        }
        return;
lbl245:
        // 1 sources

        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    @Override
    public HObject getDataObject() {
        return this.dataset;
    }

    @Override
    public void dispose() {
        if (this.isValueChanged && !this.isReadOnly) {
            int op = JOptionPane.showConfirmDialog(this, "\"" + this.dataset.getName() + "\" has changed.\n" + "Do you want to save the changes?", this.getTitle(), 0);
            if (op == 0) {
                this.updateValueInFile();
            } else {
                this.dataset.clearData();
            }
        }
        if (this.dataset instanceof ScalarDS) {
            ScalarDS sds = (ScalarDS)this.dataset;
            if (sds.isImage()) {
                sds.clearData();
            }
            this.dataValue = null;
            this.table = null;
        }
        this.viewer.removeDataView(this);
        super.dispose();
    }

    private void previousPage() {
        int rank = this.dataset.getRank();
        if (rank < 3) {
            return;
        }
        long[] start = this.dataset.getStartDims();
        long[] dims = this.dataset.getDims();
        int[] selectedIndex = this.dataset.getSelectedIndex();
        long idx = start[selectedIndex[2]];
        if (idx == 0L) {
            return;
        }
        this.gotoPage(start[selectedIndex[2]] - 1L);
    }

    private void nextPage() {
        long[] dims;
        int[] selectedIndex;
        int rank = this.dataset.getRank();
        if (rank < 3) {
            return;
        }
        long[] start = this.dataset.getStartDims();
        long idx = start[(selectedIndex = this.dataset.getSelectedIndex())[2]];
        if (idx == (dims = this.dataset.getDims())[selectedIndex[2]] - 1L) {
            return;
        }
        this.gotoPage(start[selectedIndex[2]] + 1L);
    }

    private void firstPage() {
        int rank = this.dataset.getRank();
        if (rank < 3) {
            return;
        }
        long[] start = this.dataset.getStartDims();
        int[] selectedIndex = this.dataset.getSelectedIndex();
        long[] dims = this.dataset.getDims();
        long idx = start[selectedIndex[2]];
        if (idx == 0L) {
            return;
        }
        this.gotoPage(0L);
    }

    private void lastPage() {
        long[] dims;
        int[] selectedIndex;
        int rank = this.dataset.getRank();
        if (rank < 3) {
            return;
        }
        long[] start = this.dataset.getStartDims();
        long idx = start[(selectedIndex = this.dataset.getSelectedIndex())[2]];
        if (idx == (dims = this.dataset.getDims())[selectedIndex[2]] - 1L) {
            return;
        }
        this.gotoPage(dims[selectedIndex[2]] - 1L);
    }

    @Override
    public JTable getTable() {
        return this.table;
    }

    private void showLineplot() {
        int n;
        int j;
        int i;
        double value;
        int[] rows = this.table.getSelectedRows();
        int[] cols = this.table.getSelectedColumns();
        if (rows == null || cols == null || rows.length <= 0 || cols.length <= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Select rows/columns to draw line plot.", this.getTitle(), 0);
            return;
        }
        int nrow = this.table.getRowCount();
        int ncol = this.table.getColumnCount();
        LineplotOption lpo = new LineplotOption((JFrame)((Object)this.viewer), "Line Plot Options -- " + this.dataset.getName(), nrow, ncol);
        lpo.setVisible(true);
        int plotType = lpo.getPlotBy();
        if (plotType == -1) {
            return;
        }
        boolean isRowPlot = plotType == 0;
        int xIndex = lpo.getXindex();
        double[][] data = null;
        int nLines = 0;
        String title = "Lineplot - " + this.dataset.getPath() + this.dataset.getName();
        String[] lineLabels = null;
        double[] yRange = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY};
        double[] xData = null;
        if (isRowPlot) {
            title = title + " - by row";
            nLines = rows.length;
            if (nLines > 10) {
                this.toolkit.beep();
                nLines = 10;
                JOptionPane.showMessageDialog(this, "More than 10 rows are selected.\nThe first 10 rows will be displayed.", this.getTitle(), 2);
            }
            lineLabels = new String[nLines];
            data = new double[nLines][cols.length];
            value = 0.0;
            for (i = 0; i < nLines; ++i) {
                lineLabels[i] = String.valueOf(rows[i]);
                for (int j2 = 0; j2 < cols.length; ++j2) {
                    data[i][j2] = 0.0;
                    try {
                        data[i][j2] = value = Double.parseDouble(this.table.getValueAt(rows[i], cols[j2]).toString());
                        yRange[0] = Math.min(yRange[0], value);
                        yRange[1] = Math.max(yRange[1], value);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
            }
            if (xIndex >= 0) {
                xData = new double[cols.length];
                for (j = 0; j < cols.length; ++j) {
                    xData[j] = 0.0;
                    try {
                        xData[j] = value = Double.parseDouble(this.table.getValueAt(xIndex, cols[j]).toString());
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
            }
        } else {
            title = title + " - by column";
            nLines = cols.length;
            if (nLines > 10) {
                this.toolkit.beep();
                nLines = 10;
                JOptionPane.showMessageDialog(this, "More than 10 columns are selected.\nThe first 10 columns will be displayed.", this.getTitle(), 2);
            }
            lineLabels = new String[nLines];
            data = new double[nLines][rows.length];
            value = 0.0;
            for (j = 0; j < nLines; ++j) {
                lineLabels[j] = this.table.getColumnName(cols[j]);
                for (int i2 = 0; i2 < rows.length; ++i2) {
                    data[j][i2] = 0.0;
                    try {
                        data[j][i2] = value = Double.parseDouble(this.table.getValueAt(rows[i2], cols[j]).toString());
                        yRange[0] = Math.min(yRange[0], value);
                        yRange[1] = Math.max(yRange[1], value);
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
            }
            if (xIndex >= 0) {
                xData = new double[rows.length];
                for (j = 0; j < rows.length; ++j) {
                    xData[j] = 0.0;
                    try {
                        xData[j] = value = Double.parseDouble(this.table.getValueAt(rows[j], xIndex).toString());
                        continue;
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
            }
        }
        if ((n = this.removeInvalidPlotData(data, xData, yRange)) < data[0].length) {
            double[][] dataNew = new double[data.length][n];
            for (i = 0; i < data.length; ++i) {
                System.arraycopy(data[i], 0, dataNew[i], 0, n);
            }
            data = dataNew;
            if (xData != null) {
                double[] xDataNew = new double[n];
                System.arraycopy(xData, 0, xDataNew, 0, n);
                xData = xDataNew;
            }
        }
        if (yRange[0] == yRange[1]) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Cannot show line plot for the selected data. \nPlease check the data range: (" + yRange[0] + ", " + yRange[1] + ").", this.getTitle(), 0);
            data = null;
            return;
        }
        Chart cv = new Chart((JFrame)((Object)this.viewer), title, 1, data, xData, yRange);
        cv.setLineLabels(lineLabels);
        String cname = this.dataValue.getClass().getName();
        char dname = cname.charAt(cname.lastIndexOf("[") + 1);
        if (dname == 'B' || dname == 'S' || dname == 'I' || dname == 'J') {
            cv.setTypeToInteger();
        }
        cv.setVisible(true);
    }

    private int removeInvalidPlotData(double[][] data, double[] xData, double[] yRange) {
        int idx = 0;
        boolean hasInvalid = false;
        if (data == null || yRange == null) {
            return -1;
        }
        yRange[0] = Double.POSITIVE_INFINITY;
        yRange[1] = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < data[0].length; ++i) {
            hasInvalid = false;
            for (int j = 0; j < data.length; ++j) {
                hasInvalid = Tools.isNaNINF(data[j][i]);
                if (xData != null) {
                    boolean bl = hasInvalid = hasInvalid || Tools.isNaNINF(xData[i]);
                }
                if (hasInvalid) break;
                data[j][idx] = data[j][i];
                if (xData != null) {
                    xData[idx] = xData[i];
                }
                yRange[0] = Math.min(yRange[0], data[j][idx]);
                yRange[1] = Math.max(yRange[1], data[j][idx]);
            }
            if (hasInvalid) continue;
            ++idx;
        }
        return idx;
    }

    @Override
    public Object getSelectedData() {
        if (this.dataset instanceof CompoundDS) {
            return this.getSelectedCompoundData();
        }
        return this.getSelectedScalarData();
    }

    private Object getSelectedScalarData() {
        Object[] selectedData = null;
        int[] selectedRows = this.table.getSelectedRows();
        int[] selectedCols = this.table.getSelectedColumns();
        if (selectedRows == null || selectedRows.length <= 0 || selectedCols == null || selectedCols.length <= 0) {
            return null;
        }
        int size = selectedCols.length * selectedRows.length;
        if (this.table.getColumnCount() == selectedCols.length && this.table.getRowCount() == selectedRows.length) {
            return this.dataValue;
        }
        selectedData = null;
        if (this.isRegRef) {
            selectedData = new String[size];
        } else {
            switch (this.NT) {
                case 'B': {
                    selectedData = new byte[size];
                    break;
                }
                case 'S': {
                    selectedData = new short[size];
                    break;
                }
                case 'I': {
                    selectedData = new int[size];
                    break;
                }
                case 'J': {
                    selectedData = new long[size];
                    break;
                }
                case 'F': {
                    selectedData = new float[size];
                    break;
                }
                case 'D': {
                    selectedData = new double[size];
                    break;
                }
                default: {
                    selectedData = null;
                }
            }
        }
        if (selectedData == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Unsupported data type.", this.getTitle(), 0);
            return null;
        }
        int r0 = this.table.getSelectedRow();
        int c0 = this.table.getSelectedColumn();
        int w = this.table.getColumnCount();
        int idx_src = 0;
        int idx_dst = 0;
        for (int i = 0; i < selectedRows.length; ++i) {
            for (int j = 0; j < selectedCols.length; ++j) {
                idx_src = selectedRows[i] * w + selectedCols[j];
                Array.set(selectedData, idx_dst, Array.get(this.dataValue, idx_src));
                ++idx_dst;
            }
        }
        return selectedData;
    }

    private Object getSelectedCompoundData() {
        Object[] selectedData = null;
        int cols = this.table.getSelectedColumnCount();
        int rows = this.table.getSelectedRowCount();
        if (cols <= 0 || rows <= 0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "No data is selected.", this.getTitle(), 0);
            return null;
        }
        Object colData = null;
        try {
            colData = ((List)this.dataset.getData()).get(this.table.getSelectedColumn());
        }
        catch (Exception ex) {
            return null;
        }
        int size = Array.getLength(colData);
        String cName = colData.getClass().getName();
        int cIndex = cName.lastIndexOf("[");
        int nt = 32;
        if (cIndex >= 0) {
            nt = cName.charAt(cIndex + 1);
        }
        if (nt == 66) {
            selectedData = new byte[size];
        } else if (nt == 83) {
            selectedData = new short[size];
        } else if (nt == 73) {
            selectedData = new int[size];
        } else if (nt == 74) {
            selectedData = new long[size];
        } else if (nt == 70) {
            selectedData = new float[size];
        } else if (nt == 68) {
            selectedData = new double[size];
        } else {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Unsupported data type.", this.getTitle(), 0);
            return null;
        }
        System.arraycopy(colData, 0, selectedData, 0, size);
        return selectedData;
    }

    private JTable createTable(ScalarDS d) {
        Datatype baseType;
        JTable theTable = null;
        int rows = 0;
        int cols = 0;
        int rank = d.getRank();
        if (rank <= 0) {
            d.init();
            rank = d.getRank();
        }
        long[] dims = d.getSelectedDims();
        rows = (int)dims[0];
        cols = 1;
        if (rank > 1) {
            rows = d.getHeight();
            cols = d.getWidth();
        }
        this.dataValue = null;
        try {
            this.dataValue = d.getData();
            if (Tools.applyBitmask(this.dataValue, this.bitmask, this.bitmaskOP)) {
                this.isReadOnly = true;
                String opName = "Extract bits ";
                if (this.bitmaskOP == ViewProperties.BITMASK_OP.AND) {
                    opName = "Apply bitwise AND ";
                }
                CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLUE, 1), opName + this.bitmask, 3, 2, this.getFont(), Color.RED));
                this.setBorder(border);
            }
            d.convertFromUnsignedC();
            this.dataValue = d.getData();
            if (Array.getLength(this.dataValue) <= rows) {
                cols = 1;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex, this.getTitle(), 0);
            this.dataValue = null;
        }
        if (this.dataValue == null) {
            return null;
        }
        this.fillValue = d.getFillValue();
        String cName = this.dataValue.getClass().getName();
        int cIndex = cName.lastIndexOf("[");
        if (cIndex >= 0) {
            this.NT = cName.charAt(cIndex + 1);
        }
        boolean isVL = cName.startsWith("[Ljava.lang.String;");
        if (this.isDisplayTypeChar && (this.NT == 'B' || this.NT == 'S')) {
            int n = Array.getLength(this.dataValue);
            char[] charData = new char[n];
            for (int i = 0; i < n; ++i) {
                if (this.NT == 'B') {
                    charData[i] = (char)Array.getByte(this.dataValue, i);
                    continue;
                }
                if (this.NT != 'S') continue;
                charData[i] = (char)Array.getShort(this.dataValue, i);
            }
            this.dataValue = charData;
        } else if (this.NT == 'B' && this.dataset.getDatatype().getDatatypeClass() == 10 && (baseType = this.dataset.getDatatype().getBasetype()).getDatatypeClass() == 3) {
            this.dataValue = Dataset.byteToString((byte[])this.dataValue, baseType.getDatatypeSize());
        }
        final String[] columnNames = new String[cols];
        final int rowCount = rows;
        final int colCount = cols;
        long[] startArray = this.dataset.getStartDims();
        long[] strideArray = this.dataset.getStride();
        int[] selectedIndex = this.dataset.getSelectedIndex();
        final int rowStart = (int)startArray[selectedIndex[0]];
        final int rowStride = (int)strideArray[selectedIndex[0]];
        int start = 0;
        int stride = 1;
        if (rank > 1) {
            start = (int)startArray[selectedIndex[1]];
            stride = (int)strideArray[selectedIndex[1]];
        }
        for (int i = 0; i < cols; ++i) {
            columnNames[i] = String.valueOf(start + this.indexBase + i * stride);
        }
        AbstractTableModel tm = new AbstractTableModel(){
            private static final long serialVersionUID = 254175303655079056L;
            private final StringBuffer stringBuffer = new StringBuffer();
            private final Datatype dtype = DefaultTableView.access$000(DefaultTableView.this).getDatatype();
            private final Datatype btype = this.dtype.getBasetype();
            private final int typeSize = this.dtype.getDatatypeSize();
            private final boolean isArray = this.dtype.getDatatypeClass() == 10;
            private final boolean isStr = DefaultTableView.access$100(DefaultTableView.this) == 'L';
            private final boolean isInt = DefaultTableView.access$100(DefaultTableView.this) == 'B' || DefaultTableView.access$100(DefaultTableView.this) == 'S' || DefaultTableView.access$100(DefaultTableView.this) == 'I' || DefaultTableView.access$100(DefaultTableView.this) == 'J';
            private final boolean isUINT64 = this.dtype.isUnsigned() && DefaultTableView.access$100(DefaultTableView.this) == 'J';
            private Object theValue;

            @Override
            public int getColumnCount() {
                return columnNames.length;
            }

            @Override
            public int getRowCount() {
                return rowCount;
            }

            @Override
            public String getColumnName(int col) {
                return columnNames[col];
            }

            @Override
            public Object getValueAt(int row, int column) {
                if (DefaultTableView.this.startEditing[0]) {
                    return "";
                }
                if (this.isArray) {
                    int arraySize = this.dtype.getDatatypeSize() / this.btype.getDatatypeSize();
                    this.stringBuffer.setLength(0);
                    int i0 = (row * colCount + column) * arraySize;
                    int i1 = i0 + arraySize;
                    if (DefaultTableView.this.isDisplayTypeChar) {
                        for (int i = i0; i < i1; ++i) {
                            this.stringBuffer.append(Array.getChar(DefaultTableView.this.dataValue, i));
                            if (this.stringBuffer.length() <= 0 || i >= i1 - 1) continue;
                            this.stringBuffer.append(", ");
                        }
                    } else {
                        for (int i = i0; i < i1; ++i) {
                            this.stringBuffer.append(Array.get(DefaultTableView.this.dataValue, i));
                            if (this.stringBuffer.length() <= 0 || i >= i1 - 1) continue;
                            this.stringBuffer.append(", ");
                        }
                    }
                    this.theValue = this.stringBuffer;
                } else {
                    int[] selectedIndex = DefaultTableView.this.dataset.getSelectedIndex();
                    int index = column * rowCount + row;
                    if (DefaultTableView.this.dataset.getRank() > 1) {
                        boolean isNaturalOrder = selectedIndex[0] < selectedIndex[1];
                        index = DefaultTableView.this.isDataTransposed && isNaturalOrder || !DefaultTableView.this.isDataTransposed && !isNaturalOrder ? column * rowCount + row : row * colCount + column;
                    }
                    this.theValue = Array.get(DefaultTableView.this.dataValue, index);
                    if (this.isStr) {
                        return this.theValue;
                    }
                    if (this.isUINT64) {
                        Long l = (Long)this.theValue;
                        if (l < 0L) {
                            l = l << 1 >> 1;
                            BigInteger big1 = new BigInteger("9223372036854775808");
                            BigInteger big2 = new BigInteger(l.toString());
                            BigInteger big = big1.add(big2);
                            this.theValue = big.toString();
                        }
                    } else if (DefaultTableView.this.showAsHex && this.isInt) {
                        this.theValue = Long.toHexString(Long.valueOf(this.theValue.toString()));
                    } else if (DefaultTableView.this.showAsBin && this.isInt) {
                        this.theValue = Tools.toBinaryString(Long.valueOf(this.theValue.toString()), this.typeSize);
                    } else if (DefaultTableView.this.numberFormat != null) {
                        this.theValue = DefaultTableView.this.numberFormat.format(this.theValue);
                    }
                }
                return this.theValue;
            }
        };
        theTable = new JTable(tm){
            private static final long serialVersionUID = -145476220959400488L;
            private final Datatype dtype;
            private final boolean isArray;
            {
                super(x0);
                this.dtype = DefaultTableView.this.dataset.getDatatype();
                this.isArray = this.dtype.getDatatypeClass() == 10;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return !DefaultTableView.this.isReadOnly && !DefaultTableView.this.isDisplayTypeChar && !this.isArray && !DefaultTableView.this.showAsBin && !DefaultTableView.this.showAsHex;
            }

            @Override
            public boolean editCellAt(int row, int column, EventObject e) {
                MouseEvent me;
                int mc;
                if (!this.isCellEditable(row, column)) {
                    return super.editCellAt(row, column, e);
                }
                if (e instanceof KeyEvent) {
                    KeyEvent ke = (KeyEvent)e;
                    if (ke.getID() == 401) {
                        ((DefaultTableView)DefaultTableView.this).startEditing[0] = true;
                    }
                } else if (e instanceof MouseEvent && (mc = (me = (MouseEvent)e).getClickCount()) > 1) {
                    DefaultTableView.this.currentEditingCellValue = this.getValueAt(row, column);
                }
                return super.editCellAt(row, column, e);
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                int row = this.getEditingRow();
                int col = this.getEditingColumn();
                super.editingStopped(e);
                ((DefaultTableView)DefaultTableView.this).startEditing[0] = false;
                Object source = e.getSource();
                if (source instanceof CellEditor) {
                    CellEditor editor = (CellEditor)source;
                    String cellValue = (String)editor.getCellEditorValue();
                    try {
                        DefaultTableView.this.updateValueInMemory(cellValue, row, col);
                    }
                    catch (Exception ex) {
                        DefaultTableView.this.toolkit.beep();
                        JOptionPane.showMessageDialog(this, ex, DefaultTableView.this.getTitle(), 0);
                    }
                }
            }

            @Override
            public boolean isCellSelected(int row, int column) {
                if (this.getSelectedRow() == row && this.getSelectedColumn() == column) {
                    DefaultTableView.this.cellLabel.setText(String.valueOf(rowStart + DefaultTableView.this.indexBase + row * rowStride) + ", " + DefaultTableView.this.table.getColumnName(column) + "  =  ");
                    Object val = this.getValueAt(row, column);
                    String strVal = null;
                    if (DefaultTableView.this.isRegRef) {
                        String reg = (String)val;
                        String oidStr = reg.substring(reg.indexOf(58) + 1, reg.indexOf(32));
                        long[] oid = new long[]{-1L};
                        try {
                            oid[0] = Long.valueOf(oidStr);
                            HObject obj = FileFormat.findObject(DefaultTableView.this.dataset.getFileFormat(), oid);
                            strVal = obj.getFullName() + " " + reg.substring(reg.indexOf("{"));
                        }
                        catch (Exception ex) {
                            strVal = null;
                        }
                    } else if (DefaultTableView.this.isObjRef) {
                        Long ref = (Long)val;
                        long[] oid = new long[]{ref};
                        try {
                            HObject obj = FileFormat.findObject(DefaultTableView.this.dataset.getFileFormat(), oid);
                            strVal = obj.getFullName();
                        }
                        catch (Exception ex) {
                            strVal = null;
                        }
                    }
                    if (strVal == null && val != null) {
                        strVal = val.toString();
                    }
                    DefaultTableView.this.cellValueField.setText(strVal);
                }
                return super.isCellSelected(row, column);
            }
        };
        return theTable;
    }

    private JTable createTable(CompoundDS d) {
        JTable theTable = null;
        int rank = d.getRank();
        if (rank <= 0) {
            d.init();
        }
        long[] startArray = d.getStartDims();
        long[] strideArray = d.getStride();
        int[] selectedIndex = d.getSelectedIndex();
        final int rowStart = (int)startArray[selectedIndex[0]];
        final int rowStride = (int)strideArray[selectedIndex[0]];
        if (d.getHeight() > 10000) {
            d.setConvertByteToString(false);
        }
        this.dataValue = null;
        try {
            this.dataValue = d.getData();
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex, this.getTitle(), 0);
            this.dataValue = null;
        }
        if (this.dataValue == null || !(this.dataValue instanceof List)) {
            return null;
        }
        final int rows = d.getHeight();
        int cols = d.getSelectedMemberCount();
        String[] columnNames = new String[cols];
        int idx = 0;
        String[] columnNamesAll = d.getMemberNames();
        for (int i = 0; i < columnNamesAll.length; ++i) {
            if (!d.isMemberSelected(i)) continue;
            columnNames[idx] = columnNamesAll[i];
            columnNames[idx] = columnNames[idx].replaceAll("\u0095", "->");
            ++idx;
        }
        String[] subColumnNames = columnNames;
        int columns = d.getWidth();
        if (columns > 1) {
            subColumnNames = new String[columns * columnNames.length];
            int halfIdx = columnNames.length / 2;
            for (int i = 0; i < columns; ++i) {
                for (int j = 0; j < columnNames.length; ++j) {
                    subColumnNames[i * columnNames.length + j] = j == halfIdx ? i + 1 + "\n " + columnNames[j] : " \n " + columnNames[j];
                }
            }
        }
        final String[] allColumnNames = subColumnNames;
        AbstractTableModel tm = new AbstractTableModel(){
            private static final long serialVersionUID = -2176296469630678304L;
            CompoundDS compound;
            int[] orders;
            Datatype[] types;
            StringBuffer stringBuffer;
            int nFields;
            int nRows;
            int nSubColumns;
            {
                this.compound = (CompoundDS)DefaultTableView.this.dataset;
                this.orders = this.compound.getSelectedMemberOrders();
                this.types = this.compound.getSelectedMemberTypes();
                this.stringBuffer = new StringBuffer();
                this.nFields = ((List)DefaultTableView.this.dataValue).size();
                this.nRows = this.getRowCount();
                this.nSubColumns = this.nFields > 0 ? this.getColumnCount() / this.nFields : 0;
            }

            @Override
            public int getColumnCount() {
                return allColumnNames.length;
            }

            @Override
            public int getRowCount() {
                return rows;
            }

            @Override
            public String getColumnName(int col) {
                return allColumnNames[col];
            }

            @Override
            public Object getValueAt(int row, int col) {
                boolean isString;
                if (DefaultTableView.this.startEditing[0]) {
                    return "";
                }
                int fieldIdx = col;
                int rowIdx = row;
                if (this.nSubColumns > 1) {
                    int colIdx = col / this.nFields;
                    fieldIdx = col - colIdx * this.nFields;
                    rowIdx = row * this.orders[fieldIdx] * this.nSubColumns + colIdx * this.orders[fieldIdx];
                } else {
                    rowIdx = row * this.orders[fieldIdx];
                }
                Object colValue = ((List)DefaultTableView.this.dataValue).get(fieldIdx);
                if (colValue == null) {
                    return "Null";
                }
                this.stringBuffer.setLength(0);
                boolean bl = isString = this.types[fieldIdx].getDatatypeClass() == 3;
                if (isString && !this.compound.getConvertByteToString()) {
                    int strlen = this.types[fieldIdx].getDatatypeSize();
                    String str = new String((byte[])colValue, rowIdx * strlen, strlen);
                    int idx = str.indexOf(0);
                    if (idx > 0) {
                        str = str.substring(0, idx);
                    }
                    this.stringBuffer.append(str.trim());
                } else {
                    String cName;
                    int cIndex;
                    Datatype dtype = this.types[fieldIdx];
                    boolean isUINT64 = false;
                    if (dtype.isUnsigned() && (cIndex = (cName = colValue.getClass().getName()).lastIndexOf("[")) >= 0) {
                        isUINT64 = cName.charAt(cIndex + 1) == 'J';
                    }
                    for (int i = 0; i < this.orders[fieldIdx]; ++i) {
                        Long l;
                        Object theValue = Array.get(colValue, rowIdx + i);
                        if (isUINT64 && (l = (Long)theValue) < 0L) {
                            l = l << 1 >> 1;
                            BigInteger big1 = new BigInteger("9223372036854775808");
                            BigInteger big2 = new BigInteger(l.toString());
                            BigInteger big = big1.add(big2);
                            theValue = big.toString();
                        }
                        if (i > 0) {
                            this.stringBuffer.append(", ");
                        }
                        this.stringBuffer.append(theValue);
                    }
                }
                return this.stringBuffer;
            }
        };
        theTable = new JTable(tm){
            private static final long serialVersionUID = 3221288637329958074L;
            int lastSelectedRow;
            int lastSelectedColumn;
            {
                super(x0);
                this.lastSelectedRow = -1;
                this.lastSelectedColumn = -1;
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return !DefaultTableView.this.isReadOnly;
            }

            @Override
            public boolean editCellAt(int row, int column, EventObject e) {
                MouseEvent me;
                int mc;
                if (!this.isCellEditable(row, column)) {
                    return super.editCellAt(row, column, e);
                }
                if (e instanceof KeyEvent) {
                    KeyEvent ke = (KeyEvent)e;
                    if (ke.getID() == 401) {
                        ((DefaultTableView)DefaultTableView.this).startEditing[0] = true;
                    }
                } else if (e instanceof MouseEvent && (mc = (me = (MouseEvent)e).getClickCount()) > 1) {
                    DefaultTableView.this.currentEditingCellValue = this.getValueAt(row, column);
                }
                return super.editCellAt(row, column, e);
            }

            @Override
            public void editingStopped(ChangeEvent e) {
                int row = this.getEditingRow();
                int col = this.getEditingColumn();
                super.editingStopped(e);
                ((DefaultTableView)DefaultTableView.this).startEditing[0] = false;
                Object source = e.getSource();
                if (source instanceof CellEditor) {
                    CellEditor editor = (CellEditor)source;
                    String cellValue = (String)editor.getCellEditorValue();
                    try {
                        DefaultTableView.this.updateValueInMemory(cellValue, row, col);
                    }
                    catch (Exception ex) {
                        DefaultTableView.this.toolkit.beep();
                        JOptionPane.showMessageDialog(this, ex, DefaultTableView.this.getTitle(), 0);
                    }
                }
            }

            @Override
            public boolean isCellSelected(int row, int column) {
                if (this.lastSelectedRow == row && this.lastSelectedColumn == column) {
                    return super.isCellSelected(row, column);
                }
                this.lastSelectedRow = row;
                this.lastSelectedColumn = column;
                if (this.getSelectedRow() == row && this.getSelectedColumn() == column) {
                    DefaultTableView.this.cellLabel.setText(String.valueOf(rowStart + DefaultTableView.this.indexBase + row * rowStride) + ", " + DefaultTableView.this.table.getColumnName(column) + "  =  ");
                    DefaultTableView.this.cellValueField.setText(this.getValueAt(row, column).toString());
                }
                return super.isCellSelected(row, column);
            }
        };
        if (columns > 1) {
            MultiLineHeaderRenderer renderer = new MultiLineHeaderRenderer(columns, columnNames.length);
            Enumeration<TableColumn> local_enum = theTable.getColumnModel().getColumns();
            while (local_enum.hasMoreElements()) {
                local_enum.nextElement().setHeaderRenderer(renderer);
            }
        }
        return theTable;
    }

    private void gotoPage(long idx) {
        if (this.dataset.getRank() < 3 || idx == this.curFrame - (long)this.indexBase) {
            return;
        }
        if (this.isValueChanged) {
            this.updateValueInFile();
        }
        long[] start = this.dataset.getStartDims();
        int[] selectedIndex = this.dataset.getSelectedIndex();
        long[] dims = this.dataset.getDims();
        if (idx < 0L || idx >= dims[selectedIndex[2]]) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Frame number must be between" + this.indexBase + " and " + (dims[selectedIndex[2]] - 1L + (long)this.indexBase), this.getTitle(), 0);
            return;
        }
        start[selectedIndex[2]] = idx;
        this.curFrame = idx + (long)this.indexBase;
        this.dataset.clearData();
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.dataValue = this.dataset.getData();
            if (this.dataset instanceof ScalarDS) {
                ((ScalarDS)this.dataset).convertFromUnsignedC();
                this.dataValue = this.dataset.getData();
            }
        }
        catch (Exception ex) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.dataValue = null;
            JOptionPane.showMessageDialog(this, ex, this.getTitle(), 0);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.frameField.setText(String.valueOf(this.curFrame));
        this.updateUI();
    }

    private void copyData() {
        StringBuffer sb = new StringBuffer();
        int r0 = this.table.getSelectedRow();
        int c0 = this.table.getSelectedColumn();
        if (r0 < 0 || c0 < 0) {
            return;
        }
        int nr = this.table.getSelectedRowCount();
        int nc = this.table.getSelectedColumnCount();
        int r1 = r0 + nr;
        int c1 = c0 + nc;
        try {
            for (int i = r0; i < r1; ++i) {
                sb.append(this.table.getValueAt(i, c0).toString());
                for (int j = c0 + 1; j < c1; ++j) {
                    sb.append("\t");
                    sb.append(this.table.getValueAt(i, j).toString());
                }
                sb.append("\n");
            }
        }
        catch (OutOfMemoryError err) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), "Copying data to system clipboard failed. \nUsing \"export/import data\" for copying/pasting large data.", this.getTitle(), 0);
            return;
        }
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection contents = new StringSelection(sb.toString());
        cb.setContents(contents, null);
    }

    private void pasteData() {
        int pasteDataFlag = JOptionPane.showConfirmDialog(this, "Do you want to paste selected data ?", this.getTitle(), 0);
        if (pasteDataFlag == 1) {
            return;
        }
        int cols = this.table.getColumnCount();
        int rows = this.table.getRowCount();
        int r0 = this.table.getSelectedRow();
        int c0 = this.table.getSelectedColumn();
        if (c0 < 0) {
            c0 = 0;
        }
        if (r0 < 0) {
            r0 = 0;
        }
        int r = r0;
        int c = c0;
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        String line = "";
        try {
            String s = (String)cb.getData(DataFlavor.stringFlavor);
            StringTokenizer st = new StringTokenizer(s, "\n");
            while (st.hasMoreTokens() && r < rows) {
                line = st.nextToken();
                if (this.fixedDataLength < 1) {
                    StringTokenizer lt = new StringTokenizer(line, "\t");
                    while (lt.hasMoreTokens() && c < cols) {
                        try {
                            this.updateValueInMemory(lt.nextToken(), r, c);
                        }
                        catch (Exception ex) {
                            continue;
                        }
                        ++c;
                    }
                    ++r;
                    c = c0;
                    continue;
                }
                int n = line.length();
                for (int i = 0; i < n; i += this.fixedDataLength) {
                    try {
                        String theVal = line.substring(i, i + this.fixedDataLength);
                        this.updateValueInMemory(theVal, r, c);
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    ++c;
                }
            }
        }
        catch (Throwable ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex, this.getTitle(), 0);
        }
        this.table.updateUI();
    }

    private void importTextData(String fname) {
        int pasteDataFlag = JOptionPane.showConfirmDialog(this, "Do you want to paste selected data ?", this.getTitle(), 0);
        if (pasteDataFlag == 1) {
            return;
        }
        int cols = this.table.getColumnCount();
        int rows = this.table.getRowCount();
        int r0 = this.table.getSelectedRow();
        int c0 = this.table.getSelectedColumn();
        if (c0 < 0) {
            c0 = 0;
        }
        if (r0 < 0) {
            r0 = 0;
        }
        if (this.dataset instanceof CompoundDS) {
            c0 = 0;
        }
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(fname));
        }
        catch (FileNotFoundException ex) {
            return;
        }
        String line = null;
        StringTokenizer tokenizer1 = null;
        try {
            line = in.readLine();
        }
        catch (IOException ex) {
            try {
                in.close();
            }
            catch (IOException ex2) {
                // empty catch block
            }
            return;
        }
        String delName = ViewProperties.getDataDelimiter();
        String delimiter = "";
        if (this.dataset instanceof CompoundDS) {
            delimiter = "\t";
        } else if (delName.equalsIgnoreCase("Tab")) {
            delimiter = "\t";
        } else if (delName.equalsIgnoreCase("Space")) {
            delimiter = " " + delimiter;
        } else if (delName.equalsIgnoreCase("Comma")) {
            delimiter = ",";
        } else if (delName.equalsIgnoreCase("Colon")) {
            delimiter = ":";
        } else if (delName.equalsIgnoreCase("Semi-Colon")) {
            delimiter = ";";
        }
        String token = null;
        int c = c0;
        for (int r = r0; line != null && r < rows; ++r) {
            if (this.fixedDataLength > 0) {
                int n = line.length();
                for (int i = 0; i < n; i += this.fixedDataLength) {
                    try {
                        String theVal = line.substring(i, i + this.fixedDataLength);
                        this.updateValueInMemory(theVal, r, c);
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    ++c;
                }
            } else {
                try {
                    tokenizer1 = new StringTokenizer(line, delimiter);
                    while (tokenizer1.hasMoreTokens() && c < cols) {
                        token = tokenizer1.nextToken();
                        if (this.dataset instanceof ScalarDS) {
                            StringTokenizer tokenizer2 = new StringTokenizer(token);
                            while (tokenizer2.hasMoreTokens() && c < cols) {
                                this.updateValueInMemory(tokenizer2.nextToken(), r, c);
                                ++c;
                            }
                            continue;
                        }
                        this.updateValueInMemory(token, r, c);
                        ++c;
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, ex, this.getTitle(), 0);
                    try {
                        in.close();
                    }
                    catch (IOException ex2) {
                        // empty catch block
                    }
                    return;
                }
            }
            try {
                line = in.readLine();
            }
            catch (IOException ex) {
                line = null;
            }
            c = 0;
        }
        try {
            in.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        this.table.updateUI();
    }

    private void importBinaryData() {
        String currentDir = this.dataset.getFileFormat().getParent();
        JFileChooser fchooser = new JFileChooser(currentDir);
        fchooser.setFileFilter(DefaultFileFilter.getFileFilterBinary());
        int returnVal = fchooser.showOpenDialog(this);
        if (returnVal != 0) {
            return;
        }
        File choosedFile = fchooser.getSelectedFile();
        if (choosedFile == null) {
            return;
        }
        String fname = choosedFile.getAbsolutePath();
        int pasteDataFlag = JOptionPane.showConfirmDialog(this, "Do you want to paste selected data ?", this.getTitle(), 0);
        if (pasteDataFlag == 1) {
            return;
        }
        this.getBinaryDatafromFile(fname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getBinaryDatafromFile(String fileName) {
        String fname = fileName;
        FileInputStream inputFile = null;
        BufferedInputStream in = null;
        ByteBuffer byteBuffer = null;
        try {
            inputFile = new FileInputStream(fname);
            long fileSize = inputFile.getChannel().size();
            in = new BufferedInputStream(inputFile);
            Object data = this.dataset.getData();
            int datasetSize = Array.getLength(data);
            String cname = data.getClass().getName();
            char dname = cname.charAt(cname.lastIndexOf("[") + 1);
            if (dname == 'B') {
                long datasetByteSize = datasetSize;
                byteBuffer = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    byteBuffer.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                }
                int bufferSize = (int)Math.min(fileSize, datasetByteSize);
                int remainingSize = bufferSize - 0x200000;
                int allocValue = 0;
                int iterationNumber = 0;
                byte[] byteArray = new byte[0x200000];
                do {
                    allocValue = remainingSize <= 0 ? remainingSize + 0x200000 : 0x200000;
                    in.read(byteBuffer.array(), 0, allocValue);
                    byteBuffer.get(byteArray, 0, allocValue);
                    System.arraycopy(byteArray, 0, this.dataValue, iterationNumber * 0x200000, allocValue);
                    byteBuffer.clear();
                    ++iterationNumber;
                } while ((remainingSize -= 0x200000) > -2097152);
                this.isValueChanged = true;
            } else if (dname == 'S') {
                long datasetShortSize = datasetSize * 2;
                byteBuffer = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    byteBuffer.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                }
                int bufferSize = (int)Math.min(fileSize, datasetShortSize);
                int remainingSize = bufferSize - 0x200000;
                int allocValue = 0;
                int iterationNumber = 0;
                ShortBuffer sb = byteBuffer.asShortBuffer();
                short[] shortArray = new short[0x100000];
                do {
                    allocValue = remainingSize <= 0 ? remainingSize + 0x200000 : 0x200000;
                    in.read(byteBuffer.array(), 0, allocValue);
                    sb.get(shortArray, 0, allocValue / 2);
                    System.arraycopy(shortArray, 0, this.dataValue, iterationNumber * 0x100000, allocValue / 2);
                    byteBuffer.clear();
                    sb.clear();
                    ++iterationNumber;
                } while ((remainingSize -= 0x200000) > -2097152);
                this.isValueChanged = true;
            } else if (dname == 'I') {
                long datasetIntSize = datasetSize * 4;
                byteBuffer = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    byteBuffer.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                }
                int bufferSize = (int)Math.min(fileSize, datasetIntSize);
                int remainingSize = bufferSize - 0x200000;
                int allocValue = 0;
                int iterationNumber = 0;
                int[] intArray = new int[524288];
                byte[] tmpBuf = byteBuffer.array();
                IntBuffer ib = byteBuffer.asIntBuffer();
                do {
                    allocValue = remainingSize <= 0 ? remainingSize + 0x200000 : 0x200000;
                    in.read(tmpBuf, 0, allocValue);
                    ib.get(intArray, 0, allocValue / 4);
                    System.arraycopy(intArray, 0, this.dataValue, iterationNumber * 524288, allocValue / 4);
                    byteBuffer.clear();
                    ib.clear();
                    ++iterationNumber;
                } while ((remainingSize -= 0x200000) > -2097152);
                this.isValueChanged = true;
            } else if (dname == 'J') {
                long datasetLongSize = datasetSize * 8;
                byteBuffer = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    byteBuffer.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                }
                int bufferSize = (int)Math.min(fileSize, datasetLongSize);
                int remainingSize = bufferSize - 0x200000;
                int allocValue = 0;
                int iterationNumber = 0;
                long[] longArray = new long[262144];
                LongBuffer lb = byteBuffer.asLongBuffer();
                do {
                    allocValue = remainingSize <= 0 ? remainingSize + 0x200000 : 0x200000;
                    in.read(byteBuffer.array(), 0, allocValue);
                    lb.get(longArray, 0, allocValue / 8);
                    System.arraycopy(longArray, 0, this.dataValue, iterationNumber * 262144, allocValue / 8);
                    byteBuffer.clear();
                    lb.clear();
                    ++iterationNumber;
                } while ((remainingSize -= 0x200000) > -2097152);
                this.isValueChanged = true;
            } else if (dname == 'F') {
                long datasetFloatSize = datasetSize * 4;
                byteBuffer = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    byteBuffer.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                }
                int bufferSize = (int)Math.min(fileSize, datasetFloatSize);
                int remainingSize = bufferSize - 0x200000;
                int allocValue = 0;
                int iterationNumber = 0;
                FloatBuffer fb = byteBuffer.asFloatBuffer();
                float[] floatArray = new float[524288];
                do {
                    allocValue = remainingSize <= 0 ? remainingSize + 0x200000 : 0x200000;
                    in.read(byteBuffer.array(), 0, allocValue);
                    fb.get(floatArray, 0, allocValue / 4);
                    System.arraycopy(floatArray, 0, this.dataValue, iterationNumber * 524288, allocValue / 4);
                    byteBuffer.clear();
                    fb.clear();
                    ++iterationNumber;
                } while ((remainingSize -= 0x200000) > -2097152);
                this.isValueChanged = true;
            } else if (dname == 'D') {
                long datasetDoubleSize = datasetSize * 8;
                byteBuffer = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    byteBuffer.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    byteBuffer.order(ByteOrder.BIG_ENDIAN);
                }
                int bufferSize = (int)Math.min(fileSize, datasetDoubleSize);
                int remainingSize = bufferSize - 0x200000;
                int allocValue = 0;
                int iterationNumber = 0;
                DoubleBuffer db = byteBuffer.asDoubleBuffer();
                double[] doubleArray = new double[262144];
                do {
                    allocValue = remainingSize <= 0 ? remainingSize + 0x200000 : 0x200000;
                    in.read(byteBuffer.array(), 0, allocValue);
                    db.get(doubleArray, 0, allocValue / 8);
                    System.arraycopy(doubleArray, 0, this.dataValue, iterationNumber * 262144, allocValue / 8);
                    byteBuffer.clear();
                    db.clear();
                    ++iterationNumber;
                } while ((remainingSize -= 0x200000) > -2097152);
                this.isValueChanged = true;
            }
        }
        catch (Exception es) {
            es.printStackTrace();
        }
        finally {
            try {
                in.close();
                inputFile.close();
            }
            catch (IOException ex) {}
        }
        this.table.updateUI();
    }

    private void saveAsText() throws Exception {
        int newFileFlag;
        JFileChooser fchooser = new JFileChooser(this.dataset.getFile());
        fchooser.setFileFilter(DefaultFileFilter.getFileFilterText());
        fchooser.setDialogTitle("Save Current Data To Text File --- " + this.dataset.getName());
        File choosedFile = new File(this.dataset.getName() + ".txt");
        fchooser.setSelectedFile(choosedFile);
        int returnVal = fchooser.showSaveDialog(this);
        if (returnVal != 0) {
            return;
        }
        choosedFile = fchooser.getSelectedFile();
        if (choosedFile == null) {
            return;
        }
        String fname = choosedFile.getAbsolutePath();
        List<FileFormat> fileList = this.viewer.getTreeView().getCurrentFiles();
        if (fileList != null) {
            FileFormat theFile2 = null;
            for (FileFormat theFile2 : fileList) {
                if (!theFile2.getFilePath().equals(fname)) continue;
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Unable to save data to file \"" + fname + "\". \nThe file is being used.", this.getTitle(), 0);
                return;
            }
        }
        if (choosedFile.exists() && (newFileFlag = JOptionPane.showConfirmDialog(this, "File exists. Do you want to replace it ?", this.getTitle(), 0)) == 1) {
            return;
        }
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(choosedFile)));
        String delName = ViewProperties.getDataDelimiter();
        String delimiter = "";
        if (this.dataset instanceof CompoundDS) {
            delimiter = "\t";
        }
        if (delName.equalsIgnoreCase("Tab")) {
            delimiter = "\t";
        } else if (delName.equalsIgnoreCase("Space")) {
            delimiter = " " + delimiter;
        } else if (delName.equalsIgnoreCase("Comma")) {
            delimiter = "," + delimiter;
        } else if (delName.equalsIgnoreCase("Colon")) {
            delimiter = ":" + delimiter;
        } else if (delName.equalsIgnoreCase("Semi-Colon")) {
            delimiter = ";" + delimiter;
        }
        int cols = this.table.getColumnCount();
        int rows = this.table.getRowCount();
        for (int i = 0; i < rows; ++i) {
            out.print(this.table.getValueAt(i, 0));
            for (int j = 1; j < cols; ++j) {
                out.print(delimiter);
                out.print(this.table.getValueAt(i, j));
            }
            out.println();
        }
        out.flush();
        out.close();
        this.viewer.showStatus("Data save to: " + fname);
    }

    private void saveAsBinary() throws Exception {
        int newFileFlag;
        JFileChooser fchooser = new JFileChooser(this.dataset.getFile());
        fchooser.setFileFilter(DefaultFileFilter.getFileFilterBinary());
        fchooser.setDialogTitle("Save Current Data To Binary File --- " + this.dataset.getName());
        File choosedFile = new File(this.dataset.getName() + ".bin");
        fchooser.setSelectedFile(choosedFile);
        int returnVal = fchooser.showSaveDialog(this);
        if (returnVal != 0) {
            return;
        }
        choosedFile = fchooser.getSelectedFile();
        if (choosedFile == null) {
            return;
        }
        String fname = choosedFile.getAbsolutePath();
        List<FileFormat> fileList = this.viewer.getTreeView().getCurrentFiles();
        if (fileList != null) {
            FileFormat theFile2 = null;
            for (FileFormat theFile2 : fileList) {
                if (!theFile2.getFilePath().equals(fname)) continue;
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "Unable to save data to file \"" + fname + "\". \nThe file is being used.", this.getTitle(), 0);
                return;
            }
        }
        if (choosedFile.exists() && (newFileFlag = JOptionPane.showConfirmDialog(this, "File exists. Do you want to replace it ?", this.getTitle(), 0)) == 1) {
            return;
        }
        FileOutputStream outputFile = new FileOutputStream(choosedFile);
        DataOutputStream out = new DataOutputStream(outputFile);
        if (this.dataset instanceof ScalarDS) {
            Object data = this.dataset.getData();
            String cname = data.getClass().getName();
            char dname = cname.charAt(cname.lastIndexOf("[") + 1);
            ByteBuffer bb = null;
            int size = Array.getLength(data);
            if (dname == 'B') {
                byte[] bdata = new byte[size];
                bdata = (byte[])data;
                bb = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    bb.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    bb.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    bb.order(ByteOrder.BIG_ENDIAN);
                }
                int remainingSize = size - 0x200000;
                int allocValue = 0;
                int iterationNumber = 0;
                do {
                    allocValue = remainingSize <= 0 ? remainingSize + 0x200000 : 0x200000;
                    bb.clear();
                    bb.put(bdata, iterationNumber * 0x200000, allocValue);
                    out.write(bb.array(), 0, allocValue);
                    ++iterationNumber;
                } while ((remainingSize -= 0x200000) > -2097152);
                out.flush();
                out.close();
            } else if (dname == 'S') {
                short[] sdata = new short[size];
                sdata = (short[])data;
                bb = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    bb.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    bb.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    bb.order(ByteOrder.BIG_ENDIAN);
                }
                ShortBuffer sb = bb.asShortBuffer();
                int remainingSize = size - 0x100000;
                int allocValue = 0;
                int iterationNumber = 0;
                do {
                    allocValue = remainingSize <= 0 ? remainingSize + 0x100000 : 0x100000;
                    bb.clear();
                    sb.clear();
                    sb.put(sdata, iterationNumber * 0x100000, allocValue);
                    out.write(bb.array(), 0, allocValue * 2);
                    ++iterationNumber;
                } while ((remainingSize -= 0x100000) > -1048576);
                out.flush();
                out.close();
            } else if (dname == 'I') {
                int[] idata = new int[size];
                idata = (int[])data;
                bb = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    bb.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    bb.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    bb.order(ByteOrder.BIG_ENDIAN);
                }
                IntBuffer ib = bb.asIntBuffer();
                int remainingSize = size - 524288;
                int allocValue = 0;
                int iterationNumber = 0;
                do {
                    allocValue = remainingSize <= 0 ? remainingSize + 524288 : 524288;
                    bb.clear();
                    ib.clear();
                    ib.put(idata, iterationNumber * 524288, allocValue);
                    out.write(bb.array(), 0, allocValue * 4);
                    ++iterationNumber;
                } while ((remainingSize -= 524288) > -524288);
                out.flush();
                out.close();
            } else if (dname == 'J') {
                long[] ldata = new long[size];
                ldata = (long[])data;
                bb = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    bb.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    bb.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    bb.order(ByteOrder.BIG_ENDIAN);
                }
                LongBuffer lb = bb.asLongBuffer();
                int remainingSize = size - 262144;
                int allocValue = 0;
                int iterationNumber = 0;
                do {
                    allocValue = remainingSize <= 0 ? remainingSize + 262144 : 262144;
                    bb.clear();
                    lb.clear();
                    lb.put(ldata, iterationNumber * 262144, allocValue);
                    out.write(bb.array(), 0, allocValue * 8);
                    ++iterationNumber;
                } while ((remainingSize -= 262144) > -262144);
                out.flush();
                out.close();
            } else if (dname == 'F') {
                float[] fdata = new float[size];
                fdata = (float[])data;
                bb = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    bb.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    bb.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    bb.order(ByteOrder.BIG_ENDIAN);
                }
                FloatBuffer fb = bb.asFloatBuffer();
                int remainingSize = size - 524288;
                int allocValue = 0;
                int iterationNumber = 0;
                do {
                    allocValue = remainingSize <= 0 ? remainingSize + 524288 : 524288;
                    bb.clear();
                    fb.clear();
                    fb.put(fdata, iterationNumber * 524288, allocValue);
                    out.write(bb.array(), 0, allocValue * 4);
                    ++iterationNumber;
                } while ((remainingSize -= 524288) > -524288);
                out.flush();
                out.close();
            } else if (dname == 'D') {
                double[] ddata = new double[size];
                ddata = (double[])data;
                bb = ByteBuffer.allocate(0x200000);
                if (this.binaryOrder == 1) {
                    bb.order(ByteOrder.nativeOrder());
                } else if (this.binaryOrder == 2) {
                    bb.order(ByteOrder.LITTLE_ENDIAN);
                } else if (this.binaryOrder == 3) {
                    bb.order(ByteOrder.BIG_ENDIAN);
                }
                DoubleBuffer db = bb.asDoubleBuffer();
                int remainingSize = size - 262144;
                int allocValue = 0;
                int iterationNumber = 0;
                do {
                    allocValue = remainingSize <= 0 ? remainingSize + 262144 : 262144;
                    bb.clear();
                    db.clear();
                    db.put(ddata, iterationNumber * 262144, allocValue);
                    out.write(bb.array(), 0, allocValue * 8);
                    ++iterationNumber;
                } while ((remainingSize -= 262144) > -262144);
                out.flush();
                out.close();
            }
        }
        this.viewer.showStatus("Data save to: " + fname);
    }

    @Override
    public void updateValueInFile() {
        if (this.isReadOnly || this.showAsBin || this.showAsHex) {
            return;
        }
        if (!this.isValueChanged) {
            return;
        }
        try {
            this.dataset.write();
        }
        catch (Exception ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex, this.getTitle(), 0);
            return;
        }
        this.isValueChanged = false;
    }

    private void selectAll() throws Exception {
        this.table.selectAll();
    }

    private void mathConversion() throws Exception {
        if (this.isReadOnly) {
            return;
        }
        int cols = this.table.getSelectedColumnCount();
        if (this.dataset instanceof CompoundDS && cols > 1) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Please select one colunm a time for math conversion for compound dataset.", this.getTitle(), 0);
            return;
        }
        Object theData = this.getSelectedData();
        if (theData == null) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "No data is selected.", this.getTitle(), 0);
            return;
        }
        MathConversionDialog dialog = new MathConversionDialog((JFrame)((Object)this.viewer), theData);
        dialog.setVisible(true);
        if (dialog.isConverted()) {
            if (this.dataset instanceof CompoundDS) {
                Object colData = null;
                try {
                    colData = ((List)this.dataset.getData()).get(this.table.getSelectedColumn());
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (colData != null) {
                    int size = Array.getLength(theData);
                    System.arraycopy(theData, 0, colData, 0, size);
                }
            } else {
                int rows = this.table.getSelectedRowCount();
                int r0 = this.table.getSelectedRow();
                int c0 = this.table.getSelectedColumn();
                int w = this.table.getColumnCount();
                int idx_src = 0;
                int idx_dst = 0;
                for (int i = 0; i < rows; ++i) {
                    idx_dst = (r0 + i) * w + c0;
                    System.arraycopy(theData, idx_src, this.dataValue, idx_dst, cols);
                    idx_src += cols;
                }
            }
            theData = null;
            System.gc();
            this.table.updateUI();
            this.isValueChanged = true;
        }
    }

    private void updateValueInMemory(String cellValue, int row, int col) throws Exception {
        if (this.currentEditingCellValue != null && this.currentEditingCellValue.toString().equals(cellValue)) {
            return;
        }
        if (this.dataset instanceof ScalarDS) {
            this.updateScalarData(cellValue, row, col);
        } else if (this.dataset instanceof CompoundDS) {
            this.updateCompoundData(cellValue, row, col);
        }
    }

    private void updateScalarData(String cellValue, int row, int col) throws Exception {
        if (!(this.dataset instanceof ScalarDS) || cellValue == null || (cellValue = cellValue.trim()) == null || this.showAsBin || this.showAsHex) {
            return;
        }
        int i = 0;
        i = this.isDataTransposed ? col * this.table.getRowCount() + row : row * this.table.getColumnCount() + col;
        ScalarDS sds = (ScalarDS)this.dataset;
        boolean isUnsigned = sds.isUnsigned();
        if (isUnsigned) {
            long lvalue = -1L;
            long maxValue = Long.MAX_VALUE;
            lvalue = Long.parseLong(cellValue);
            if (lvalue < 0L) {
                throw new NumberFormatException("Negative value for unsigned integer: " + lvalue);
            }
            if (this.NT == 'S') {
                maxValue = 255L;
            } else if (this.NT == 'I') {
                maxValue = 65535L;
            } else if (this.NT == 'J') {
                maxValue = 0xFFFFFFFFL;
            }
            if (lvalue < 0L || lvalue > maxValue) {
                throw new NumberFormatException("Data value is out of range: " + lvalue);
            }
        }
        switch (this.NT) {
            case 'B': {
                byte bvalue = 0;
                bvalue = Byte.parseByte(cellValue);
                Array.setByte(this.dataValue, i, bvalue);
                break;
            }
            case 'S': {
                short svalue = 0;
                svalue = Short.parseShort(cellValue);
                Array.setShort(this.dataValue, i, svalue);
                break;
            }
            case 'I': {
                int ivalue = 0;
                ivalue = Integer.parseInt(cellValue);
                Array.setInt(this.dataValue, i, ivalue);
                break;
            }
            case 'J': {
                long lvalue = 0L;
                lvalue = Long.parseLong(cellValue);
                Array.setLong(this.dataValue, i, lvalue);
                break;
            }
            case 'F': {
                float fvalue = 0.0f;
                fvalue = Float.parseFloat(cellValue);
                Array.setFloat(this.dataValue, i, fvalue);
                break;
            }
            case 'D': {
                double dvalue = 0.0;
                dvalue = Double.parseDouble(cellValue);
                Array.setDouble(this.dataValue, i, dvalue);
                break;
            }
            default: {
                Array.set(this.dataValue, i, cellValue);
            }
        }
        this.isValueChanged = true;
    }

    private void updateCompoundData(String cellValue, int row, int col) throws Exception {
        StringTokenizer st;
        if (!(this.dataset instanceof CompoundDS) || cellValue == null || (cellValue = cellValue.trim()) == null) {
            return;
        }
        CompoundDS compDS = (CompoundDS)this.dataset;
        List cdata = (List)compDS.getData();
        int[] orders = compDS.getSelectedMemberOrders();
        Datatype[] types = compDS.getSelectedMemberTypes();
        int nFields = cdata.size();
        int nSubColumns = this.table.getColumnCount() / nFields;
        int nRows = this.table.getRowCount();
        int column = col;
        int offset = 0;
        int morder = 1;
        if (nSubColumns > 1) {
            int colIdx = col / nFields;
            column = col - colIdx * nFields;
            offset = row * orders[column] * nSubColumns + colIdx * orders[column];
        } else {
            offset = row * orders[column];
        }
        morder = orders[column];
        Object mdata = cdata.get(column);
        if (Array.get(mdata, 0) instanceof String) {
            Array.set(mdata, offset, cellValue);
            this.isValueChanged = true;
            return;
        }
        if (types[column].getDatatypeClass() == 3) {
            int strlen = types[column].getDatatypeSize();
            byte[] bytes = cellValue.getBytes();
            byte[] bData = (byte[])mdata;
            int n = Math.min(strlen, bytes.length);
            System.arraycopy(bytes, 0, bData, offset *= strlen, n);
            offset += n;
            n = strlen - bytes.length;
            for (int i = 0; i < n; ++i) {
                bData[offset + i] = 32;
            }
            this.isValueChanged = true;
            return;
        }
        int mNT = 32;
        String cName = mdata.getClass().getName();
        int cIndex = cName.lastIndexOf("[");
        if (cIndex >= 0) {
            mNT = cName.charAt(cIndex + 1);
        }
        if ((st = new StringTokenizer(cellValue, ",")).countTokens() < morder) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Number of data point < " + morder + ".", this.getTitle(), 0);
            return;
        }
        String token = "";
        this.isValueChanged = true;
        switch (mNT) {
            case 66: {
                byte bvalue = 0;
                for (int i = 0; i < morder; ++i) {
                    token = st.nextToken().trim();
                    bvalue = Byte.parseByte(token);
                    Array.setByte(mdata, offset + i, bvalue);
                }
                break;
            }
            case 83: {
                short svalue = 0;
                for (int i = 0; i < morder; ++i) {
                    token = st.nextToken().trim();
                    svalue = Short.parseShort(token);
                    Array.setShort(mdata, offset + i, svalue);
                }
                break;
            }
            case 73: {
                int ivalue = 0;
                for (int i = 0; i < morder; ++i) {
                    token = st.nextToken().trim();
                    ivalue = Integer.parseInt(token);
                    Array.setInt(mdata, offset + i, ivalue);
                }
                break;
            }
            case 74: {
                long lvalue = 0L;
                for (int i = 0; i < morder; ++i) {
                    token = st.nextToken().trim();
                    lvalue = Long.parseLong(token);
                    Array.setLong(mdata, offset + i, lvalue);
                }
                break;
            }
            case 70: {
                float fvalue = 0.0f;
                for (int i = 0; i < morder; ++i) {
                    token = st.nextToken().trim();
                    fvalue = Float.parseFloat(token);
                    Array.setFloat(mdata, offset + i, fvalue);
                }
                break;
            }
            case 68: {
                double dvalue = 0.0;
                for (int i = 0; i < morder; ++i) {
                    token = st.nextToken().trim();
                    dvalue = Double.parseDouble(token);
                    Array.setDouble(mdata, offset + i, dvalue);
                }
                break;
            }
            default: {
                this.isValueChanged = false;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.isRegRef && !this.isObjRef) {
            return;
        }
        int eMod = e.getModifiers();
        if (e.isPopupTrigger() || eMod == 4 || System.getProperty("os.name").startsWith("Mac") && eMod == 18) {
            if (this.popupMenu != null) {
                this.popupMenu.show((JComponent)e.getSource(), e.getX(), e.getY());
            }
        } else if (e.getClickCount() == 2) {
            this.viewType = ViewType.TABLE;
            Object theData = this.getSelectedData();
            if (theData == null) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog(this, "No data selected.", this.getTitle(), 0);
                return;
            }
            int len = Array.getLength(theData);
            for (int i = 0; i < len; ++i) {
                if (this.isRegRef) {
                    this.showRegRefData((String)Array.get(theData, i));
                    continue;
                }
                if (!this.isObjRef) continue;
                this.showObjRefData(Array.getLong(theData, i));
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private JPopupMenu createPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = new JMenuItem("Show As Table");
        item.setMnemonic(84);
        item.addActionListener(this);
        item.setActionCommand("Show data as table");
        menu.add(item);
        item = new JMenuItem("Show As Image");
        item.setMnemonic(73);
        item.addActionListener(this);
        item.setActionCommand("Show data as image");
        menu.add(item);
        return menu;
    }

    private void showObjRefData(long ref) {
        long[] oid = new long[]{ref};
        HObject obj = FileFormat.findObject(this.dataset.getFileFormat(), oid);
        if (obj == null || !(obj instanceof ScalarDS)) {
            return;
        }
        ScalarDS dset = (ScalarDS)obj;
        ScalarDS dset_copy = null;
        Constructor<?> constructor = null;
        Object[] paramObj = null;
        Object data = null;
        try {
            Class[] paramClass = new Class[]{FileFormat.class, String.class, String.class};
            constructor = dset.getClass().getConstructor(paramClass);
            paramObj = new Object[]{dset.getFileFormat(), dset.getName(), dset.getPath()};
            dset_copy = (ScalarDS)constructor.newInstance(paramObj);
            data = dset_copy.getData();
        }
        catch (Exception ex) {
            data = null;
        }
        if (data == null) {
            return;
        }
        StringBuffer titleSB = new StringBuffer();
        Font font = this.getFont();
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLUE, 3), "Data pointed by object reference", 3, 2, font, Color.RED));
        JInternalFrame dataView = null;
        HashMap<ViewProperties.DATA_VIEW_KEY, ScalarDS> map = new HashMap<ViewProperties.DATA_VIEW_KEY, ScalarDS>(1);
        map.put(ViewProperties.DATA_VIEW_KEY.OBJECT, dset_copy);
        switch (this.viewType) {
            case TEXT: {
                dataView = new DefaultTextView(this.viewer, map);
                break;
            }
            case IMAGE: {
                dataView = new DefaultImageView(this.viewer, map);
                break;
            }
            default: {
                dataView = new DefaultTableView(this.viewer, map);
            }
        }
        if (dataView != null) {
            this.viewer.addDataView((DataView)((Object)dataView));
            titleSB.append(dset_copy.getName());
            titleSB.append("  -  ");
            titleSB.append(dset_copy.getPath());
            titleSB.append("  -  ");
            titleSB.append(this.dataset.getFile());
            dataView.setTitle(titleSB.toString());
            dataView.setBorder(border);
        }
    }

    private void showRegRefData(String reg) {
        boolean isPointSelection = false;
        if (reg == null || reg.length() <= 0) {
            return;
        }
        isPointSelection = reg.indexOf(45) <= 0;
        String oidStr = reg.substring(reg.indexOf(58) + 1, reg.indexOf(32));
        long[] oid = new long[]{-1L};
        try {
            oid[0] = Long.valueOf(oidStr);
        }
        catch (Exception ex) {
            return;
        }
        String regStr = reg.substring(reg.indexOf(123) + 1, reg.indexOf(125));
        if (regStr == null || regStr.length() <= 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(regStr);
        int nSelections = st.countTokens();
        if (nSelections <= 0) {
            return;
        }
        HObject obj = FileFormat.findObject(this.dataset.getFileFormat(), oid);
        if (obj == null || !(obj instanceof ScalarDS)) {
            return;
        }
        ScalarDS dset = (ScalarDS)obj;
        ScalarDS dset_copy = null;
        Constructor<?> constructor = null;
        Object[] paramObj = null;
        try {
            Class[] paramClass = new Class[]{FileFormat.class, String.class, String.class};
            constructor = dset.getClass().getConstructor(paramClass);
            paramObj = new Object[]{dset.getFileFormat(), dset.getName(), dset.getPath()};
        }
        catch (Exception ex) {
            constructor = null;
        }
        StringBuffer titleSB = new StringBuffer();
        Font font = this.getFont();
        CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLUE, 3), "Data pointed by region reference", 3, 2, font, Color.RED));
        while (st.hasMoreTokens()) {
            try {
                dset_copy = (ScalarDS)constructor.newInstance(paramObj);
            }
            catch (Exception ex) {
                continue;
            }
            if (dset_copy == null) continue;
            try {
                dset_copy.init();
            }
            catch (Exception ex) {
                continue;
            }
            int rank = dset_copy.getRank();
            long[] start = dset_copy.getStartDims();
            long[] count = dset_copy.getSelectedDims();
            int idx = 0;
            String sizeStr = null;
            String token = st.nextToken();
            titleSB.setLength(0);
            titleSB.append(token);
            titleSB.append(" at ");
            token = token.replace('(', ' ');
            token = token.replace(')', ' ');
            if (isPointSelection) {
                StringTokenizer tmp = new StringTokenizer(token, ",");
                while (tmp.hasMoreTokens()) {
                    count[idx] = 1L;
                    sizeStr = tmp.nextToken().trim();
                    start[idx] = Long.valueOf(sizeStr);
                    ++idx;
                }
            } else {
                String startStr = token.substring(0, token.indexOf(45));
                String endStr = token.substring(token.indexOf(45) + 1);
                StringTokenizer tmp = new StringTokenizer(startStr, ",");
                while (tmp.hasMoreTokens()) {
                    sizeStr = tmp.nextToken().trim();
                    start[idx] = Long.valueOf(sizeStr);
                    ++idx;
                }
                idx = 0;
                tmp = new StringTokenizer(endStr, ",");
                while (tmp.hasMoreTokens()) {
                    sizeStr = tmp.nextToken().trim();
                    count[idx] = Long.valueOf(sizeStr) - start[idx] + 1L;
                    ++idx;
                }
            }
            Object data = null;
            try {
                data = dset_copy.getData();
            }
            catch (Exception ex) {
                data = null;
            }
            JInternalFrame dataView = null;
            HashMap<ViewProperties.DATA_VIEW_KEY, ScalarDS> map = new HashMap<ViewProperties.DATA_VIEW_KEY, ScalarDS>(1);
            map.put(ViewProperties.DATA_VIEW_KEY.OBJECT, dset_copy);
            switch (this.viewType) {
                case TEXT: {
                    dataView = new DefaultTextView(this.viewer, map);
                    break;
                }
                case IMAGE: {
                    dataView = new DefaultImageView(this.viewer, map);
                    break;
                }
                default: {
                    dataView = new DefaultTableView(this.viewer, map);
                }
            }
            if (dataView == null) continue;
            this.viewer.addDataView((DataView)((Object)dataView));
            titleSB.append(dset_copy.getName());
            titleSB.append("  -  ");
            titleSB.append(dset_copy.getPath());
            titleSB.append("  -  ");
            titleSB.append(this.dataset.getFile());
            dataView.setTitle(titleSB.toString());
            dataView.setBorder(border);
        }
    }

    static /* synthetic */ char access$100(DefaultTableView x0) {
        return x0.NT;
    }

    private class MultiLineHeaderRenderer
    extends JList
    implements TableCellRenderer {
        private static final long serialVersionUID = -3697496960833719169L;
        private final CompoundBorder subBorder = new CompoundBorder(new MatteBorder(1, 0, 1, 0, Color.darkGray), new MatteBorder(1, 0, 1, 0, Color.white));
        private final CompoundBorder majorBorder = new CompoundBorder(new MatteBorder(1, 1, 1, 0, Color.darkGray), new MatteBorder(1, 2, 1, 0, Color.white));
        Vector lines = new Vector();
        int nMajorcolumns = 1;
        int nSubcolumns = 1;

        public MultiLineHeaderRenderer(int majorColumns, int subColumns) {
            this.nMajorcolumns = majorColumns;
            this.nSubcolumns = subColumns;
            this.setOpaque(true);
            this.setForeground(UIManager.getColor("TableHeader.foreground"));
            this.setBackground(UIManager.getColor("TableHeader.background"));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setFont(table.getFont());
            String str = value == null ? "" : value.toString();
            BufferedReader br = new BufferedReader(new StringReader(str));
            this.lines.clear();
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    this.lines.addElement(line);
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (column / this.nSubcolumns * this.nSubcolumns == column) {
                this.setBorder(this.majorBorder);
            } else {
                this.setBorder(this.subBorder);
            }
            this.setListData(this.lines);
            return this;
        }
    }

    private class RowHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = -8963879626159783226L;

        public RowHeaderRenderer() {
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setBackground(Color.lightGray);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setFont(table.getFont());
            if (value != null) {
                this.setText(value.toString());
            }
            return this;
        }
    }

    private class RowHeader
    extends JTable {
        private static final long serialVersionUID = -1548007702499873626L;
        private int currentRowIndex = -1;
        private int lastRowIndex = -1;
        private JTable parentTable;

        public RowHeader(JTable pTable, Dataset dset) {
            long[] startArray = dset.getStartDims();
            long[] strideArray = dset.getStride();
            int[] selectedIndex = dset.getSelectedIndex();
            final int start = (int)startArray[selectedIndex[0]];
            final int stride = (int)strideArray[selectedIndex[0]];
            final int rowCount = pTable.getRowCount();
            this.parentTable = pTable;
            AbstractTableModel tm = new AbstractTableModel(){
                private static final long serialVersionUID = -8117073107569884677L;

                @Override
                public int getColumnCount() {
                    return 1;
                }

                @Override
                public int getRowCount() {
                    return rowCount;
                }

                @Override
                public String getColumnName(int col) {
                    return " ";
                }

                @Override
                public Object getValueAt(int row, int column) {
                    return String.valueOf(start + DefaultTableView.this.indexBase + row * stride);
                }
            };
            this.setModel(tm);
            TableColumn col = this.getColumnModel().getColumn(0);
            col.setCellRenderer(new RowHeaderRenderer());
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (this.parentTable == null) {
                return;
            }
            int[] rows = this.getSelectedRows();
            if (rows == null || rows.length == 0) {
                return;
            }
            this.parentTable.clearSelection();
            this.parentTable.setRowSelectionInterval(rows[0], rows[rows.length - 1]);
            this.parentTable.setColumnSelectionInterval(0, this.parentTable.getColumnCount() - 1);
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
            if (e.getID() == 506) {
                int colEnd = this.rowAtPoint(e.getPoint());
                if (colEnd < 0) {
                    colEnd = 0;
                }
                if (this.currentRowIndex < 0) {
                    this.currentRowIndex = 0;
                }
                this.parentTable.clearSelection();
                if (colEnd > this.currentRowIndex) {
                    this.parentTable.setRowSelectionInterval(this.currentRowIndex, colEnd);
                } else {
                    this.parentTable.setRowSelectionInterval(colEnd, this.currentRowIndex);
                }
                this.parentTable.setColumnSelectionInterval(0, this.parentTable.getColumnCount() - 1);
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            int mouseID = e.getID();
            if (mouseID == 500) {
                if (this.currentRowIndex < 0) {
                    return;
                }
                if (e.isControlDown()) {
                    this.parentTable.addRowSelectionInterval(this.currentRowIndex, this.currentRowIndex);
                } else if (e.isShiftDown()) {
                    if (this.lastRowIndex < 0) {
                        this.parentTable.addRowSelectionInterval(0, this.currentRowIndex);
                    } else if (this.lastRowIndex < this.currentRowIndex) {
                        this.parentTable.addRowSelectionInterval(this.lastRowIndex, this.currentRowIndex);
                    } else {
                        this.parentTable.addRowSelectionInterval(this.currentRowIndex, this.lastRowIndex);
                    }
                } else {
                    this.parentTable.clearSelection();
                    this.parentTable.setRowSelectionInterval(this.currentRowIndex, this.currentRowIndex);
                }
                this.lastRowIndex = this.currentRowIndex;
                this.parentTable.setColumnSelectionInterval(0, this.parentTable.getColumnCount() - 1);
            } else if (mouseID == 501) {
                this.currentRowIndex = this.rowAtPoint(e.getPoint());
            }
        }
    }

    private class ColumnHeader
    extends JTableHeader {
        private static final long serialVersionUID = -3179653809792147055L;
        private int currentColumnIndex;
        private int lastColumnIndex;
        private JTable parentTable;

        public ColumnHeader(JTable theTable) {
            super(theTable.getColumnModel());
            this.currentColumnIndex = -1;
            this.lastColumnIndex = -1;
            this.parentTable = theTable;
            this.setReorderingAllowed(false);
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent e) {
            super.processMouseMotionEvent(e);
            if (e.getID() == 506) {
                if (this.getResizingColumn() != null) {
                    return;
                }
                int colEnd = this.columnAtPoint(e.getPoint());
                if (colEnd < 0) {
                    colEnd = 0;
                }
                if (this.currentColumnIndex < 0) {
                    this.currentColumnIndex = 0;
                }
                this.parentTable.clearSelection();
                if (colEnd > this.currentColumnIndex) {
                    this.parentTable.setColumnSelectionInterval(this.currentColumnIndex, colEnd);
                } else {
                    this.parentTable.setColumnSelectionInterval(colEnd, this.currentColumnIndex);
                }
                this.parentTable.setRowSelectionInterval(0, this.parentTable.getRowCount() - 1);
            }
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            super.processMouseEvent(e);
            int mouseID = e.getID();
            if (mouseID == 500) {
                if (this.currentColumnIndex < 0) {
                    return;
                }
                if (e.isControlDown()) {
                    this.parentTable.addColumnSelectionInterval(this.currentColumnIndex, this.currentColumnIndex);
                } else if (e.isShiftDown()) {
                    if (this.lastColumnIndex < 0) {
                        this.parentTable.addColumnSelectionInterval(0, this.currentColumnIndex);
                    } else if (this.lastColumnIndex < this.currentColumnIndex) {
                        this.parentTable.addColumnSelectionInterval(this.lastColumnIndex, this.currentColumnIndex);
                    } else {
                        this.parentTable.addColumnSelectionInterval(this.currentColumnIndex, this.lastColumnIndex);
                    }
                } else {
                    this.parentTable.clearSelection();
                    this.parentTable.setColumnSelectionInterval(this.currentColumnIndex, this.currentColumnIndex);
                }
                this.lastColumnIndex = this.currentColumnIndex;
                this.parentTable.setRowSelectionInterval(0, this.parentTable.getRowCount() - 1);
            } else if (mouseID == 501) {
                this.currentColumnIndex = this.columnAtPoint(e.getPoint());
            }
        }
    }

    private class LineplotOption
    extends JDialog
    implements ActionListener,
    ItemListener {
        private static final long serialVersionUID = -3457035832213978906L;
        public static final int NO_PLOT = -1;
        public static final int ROW_PLOT = 0;
        public static final int COLUMN_PLOT = 1;
        private int idx_xaxis;
        private int nRows;
        private int nCols;
        private int plotType;
        private JRadioButton rowButton;
        private JRadioButton colButton;
        private JComboBox rowBox;
        private JComboBox colBox;

        public LineplotOption(JFrame owner, String title, int nrow, int ncol) {
            int i;
            super(owner, title, true);
            this.idx_xaxis = -1;
            this.nRows = 0;
            this.nCols = 0;
            this.plotType = -1;
            this.nRows = nrow;
            this.nCols = ncol;
            this.rowBox = new JComboBox();
            this.rowBox.setEditable(false);
            this.colBox = new JComboBox();
            this.colBox.setEditable(false);
            JPanel contentPane = (JPanel)this.getContentPane();
            contentPane.setPreferredSize(new Dimension(400, 150));
            contentPane.setLayout(new BorderLayout(10, 10));
            long[] startArray = DefaultTableView.this.dataset.getStartDims();
            long[] strideArray = DefaultTableView.this.dataset.getStride();
            int[] selectedIndex = DefaultTableView.this.dataset.getSelectedIndex();
            int start = (int)startArray[selectedIndex[0]];
            int stride = (int)strideArray[selectedIndex[0]];
            this.rowBox.addItem("array index");
            for (i = 0; i < nrow; ++i) {
                this.rowBox.addItem("row " + (start + i * stride));
            }
            this.colBox.addItem("array index");
            for (i = 0; i < ncol; ++i) {
                this.colBox.addItem("column " + DefaultTableView.this.table.getColumnName(i));
            }
            this.rowButton = new JRadioButton("Row");
            this.colButton = new JRadioButton("Column", true);
            this.rowButton.addItemListener(this);
            this.colButton.addItemListener(this);
            ButtonGroup rgroup = new ButtonGroup();
            rgroup.add(this.rowButton);
            rgroup.add(this.colButton);
            JPanel p1 = new JPanel();
            p1.setLayout(new GridLayout(2, 1, 5, 5));
            p1.add(new JLabel(" Series in:", 4));
            p1.add(new JLabel(" For abscissa use:", 4));
            JPanel p2 = new JPanel();
            p2.setLayout(new GridLayout(2, 1, 5, 5));
            p2.add(this.colButton);
            p2.add(this.colBox);
            JPanel p3 = new JPanel();
            p3.setLayout(new GridLayout(2, 1, 5, 5));
            p3.add(this.rowButton);
            p3.add(this.rowBox);
            JPanel p = new JPanel();
            p.setBorder(new LineBorder(Color.lightGray));
            p.setLayout(new GridLayout(1, 3, 20, 5));
            p.add(p1);
            p.add(p2);
            p.add(p3);
            JPanel bp = new JPanel();
            JButton okButton = new JButton("Ok");
            okButton.addActionListener(this);
            okButton.setActionCommand("Ok");
            bp.add(okButton);
            JButton cancelButton = new JButton("Cancel");
            cancelButton.addActionListener(this);
            cancelButton.setActionCommand("Cancel");
            bp.add(cancelButton);
            contentPane.add((Component)new JLabel(" Select plot options:"), "North");
            contentPane.add((Component)p, "Center");
            contentPane.add((Component)bp, "South");
            this.colBox.setEnabled(this.colButton.isSelected());
            this.rowBox.setEnabled(this.rowButton.isSelected());
            Point l = this.getParent().getLocation();
            l.x += 450;
            l.y += 200;
            this.setLocation(l);
            this.pack();
        }

        int getXindex() {
            return this.idx_xaxis;
        }

        int getPlotBy() {
            return this.plotType;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            String cmd = e.getActionCommand();
            if (cmd.equals("Cancel")) {
                this.plotType = -1;
                this.dispose();
            } else if (cmd.equals("Ok")) {
                if (this.colButton.isSelected()) {
                    this.idx_xaxis = this.colBox.getSelectedIndex() - 1;
                    this.plotType = 1;
                } else {
                    this.idx_xaxis = this.rowBox.getSelectedIndex() - 1;
                    this.plotType = 0;
                }
                this.dispose();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (source.equals(this.colButton) || source.equals(this.rowButton)) {
                this.colBox.setEnabled(this.colButton.isSelected());
                this.rowBox.setEnabled(this.rowButton.isSelected());
            }
        }
    }

    private static enum ViewType {
        TABLE,
        IMAGE,
        TEXT;

    }
}

