/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.NumberFormatter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.Chart;
import ncsa.hdf.view.DefaultFileFilter;
import ncsa.hdf.view.HDFView;
import ncsa.hdf.view.ImageView;
import ncsa.hdf.view.NewDatasetDialog;
import ncsa.hdf.view.PaletteView;
import ncsa.hdf.view.Tools;
import ncsa.hdf.view.TreeView;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class DefaultImageView
extends JInternalFrame
implements ImageView,
ActionListener {
    private static final long serialVersionUID = -6534336542813587242L;
    public static final int FLIP_HORIZONTAL = 0;
    public static final int FLIP_VERTICAL = 1;
    public static final int ROTATE_CW_90 = 10;
    public static final int ROTATE_CCW_90 = 11;
    private final ViewManager viewer;
    private ScalarDS dataset;
    private ImageComponent imageComponent;
    private Image image;
    private float zoomFactor;
    private byte[] imageByteData;
    private byte[][] imagePalette;
    private String frameTitle;
    private JTextField valueField;
    private boolean isTrueColor;
    private boolean is3D;
    private boolean isPlaneInterlace;
    private boolean isHorizontalFlipped = false;
    private boolean isVerticalFlipped = false;
    private int rotateCount = 0;
    private char NT;
    private Object data;
    private boolean isUnsigned;
    private boolean isUnsignedConverted = false;
    private final Toolkit toolkit;
    private double[] dataRange;
    private final double[] originalRange = new double[]{0.0, 0.0};
    private PaletteComponent paletteComponent;
    private int animationSpeed = 2;
    private List rotateRelatedItems;
    private JScrollPane imageScroller;
    private JTextField frameField;
    private long curFrame = 0L;
    private long maxFrame = 1L;
    private MemoryImageSource memoryImageSource;
    private ContrastSlider contrastSlider;
    private int indexBase = 0;
    private int[] dataDist = null;
    private boolean doAutoGainContrast = false;
    private double[] gainBias;
    private double[] gainBias_current;
    private Object autoGainData;
    private BitSet bitmask;
    private boolean convertByteData = false;
    private ViewProperties.BITMASK_OP bitmaskOP = ViewProperties.BITMASK_OP.EXTRACT;
    private int origin = 0;

    public DefaultImageView(ViewManager theView) {
        this(theView, null);
    }

    public DefaultImageView(ViewManager theView, HashMap map) {
        int i;
        this.setDefaultCloseOperation(2);
        this.setFrameIcon(ViewProperties.getImageIcon());
        this.viewer = theView;
        this.zoomFactor = 1.0f;
        this.imageByteData = null;
        this.imagePalette = null;
        this.paletteComponent = null;
        this.isTrueColor = false;
        this.is3D = false;
        this.isPlaneInterlace = false;
        this.isUnsigned = false;
        this.data = null;
        this.NT = '\u0000';
        this.toolkit = Toolkit.getDefaultToolkit();
        this.rotateRelatedItems = new Vector(10);
        this.imageScroller = null;
        this.memoryImageSource = null;
        this.gainBias = null;
        this.gainBias_current = null;
        this.autoGainData = null;
        this.contrastSlider = null;
        this.bitmask = null;
        String origStr = ViewProperties.getImageOrigin();
        if ("LowerLeft".equalsIgnoreCase(origStr)) {
            this.origin = 1;
        } else if ("UpperRight".equalsIgnoreCase(origStr)) {
            this.origin = 2;
        } else if ("LowerRight".equalsIgnoreCase(origStr)) {
            this.origin = 3;
        }
        if (ViewProperties.isIndexBase1()) {
            this.indexBase = 1;
        }
        HObject hobject = null;
        if (map != null) {
            hobject = (HObject)map.get((Object)ViewProperties.DATA_VIEW_KEY.OBJECT);
            this.bitmask = (BitSet)map.get((Object)ViewProperties.DATA_VIEW_KEY.BITMASK);
            this.bitmaskOP = (ViewProperties.BITMASK_OP)((Object)map.get((Object)ViewProperties.DATA_VIEW_KEY.BITMASKOP));
            Boolean b = (Boolean)map.get((Object)ViewProperties.DATA_VIEW_KEY.CONVERTBYTE);
            if (b != null) {
                this.convertByteData = b;
            }
            if ((b = (Boolean)map.get((Object)ViewProperties.DATA_VIEW_KEY.INDEXBASE1)) != null) {
                this.indexBase = b != false ? 1 : 0;
            }
        }
        if (hobject == null) {
            hobject = theView.getTreeView().getCurrentObject();
        }
        if (hobject == null || !(hobject instanceof ScalarDS)) {
            this.viewer.showStatus("Display data in image failed for - " + hobject);
            return;
        }
        this.dataset = (ScalarDS)hobject;
        this.dataRange = this.dataset.getImageDataRange();
        if (this.dataRange == null) {
            this.dataRange = new double[2];
            this.dataRange[1] = 0.0;
            this.dataRange[0] = 0.0;
            if (this.dataset.getDatatype().getDatatypeSize() == 1 && !this.convertByteData) {
                this.dataRange[1] = 255.0;
            }
        } else if (this.dataRange[0] < this.dataRange[1]) {
            this.convertByteData = true;
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.valueField = new JTextField();
        contentPane.add((Component)this.valueField, "South");
        this.valueField.setEditable(false);
        this.valueField.setVisible(ViewProperties.showImageValues());
        if (this.image == null) {
            this.getImage();
        }
        if (this.image == null) {
            this.viewer.showStatus("Loading image failed - " + this.dataset.getName());
            this.dataset = null;
            return;
        }
        this.originalRange[0] = this.dataRange[0];
        this.originalRange[1] = this.dataRange[1];
        this.imageComponent = new ImageComponent(this.image);
        JScrollPane scroller = new JScrollPane(this.imageComponent);
        scroller.getVerticalScrollBar().setUnitIncrement(50);
        scroller.getHorizontalScrollBar().setUnitIncrement(50);
        this.imageScroller = scroller;
        contentPane.add((Component)scroller, "Center");
        if (this.imagePalette != null) {
            this.paletteComponent = new PaletteComponent(this.imagePalette, this.dataRange);
            contentPane.add((Component)this.paletteComponent, "East");
        }
        if (this.origin == 1) {
            this.flip(1);
        } else if (this.origin == 2) {
            this.flip(0);
        }
        if (this.origin == 3) {
            this.rotate(10);
            this.rotate(10);
        }
        StringBuffer sb = new StringBuffer("ImageView <" + ViewProperties.getImageOrigin() + ">  -  ");
        sb.append(hobject.getName());
        sb.append("  -  ");
        sb.append(hobject.getPath());
        sb.append("  -  ");
        sb.append(this.dataset.getFile());
        this.setTitle(sb.toString());
        this.frameTitle = sb.toString();
        this.setTitle(this.frameTitle);
        this.setName(this.frameTitle);
        int rank = this.dataset.getRank();
        int[] selectedIndex = this.dataset.getSelectedIndex();
        long[] count = this.dataset.getSelectedDims();
        long[] stride = this.dataset.getStride();
        long[] dims = this.dataset.getDims();
        long[] start = this.dataset.getStartDims();
        int n = Math.min(3, rank);
        if (rank > 2) {
            this.curFrame = start[selectedIndex[2]] + (long)this.indexBase;
            this.maxFrame = dims[selectedIndex[2]];
        }
        sb.append(" [ dims");
        sb.append(selectedIndex[0]);
        for (i = 1; i < n; ++i) {
            sb.append("x");
            sb.append(selectedIndex[i]);
        }
        sb.append(", start");
        sb.append(start[selectedIndex[0]]);
        for (i = 1; i < n; ++i) {
            sb.append("x");
            sb.append(start[selectedIndex[i]]);
        }
        sb.append(", count");
        sb.append(count[selectedIndex[0]]);
        for (i = 1; i < n; ++i) {
            sb.append("x");
            sb.append(count[selectedIndex[i]]);
        }
        sb.append(", stride");
        sb.append(stride[selectedIndex[0]]);
        for (i = 1; i < n; ++i) {
            sb.append("x");
            sb.append(stride[selectedIndex[i]]);
        }
        sb.append(" ] ");
        this.setJMenuBar(this.createMenuBar());
        this.viewer.showStatus(sb.toString());
    }

    private JMenuBar createMenuBar() {
        JMenuBar bar = new JMenuBar();
        boolean isEditable = !this.dataset.getFileFormat().isReadOnly();
        JMenu menu = new JMenu("Image", false);
        menu.setMnemonic('I');
        bar.add(menu);
        JMenu convertImageMenu = new JMenu("Save Image As");
        menu.add(convertImageMenu);
        JMenuItem item = new JMenuItem("JPEG");
        item.addActionListener(this);
        item.setActionCommand("Save image as jpeg");
        convertImageMenu.add(item);
        item = new JMenuItem("PNG");
        item.addActionListener(this);
        item.setActionCommand("Save image as png");
        convertImageMenu.add(item);
        item = new JMenuItem("GIF");
        item.addActionListener(this);
        item.setActionCommand("Save image as gif");
        convertImageMenu.add(item);
        item = new JMenuItem("BMP");
        item.addActionListener(this);
        item.setActionCommand("Save image as bmp");
        convertImageMenu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Write Selection to Image");
        item.addActionListener(this);
        item.setActionCommand("Write selection to image");
        item.setEnabled(isEditable);
        this.rotateRelatedItems.add(item);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Change Palette");
        item.addActionListener(this);
        item.setActionCommand("Edit palette");
        item.setEnabled(!this.isTrueColor);
        menu.add(item);
        item = new JMenuItem("Import Palette");
        item.addActionListener(this);
        item.setActionCommand("Import palette");
        item.setEnabled(!this.isTrueColor);
        menu.add(item);
        item = new JMenuItem("Export Palette");
        item.addActionListener(this);
        item.setActionCommand("Export palette");
        item.setEnabled(!this.isTrueColor);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Set Value Range");
        item.setEnabled(!this.isTrueColor);
        item.addActionListener(this);
        item.setActionCommand("Set data range");
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Show Histogram");
        item.addActionListener(this);
        item.setActionCommand("Show chart");
        item.setEnabled(!this.isTrueColor);
        this.rotateRelatedItems.add(item);
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Zoom In");
        item.addActionListener(this);
        item.setActionCommand("Zoom in");
        menu.add(item);
        item = new JMenuItem("Zoom Out");
        item.addActionListener(this);
        item.setActionCommand("Zoom out");
        menu.add(item);
        menu.addSeparator();
        JMenu imageMenu = new JMenu("Flip");
        menu.add(imageMenu);
        item = new JMenuItem("Horizontal");
        item.addActionListener(this);
        item.setActionCommand("Flip horizontal");
        imageMenu.add(item);
        item = new JMenuItem("Vertical");
        item.addActionListener(this);
        item.setActionCommand("Flip vertical");
        imageMenu.add(item);
        imageMenu = new JMenu("Rotate Image");
        menu.add(imageMenu);
        char t = '\u00ba';
        item = new JMenuItem("90" + t + " CW");
        item.addActionListener(this);
        item.setActionCommand("Rotate clockwise");
        imageMenu.add(item);
        item = new JMenuItem("90" + t + " CCW");
        item.addActionListener(this);
        item.setActionCommand("Rotate counter clockwise");
        imageMenu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Brightness/Contrast");
        item.addActionListener(this);
        item.setActionCommand("Brightness");
        menu.add(item);
        JMenu contourMenu = new JMenu("Contour");
        for (int i = 3; i < 10; ++i) {
            item = new JMenuItem(String.valueOf(i));
            item.addActionListener(this);
            item.setActionCommand("Contour " + i);
            contourMenu.add(item);
        }
        menu.add(contourMenu);
        menu.addSeparator();
        item = new JMenuItem("Show Animation");
        item.addActionListener(this);
        item.setActionCommand("Show animation");
        item.setEnabled(this.is3D);
        menu.add(item);
        JMenu animationMenu = new JMenu("Animation (frames/second)");
        for (int i = 2; i < 12; i += 2) {
            item = new JMenuItem(String.valueOf(i));
            item.addActionListener(this);
            item.setActionCommand("Animation speed " + i);
            animationMenu.add(item);
        }
        animationMenu.setEnabled(this.is3D);
        menu.add(animationMenu);
        menu.addSeparator();
        JCheckBoxMenuItem imageValueCheckBox = new JCheckBoxMenuItem("Show Value", false);
        imageValueCheckBox.addActionListener(this);
        imageValueCheckBox.setActionCommand("Show image value");
        imageValueCheckBox.setSelected(ViewProperties.showImageValues());
        this.rotateRelatedItems.add(imageValueCheckBox);
        menu.add(imageValueCheckBox);
        item = new JMenuItem("Show Statistics");
        item.addActionListener(this);
        item.setActionCommand("Show statistics");
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Select All");
        item.addActionListener(this);
        item.setActionCommand("Select all data");
        menu.add(item);
        menu.addSeparator();
        item = new JMenuItem("Close");
        item.addActionListener(this);
        item.setActionCommand("Close");
        menu.add(item);
        bar.add(new JLabel("       "));
        Insets margin = new Insets(0, 2, 0, 2);
        JButton button = new JButton(ViewProperties.getChartIcon());
        bar.add(button);
        button.setToolTipText("Histogram");
        button.setMargin(margin);
        button.addActionListener(this);
        button.setActionCommand("Show chart");
        button.setEnabled(!this.isTrueColor);
        button = new JButton(ViewProperties.getPaletteIcon());
        bar.add(button);
        button.setToolTipText("Palette");
        button.setMargin(margin);
        button.addActionListener(this);
        button.setActionCommand("Edit palette");
        button.setEnabled(!this.isTrueColor);
        button = new JButton(ViewProperties.getBrightIcon());
        bar.add(button);
        button.setToolTipText("Brightness");
        button.setMargin(margin);
        button.addActionListener(this);
        button.setActionCommand("Brightness");
        button = new JButton(ViewProperties.getZoominIcon());
        bar.add(button);
        button.addActionListener(this);
        button.setMargin(margin);
        button.setActionCommand("Zoom in");
        button.setToolTipText("Zoom In");
        button = new JButton(ViewProperties.getZoomoutIcon());
        bar.add(button);
        button.setToolTipText("Zoom Out");
        button.setMargin(margin);
        button.addActionListener(this);
        button.setActionCommand("Zoom out");
        if (this.is3D) {
            bar.add(new JLabel("     "));
            button = new JButton(ViewProperties.getFirstIcon());
            bar.add(button);
            button.setToolTipText("First");
            button.setMargin(margin);
            button.addActionListener(this);
            button.setActionCommand("First page");
            button = new JButton(ViewProperties.getPreviousIcon());
            bar.add(button);
            button.setToolTipText("Previous");
            button.setMargin(margin);
            button.addActionListener(this);
            button.setActionCommand("Previous page");
            this.frameField = new JTextField(String.valueOf(this.curFrame));
            this.frameField.setMaximumSize(new Dimension(50, 30));
            bar.add(this.frameField);
            this.frameField.setMargin(margin);
            this.frameField.addActionListener(this);
            this.frameField.setActionCommand("Go to frame");
            JLabel tmpField = new JLabel(String.valueOf(this.maxFrame), 0);
            tmpField.setMaximumSize(new Dimension(50, 30));
            bar.add(tmpField);
            button = new JButton(ViewProperties.getNextIcon());
            bar.add(button);
            button.setToolTipText("Next");
            button.setMargin(margin);
            button.addActionListener(this);
            button.setActionCommand("Next page");
            button = new JButton(ViewProperties.getLastIcon());
            bar.add(button);
            button.setToolTipText("Last");
            button.setMargin(margin);
            button.addActionListener(this);
            button.setActionCommand("Last page");
            button = new JButton(ViewProperties.getAnimationIcon());
            bar.add(button);
            button.setToolTipText("Animation");
            button.setMargin(margin);
            button.addActionListener(this);
            button.setActionCommand("Show animation");
        }
        return bar;
    }

    private void previousPage() {
        int rank = this.dataset.getRank();
        if (rank < 3) {
            return;
        }
        int[] selectedIndex = this.dataset.getSelectedIndex();
        long[] selectedDims = this.dataset.getSelectedDims();
        if (selectedDims[selectedIndex[2]] > 1L) {
            return;
        }
        long[] start = this.dataset.getStartDims();
        long[] dims = this.dataset.getDims();
        long idx = start[selectedIndex[2]];
        if (idx == 0L) {
            return;
        }
        this.gotoPage(start[selectedIndex[2]] - 1L);
    }

    private void nextPage() {
        long[] dims;
        int rank = this.dataset.getRank();
        if (rank < 3) {
            return;
        }
        int[] selectedIndex = this.dataset.getSelectedIndex();
        long[] selectedDims = this.dataset.getSelectedDims();
        if (selectedDims[selectedIndex[2]] > 1L) {
            return;
        }
        long[] start = this.dataset.getStartDims();
        long idx = start[selectedIndex[2]];
        if (idx == (dims = this.dataset.getDims())[selectedIndex[2]] - 1L) {
            return;
        }
        this.gotoPage(start[selectedIndex[2]] + 1L);
    }

    private void firstPage() {
        int rank = this.dataset.getRank();
        if (rank < 3) {
            return;
        }
        int[] selectedIndex = this.dataset.getSelectedIndex();
        long[] selectedDims = this.dataset.getSelectedDims();
        if (selectedDims[selectedIndex[2]] > 1L) {
            return;
        }
        long[] start = this.dataset.getStartDims();
        long[] dims = this.dataset.getDims();
        long idx = start[selectedIndex[2]];
        if (idx == 0L) {
            return;
        }
        this.gotoPage(0L);
    }

    private void lastPage() {
        long[] dims;
        int rank = this.dataset.getRank();
        if (rank < 3) {
            return;
        }
        int[] selectedIndex = this.dataset.getSelectedIndex();
        long[] selectedDims = this.dataset.getSelectedDims();
        if (selectedDims[selectedIndex[2]] > 1L) {
            return;
        }
        long[] start = this.dataset.getStartDims();
        long idx = start[selectedIndex[2]];
        if (idx == (dims = this.dataset.getDims())[selectedIndex[2]] - 1L) {
            return;
        }
        this.gotoPage(dims[selectedIndex[2]] - 1L);
    }

    @Override
    public Image getImage() {
        if (this.image != null) {
            return this.image;
        }
        int rank = this.dataset.getRank();
        if (rank <= 0) {
            this.dataset.init();
        }
        this.isTrueColor = this.dataset.isTrueColor();
        this.is3D = this.dataset.getRank() > 2 && !this.dataset.isTrueColor();
        Object strValue = null;
        try {
            if (this.isTrueColor) {
                this.getTrueColorImage();
            } else {
                this.getIndexedImage();
            }
        }
        catch (Throwable ex) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, ex, this.getTitle(), 0);
            return null;
        }
        if (this.data != null) {
            this.isUnsigned = this.dataset.isUnsigned();
            String cname = this.data.getClass().getName();
            this.NT = cname.charAt(cname.lastIndexOf("[") + 1);
        }
        return this.image;
    }

    private void getIndexedImage() throws Exception, OutOfMemoryError {
        int typeClass;
        if (this.imagePalette == null) {
            this.imagePalette = this.dataset.getPalette();
        }
        boolean noPalette = false;
        boolean isLocalFile = this.dataset.getFileFormat().exists();
        if (this.imagePalette == null) {
            noPalette = true;
            this.imagePalette = Tools.createGrayPalette();
            this.viewer.showStatus("\nNo attached palette found, default grey palette is used to display image");
        }
        this.data = this.dataset.getData();
        if (this.bitmask != null && Tools.applyBitmask(this.data, this.bitmask, this.bitmaskOP)) {
            String opName = "Extract bits ";
            if (this.bitmaskOP == ViewProperties.BITMASK_OP.AND) {
                opName = "Apply bitwise AND ";
            }
            CompoundBorder border = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLUE, 1), opName + this.bitmask, 3, 2, this.getFont(), Color.RED));
            this.doAutoGainContrast = false;
            this.setBorder(border);
        }
        if ((typeClass = this.dataset.getDatatype().getDatatypeClass()) == 0 || typeClass == 2) {
            this.data = this.dataset.convertFromUnsignedC();
            this.isUnsignedConverted = true;
            this.doAutoGainContrast = this.doAutoGainContrast || ViewProperties.isAutoContrast() && noPalette && isLocalFile;
        } else {
            this.doAutoGainContrast = false;
        }
        boolean isAutoContrastFailed = true;
        if (this.doAutoGainContrast) {
            isAutoContrastFailed = !this.computeAutoGainImageData(this.gainBias, null);
        }
        int w = this.dataset.getWidth();
        int h = this.dataset.getHeight();
        if (isAutoContrastFailed) {
            this.doAutoGainContrast = false;
            this.imageByteData = Tools.getBytes(this.data, this.dataRange, w, h, !this.dataset.isDefaultImageOrder(), this.dataset.getFillValue(), this.convertByteData, this.imageByteData);
        } else if (this.dataRange != null && this.dataRange[0] == this.dataRange[1]) {
            Tools.findMinMax(this.data, this.dataRange, null);
        }
        this.image = this.createIndexedImage(this.imageByteData, this.imagePalette, w, h);
    }

    private void getTrueColorImage() throws Exception, OutOfMemoryError {
        this.isPlaneInterlace = this.dataset.getInterlace() == 2;
        long[] selected = this.dataset.getSelectedDims();
        long[] start = this.dataset.getStartDims();
        int[] selectedIndex = this.dataset.getSelectedIndex();
        long[] stride = this.dataset.getStride();
        if (start.length > 2) {
            start[selectedIndex[2]] = 0L;
            selected[selectedIndex[2]] = 3L;
            stride[selectedIndex[2]] = 1L;
        }
        this.dataset.clearData();
        this.data = this.dataset.getData();
        this.imageByteData = Tools.getBytes(this.data, this.dataRange, this.dataset.getFillValue(), this.imageByteData);
        int w = this.dataset.getWidth();
        int h = this.dataset.getHeight();
        this.image = this.createTrueColorImage(this.imageByteData, this.isPlaneInterlace, w, h);
    }

    private boolean computeAutoGainImageData(double[] gb, double[] range) {
        boolean retValue = true;
        boolean isUnsigned = this.dataset.isUnsigned();
        if (this.gainBias == null) {
            this.gainBias = new double[2];
            Tools.autoContrastCompute(this.data, this.gainBias, isUnsigned);
        }
        if (gb == null) {
            gb = this.gainBias;
        }
        this.autoGainData = Tools.autoContrastApply(this.data, this.autoGainData, gb, range, isUnsigned);
        if (this.autoGainData != null) {
            if (this.imageByteData == null || this.imageByteData.length != Array.getLength(this.data)) {
                this.imageByteData = new byte[Array.getLength(this.data)];
            }
            retValue = Tools.autoContrastConvertImageBuffer(this.autoGainData, this.imageByteData, true) >= 0;
        } else {
            retValue = false;
        }
        if (this.gainBias_current == null) {
            this.gainBias_current = new double[2];
        }
        this.gainBias_current[0] = gb[0];
        this.gainBias_current[1] = gb[1];
        return retValue;
    }

    private void zoomIn() {
        if (this.zoomFactor >= 1.0f) {
            this.zoomTo(this.zoomFactor + 1.0f);
        } else {
            this.zoomTo(this.zoomFactor + 0.125f);
        }
    }

    private void zoomOut() {
        if (this.zoomFactor > 1.0f) {
            this.zoomTo(this.zoomFactor - 1.0f);
        } else {
            this.zoomTo(this.zoomFactor - 0.125f);
        }
    }

    private void zoomTo(float zf) {
        if (zf > 8.0f) {
            zf = 8.0f;
        } else if ((double)zf < 0.125) {
            zf = 0.125f;
        }
        if (this.zoomFactor == zf) {
            return;
        }
        this.zoomFactor = zf;
        Dimension imageSize = new Dimension((int)((float)((ImageComponent)this.imageComponent).originalSize.width * this.zoomFactor), (int)((float)((ImageComponent)this.imageComponent).originalSize.height * this.zoomFactor));
        this.invalidate();
        this.imageComponent.invalidate();
        this.imageComponent.setImageSize(imageSize);
        this.validate();
        if ((double)this.zoomFactor > 0.99 && (double)this.zoomFactor < 1.01) {
            this.setTitle(this.frameTitle);
        } else {
            this.setTitle(this.frameTitle + " - " + 100.0f * this.zoomFactor + "%");
        }
    }

    private void showColorTable() {
        if (this.imagePalette == null) {
            return;
        }
        String viewName = (String)HDFView.getListOfPaletteView().get(0);
        try {
            Class<?> theClass = Class.forName(viewName);
            if ("ncsa.hdf.view.DefaultPaletteView".equals(viewName)) {
                Object[] initargs = new Object[]{this.viewer, this};
                PaletteView theView = (PaletteView)Tools.newInstance(theClass, initargs);
            } else {
                Object[] initargs = new Object[]{this};
                PaletteView theView = (PaletteView)Tools.newInstance(theClass, initargs);
            }
        }
        catch (Exception ex) {
            this.viewer.showStatus(ex.toString());
        }
    }

    private void showHistogram() {
        Rectangle rec = this.imageComponent.selectedArea;
        if (this.isTrueColor) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Unsupported operation: unable to draw histogram for true color image.", this.getTitle(), 0);
            return;
        }
        if (rec == null || rec.getWidth() <= 0.0 || rec.getHeight() <= 0.0) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "No data for histogram.\nUse Shift+Mouse_drag to select an image area.", this.getTitle(), 0);
            return;
        }
        double[][] chartData = new double[1][256];
        for (int i = 0; i < 256; ++i) {
            chartData[0][i] = 0.0;
        }
        int w = this.dataset.getWidth();
        int x0 = (int)((float)rec.x / this.zoomFactor);
        int y0 = (int)((float)rec.y / this.zoomFactor);
        int x = x0 + (int)((float)rec.width / this.zoomFactor);
        int y = y0 + (int)((float)rec.height / this.zoomFactor);
        int arrayIndex = 0;
        for (int i = y0; i < y; ++i) {
            for (int j = x0; j < x; ++j) {
                arrayIndex = this.imageByteData[i * w + j];
                if (arrayIndex < 0) {
                    arrayIndex += 256;
                }
                double[] dArray = chartData[0];
                int n = arrayIndex;
                dArray[n] = dArray[n] + 1.0;
            }
        }
        double[] xRange = this.originalRange;
        if (xRange == null || xRange[0] == xRange[1]) {
            xRange = new double[2];
            Tools.findMinMax(this.data, xRange, null);
        }
        Chart cv = new Chart((JFrame)((Object)this.viewer), "Histogram - " + this.dataset.getPath() + this.dataset.getName() + " - by pixel index", 0, chartData, xRange, null);
        cv.setVisible(true);
    }

    private void selectAll() throws Exception {
        this.imageComponent.selectAll();
    }

    private void flip(int direction) {
        FlipFilter filter = new FlipFilter(direction);
        if (filter == null) {
            return;
        }
        if (this.applyImageFilter(filter)) {
            if (direction == 0) {
                this.isHorizontalFlipped = !this.isHorizontalFlipped;
            } else {
                this.isVerticalFlipped = !this.isVerticalFlipped;
            }
        }
    }

    private void rotate(int direction) {
        if (direction != 10 && direction != 11) {
            return;
        }
        Rotate90Filter filter = new Rotate90Filter(direction);
        this.applyImageFilter(filter);
        if (direction == 10) {
            ++this.rotateCount;
            if (this.rotateCount == 4) {
                this.rotateCount = 0;
            }
        } else {
            --this.rotateCount;
            if (this.rotateCount == -4) {
                this.rotateCount = 0;
            }
        }
    }

    private void contour(int level) {
        ContourFilter filter = new ContourFilter(level);
        if (filter == null) {
            return;
        }
        this.applyImageFilter(filter);
    }

    private void brightness(int blevel, int clevel) {
        BrightnessFilter filter = new BrightnessFilter(blevel, clevel);
        if (filter == null) {
            return;
        }
        this.applyImageFilter(filter);
    }

    private void applyAutoGain(double[] gb, double[] range) {
        if (this.computeAutoGainImageData(gb, range)) {
            int w = this.dataset.getWidth();
            int h = this.dataset.getHeight();
            this.image = this.createIndexedImage(this.imageByteData, this.imagePalette, w, h);
            this.imageComponent.setImage(this.image);
            this.zoomTo(this.zoomFactor);
        }
    }

    private void setValueVisible(boolean b) {
        this.valueField.setVisible(b);
        this.validate();
    }

    private boolean hasAlpha(Image image) {
        if (image == null) {
            return false;
        }
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    private BufferedImage toBufferedImage(Image image) {
        if (image == null) {
            return null;
        }
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        int w = image.getWidth(null);
        int h = image.getHeight(null);
        BufferedImage bimage = (BufferedImage)this.createImage(w, h);
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    private void saveImageAs(String type) throws Exception {
        int newFileFlag;
        if (this.image == null) {
            return;
        }
        JFileChooser fchooser = new JFileChooser(this.dataset.getFile());
        if (type.equals("JPEG")) {
            fchooser.setFileFilter(DefaultFileFilter.getFileFilterJPEG());
        } else if (type.equals("PNG")) {
            fchooser.setFileFilter(DefaultFileFilter.getFileFilterPNG());
        } else if (type.equals("GIF")) {
            fchooser.setFileFilter(DefaultFileFilter.getFileFilterGIF());
        } else if (type.equals("BMP")) {
            fchooser.setFileFilter(DefaultFileFilter.getFileFilterBMP());
        }
        fchooser.setDialogTitle("Save Current Image To " + type + " File --- " + this.dataset.getName());
        File choosedFile = new File(this.dataset.getName() + "." + type.toLowerCase());
        fchooser.setSelectedFile(choosedFile);
        int returnVal = fchooser.showSaveDialog(this);
        if (returnVal != 0) {
            return;
        }
        choosedFile = fchooser.getSelectedFile();
        if (choosedFile == null) {
            return;
        }
        String fname = choosedFile.getAbsolutePath();
        if (choosedFile.exists() && (newFileFlag = JOptionPane.showConfirmDialog(this, "File exists. Do you want to replace it ?", this.getTitle(), 0)) == 1) {
            return;
        }
        BufferedImage bi = null;
        try {
            bi = this.toBufferedImage(this.image);
        }
        catch (OutOfMemoryError err) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, err.getMessage(), this.getTitle(), 0);
            return;
        }
        Tools.saveImageAs(bi, choosedFile, type);
        bi = null;
        this.viewer.showStatus("Current image saved to: " + fname);
        try {
            RandomAccessFile rf = new RandomAccessFile(choosedFile, "r");
            long size = rf.length();
            rf.close();
            this.viewer.showStatus("File size (bytes): " + size);
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        block83: {
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                Object source = e.getSource();
                String cmd = e.getActionCommand();
                if (cmd.equals("Close")) {
                    this.dispose();
                    ((Vector)this.rotateRelatedItems).setSize(0);
                    break block83;
                }
                if (cmd.startsWith("Save image as ")) {
                    String filetype = null;
                    if (cmd.equals("Save image as jpeg")) {
                        filetype = "JPEG";
                    } else if (cmd.equals("Save image as tiff")) {
                        filetype = "TIFF";
                    } else if (cmd.equals("Save image as png")) {
                        filetype = "PNG";
                    } else if (cmd.equals("Save image as gif")) {
                        filetype = "GIF";
                    } else if (cmd.equals("Save image as bmp")) {
                        filetype = "BMP";
                    }
                    try {
                        this.saveImageAs(filetype);
                    }
                    catch (Exception ex) {
                        this.toolkit.beep();
                        JOptionPane.showMessageDialog(this, ex, this.getTitle(), 0);
                    }
                    break block83;
                }
                if (cmd.equals("Write selection to image")) {
                    if (this.getSelectedArea().width <= 0 || this.getSelectedArea().height <= 0) {
                        JOptionPane.showMessageDialog(this, "No data to write.\nUse Shift+Mouse_drag to select an image area.", "HDFView", 1);
                        return;
                    }
                    TreeView treeView = this.viewer.getTreeView();
                    TreeNode node = treeView.findTreeNode(this.dataset);
                    Group pGroup = (Group)((DefaultMutableTreeNode)node.getParent()).getUserObject();
                    TreeNode root = this.dataset.getFileFormat().getRootNode();
                    if (root == null) {
                        return;
                    }
                    Vector<Object> list = new Vector<Object>(this.dataset.getFileFormat().getNumberOfMembers() + 5);
                    DefaultMutableTreeNode theNode = null;
                    Enumeration<TreeNode> local_enum = ((DefaultMutableTreeNode)root).depthFirstEnumeration();
                    while (local_enum.hasMoreElements()) {
                        theNode = (DefaultMutableTreeNode)local_enum.nextElement();
                        list.add(theNode.getUserObject());
                    }
                    NewDatasetDialog dialog = new NewDatasetDialog((JFrame)((Object)this.viewer), pGroup, list, this);
                    dialog.setVisible(true);
                    HObject obj = (HObject)dialog.getObject();
                    if (obj != null) {
                        Group pgroup = dialog.getParentGroup();
                        try {
                            treeView.addObject(obj, pgroup);
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    list.setSize(0);
                    break block83;
                }
                if (cmd.equals("Zoom in")) {
                    this.zoomIn();
                    break block83;
                }
                if (cmd.equals("Zoom out")) {
                    this.zoomOut();
                    break block83;
                }
                if (cmd.equals("Edit palette")) {
                    this.showColorTable();
                    break block83;
                }
                if (cmd.equals("Import palette")) {
                    JFileChooser fchooser = new JFileChooser(ViewProperties.getWorkDir());
                    int returnVal = fchooser.showOpenDialog(this);
                    if (returnVal != 0) {
                        return;
                    }
                    File choosedFile = fchooser.getSelectedFile();
                    if (choosedFile == null || choosedFile.isDirectory()) {
                        return;
                    }
                    Vector<String> palList = ViewProperties.getPaletteList();
                    String palPath = choosedFile.getAbsolutePath();
                    if (!palList.contains(palList)) {
                        palList.addElement(palPath);
                    }
                    break block83;
                }
                if (cmd.equals("Export palette")) {
                    int newFileFlag;
                    if (this.imagePalette == null) {
                        return;
                    }
                    String wd = ViewProperties.getWorkDir() + File.separator;
                    JFileChooser fchooser = new JFileChooser(wd);
                    FileNameExtensionFilter filter = new FileNameExtensionFilter("Color lookup table", "lut");
                    File pfile = Tools.checkNewFile(wd, ".lut");
                    fchooser.setSelectedFile(pfile);
                    fchooser.setFileFilter(filter);
                    int returnVal = fchooser.showOpenDialog(this);
                    if (returnVal != 0) {
                        return;
                    }
                    File choosedFile = fchooser.getSelectedFile();
                    if (choosedFile == null || choosedFile.isDirectory()) {
                        return;
                    }
                    if (choosedFile.exists() && (newFileFlag = JOptionPane.showConfirmDialog(this, "File exists. Do you want to replace it ?", this.getTitle(), 0)) == 1) {
                        return;
                    }
                    PrintWriter out = null;
                    try {
                        out = new PrintWriter(new BufferedWriter(new FileWriter(choosedFile)));
                    }
                    catch (Exception ex) {
                        out = null;
                    }
                    if (out == null) {
                        return;
                    }
                    int cols = 3;
                    int rows = 256;
                    int rgb = 0;
                    for (int i = 0; i < rows; ++i) {
                        out.print(i);
                        for (int j = 0; j < cols; ++j) {
                            out.print(' ');
                            rgb = this.imagePalette[j][i];
                            if (rgb < 0) {
                                rgb += 256;
                            }
                            out.print(rgb);
                        }
                        out.println();
                    }
                    out.flush();
                    out.close();
                    break block83;
                }
                if (cmd.equals("Set data range")) {
                    DataRangeDialog drd;
                    double[] drange;
                    if (this.originalRange == null || this.originalRange[0] == this.originalRange[1]) {
                        return;
                    }
                    if (this.dataDist == null) {
                        this.dataDist = new int[256];
                        Tools.findDataDist(this.data, this.dataDist, this.originalRange);
                    }
                    if ((drange = (drd = new DataRangeDialog((JFrame)((Object)this.viewer), this.dataRange, this.originalRange, this.dataDist)).getRange()) == null || drange[0] == drange[1] || drange[0] == this.dataRange[0] && drange[1] == this.dataRange[1]) {
                        return;
                    }
                    this.applyDataRange(drange);
                    break block83;
                }
                if (cmd.equals("Flip horizontal")) {
                    this.flip(0);
                    break block83;
                }
                if (cmd.equals("Flip vertical")) {
                    this.flip(1);
                    break block83;
                }
                if (cmd.startsWith("Rotate")) {
                    if (cmd.equals("Rotate clockwise")) {
                        this.rotate(10);
                    } else {
                        this.rotate(11);
                    }
                    int n = this.rotateRelatedItems.size();
                    for (int i = 0; i < n; ++i) {
                        boolean itemState = this.rotateCount == 0;
                        ((JComponent)this.rotateRelatedItems.get(i)).setEnabled(itemState);
                    }
                    break block83;
                }
                if (cmd.equals("Show image value")) {
                    boolean b = ((JCheckBoxMenuItem)source).getState();
                    this.setValueVisible(b);
                    break block83;
                }
                if (cmd.startsWith("Go to frame")) {
                    int page = 0;
                    try {
                        page = Integer.parseInt(this.frameField.getText().trim()) - this.indexBase;
                    }
                    catch (Exception ex) {
                        page = -1;
                    }
                    this.gotoPage(page);
                    break block83;
                }
                if (cmd.startsWith("Show animation")) {
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    new Animation((JFrame)((Object)this.viewer), this.dataset);
                    this.setCursor(Cursor.getPredefinedCursor(0));
                    break block83;
                }
                if (cmd.startsWith("Animation speed")) {
                    this.animationSpeed = Integer.parseInt(cmd.substring(cmd.length() - 2).trim());
                    break block83;
                }
                if (cmd.startsWith("Contour")) {
                    int level = Integer.parseInt(cmd.substring(cmd.length() - 1));
                    this.contour(level);
                    break block83;
                }
                if (cmd.startsWith("Brightness")) {
                    if (this.contrastSlider == null) {
                        this.contrastSlider = new ContrastSlider((JFrame)((Object)this.viewer), this.image.getSource());
                    }
                    this.contrastSlider.setVisible(true);
                    break block83;
                }
                if (cmd.equals("Show chart")) {
                    this.showHistogram();
                    break block83;
                }
                if (cmd.equals("First page")) {
                    this.firstPage();
                    break block83;
                }
                if (cmd.equals("Previous page")) {
                    this.previousPage();
                    break block83;
                }
                if (cmd.equals("Next page")) {
                    this.nextPage();
                    break block83;
                }
                if (cmd.equals("Last page")) {
                    this.lastPage();
                    break block83;
                }
                if (cmd.equals("Show statistics")) {
                    try {
                        double[] minmax = new double[2];
                        double[] stat = new double[2];
                        Tools.findMinMax(this.data, minmax, this.dataset.getFillValue());
                        if (Tools.computeStatistics(this.data, stat, this.dataset.getFillValue()) > 0) {
                            String statistics = "Min                      = " + minmax[0] + "\nMax                      = " + minmax[1] + "\nMean                     = " + stat[0] + "\nStandard deviation = " + stat[1];
                            JOptionPane.showMessageDialog(this, statistics, "Statistics", 1);
                        }
                        break block83;
                    }
                    catch (Exception ex) {
                        this.toolkit.beep();
                        JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), ex, this.getTitle(), 0);
                    }
                    break block83;
                }
                if (cmd.equals("Select all data")) {
                    try {
                        this.selectAll();
                    }
                    catch (Exception ex) {
                        this.toolkit.beep();
                        JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), ex, this.getTitle(), 0);
                    }
                }
            }
            finally {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    @Override
    public void dispose() {
        if (!this.dataset.isImage()) {
            this.dataset.clearData();
        }
        this.data = null;
        this.image = null;
        this.imageByteData = null;
        this.imageComponent = null;
        this.autoGainData = null;
        ((Vector)this.rotateRelatedItems).setSize(0);
        System.runFinalization();
        System.gc();
        this.viewer.removeDataView(this);
        super.dispose();
    }

    @Override
    public HObject getDataObject() {
        return this.dataset;
    }

    @Override
    public byte[] getImageByteData() {
        return this.imageByteData;
    }

    @Override
    public Object getSelectedData() {
        Object[] selectedData = null;
        int cols = ((ImageComponent)this.imageComponent).originalSelectedArea.width;
        int rows = ((ImageComponent)this.imageComponent).originalSelectedArea.height;
        if (cols <= 0 || rows <= 0) {
            return null;
        }
        int size = cols * rows;
        if (this.isTrueColor) {
            size *= 3;
        }
        if (this.NT == 'B') {
            selectedData = new byte[size];
        } else if (this.NT == 'S') {
            selectedData = new short[size];
        } else if (this.NT == 'I') {
            selectedData = new int[size];
        } else if (this.NT == 'J') {
            selectedData = new long[size];
        } else if (this.NT == 'F') {
            selectedData = new float[size];
        } else if (this.NT == 'D') {
            selectedData = new double[size];
        } else {
            return null;
        }
        int r0 = ((ImageComponent)this.imageComponent).originalSelectedArea.y;
        int c0 = ((ImageComponent)this.imageComponent).originalSelectedArea.x;
        int w = ((ImageComponent)this.imageComponent).originalSize.width;
        int h = ((ImageComponent)this.imageComponent).originalSize.height;
        if (this.isHorizontalFlipped) {
            c0 = w - 1 - c0 - cols;
        }
        if (this.isVerticalFlipped) {
            r0 = h - 1 - r0 - rows;
        }
        int idx_src = 0;
        int idx_dst = 0;
        if (this.isTrueColor) {
            int imageSize = w * h;
            if (this.isPlaneInterlace) {
                for (int j = 0; j < 3; ++j) {
                    int plane = imageSize * j;
                    for (int i = 0; i < rows; ++i) {
                        idx_src = plane + (r0 + i) * w + c0;
                        System.arraycopy(this.data, idx_src, selectedData, idx_dst, cols);
                        idx_dst += cols;
                    }
                }
            } else {
                int numberOfDataPoints = cols * 3;
                for (int i = 0; i < rows; ++i) {
                    idx_src = (r0 + i) * w + c0;
                    System.arraycopy(this.data, idx_src * 3, selectedData, idx_dst, numberOfDataPoints);
                    idx_dst += numberOfDataPoints;
                }
            }
        } else {
            for (int i = 0; i < rows; ++i) {
                idx_src = (r0 + i) * w + c0;
                System.arraycopy(this.data, idx_src, selectedData, idx_dst, cols);
                idx_dst += cols;
            }
        }
        return selectedData;
    }

    @Override
    public Rectangle getSelectedArea() {
        return this.imageComponent.originalSelectedArea;
    }

    @Override
    public boolean isTrueColor() {
        return this.isTrueColor;
    }

    @Override
    public boolean isPlaneInterlace() {
        return this.isPlaneInterlace;
    }

    @Override
    public void setImage(Image img) {
        this.image = img;
        this.imageComponent.setImage(img);
        this.setImageDirection();
    }

    private void setImageDirection() {
        boolean isHF = this.isHorizontalFlipped;
        boolean isVF = this.isVerticalFlipped;
        int rc = this.rotateCount;
        if (isHF || isVF || rc != 0) {
            this.isHorizontalFlipped = false;
            this.isVerticalFlipped = false;
            this.rotateCount = 0;
            if (isHF) {
                this.flip(0);
            }
            if (isVF) {
                this.flip(1);
            }
            while (rc > 0) {
                this.rotate(10);
                --rc;
            }
            while (rc < 0) {
                this.rotate(11);
                ++rc;
            }
        } else {
            if (this.origin == 1) {
                this.flip(1);
            } else if (this.origin == 2) {
                this.flip(0);
            }
            if (this.origin == 3) {
                this.rotate(10);
                this.rotate(10);
            }
        }
        this.zoomTo(this.zoomFactor);
    }

    @Override
    public byte[][] getPalette() {
        return this.imagePalette;
    }

    @Override
    public void setPalette(byte[][] pal) {
        this.imagePalette = pal;
        this.paletteComponent.updatePalette(pal);
    }

    private void gotoPage(long idx) {
        if (this.dataset.getRank() < 3 || idx == this.curFrame - (long)this.indexBase) {
            return;
        }
        long[] start = this.dataset.getStartDims();
        int[] selectedIndex = this.dataset.getSelectedIndex();
        long[] dims = this.dataset.getDims();
        if (idx < 0L || idx >= dims[selectedIndex[2]]) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, "Frame number must be between " + this.indexBase + " and " + (dims[selectedIndex[2]] - 1L + (long)this.indexBase), this.getTitle(), 0);
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        start[selectedIndex[2]] = idx;
        this.curFrame = idx + (long)this.indexBase;
        this.dataset.clearData();
        this.image = null;
        this.gainBias = null;
        this.imageComponent.setImage(this.getImage());
        this.frameField.setText(String.valueOf(this.curFrame));
        this.isHorizontalFlipped = false;
        this.isVerticalFlipped = false;
        this.rotateCount = 0;
        if (this.origin == 1) {
            this.flip(1);
        } else if (this.origin == 2) {
            this.flip(0);
        }
        if (this.origin == 3) {
            this.rotate(10);
            this.rotate(10);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.updateUI();
    }

    public Image createIndexedImage(byte[] imageData, byte[][] palette, int w, int h) {
        Image theImage = null;
        IndexColorModel colorModel = new IndexColorModel(8, 256, palette[0], palette[1], palette[2]);
        if (this.memoryImageSource == null) {
            this.memoryImageSource = new MemoryImageSource(w, h, (ColorModel)colorModel, imageData, 0, w);
        } else {
            this.memoryImageSource.newPixels(imageData, (ColorModel)colorModel, 0, w);
        }
        theImage = Toolkit.getDefaultToolkit().createImage(this.memoryImageSource);
        return theImage;
    }

    public Image createTrueColorImage(byte[] imageData, boolean planeInterlace, int w, int h) {
        Image theImage = null;
        int imgSize = w * h;
        int[] packedImageData = new int[imgSize];
        int pixel = 0;
        int idx = 0;
        int r = 0;
        int g = 0;
        int b = 0;
        for (int i = 0; i < h; ++i) {
            for (int j = 0; j < w; ++j) {
                b = 0;
                g = 0;
                r = 0;
                pixel = 0;
                if (planeInterlace) {
                    r = imageData[idx];
                    g = imageData[imgSize + idx];
                    b = imageData[imgSize * 2 + idx];
                } else {
                    r = imageData[idx * 3];
                    g = imageData[idx * 3 + 1];
                    b = imageData[idx * 3 + 2];
                }
                r = r << 16 & 0xFF0000;
                g = g << 8 & 0xFF00;
                pixel = 0xFF000000 | r | g | (b &= 0xFF);
                packedImageData[idx++] = pixel;
            }
        }
        DirectColorModel dcm = (DirectColorModel)ColorModel.getRGBdefault();
        if (this.memoryImageSource == null) {
            this.memoryImageSource = new MemoryImageSource(w, h, (ColorModel)dcm, packedImageData, 0, w);
        } else {
            this.memoryImageSource.newPixels(packedImageData, (ColorModel)dcm, 0, w);
        }
        theImage = Toolkit.getDefaultToolkit().createImage(this.memoryImageSource);
        packedImageData = null;
        return theImage;
    }

    private boolean applyImageFilter(ImageFilter filter) {
        boolean status = true;
        ImageProducer imageProducer = this.image.getSource();
        try {
            this.image = this.createImage(new FilteredImageSource(imageProducer, filter));
            this.imageComponent.setImage(this.image);
            this.zoomTo(this.zoomFactor);
        }
        catch (Throwable err) {
            this.toolkit.beep();
            JOptionPane.showMessageDialog(this, err.getMessage(), this.getTitle(), 0);
            status = false;
        }
        return status;
    }

    private void applyDataRange(double[] newRange) {
        if (this.doAutoGainContrast && this.gainBias != null) {
            this.applyAutoGain(this.gainBias_current, newRange);
        } else {
            int w = this.dataset.getWidth();
            int h = this.dataset.getHeight();
            this.imageByteData = Tools.getBytes(this.data, newRange, w, h, !this.dataset.isDefaultImageOrder(), this.dataset.getFillValue(), true, null);
            this.image = this.createIndexedImage(this.imageByteData, this.imagePalette, w, h);
            this.setImage(this.image);
            this.zoomTo(this.zoomFactor);
            this.paletteComponent.updateRange(newRange);
        }
        this.dataRange[0] = newRange[0];
        this.dataRange[1] = newRange[1];
    }

    private class ContrastSlider
    extends JDialog
    implements ActionListener,
    ChangeListener,
    PropertyChangeListener {
        private static final long serialVersionUID = -3002524363351111565L;
        JSlider brightSlider;
        JSlider contrastSlider;
        JFormattedTextField brightField;
        JFormattedTextField contrastField;
        ImageProducer imageProducer;
        double[] autoGainBias;
        int bLevel;
        int cLevel;

        public ContrastSlider(JFrame theOwner, ImageProducer producer) {
            super(theOwner, "Brightness/Contrast", true);
            this.autoGainBias = new double[]{0.0, 0.0};
            this.bLevel = 0;
            this.cLevel = 0;
            String bLabel = "Brightness";
            String cLabel = "Contrast";
            this.imageProducer = producer;
            if (DefaultImageView.this.doAutoGainContrast && DefaultImageView.this.gainBias != null) {
                bLabel = "Bias";
                cLabel = "Gain";
                this.setTitle(bLabel + "/" + cLabel);
            }
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            NumberFormatter formatter = new NumberFormatter(numberFormat);
            formatter.setMinimum(new Integer(-100));
            formatter.setMaximum(new Integer(100));
            this.brightField = new JFormattedTextField(formatter);
            this.brightField.addPropertyChangeListener(this);
            this.brightField.setValue(new Integer(0));
            this.brightSlider = new JSlider(0, -100, 100, 0);
            this.brightSlider.setMajorTickSpacing(20);
            this.brightSlider.setPaintTicks(true);
            this.brightSlider.setPaintLabels(true);
            this.brightSlider.addChangeListener(this);
            this.brightSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            formatter = new NumberFormatter(numberFormat);
            formatter.setMinimum(new Integer(-100));
            formatter.setMaximum(new Integer(100));
            this.contrastField = new JFormattedTextField(formatter);
            this.contrastField.addPropertyChangeListener(this);
            this.contrastField.setValue(new Integer(0));
            this.contrastSlider = new JSlider(0, -100, 100, 0);
            this.contrastSlider.setMajorTickSpacing(20);
            this.contrastSlider.setPaintTicks(true);
            this.contrastSlider.setPaintLabels(true);
            this.contrastSlider.addChangeListener(this);
            this.contrastSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            JPanel contentPane = (JPanel)this.getContentPane();
            contentPane.setLayout(new BorderLayout(5, 5));
            contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            contentPane.setPreferredSize(new Dimension(500, 300));
            JPanel brightPane = new JPanel();
            brightPane.setBorder(new TitledBorder(bLabel + "%"));
            brightPane.setLayout(new BorderLayout());
            brightPane.add((Component)this.brightField, "North");
            brightPane.add((Component)this.brightSlider, "Center");
            JPanel contrastPane = new JPanel();
            contrastPane.setBorder(new TitledBorder(cLabel + "%"));
            contrastPane.setLayout(new BorderLayout());
            contrastPane.add((Component)this.contrastField, "North");
            contrastPane.add((Component)this.contrastSlider, "Center");
            JPanel mainPane = new JPanel();
            mainPane.setLayout(new GridLayout(2, 1, 5, 5));
            mainPane.add(brightPane);
            mainPane.add(contrastPane);
            contentPane.add((Component)mainPane, "Center");
            JPanel confirmP = new JPanel();
            JButton button = new JButton("   Ok   ");
            button.setMnemonic(79);
            button.setActionCommand("Ok_brightness_change");
            button.addActionListener(this);
            confirmP.add(button);
            button = new JButton("Cancel");
            button.setMnemonic(67);
            button.setActionCommand("Cancel_brightness_change");
            button.addActionListener(this);
            confirmP.add(button);
            button = new JButton("Apply");
            button.setMnemonic(65);
            button.setActionCommand("Apply_brightness_change");
            button.addActionListener(this);
            confirmP.add(button);
            contentPane.add((Component)confirmP, "South");
            contentPane.add((Component)new JLabel(" "), "North");
            Point l = this.getParent().getLocation();
            Dimension d = this.getParent().getPreferredSize();
            l.x += 300;
            l.y += 200;
            this.setLocation(l);
            this.pack();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals("Ok_brightness_change") || cmd.equals("Apply_brightness_change")) {
                int b = ((Number)this.brightField.getValue()).intValue();
                int c = ((Number)this.contrastField.getValue()).intValue();
                this.applyBrightContrast(b, c);
                if (cmd.startsWith("Ok")) {
                    this.bLevel = b;
                    this.cLevel = c;
                    this.setVisible(false);
                }
            } else if (cmd.equals("Cancel_brightness_change")) {
                this.applyBrightContrast(this.bLevel, this.cLevel);
                this.setVisible(false);
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object source = e.getSource();
            if (!(source instanceof JSlider)) {
                return;
            }
            JSlider slider = (JSlider)source;
            int value = slider.getValue();
            if (slider.equals(this.brightSlider)) {
                this.brightField.setValue(new Integer(value));
            } else if (slider.equals(this.contrastSlider)) {
                this.contrastField.setValue(new Integer(value));
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Object source = e.getSource();
            if ("value".equals(e.getPropertyName())) {
                Number num = (Number)e.getNewValue();
                if (num == null) {
                    return;
                }
                double value = num.doubleValue();
                if (value > 100.0) {
                    value = 100.0;
                } else if (value < -100.0) {
                    value = -100.0;
                }
                if (source.equals(this.brightField) && this.brightSlider != null) {
                    this.brightSlider.setValue((int)value);
                } else if (source.equals(this.contrastField) && this.contrastSlider != null) {
                    this.contrastSlider.setValue((int)value);
                }
            }
        }

        private void applyBrightContrast(int blevel, int clevel) {
            if (DefaultImageView.this.doAutoGainContrast && DefaultImageView.this.gainBias != null) {
                this.autoGainBias[0] = DefaultImageView.this.gainBias[0] * (1.0 + (double)clevel / 100.0);
                this.autoGainBias[1] = DefaultImageView.this.gainBias[1] * (1.0 + (double)blevel / 100.0);
                DefaultImageView.this.applyAutoGain(this.autoGainBias, null);
            } else {
                BrightnessFilter filter = new BrightnessFilter(blevel, clevel);
                DefaultImageView.this.image = this.createImage(new FilteredImageSource(this.imageProducer, filter));
                DefaultImageView.this.imageComponent.setImage(DefaultImageView.this.image);
                DefaultImageView.this.zoomTo(DefaultImageView.this.zoomFactor);
            }
        }
    }

    private class DataRangeDialog
    extends JDialog
    implements ActionListener,
    ChangeListener,
    PropertyChangeListener {
        final int W = 500;
        final int H = 400;
        double[] minmax_current;
        double min;
        double max;
        final double[] minmax_previous;
        final double[] minmax_dist;
        JSlider minSlider;
        JSlider maxSlider;
        JFormattedTextField minField;
        JFormattedTextField maxField;

        public DataRangeDialog(JFrame theOwner, double[] minmaxCurrent, double[] minmaxOriginal, final int[] dataDist) {
            super(theOwner, "Image Vaule Range", true);
            this.W = 500;
            this.H = 400;
            this.minmax_current = new double[]{0.0, 0.0};
            this.minmax_previous = new double[]{0.0, 0.0};
            this.minmax_dist = new double[]{0.0, 0.0};
            Tools.findMinMax(dataDist, this.minmax_dist, null);
            if (minmaxCurrent == null || minmaxCurrent.length <= 1) {
                this.minmax_current[0] = 0.0;
                this.minmax_current[1] = 255.0;
            } else {
                if (minmaxCurrent[0] == minmaxCurrent[1]) {
                    Tools.findMinMax(DefaultImageView.this.data, minmaxCurrent, DefaultImageView.this.dataset.getFillValue());
                }
                this.minmax_current[0] = minmaxCurrent[0];
                this.minmax_current[1] = minmaxCurrent[1];
            }
            this.minmax_previous[0] = this.min = this.minmax_current[0];
            this.minmax_previous[1] = this.max = this.minmax_current[1];
            int tickSpace = (int)(minmaxOriginal[1] - minmaxOriginal[0]) / 10;
            final DecimalFormat numberFormat = new DecimalFormat("#.##E0");
            NumberFormatter formatter = new NumberFormatter(numberFormat);
            formatter.setMinimum(new Double(this.min));
            formatter.setMaximum(new Double(this.max));
            this.minField = new JFormattedTextField(formatter);
            this.minField.addPropertyChangeListener(this);
            this.minField.setValue(new Double(this.min));
            this.maxField = new JFormattedTextField(formatter);
            this.maxField.addPropertyChangeListener(this);
            this.maxField.setValue(new Double(this.max));
            this.minSlider = new JSlider(0, (int)minmaxOriginal[0], (int)minmaxOriginal[1], (int)this.min);
            this.minSlider.setMajorTickSpacing(tickSpace);
            this.minSlider.setPaintTicks(true);
            this.minSlider.setPaintLabels(true);
            this.minSlider.addChangeListener(this);
            this.minSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            this.maxSlider = new JSlider(0, (int)minmaxOriginal[0], (int)minmaxOriginal[1], (int)this.max);
            this.maxSlider.setMajorTickSpacing(tickSpace);
            this.maxSlider.setPaintTicks(true);
            this.maxSlider.setPaintLabels(true);
            this.maxSlider.addChangeListener(this);
            this.maxSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            JPanel contentPane = (JPanel)this.getContentPane();
            contentPane.setLayout(new BorderLayout(5, 5));
            contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            contentPane.setPreferredSize(new Dimension(500, 400));
            JPanel minPane = new JPanel();
            minPane.setBorder(new TitledBorder("Lower Bound"));
            minPane.setLayout(new BorderLayout());
            minPane.add((Component)this.minField, "Center");
            minPane.add((Component)this.minSlider, "South");
            JPanel maxPane = new JPanel();
            maxPane.setBorder(new TitledBorder("Upper Bound"));
            maxPane.setLayout(new BorderLayout());
            maxPane.add((Component)this.maxField, "Center");
            maxPane.add((Component)this.maxSlider, "South");
            JPanel chartPane = new JPanel(){
                int numberOfPoints;
                int gap;
                int xgap;
                double xmin;
                double xmax;
                {
                    this.numberOfPoints = dataDist.length;
                    this.gap = 5;
                    this.xgap = 2 * this.gap;
                    this.xmin = DefaultImageView.this.originalRange[0];
                    this.xmax = DefaultImageView.this.originalRange[1];
                }

                @Override
                public void paint(Graphics g) {
                    int h = 83;
                    int w = 500;
                    int xnpoints = Math.min(10, this.numberOfPoints - 1);
                    g.drawLine(this.xgap, h, w + this.xgap, h);
                    double xp = 0.0;
                    double x = this.xmin;
                    double dw = (double)w / (double)xnpoints;
                    double dx = (this.xmax - this.xmin) / (double)xnpoints;
                    for (int i = 0; i <= xnpoints; ++i) {
                        x = this.xmin + (double)i * dx;
                        xp = (double)this.xgap + (double)i * dw;
                        g.drawLine((int)xp, h, (int)xp, h - 5);
                        g.drawString(numberFormat.format(x), (int)xp - 5, h + 20);
                    }
                    Color c = g.getColor();
                    double ymin = DataRangeDialog.this.minmax_dist[0];
                    double dy = DataRangeDialog.this.minmax_dist[1] - DataRangeDialog.this.minmax_dist[0];
                    if (dy <= 0.0) {
                        dy = 1.0;
                    }
                    xp = this.xgap;
                    double yp = 0.0;
                    g.setColor(Color.blue);
                    int barWidth = w / this.numberOfPoints;
                    if (barWidth <= 0) {
                        barWidth = 1;
                    }
                    dw = (double)w / (double)this.numberOfPoints;
                    for (int j = 0; j < this.numberOfPoints; ++j) {
                        xp = (double)this.xgap + (double)j * dw;
                        yp = (int)((double)h * ((double)dataDist[j] - ymin) / dy);
                        g.fillRect((int)xp, (int)((double)h - yp), barWidth, (int)yp);
                    }
                    g.setColor(c);
                }
            };
            JPanel mainPane = new JPanel();
            mainPane.setLayout(new GridLayout(3, 1, 5, 5));
            mainPane.add(chartPane);
            mainPane.add(minPane);
            mainPane.add(maxPane);
            contentPane.add((Component)mainPane, "Center");
            JPanel confirmP = new JPanel();
            JButton button = new JButton("   Ok   ");
            button.setMnemonic(79);
            button.setActionCommand("Ok");
            button.addActionListener(this);
            confirmP.add(button);
            button = new JButton("Cancel");
            button.setMnemonic(67);
            button.setActionCommand("Cancel");
            button.addActionListener(this);
            confirmP.add(button);
            button = new JButton("Apply");
            button.setMnemonic(65);
            button.setActionCommand("Apply");
            button.addActionListener(this);
            confirmP.add(button);
            contentPane.add((Component)confirmP, "South");
            contentPane.add((Component)new JLabel(" "), "North");
            if (this.max - this.min < 2.0) {
                this.minSlider.setEnabled(false);
                this.maxSlider.setEnabled(false);
            }
            Point l = this.getParent().getLocation();
            Dimension d = this.getParent().getPreferredSize();
            l.x += 300;
            l.y += 200;
            this.setLocation(l);
            this.pack();
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals("Ok")) {
                this.minmax_current[0] = ((Number)this.minField.getValue()).doubleValue();
                this.minmax_current[1] = ((Number)this.maxField.getValue()).doubleValue();
                this.dispose();
            }
            if (cmd.equals("Apply")) {
                this.minmax_previous[0] = this.minmax_current[0];
                this.minmax_previous[1] = this.minmax_current[1];
                this.minmax_current[0] = ((Number)this.minField.getValue()).doubleValue();
                this.minmax_current[1] = ((Number)this.maxField.getValue()).doubleValue();
                DefaultImageView.this.applyDataRange(this.minmax_current);
                this.minmax_current[1] = 0.0;
                this.minmax_current[0] = 0.0;
            } else if (cmd.equals("Cancel")) {
                this.minmax_current[0] = this.minmax_previous[0];
                this.minmax_current[1] = this.minmax_previous[1];
                DefaultImageView.this.applyDataRange(this.minmax_previous);
                this.dispose();
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object source = e.getSource();
            if (!(source instanceof JSlider)) {
                return;
            }
            JSlider slider = (JSlider)source;
            if (!slider.isEnabled()) {
                return;
            }
            double value = slider.getValue();
            if (slider.equals(this.minSlider)) {
                double maxValue = this.maxSlider.getValue();
                if (value > maxValue) {
                    value = maxValue;
                    slider.setValue((int)value);
                }
                this.minField.setValue(new Double(value));
            } else if (slider.equals(this.maxSlider)) {
                double minValue = this.minSlider.getValue();
                if (value < minValue) {
                    value = minValue;
                    slider.setValue((int)value);
                }
                this.maxField.setValue(new Double(value));
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Object source = e.getSource();
            if ("value".equals(e.getPropertyName())) {
                Number num = (Number)e.getNewValue();
                if (num == null) {
                    return;
                }
                double value = num.doubleValue();
                if (source.equals(this.minField) && this.minSlider != null && this.minSlider.isEnabled()) {
                    int maxValue = this.maxSlider.getValue();
                    if (value > (double)maxValue) {
                        value = maxValue;
                        this.minField.setText(String.valueOf(value));
                    }
                    this.minSlider.setValue((int)value);
                } else if (source.equals(this.maxField) && this.maxSlider != null && this.minSlider.isEnabled()) {
                    int minValue = this.minSlider.getValue();
                    if (value < (double)minValue) {
                        value = minValue;
                        this.maxField.setText(String.valueOf(value));
                    }
                    this.maxSlider.setValue((int)value);
                }
            }
        }

        public double[] getRange() {
            return this.minmax_current;
        }
    }

    private class Animation
    extends JDialog
    implements ActionListener,
    Runnable {
        private static final long serialVersionUID = 6717628496771098250L;
        private final int MAX_ANIMATION_IMAGE_SIZE = 300;
        private Image[] frames;
        private JComponent canvas;
        private Thread engine;
        private int numberOfImages;
        private int currentFrame;
        private int sleepTime;
        private Image offScrImage;
        private Graphics offScrGC;
        private JFrame owner;
        private int x0;
        private int y0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Animation(JFrame theOwner, ScalarDS dataset) {
            super(theOwner, "Animation", true);
            this.MAX_ANIMATION_IMAGE_SIZE = 300;
            this.frames = null;
            this.canvas = null;
            this.engine = null;
            this.numberOfImages = 0;
            this.currentFrame = 0;
            this.sleepTime = 200;
            this.x0 = 0;
            this.y0 = 0;
            this.owner = theOwner;
            this.setDefaultCloseOperation(2);
            long[] dims = dataset.getDims();
            long[] stride = dataset.getStride();
            long[] start = dataset.getStartDims();
            long[] selected = dataset.getSelectedDims();
            int[] selectedIndex = dataset.getSelectedIndex();
            int rank = dataset.getRank();
            if (DefaultImageView.this.animationSpeed != 0) {
                this.sleepTime = 1000 / DefaultImageView.this.animationSpeed;
            }
            long[] tstart = new long[rank];
            long[] tselected = new long[rank];
            long[] tstride = new long[rank];
            System.arraycopy(start, 0, tstart, 0, rank);
            System.arraycopy(selected, 0, tselected, 0, rank);
            System.arraycopy(stride, 0, tstride, 0, rank);
            int stride_n = 1;
            int max_size = (int)Math.max(selected[selectedIndex[0]], selected[selectedIndex[1]]);
            if (max_size > 300) {
                stride_n = (int)((double)max_size / 300.0 + 0.5);
            }
            start[selectedIndex[0]] = 0L;
            start[selectedIndex[1]] = 0L;
            start[selectedIndex[2]] = 0L;
            selected[selectedIndex[0]] = dims[selectedIndex[0]] / (long)stride_n;
            selected[selectedIndex[1]] = dims[selectedIndex[1]] / (long)stride_n;
            selected[selectedIndex[2]] = 1L;
            stride[selectedIndex[0]] = stride_n;
            stride[selectedIndex[1]] = stride_n;
            stride[selectedIndex[2]] = 1L;
            Object data3d = null;
            byte[] byteData = null;
            int h = (int)selected[selectedIndex[0]];
            int w = (int)selected[selectedIndex[1]];
            int size = w * h;
            this.numberOfImages = (int)dims[selectedIndex[2]];
            this.frames = new Image[this.numberOfImages];
            MemoryImageSource mir = DefaultImageView.this.memoryImageSource;
            try {
                for (int i = 0; i < this.numberOfImages; ++i) {
                    DefaultImageView.this.memoryImageSource = null;
                    start[selectedIndex[2]] = i;
                    dataset.clearData();
                    try {
                        data3d = dataset.read();
                    }
                    catch (Throwable err) {
                        continue;
                    }
                    byteData = new byte[size];
                    byteData = Tools.getBytes(data3d, DefaultImageView.this.dataRange, w, h, false, dataset.getFillValue(), true, byteData);
                    this.frames[i] = DefaultImageView.this.createIndexedImage(byteData, DefaultImageView.this.imagePalette, w, h);
                }
            }
            finally {
                DefaultImageView.this.memoryImageSource = mir;
                System.arraycopy(tstart, 0, start, 0, rank);
                System.arraycopy(tselected, 0, selected, 0, rank);
                System.arraycopy(tstride, 0, stride, 0, rank);
            }
            this.offScrImage = this.owner.createImage(w, h);
            this.offScrGC = this.offScrImage.getGraphics();
            this.x0 = Math.max((300 - w) / 2, 0);
            this.y0 = Math.max((300 - h) / 2, 0);
            this.canvas = new JComponent(){
                private static final long serialVersionUID = -6828735330511795835L;

                @Override
                public void paint(Graphics g) {
                    g.clearRect(0, 0, 300, 300);
                    if (Animation.this.offScrGC == null || Animation.this.frames == null) {
                        return;
                    }
                    Animation.this.offScrGC.drawImage(Animation.this.frames[Animation.this.currentFrame], 0, 0, Animation.this.owner);
                    g.drawImage(Animation.this.offScrImage, Animation.this.x0, Animation.this.y0, Animation.this.owner);
                }
            };
            JPanel contentPane = (JPanel)this.getContentPane();
            contentPane.setPreferredSize(new Dimension(300, 300));
            contentPane.setLayout(new BorderLayout());
            JButton b = new JButton("Close");
            b.setActionCommand("Close animation");
            b.addActionListener(this);
            contentPane.add((Component)b, "South");
            contentPane.add((Component)this.canvas, "Center");
            this.start();
            Point l = this.getParent().getLocation();
            l.x += 300;
            l.y += 200;
            this.setLocation(l);
            this.pack();
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            String cmd = e.getActionCommand();
            if (cmd.equals("Close animation")) {
                this.dispose();
            }
        }

        @Override
        public void dispose() {
            this.engine = null;
            this.frames = null;
            super.dispose();
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public void paint(Graphics g) {
            this.canvas.paint(g);
        }

        private void start() {
            this.engine = new Thread(this);
            this.engine.start();
        }

        @Override
        public void run() {
            Thread me = Thread.currentThread();
            if (this.frames == null || this.canvas == null) {
                return;
            }
            while (me == this.engine) {
                if (++this.currentFrame >= this.numberOfImages) {
                    this.currentFrame = 0;
                }
                this.repaint();
                this.getToolkit().sync();
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class Rotate90Filter
    extends ImageFilter {
        private ColorModel defaultRGB = ColorModel.getRGBdefault();
        private double[] coord = new double[2];
        private int[] raster;
        private int xoffset;
        private int yoffset;
        private int srcW;
        private int srcH;
        private int dstW;
        private int dstH;
        private int direction;

        public Rotate90Filter(int dir) {
            this.direction = dir;
        }

        public void transform(double x, double y, double[] retcoord) {
            if (this.direction == 10) {
                retcoord[0] = -y;
                retcoord[1] = x;
            } else {
                retcoord[0] = y;
                retcoord[1] = -x;
            }
        }

        public void itransform(double x, double y, double[] retcoord) {
            if (this.direction == 11) {
                retcoord[0] = -y;
                retcoord[1] = x;
            } else {
                retcoord[0] = y;
                retcoord[1] = -x;
            }
        }

        public void transformBBox(Rectangle rect) {
            double minx = Double.POSITIVE_INFINITY;
            double miny = Double.POSITIVE_INFINITY;
            double maxx = Double.NEGATIVE_INFINITY;
            double maxy = Double.NEGATIVE_INFINITY;
            for (int y = 0; y <= 1; ++y) {
                for (int x = 0; x <= 1; ++x) {
                    this.transform(rect.x + x * rect.width, rect.y + y * rect.height, this.coord);
                    minx = Math.min(minx, this.coord[0]);
                    miny = Math.min(miny, this.coord[1]);
                    maxx = Math.max(maxx, this.coord[0]);
                    maxy = Math.max(maxy, this.coord[1]);
                }
            }
            rect.x = (int)Math.floor(minx);
            rect.y = (int)Math.floor(miny);
            rect.width = (int)Math.ceil(maxx) - rect.x;
            rect.height = (int)Math.ceil(maxy) - rect.y;
        }

        @Override
        public void setDimensions(int width, int height) {
            Rectangle rect = new Rectangle(0, 0, width, height);
            this.transformBBox(rect);
            this.xoffset = -rect.x;
            this.yoffset = -rect.y;
            this.srcW = width;
            this.srcH = height;
            this.dstW = rect.width;
            this.dstH = rect.height;
            this.raster = new int[this.srcW * this.srcH];
            this.consumer.setDimensions(this.dstW, this.dstH);
        }

        public void setProperties(Hashtable props) {
            Object o = (props = (Hashtable)props.clone()).get("filters");
            if (o == null) {
                props.put("filters", this.toString());
            } else if (o instanceof String) {
                props.put("filters", (String)o + this.toString());
            }
            this.consumer.setProperties(props);
        }

        @Override
        public void setColorModel(ColorModel model) {
            this.consumer.setColorModel(this.defaultRGB);
        }

        @Override
        public void setHints(int hintflags) {
            this.consumer.setHints(0xE | hintflags & 0x10);
        }

        @Override
        public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
            int srcoff = off;
            int dstoff = y * this.srcW + x;
            for (int yc = 0; yc < h; ++yc) {
                for (int xc = 0; xc < w; ++xc) {
                    this.raster[dstoff++] = model.getRGB(pixels[srcoff++] & 0xFF);
                }
                srcoff += scansize - w;
                dstoff += this.srcW - w;
            }
        }

        @Override
        public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
            int srcoff = off;
            int dstoff = y * this.srcW + x;
            if (model == this.defaultRGB) {
                for (int yc = 0; yc < h; ++yc) {
                    System.arraycopy(pixels, srcoff, this.raster, dstoff, w);
                    srcoff += scansize;
                    dstoff += this.srcW;
                }
            } else {
                for (int yc = 0; yc < h; ++yc) {
                    for (int xc = 0; xc < w; ++xc) {
                        this.raster[dstoff++] = model.getRGB(pixels[srcoff++]);
                    }
                    srcoff += scansize - w;
                    dstoff += this.srcW - w;
                }
            }
        }

        @Override
        public void imageComplete(int status) {
            if (status == 1 || status == 4) {
                this.consumer.imageComplete(status);
                return;
            }
            int[] pixels = new int[this.dstW];
            for (int dy = 0; dy < this.dstH; ++dy) {
                this.itransform(0 - this.xoffset, dy - this.yoffset, this.coord);
                double x1 = this.coord[0];
                double y1 = this.coord[1];
                this.itransform(this.dstW - this.xoffset, dy - this.yoffset, this.coord);
                double x2 = this.coord[0];
                double y2 = this.coord[1];
                double xinc = (x2 - x1) / (double)this.dstW;
                double yinc = (y2 - y1) / (double)this.dstW;
                for (int dx = 0; dx < this.dstW; ++dx) {
                    int sx = (int)Math.round(x1);
                    int sy = (int)Math.round(y1);
                    pixels[dx] = sx < 0 || sy < 0 || sx >= this.srcW || sy >= this.srcH ? 0 : this.raster[sy * this.srcW + sx];
                    x1 += xinc;
                    y1 += yinc;
                }
                this.consumer.setPixels(0, dy, this.dstW, 1, this.defaultRGB, pixels, 0, this.dstW);
            }
            this.consumer.imageComplete(status);
        }
    }

    private class ContourFilter
    extends ImageFilter {
        private ColorModel defaultRGB = ColorModel.getRGBdefault();
        int level;
        int[] levels;
        int[] levelColors = new int[9];
        private int[] raster = null;
        private int imageWidth;
        private int imageHeight;

        private ContourFilter(int theLevel) {
            if (theLevel < 1) {
                theLevel = 1;
            } else if (theLevel > 9) {
                theLevel = 9;
            }
            this.level = theLevel;
            this.levels = new int[this.level];
            this.levelColors[0] = Color.white.getRGB();
            this.levelColors[1] = Color.red.getRGB();
            this.levelColors[2] = Color.yellow.getRGB();
            this.levelColors[3] = Color.blue.getRGB();
            this.levelColors[4] = Color.orange.getRGB();
            this.levelColors[5] = Color.green.getRGB();
            this.levelColors[6] = Color.cyan.getRGB();
            this.levelColors[7] = Color.pink.getRGB();
            this.levelColors[8] = Color.gray.getRGB();
            int dx = 255 / this.level;
            for (int i = 0; i < this.level; ++i) {
                this.levels[i] = (i + 1) * dx;
            }
        }

        @Override
        public void setDimensions(int width, int height) {
            this.imageWidth = width;
            this.imageHeight = height;
            if (this.raster == null) {
                this.raster = new int[this.imageWidth * this.imageHeight];
            }
            this.consumer.setDimensions(width, height);
        }

        @Override
        public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
            int rgb = 0;
            int srcoff = off;
            int dstoff = y * this.imageWidth + x;
            for (int yc = 0; yc < h; ++yc) {
                for (int xc = 0; xc < w; ++xc) {
                    rgb = model.getRGB(pixels[srcoff++] & 0xFF);
                    this.raster[dstoff++] = ((rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF)) / 3;
                }
                srcoff += scansize - w;
                dstoff += this.imageWidth - w;
            }
        }

        @Override
        public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
            int rgb = 0;
            int srcoff = off;
            int dstoff = y * this.imageWidth + x;
            for (int yc = 0; yc < h; ++yc) {
                for (int xc = 0; xc < w; ++xc) {
                    rgb = model.getRGB(pixels[srcoff++] & 0xFF);
                    this.raster[dstoff++] = ((rgb >> 16 & 0xFF) + (rgb >> 8 & 0xFF) + (rgb & 0xFF)) / 3;
                }
                srcoff += scansize - w;
                dstoff += this.imageWidth - w;
            }
        }

        @Override
        public void imageComplete(int status) {
            if (status == 1 || status == 4) {
                this.consumer.imageComplete(status);
                return;
            }
            int[] pixels = new int[this.imageWidth * this.imageHeight];
            for (int z = 0; z < this.levels.length; ++z) {
                int currentLevel = this.levels[z];
                int color = this.levelColors[z];
                this.setContourLine(this.raster, pixels, currentLevel, color, this.imageWidth, this.imageHeight);
            }
            int[] line = new int[this.imageWidth];
            for (int y = 0; y < this.imageHeight; ++y) {
                for (int x = 0; x < this.imageWidth; ++x) {
                    line[x] = pixels[y * this.imageWidth + x];
                }
                this.consumer.setPixels(0, y, this.imageWidth, 1, this.defaultRGB, line, 0, this.imageWidth);
            }
            this.consumer.imageComplete(status);
        }

        private void setContourLine(int[] raster, int[] pixels, int level, int color, int w, int h) {
            int p = 0;
            int q = p + (w * h - 1);
            int u = 0 + (w - 1);
            while (true) {
                if (p < u) {
                    int rgb = raster[p];
                    if (rgb < level) {
                        while (raster[p] < level && p < u) {
                            ++p;
                        }
                        if (raster[p] < level) continue;
                        pixels[p] = color;
                        continue;
                    }
                    if (rgb == level) {
                        while (raster[p] == level && p < u) {
                            ++p;
                        }
                        if (raster[p] >= level && raster[p] <= level) continue;
                        pixels[p] = color;
                        continue;
                    }
                    while (raster[p] > level && p < u) {
                        ++p;
                    }
                    if (raster[p] > level) continue;
                    pixels[p] = color;
                    continue;
                }
                if (u == q) break;
                u += w;
                ++p;
            }
        }
    }

    private class BrightnessFilter
    extends RGBImageFilter {
        int brightLevel = 0;
        float contrastLevel = 0.0f;

        public BrightnessFilter(int blevel, int clevel) {
            this.brightLevel = blevel < -100 ? -100 : (blevel > 100 ? 100 : blevel);
            this.brightLevel *= 2;
            if (clevel < -100) {
                clevel = -100;
            } else if (clevel > 100) {
                clevel = 100;
            }
            this.contrastLevel = clevel > 0 ? ((float)clevel / 100.0f + 1.0f) * 2.0f : (clevel < 0 ? ((float)clevel / 100.0f + 1.0f) / 2.0f : 0.0f);
            this.canFilterIndexColorModel = true;
        }

        @Override
        public int filterRGB(int x, int y, int rgb) {
            int b;
            int g;
            int r;
            if (this.brightLevel != 0) {
                r = (rgb & 0xFF0000) >> 16;
                g = (rgb & 0xFF00) >> 8;
                b = rgb & 0xFF;
                g += this.brightLevel;
                b += this.brightLevel;
                if ((r += this.brightLevel) < 0) {
                    r = 0;
                }
                if (r > 255) {
                    r = 255;
                }
                if (g < 0) {
                    g = 0;
                }
                if (g > 255) {
                    g = 255;
                }
                if (b < 0) {
                    b = 0;
                }
                if (b > 255) {
                    b = 255;
                }
                r = r << 16 & 0xFF0000;
                g = g << 8 & 0xFF00;
                rgb = rgb & 0xFF000000 | r | g | (b &= 0xFF);
            }
            if ((double)this.contrastLevel > 1.0E-6) {
                r = (rgb & 0xFF0000) >> 16;
                g = (rgb & 0xFF00) >> 8;
                b = rgb & 0xFF;
                float f = (float)r / 255.0f;
                f = (float)((double)f - 0.5);
                f *= this.contrastLevel;
                f = (float)((double)f + 0.5);
                if ((f *= 255.0f) < 0.0f) {
                    f = 0.0f;
                }
                if (f > 255.0f) {
                    f = 255.0f;
                }
                r = (int)f;
                f = (float)g / 255.0f;
                f = (float)((double)f - 0.5);
                f *= this.contrastLevel;
                f = (float)((double)f + 0.5);
                if ((f *= 255.0f) < 0.0f) {
                    f = 0.0f;
                }
                if (f > 255.0f) {
                    f = 255.0f;
                }
                g = (int)f;
                f = (float)b / 255.0f;
                f = (float)((double)f - 0.5);
                f *= this.contrastLevel;
                f = (float)((double)f + 0.5);
                if ((f *= 255.0f) < 0.0f) {
                    f = 0.0f;
                }
                if (f > 255.0f) {
                    f = 255.0f;
                }
                b = (int)f;
                r = r << 16 & 0xFF0000;
                g = g << 8 & 0xFF00;
                rgb = rgb & 0xFF000000 | r | g | (b &= 0xFF);
            }
            return rgb;
        }
    }

    private class FlipFilter
    extends ImageFilter {
        private int direction;
        private int[] raster = null;
        private int imageWidth;
        private int imageHeight;

        private FlipFilter(int d) {
            if (d < 0) {
                d = 0;
            } else if (d > 1) {
                d = 1;
            }
            this.direction = d;
        }

        @Override
        public void setDimensions(int w, int h) {
            this.imageWidth = w;
            this.imageHeight = h;
            if (this.raster == null) {
                this.raster = new int[this.imageWidth * this.imageHeight];
            }
            this.consumer.setDimensions(this.imageWidth, this.imageHeight);
        }

        @Override
        public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
            int srcoff = off;
            int dstoff = y * this.imageWidth + x;
            for (int yc = 0; yc < h; ++yc) {
                for (int xc = 0; xc < w; ++xc) {
                    this.raster[dstoff++] = model.getRGB(pixels[srcoff++] & 0xFF);
                }
                srcoff += scansize - w;
                dstoff += this.imageWidth - w;
            }
        }

        @Override
        public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
            int srcoff = off;
            int dstoff = y * this.imageWidth + x;
            for (int yc = 0; yc < h; ++yc) {
                for (int xc = 0; xc < w; ++xc) {
                    this.raster[dstoff++] = model.getRGB(pixels[srcoff++]);
                }
                srcoff += scansize - w;
                dstoff += this.imageWidth - w;
            }
        }

        @Override
        public void imageComplete(int status) {
            if (status == 1 || status == 4) {
                this.consumer.imageComplete(status);
                return;
            }
            int[] pixels = new int[this.imageWidth];
            for (int y = 0; y < this.imageHeight; ++y) {
                int kk;
                int pos;
                if (this.direction == 1) {
                    pos = (this.imageHeight - 1 - y) * this.imageWidth;
                    for (kk = 0; kk < this.imageWidth; ++kk) {
                        pixels[kk] = this.raster[pos + kk];
                    }
                } else {
                    pos = y * this.imageWidth;
                    for (kk = 0; kk < this.imageWidth; ++kk) {
                        pixels[kk] = this.raster[pos + kk];
                    }
                    int hw = this.imageWidth / 2;
                    for (int kk2 = 0; kk2 < hw; ++kk2) {
                        int tmp = pixels[kk2];
                        pixels[kk2] = pixels[this.imageWidth - kk2 - 1];
                        pixels[this.imageWidth - kk2 - 1] = tmp;
                    }
                }
                this.consumer.setPixels(0, y, this.imageWidth, 1, ColorModel.getRGBdefault(), pixels, 0, this.imageWidth);
            }
            this.consumer.imageComplete(status);
        }
    }

    private class ImageComponent
    extends JComponent
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private static final long serialVersionUID = -2690648149547151532L;
        private Dimension originalSize;
        private Dimension imageSize;
        private Image image;
        private Point startPosition;
        private Point currentPosition;
        private Rectangle selectedArea;
        private Rectangle originalSelectedArea;
        private StringBuffer strBuff;
        private int yMousePosition = 0;
        private Dimension scrollDim = null;
        private JScrollBar hbar = null;
        private JScrollBar vbar = null;

        private ImageComponent(Image img) {
            this.image = img;
            this.originalSize = this.imageSize = new Dimension(this.image.getWidth(this), this.image.getHeight(this));
            this.selectedArea = new Rectangle();
            this.originalSelectedArea = new Rectangle();
            this.setPreferredSize(this.imageSize);
            this.strBuff = new StringBuffer();
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.addMouseWheelListener(this);
        }

        @Override
        public void paint(Graphics g) {
            if (g instanceof Graphics2D && (double)DefaultImageView.this.zoomFactor < 0.99) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                Image scaledImg = this.multiBiliner(this.image, this.imageSize.width, this.imageSize.height, true);
                g2.drawImage(scaledImg, 0, 0, this.imageSize.width, this.imageSize.height, this);
            } else {
                g.drawImage(this.image, 0, 0, this.imageSize.width, this.imageSize.height, this);
            }
            if (this.selectedArea.width > 0 && this.selectedArea.height > 0) {
                g.setColor(Color.red);
                g.drawRect(this.selectedArea.x, this.selectedArea.y, this.selectedArea.width, this.selectedArea.height);
            }
        }

        private Image multiBiliner(Image img, int targetWidth, int targetHeight, boolean highquality) {
            BufferedImage tmp;
            Image ret = img;
            int w = img.getWidth(null) / 2;
            int h = img.getHeight(null) / 2;
            if (!highquality || w <= targetWidth || h <= targetHeight) {
                return ret;
            }
            int type = 1;
            if (this.image instanceof BufferedImage) {
                tmp = (BufferedImage)this.image;
                if (tmp.getColorModel().hasAlpha()) {
                    type = 2;
                }
            } else {
                PixelGrabber pg = new PixelGrabber(this.image, 0, 0, 1, 1, false);
                ColorModel cm = pg.getColorModel();
                if (cm != null && cm.hasAlpha()) {
                    type = 2;
                }
            }
            do {
                tmp = new BufferedImage(w, h, type);
                Graphics2D g2 = tmp.createGraphics();
                g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                g2.drawImage(ret, 0, 0, w, h, null);
                g2.dispose();
                ret = tmp;
                if ((w /= 2) < targetWidth) {
                    w = targetWidth;
                }
                if ((h /= 2) >= targetHeight) continue;
                h = targetHeight;
            } while (w != targetWidth || h != targetHeight);
            return ret;
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.startPosition = e.getPoint();
            this.selectedArea.setBounds(this.startPosition.x, this.startPosition.y, 0, 0);
            this.scrollDim = DefaultImageView.this.imageScroller.getSize();
            this.hbar = DefaultImageView.this.imageScroller.getHorizontalScrollBar();
            this.vbar = DefaultImageView.this.imageScroller.getVerticalScrollBar();
            if ((e.getModifiersEx() & 0x40) == 64) {
                this.setCursor(Cursor.getPredefinedCursor(1));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.startPosition = e.getPoint();
            this.selectedArea.setBounds(this.startPosition.x, this.startPosition.y, 0, 0);
            if (this.hbar.isVisible()) {
                this.hbar.setValue(this.startPosition.x - this.scrollDim.width / 2);
            }
            if (this.vbar.isVisible()) {
                this.vbar.setValue(this.startPosition.y - this.scrollDim.height / 2);
            }
            this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.currentPosition = e.getPoint();
            if ((e.getModifiersEx() & 0x40) == 64) {
                int x0 = Math.max(0, Math.min(this.startPosition.x, this.currentPosition.x));
                int y0 = Math.max(0, Math.min(this.startPosition.y, this.currentPosition.y));
                int x1 = Math.min(this.imageSize.width, Math.max(this.startPosition.x, this.currentPosition.x));
                int y1 = Math.min(this.imageSize.height, Math.max(this.startPosition.y, this.currentPosition.y));
                int w = x1 - x0;
                int h = y1 - y0;
                this.selectedArea.setBounds(x0, y0, w, h);
                double ratio = 1.0 / (double)DefaultImageView.this.zoomFactor;
                this.originalSelectedArea.setBounds((int)((double)x0 * ratio), (int)((double)y0 * ratio), (int)((double)w * ratio), (int)((double)h * ratio));
                this.repaint();
            } else {
                if (this.hbar.isVisible()) {
                    int dx = this.startPosition.x - this.currentPosition.x;
                    this.hbar.setValue(this.hbar.getValue() + dx);
                }
                if (this.vbar.isVisible()) {
                    int dy = this.startPosition.y - this.currentPosition.y;
                    this.vbar.setValue(this.vbar.getValue() + dy);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.yMousePosition = e.getY();
            this.showPixelValue(e.getX(), this.yMousePosition);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            JScrollBar jb = DefaultImageView.this.imageScroller.getVerticalScrollBar();
            int us = e.getUnitsToScroll();
            int wr = e.getWheelRotation();
            int n = us * jb.getUnitIncrement();
            int y = jb.getValue();
            if (y <= 0 && wr < 0 || (float)(y + jb.getVisibleAmount() * wr) >= DefaultImageView.this.zoomFactor * (float)this.originalSize.height) {
                return;
            }
            this.yMousePosition += n;
            jb.setValue(jb.getValue() + n);
            this.showPixelValue(e.getX(), this.yMousePosition);
        }

        private void showPixelValue(int x, int y) {
            if (!DefaultImageView.this.valueField.isVisible() || DefaultImageView.this.rotateCount != 0) {
                return;
            }
            if (DefaultImageView.this.data == null) {
                return;
            }
            x = (int)((float)x / DefaultImageView.this.zoomFactor);
            int w = this.originalSize.width;
            if (x < 0 || x >= w) {
                return;
            }
            y = (int)((float)y / DefaultImageView.this.zoomFactor);
            int h = this.originalSize.height;
            if (y < 0 || y >= h) {
                return;
            }
            if (DefaultImageView.this.isHorizontalFlipped) {
                x = w - 1 - x;
            }
            if (DefaultImageView.this.isVerticalFlipped) {
                y = h - 1 - y;
            }
            this.strBuff.setLength(0);
            this.strBuff.append("x=");
            this.strBuff.append(x + DefaultImageView.this.indexBase);
            this.strBuff.append(",   y=");
            this.strBuff.append(y + DefaultImageView.this.indexBase);
            this.strBuff.append(",   value=");
            if (DefaultImageView.this.isTrueColor) {
                String b;
                String g;
                String r;
                int i2;
                int i1;
                int i0;
                this.strBuff.append("(");
                if (DefaultImageView.this.isPlaneInterlace) {
                    i0 = y * w + x;
                    i1 = i0 + w * h;
                    i2 = i0 + 2 * w * h;
                } else {
                    i0 = 3 * (y * w + x);
                    i1 = i0 + 1;
                    i2 = i0 + 2;
                }
                if (DefaultImageView.this.isUnsigned && !DefaultImageView.this.isUnsignedConverted) {
                    r = String.valueOf(this.convertUnsignedPoint(i0));
                    g = String.valueOf(this.convertUnsignedPoint(i1));
                    b = String.valueOf(this.convertUnsignedPoint(i2));
                } else {
                    r = String.valueOf(Array.get(DefaultImageView.this.data, i0));
                    g = String.valueOf(Array.get(DefaultImageView.this.data, i1));
                    b = String.valueOf(Array.get(DefaultImageView.this.data, i2));
                }
                this.strBuff.append(r + ", " + g + ", " + b);
                this.strBuff.append(")");
            } else if (DefaultImageView.this.isUnsigned && !DefaultImageView.this.isUnsignedConverted) {
                this.strBuff.append(this.convertUnsignedPoint(y * w + x));
            } else {
                this.strBuff.append(Array.get(DefaultImageView.this.data, y * w + x));
            }
            DefaultImageView.this.valueField.setText(this.strBuff.toString());
        }

        private void selectAll() {
            this.selectedArea.setBounds(0, 0, this.imageSize.width, this.imageSize.height);
            this.originalSelectedArea.setBounds(0, 0, this.originalSize.width, this.originalSize.height);
            this.repaint();
        }

        private long convertUnsignedPoint(int idx) {
            long l = 0L;
            if (DefaultImageView.this.NT == 'B') {
                byte b = Array.getByte(DefaultImageView.this.data, idx);
                l = b < 0 ? (long)(b + 256) : (long)b;
            } else if (DefaultImageView.this.NT == 'S') {
                short s = Array.getShort(DefaultImageView.this.data, idx);
                l = s < 0 ? (long)(s + 65536) : (long)s;
            } else if (DefaultImageView.this.NT == 'I') {
                int i = Array.getInt(DefaultImageView.this.data, idx);
                l = i < 0 ? (long)i + 0x100000000L : (long)i;
            }
            return l;
        }

        private void setImageSize(Dimension size) {
            this.imageSize = size;
            this.setPreferredSize(this.imageSize);
            int w = this.selectedArea.width;
            int h = this.selectedArea.height;
            if (w > 0 && h > 0) {
                this.selectedArea.setBounds((int)((float)this.originalSelectedArea.x * DefaultImageView.this.zoomFactor), (int)((float)this.originalSelectedArea.y * DefaultImageView.this.zoomFactor), (int)((float)this.originalSelectedArea.width * DefaultImageView.this.zoomFactor), (int)((float)this.originalSelectedArea.height * DefaultImageView.this.zoomFactor));
            }
            this.repaint();
        }

        private void setImage(Image img) {
            this.image = img;
            this.originalSize = this.imageSize = new Dimension(this.image.getWidth(this), this.image.getHeight(this));
            this.selectedArea.setSize(0, 0);
            this.setPreferredSize(this.imageSize);
            this.setImageSize(new Dimension((int)((float)this.originalSize.width * DefaultImageView.this.zoomFactor), (int)((float)this.originalSize.height * DefaultImageView.this.zoomFactor)));
            this.repaint();
        }
    }

    private class PaletteComponent
    extends JComponent {
        private static final long serialVersionUID = -5194383032992628565L;
        private Color[] colors = null;
        private double[] pixelData = null;
        private Dimension paintSize = new Dimension(25, 2);
        DecimalFormat format = new DecimalFormat("0.00E0");
        double[] dRange = null;

        private PaletteComponent(byte[][] palette, double[] range) {
            this.dRange = range;
            double unsigned_celling = 0.0;
            if (palette != null && range != null) {
                double ratio = (this.dRange[1] - this.dRange[0]) / 255.0;
                this.pixelData = new double[256];
                for (int i = 0; i < 256; ++i) {
                    this.pixelData[i] = this.dRange[0] + ratio * (double)i;
                }
            }
            this.updatePalette(palette);
            this.setPreferredSize(new Dimension(this.paintSize.width + 60, this.paintSize.height * 256));
            this.setVisible(true);
        }

        private void updatePalette(byte[][] palette) {
            if (palette != null && this.dRange != null) {
                this.colors = new Color[256];
                for (int i = 0; i < 256; ++i) {
                    int b;
                    int g;
                    int r = palette[0][i];
                    if (r < 0) {
                        r += 256;
                    }
                    if ((g = palette[1][i]) < 0) {
                        g += 256;
                    }
                    if ((b = palette[2][i]) < 0) {
                        b += 256;
                    }
                    this.colors[i] = new Color(r, g, b);
                }
            }
            this.repaint();
        }

        private void updateRange(double[] newRange) {
            if (newRange == null) {
                return;
            }
            this.dRange = newRange;
            double ratio = (this.dRange[1] - this.dRange[0]) / 255.0;
            for (int i = 0; i < 256; ++i) {
                this.pixelData[i] = this.dRange[0] + ratio * (double)i;
            }
            this.repaint();
        }

        @Override
        public void paint(Graphics g) {
            int i;
            if (this.colors == null && this.pixelData == null) {
                return;
            }
            Font font = g.getFont();
            g.setFont(new Font(font.getName(), font.getStyle(), 12));
            for (i = 0; i < 256; ++i) {
                g.setColor(this.colors[i]);
                g.fillRect(0, this.paintSize.height * i, this.paintSize.width, this.paintSize.height);
            }
            g.setColor(Color.black);
            for (i = 0; i < 25; ++i) {
                g.drawString(this.format.format(this.pixelData[i * 10]), this.paintSize.width + 5, 10 + this.paintSize.height * i * 10);
            }
            g.drawString(this.format.format(this.pixelData[255]), this.paintSize.width + 5, this.paintSize.height * 255);
        }
    }
}

