/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.BitSet;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import ncsa.hdf.object.CompoundDS;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.Datatype;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.ScalarDS;
import ncsa.hdf.view.HDFView;
import ncsa.hdf.view.Tools;
import ncsa.hdf.view.ViewManager;
import ncsa.hdf.view.ViewProperties;

public class DataOptionDialog
extends JDialog
implements ActionListener,
ItemListener {
    private static final long serialVersionUID = -1078411885690696784L;
    private final ViewManager viewer;
    private Dataset dataset;
    private int rank;
    private long[] start;
    private long[] dims;
    private long[] selected;
    private long[] stride;
    private int[] selectedIndex;
    private int[] currentIndex;
    private JRadioButton spreadsheetButton;
    private JRadioButton imageButton;
    private JRadioButton base1Button;
    private JRadioButton base0Button;
    private JRadioButton[] bitmaskButtons;
    private JCheckBox applyBitmaskButton;
    private JCheckBox extractBitButton;
    private JCheckBox charCheckbox;
    private BitSet bitmask;
    private JButton bitmaskHelp;
    private JComboBox choiceTextView;
    private JComboBox choiceTableView;
    private JComboBox choiceImageView;
    private JComboBox choicePalette;
    private JComboBox[] choices;
    private JComboBox transposeChoice;
    private boolean isSelectionCancelled;
    private boolean isTrueColorImage;
    private boolean isText;
    private boolean isH5;
    private JLabel[] maxLabels;
    private JLabel selLabel;
    private JTextField[] startFields;
    private JTextField[] endFields;
    private JTextField[] strideFields;
    private JList fieldList;
    private final Toolkit toolkit;
    private final PreviewNavigator navigator;
    private int numberOfPalettes;
    private boolean performJComboBoxEvent = false;

    public DataOptionDialog(ViewManager theview, Dataset theDataset) {
        super((Frame)((JFrame)((Object)theview)), true);
        byte[] palRefs;
        this.setDefaultCloseOperation(2);
        this.viewer = theview;
        this.dataset = theDataset;
        this.isSelectionCancelled = true;
        this.isTrueColorImage = false;
        this.isText = false;
        this.bitmask = null;
        this.numberOfPalettes = 1;
        this.toolkit = Toolkit.getDefaultToolkit();
        if (this.dataset == null) {
            this.dispose();
        } else {
            this.setTitle("Dataset Selection - " + this.dataset.getPath() + this.dataset.getName());
        }
        this.isH5 = this.dataset.getFileFormat().isThisType(FileFormat.getFileFormat("HDF5"));
        this.rank = this.dataset.getRank();
        if (this.rank <= 0) {
            this.dataset.init();
        }
        if (this.isH5 && this.dataset instanceof ScalarDS && (palRefs = ((ScalarDS)this.dataset).getPaletteRefs()) != null && palRefs.length > 8) {
            this.numberOfPalettes = palRefs.length / 8;
        }
        this.rank = this.dataset.getRank();
        this.dims = this.dataset.getDims();
        this.selected = this.dataset.getSelectedDims();
        this.start = this.dataset.getStartDims();
        this.selectedIndex = this.dataset.getSelectedIndex();
        this.stride = this.dataset.getStride();
        this.fieldList = null;
        int h = 1;
        int w = 1;
        h = (int)this.dims[this.selectedIndex[0]];
        if (this.rank > 1) {
            w = (int)this.dims[this.selectedIndex[1]];
        }
        this.transposeChoice = new JComboBox();
        this.transposeChoice.addItem("Reshape");
        this.transposeChoice.addItem("Transpose");
        this.selLabel = new JLabel("", 0);
        this.navigator = new PreviewNavigator(w, h);
        this.currentIndex = new int[Math.min(3, this.rank)];
        this.choicePalette = new JComboBox();
        this.choiceTextView = new JComboBox((Vector)HDFView.getListOfTextView());
        this.choiceImageView = new JComboBox((Vector)HDFView.getListOfImageView());
        this.choiceTableView = new JComboBox((Vector)HDFView.getListOfTableView());
        this.choicePalette.addItem("Select palette");
        if (this.dataset instanceof ScalarDS) {
            String paletteName = ((ScalarDS)this.dataset).getPaletteName(0);
            if (paletteName == null) {
                paletteName = "Default";
            }
            this.choicePalette.addItem(paletteName);
            for (int i = 2; i <= this.numberOfPalettes; ++i) {
                paletteName = ((ScalarDS)this.dataset).getPaletteName(i - 1);
                this.choicePalette.addItem(paletteName);
            }
        }
        this.choicePalette.addItem("Gray");
        this.choicePalette.addItem("ReverseGray");
        this.choicePalette.addItem("GrayWave");
        this.choicePalette.addItem("Rainbow");
        this.choicePalette.addItem("Nature");
        this.choicePalette.addItem("Wave");
        this.spreadsheetButton = new JRadioButton("Spreadsheet ", true);
        this.spreadsheetButton.setMnemonic(83);
        this.imageButton = new JRadioButton("Image ");
        this.imageButton.setMnemonic(73);
        this.charCheckbox = new JCheckBox("Show As Char", false);
        this.charCheckbox.setMnemonic(67);
        this.charCheckbox.setEnabled(false);
        this.charCheckbox.addItemListener(this);
        this.extractBitButton = new JCheckBox("Show Value of Selected Bits", false);
        this.extractBitButton.setMnemonic(86);
        this.extractBitButton.setEnabled(false);
        this.extractBitButton.addItemListener(this);
        this.applyBitmaskButton = new JCheckBox("Apply Bitmask", false);
        this.applyBitmaskButton.setMnemonic(65);
        this.applyBitmaskButton.setEnabled(false);
        this.applyBitmaskButton.addItemListener(this);
        this.bitmaskHelp = new JButton(ViewProperties.getHelpIcon());
        this.bitmaskHelp.setToolTipText("Help on how to set bitmask");
        this.bitmaskHelp.setMargin(new Insets(0, 0, 0, 0));
        this.bitmaskHelp.addActionListener(this);
        this.bitmaskHelp.setActionCommand("Help on how to set bitmask");
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout(5, 5));
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        int w1 = 700 + (ViewProperties.getFontSize() - 12) * 15;
        int h1 = 350 + (ViewProperties.getFontSize() - 12) * 10;
        contentPane.setPreferredSize(new Dimension(w1, h1));
        JPanel centerP = new JPanel();
        centerP.setLayout(new BorderLayout());
        centerP.setBorder(new TitledBorder("Dimension and Subset Selection"));
        JPanel navigatorP = new JPanel();
        navigatorP.setLayout(new BorderLayout());
        navigatorP.add((Component)this.navigator, "Center");
        navigatorP.add((Component)this.selLabel, "South");
        navigatorP.setBorder(new EtchedBorder(1));
        this.performJComboBoxEvent = true;
        if (this.dataset instanceof CompoundDS) {
            CompoundDS d = (CompoundDS)this.dataset;
            String[] names = d.getMemberNames();
            this.fieldList = new JList<String>(names);
            this.fieldList.addSelectionInterval(0, names.length - 1);
            JPanel fieldP = new JPanel();
            fieldP.setLayout(new BorderLayout());
            w1 = 150 + (ViewProperties.getFontSize() - 12) * 10;
            h1 = 250 + (ViewProperties.getFontSize() - 12) * 15;
            fieldP.setPreferredSize(new Dimension(w1, h1));
            JScrollPane scrollP = new JScrollPane(this.fieldList);
            fieldP.add(scrollP);
            fieldP.setBorder(new TitledBorder("Select Members"));
            contentPane.add((Component)fieldP, "West");
            JPanel tviewP = new JPanel();
            tviewP.setLayout(new BorderLayout());
            tviewP.add((Component)new JLabel("        TableView:  "), "West");
            tviewP.add((Component)this.choiceTableView, "Center");
            tviewP.setBorder(new LineBorder(Color.LIGHT_GRAY));
            centerP.add((Component)tviewP, "South");
        } else if (this.dataset instanceof ScalarDS) {
            ScalarDS sd = (ScalarDS)this.dataset;
            this.isText = sd.isText();
            if (this.isText) {
                w1 = 700 + (ViewProperties.getFontSize() - 12) * 15;
                h1 = 280 + (ViewProperties.getFontSize() - 12) * 10;
                contentPane.setPreferredSize(new Dimension(w1, h1));
                JPanel txtviewP = new JPanel();
                txtviewP.setLayout(new BorderLayout());
                txtviewP.add((Component)new JLabel("          TextView:  "), "West");
                txtviewP.add((Component)this.choiceTextView, "Center");
                txtviewP.setBorder(new LineBorder(Color.LIGHT_GRAY));
                centerP.add((Component)txtviewP, "South");
            } else {
                w1 = 680 + (ViewProperties.getFontSize() - 12) * 15;
                h1 = 400 + (ViewProperties.getFontSize() - 12) * 10;
                contentPane.setPreferredSize(new Dimension(w1, h1));
                if (this.rank > 1) {
                    centerP.add((Component)navigatorP, "West");
                }
                this.imageButton.addItemListener(this);
                this.spreadsheetButton.addItemListener(this);
                ButtonGroup rgroup = new ButtonGroup();
                rgroup.add(this.spreadsheetButton);
                rgroup.add(this.imageButton);
                JPanel viewP = new JPanel();
                viewP.setLayout(new GridLayout(2, 1, 5, 5));
                viewP.setBorder(new TitledBorder("Display As"));
                JPanel sheetP = new JPanel();
                sheetP.setLayout(new GridLayout(1, 2, 25, 5));
                sheetP.add(this.spreadsheetButton);
                int tclass = sd.getDatatype().getDatatypeClass();
                if (tclass == 2 || tclass == 0 && sd.getDatatype().getDatatypeSize() == 1) {
                    sheetP.add(this.charCheckbox);
                }
                JPanel tviewP = new JPanel();
                tviewP.setLayout(new BorderLayout());
                tviewP.add((Component)new JLabel("TableView:   "), "West");
                tviewP.add((Component)this.choiceTableView, "Center");
                JPanel leftP = new JPanel();
                leftP.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
                leftP.setLayout(new GridLayout(2, 1, 5, 5));
                leftP.add(sheetP);
                leftP.add(tviewP);
                viewP.add(leftP);
                JPanel imageP = new JPanel();
                imageP.setLayout(new BorderLayout(5, 5));
                imageP.add((Component)this.imageButton, "West");
                imageP.add((Component)this.choicePalette, "Center");
                JPanel iviewP = new JPanel();
                iviewP.setLayout(new BorderLayout());
                iviewP.add((Component)new JLabel("ImageView: "), "West");
                iviewP.add((Component)this.choiceImageView, "Center");
                JPanel rightP = new JPanel();
                rightP.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
                rightP.setLayout(new GridLayout(2, 1, 5, 5));
                rightP.add(imageP);
                rightP.add(iviewP);
                viewP.add(rightP);
                JPanel northP = new JPanel();
                northP.setLayout(new GridLayout(1, 2, 5, 5));
                northP.add(viewP);
                viewP = new JPanel();
                viewP.setLayout(new BorderLayout());
                northP.add(viewP);
                JPanel baseIndexP = new JPanel();
                viewP.add((Component)baseIndexP, "North");
                baseIndexP.setBorder(new TitledBorder("Index Base"));
                baseIndexP.setLayout(new GridLayout(1, 2, 5, 5));
                this.base0Button = new JRadioButton("0-based ");
                this.base1Button = new JRadioButton("1-based ");
                ButtonGroup bgrp = new ButtonGroup();
                bgrp.add(this.base0Button);
                bgrp.add(this.base1Button);
                if (ViewProperties.isIndexBase1()) {
                    this.base1Button.setSelected(true);
                } else {
                    this.base0Button.setSelected(true);
                }
                baseIndexP.add(this.base0Button);
                baseIndexP.add(this.base1Button);
                if (tclass == 2 || tclass == 0 && sd.getDatatype().getDatatypeSize() <= 2) {
                    int i;
                    this.bitmaskButtons = new JRadioButton[8 * sd.getDatatype().getDatatypeSize()];
                    for (int i2 = 0; i2 < this.bitmaskButtons.length; ++i2) {
                        this.bitmaskButtons[i2] = new JRadioButton(String.valueOf(i2));
                        this.bitmaskButtons[i2].setEnabled(false);
                        this.bitmaskButtons[i2].addItemListener(this);
                    }
                    JPanel sheetP2 = new JPanel();
                    viewP.add((Component)sheetP2, "Center");
                    sheetP2.setBorder(new TitledBorder("Bitmask"));
                    JPanel tmpP = new JPanel();
                    if (this.bitmaskButtons.length <= 8) {
                        tmpP.setLayout(new GridLayout(1, this.bitmaskButtons.length));
                        for (i = this.bitmaskButtons.length; i > 0; --i) {
                            tmpP.add(this.bitmaskButtons[i - 1]);
                        }
                    } else {
                        tmpP.setLayout(new GridLayout(2, this.bitmaskButtons.length / 2));
                        for (i = this.bitmaskButtons.length; i > this.bitmaskButtons.length / 2; --i) {
                            tmpP.add(this.bitmaskButtons[i - 1]);
                        }
                        for (i = this.bitmaskButtons.length / 2; i > 0; --i) {
                            tmpP.add(this.bitmaskButtons[i - 1]);
                        }
                    }
                    sheetP2.setLayout(new BorderLayout(10, 10));
                    sheetP2.add((Component)tmpP, "Center");
                    sheetP2.add((Component)new JLabel(), "North");
                    JPanel tmpP2 = new JPanel();
                    tmpP2.setLayout(new GridLayout(2, 1));
                    tmpP2.add(this.extractBitButton);
                    tmpP2.add(this.applyBitmaskButton);
                    tmpP = new JPanel();
                    tmpP.setLayout(new BorderLayout());
                    tmpP.add((Component)tmpP2, "West");
                    tmpP2 = new JPanel();
                    tmpP2.add(this.bitmaskHelp);
                    tmpP.add((Component)tmpP2, "East");
                    sheetP2.add((Component)tmpP, "North");
                }
                contentPane.add((Component)northP, "North");
            }
        }
        JPanel selectionP = new JPanel();
        selectionP.setLayout(new GridLayout(5, 6, 10, 3));
        selectionP.setBorder(new EtchedBorder(1));
        centerP.add((Component)selectionP, "Center");
        contentPane.add((Component)centerP, "Center");
        selectionP.add(new JLabel(" "));
        if (this.rank > 1) {
            selectionP.add(this.transposeChoice);
        } else {
            selectionP.add(new JLabel(" "));
        }
        JLabel label = new JLabel("Start:");
        selectionP.add(label);
        label = new JLabel("End: ");
        selectionP.add(label);
        label = new JLabel("Stride:");
        selectionP.add(label);
        label = new JLabel("Max Size");
        selectionP.add(label);
        this.choices = new JComboBox[3];
        this.maxLabels = new JLabel[3];
        this.startFields = new JTextField[3];
        this.endFields = new JTextField[3];
        this.strideFields = new JTextField[3];
        JLabel[] dimLabels = new JLabel[]{new JLabel("Height", 4), new JLabel("Width", 4), new JLabel("Depth", 4)};
        String[] dimNames = this.dataset.getDimNames();
        for (int i = 0; i < 3; ++i) {
            this.choices[i] = new JComboBox();
            this.choices[i].addItemListener(this);
            for (int j = 0; j < this.rank; ++j) {
                if (dimNames == null) {
                    this.choices[i].addItem("dim " + j);
                    continue;
                }
                this.choices[i].addItem(dimNames[j]);
            }
            this.maxLabels[i] = new JLabel("1");
            this.startFields[i] = new JTextField("0");
            this.endFields[i] = new JTextField("0");
            this.strideFields[i] = new JTextField("1");
            selectionP.add(dimLabels[i]);
            selectionP.add(this.choices[i]);
            selectionP.add(this.startFields[i]);
            selectionP.add(this.endFields[i]);
            selectionP.add(this.strideFields[i]);
            selectionP.add(this.maxLabels[i]);
            this.choices[i].setEnabled(false);
            this.startFields[i].setEnabled(false);
            this.endFields[i].setEnabled(false);
            this.strideFields[i].setEnabled(false);
            this.maxLabels[i].setEnabled(false);
        }
        JButton button = new JButton("dims...");
        selectionP.add(new JLabel("", 4));
        selectionP.add(button);
        button.setActionCommand("Select more dimensions");
        button.addActionListener(this);
        button.setEnabled(this.rank > 3);
        selectionP.add(new JLabel(" "));
        selectionP.add(new JLabel(" "));
        button = new JButton("Reset");
        button.setActionCommand("Reset data range");
        button.addActionListener(this);
        selectionP.add(button);
        selectionP.add(new JLabel(" "));
        JPanel confirmP = new JPanel();
        contentPane.add((Component)confirmP, "South");
        button = new JButton("   Ok   ");
        button.setMnemonic(79);
        button.setActionCommand("Ok");
        button.addActionListener(this);
        confirmP.add(button);
        button = new JButton("Cancel");
        button.setMnemonic(67);
        button.setActionCommand("Cancel");
        button.addActionListener(this);
        confirmP.add(button);
        this.init();
        Point l = this.getParent().getLocation();
        l.x += 250;
        l.y += 80;
        this.setLocation(l);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("Ok")) {
            if (this.dataset instanceof ScalarDS && this.imageButton.isSelected()) {
                this.setPalette();
            }
            boolean bl = this.isSelectionCancelled = !this.setSelection();
            if (this.isSelectionCancelled) {
                return;
            }
            if (this.dataset instanceof ScalarDS) {
                ((ScalarDS)this.dataset).setIsImageDisplay(this.imageButton.isSelected());
            }
            this.dispose();
        } else if (cmd.equals("Cancel")) {
            this.dispose();
        } else if (cmd.equals("Reset data range")) {
            int n = this.startFields.length;
            for (int i = 0; i < n; ++i) {
                this.startFields[i].setText("0");
                this.strideFields[i].setText("1");
                long l = Long.valueOf(this.maxLabels[i].getText()) - 1L;
                this.endFields[i].setText(String.valueOf(l));
            }
        } else if (cmd.equals("Select more dimensions")) {
            int i;
            if (this.rank < 4) {
                return;
            }
            int idx = 0;
            Vector choice4 = new Vector(this.rank);
            int[] choice4Index = new int[this.rank - 3];
            for (int i2 = 0; i2 < this.rank; ++i2) {
                if (i2 == this.currentIndex[0] || i2 == this.currentIndex[1] || i2 == this.currentIndex[2]) continue;
                choice4.add(this.choices[0].getItemAt(i2));
                choice4Index[idx++] = i2;
            }
            String msg = "Select slice location for dimension(s):\n\"" + choice4.get(0) + " [0 .. " + (this.dims[choice4Index[0]] - 1L) + "]\"";
            String initValue = String.valueOf(this.start[choice4Index[0]]);
            int n = choice4.size();
            for (int i3 = 1; i3 < n; ++i3) {
                msg = msg + " x \"" + choice4.get(i3) + " [0 .. " + (this.dims[choice4Index[i3]] - 1L) + "]\"";
                initValue = initValue + " x " + String.valueOf(this.start[choice4Index[i3]]);
            }
            String result = JOptionPane.showInputDialog(this, msg, initValue);
            if (result == null || (result = result.trim()) == null || result.length() < 1) {
                return;
            }
            StringTokenizer st = new StringTokenizer(result, "x");
            if (st.countTokens() < n) {
                JOptionPane.showMessageDialog(this, "Number of dimension(s) is less than " + n + "\n" + result, "Select Slice Location", 0);
                return;
            }
            long[] start4 = new long[n];
            for (i = 0; i < n; ++i) {
                try {
                    start4[i] = Long.parseLong(st.nextToken().trim());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, ex.getMessage(), "Select Slice Location", 0);
                    return;
                }
                if (start4[i] >= 0L && start4[i] < this.dims[choice4Index[i]]) continue;
                JOptionPane.showMessageDialog(this, "Slice location is out of range.\n" + start4[i] + " >= " + this.dims[choice4Index[i]], "Select Slice Location", 0);
                return;
            }
            for (i = 0; i < n; ++i) {
                this.start[choice4Index[i]] = start4[i];
            }
        } else if (cmd.equals("Help on how to set bitmask")) {
            String msg = "\"Apply Bitmask\" applies bitwise \"AND\" to the original data.\nFor example, bits 2, 3, and 4 are selected for the bitmask\n         10010101 (data)\nAND 00011100 (mask)  \n  =     00010100 (result) ==> the decimal value is 20. \n\n\"Extract Bit(s)\" removes all the bits from the result above where\ntheir corresponding bits in the bitmask are 0. \nFor the same example above, the result is \n101 ==> the decimal value is 5.\n\n";
            JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), msg);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source.equals(this.imageButton)) {
            this.choicePalette.setEnabled(!this.isTrueColorImage);
            this.choiceImageView.setEnabled(true);
            this.choiceTableView.setEnabled(false);
            this.charCheckbox.setSelected(false);
            this.charCheckbox.setEnabled(false);
        } else if (source.equals(this.spreadsheetButton)) {
            this.choicePalette.setEnabled(false);
            this.choiceImageView.setEnabled(false);
            this.choiceTableView.setEnabled(true);
            Datatype dtype = this.dataset.getDatatype();
            int tclass = dtype.getDatatypeClass();
            this.charCheckbox.setEnabled((tclass == 2 || tclass == 0) && dtype.getDatatypeSize() == 1);
        } else if (source instanceof JToggleButton) {
            this.checkBitmaskButtons((JToggleButton)source);
        } else if (source instanceof JComboBox) {
            int i;
            if (!this.performJComboBoxEvent) {
                return;
            }
            if (e.getStateChange() == 2) {
                return;
            }
            JComboBox theChoice = (JComboBox)source;
            int theSelectedChoice = -1;
            int n = Math.min(3, this.rank);
            for (int i2 = 0; i2 < n; ++i2) {
                if (!theChoice.equals(this.choices[i2])) continue;
                theSelectedChoice = i2;
            }
            if (theSelectedChoice < 0) {
                return;
            }
            int theIndex = theChoice.getSelectedIndex();
            if (theIndex == this.currentIndex[theSelectedChoice]) {
                return;
            }
            this.start[this.currentIndex[theSelectedChoice]] = 0L;
            this.startFields[theSelectedChoice].setText("0");
            this.endFields[theSelectedChoice].setText(String.valueOf(this.dims[theIndex] - 1L));
            this.strideFields[theSelectedChoice].setText("1");
            this.maxLabels[theSelectedChoice].setText(String.valueOf(this.dims[theIndex]));
            for (i = 0; i < n; ++i) {
                if (i == theSelectedChoice || theIndex != this.choices[i].getSelectedIndex()) continue;
                this.setJComboBoxSelectedIndex(this.choices[i], this.currentIndex[theSelectedChoice]);
                this.startFields[i].setText("0");
                this.endFields[i].setText(String.valueOf(this.dims[this.currentIndex[theSelectedChoice]] - 1L));
                this.strideFields[i].setText("1");
                this.maxLabels[i].setText(String.valueOf(this.dims[this.currentIndex[theSelectedChoice]]));
            }
            for (i = 0; i < n; ++i) {
                this.currentIndex[i] = this.choices[i].getSelectedIndex();
            }
            if (this.rank > 1) {
                if (this.isText) {
                    this.endFields[1].setText(this.startFields[1].getText());
                } else {
                    int hIdx = this.choices[0].getSelectedIndex();
                    int wIdx = this.choices[1].getSelectedIndex();
                    this.transposeChoice.setSelectedIndex(0);
                    if (hIdx < wIdx) {
                        this.transposeChoice.setEnabled(false);
                    } else {
                        this.transposeChoice.setEnabled(true);
                    }
                    long[] dims = this.dataset.getDims();
                    int w = (int)dims[wIdx];
                    int h = (int)dims[hIdx];
                    this.navigator.setDimensionSize(w, h);
                    this.navigator.updateUI();
                }
            }
            if (this.rank > 2) {
                this.endFields[2].setText(this.startFields[2].getText());
            }
        }
    }

    public boolean isCancelled() {
        return this.isSelectionCancelled;
    }

    public boolean isImageDisplay() {
        return this.imageButton.isSelected();
    }

    public boolean isIndexBase1() {
        if (this.base1Button == null) {
            return false;
        }
        return this.base1Button.isSelected();
    }

    private void checkBitmaskButtons(JToggleButton source) {
        boolean b = false;
        int n = 0;
        if (source.equals(this.applyBitmaskButton)) {
            if (this.applyBitmaskButton.isSelected()) {
                this.extractBitButton.setSelected(false);
            }
        } else if (source.equals(this.extractBitButton) && this.extractBitButton.isSelected()) {
            this.applyBitmaskButton.setSelected(false);
        }
        b = this.applyBitmaskButton.isSelected() || this.extractBitButton.isSelected();
        this.bitmaskButtons[0].setEnabled(b);
        if (this.bitmaskButtons[0].isSelected()) {
            n = 1;
        }
        for (int i = 1; i < this.bitmaskButtons.length; ++i) {
            this.bitmaskButtons[i].setEnabled(b);
            if (!this.bitmaskButtons[i].isSelected() || this.bitmaskButtons[i - 1].isSelected()) continue;
            ++n;
        }
        if (this.extractBitButton.isSelected() && n > 1) {
            if (source.equals(this.extractBitButton) && this.extractBitButton.isSelected()) {
                this.applyBitmaskButton.setSelected(true);
                JOptionPane.showMessageDialog(this, "Selecting non-adjacent bits is only allowed \nfor the \"Apply Bitmask\" option.", "Select Bitmask", 0);
            } else if (source instanceof JRadioButton) {
                JOptionPane.showMessageDialog(this, "Please select contiguous bits \nwhen the \"Show Value of Selected Bits\" option is checked.", "Select Bitmask", 0);
                source.setSelected(false);
            }
        }
    }

    private void init() {
        int i;
        boolean isImage = false;
        if (this.dataset instanceof ScalarDS) {
            ScalarDS sd = (ScalarDS)this.dataset;
            isImage = sd.isImageDisplay();
            this.isTrueColorImage = sd.isTrueColor();
        } else if (this.dataset instanceof CompoundDS) {
            this.imageButton.setEnabled(false);
        }
        this.choiceTableView.setEnabled(!isImage);
        this.choiceImageView.setEnabled(isImage);
        this.imageButton.setSelected(isImage);
        this.choicePalette.setEnabled(isImage && !this.isTrueColorImage);
        int n = Math.min(3, this.rank);
        long endIdx = 0L;
        for (i = 0; i < n; ++i) {
            this.choices[i].setEnabled(true);
            this.startFields[i].setEnabled(true);
            this.endFields[i].setEnabled(true);
            this.strideFields[i].setEnabled(true);
            this.maxLabels[i].setEnabled(true);
            int idx = this.selectedIndex[i];
            endIdx = this.start[idx] + this.selected[idx] * this.stride[idx];
            if (endIdx >= this.dims[idx]) {
                endIdx = this.dims[idx];
            }
            this.setJComboBoxSelectedIndex(this.choices[i], idx);
            this.maxLabels[i].setText(String.valueOf(this.dims[idx]));
            this.startFields[i].setText(String.valueOf(this.start[idx]));
            this.endFields[i].setText(String.valueOf(endIdx - 1L));
            if (!this.isH5 && this.dataset instanceof CompoundDS) {
                this.strideFields[i].setEnabled(false);
                continue;
            }
            this.strideFields[i].setText(String.valueOf(this.stride[idx]));
        }
        if (this.rank > 1) {
            this.transposeChoice.setEnabled(this.choices[0].getSelectedIndex() > this.choices[1].getSelectedIndex());
            if (this.isText) {
                this.endFields[1].setEnabled(false);
                this.endFields[1].setText(this.startFields[1].getText());
            }
        }
        if (this.rank > 2) {
            this.endFields[2].setEnabled(false);
            this.strideFields[2].setEnabled(false);
            if (this.isTrueColorImage && this.imageButton.isSelected()) {
                this.choices[0].setEnabled(false);
                this.choices[1].setEnabled(false);
                this.choices[2].setEnabled(false);
                this.startFields[2].setEnabled(false);
                this.startFields[2].setText("0");
                this.endFields[2].setText("0");
            } else {
                this.choices[0].setEnabled(true);
                this.choices[1].setEnabled(true);
                this.choices[2].setEnabled(true);
                this.startFields[2].setEnabled(true);
                this.startFields[2].setText(String.valueOf(this.start[this.selectedIndex[2]]));
                this.endFields[2].setText(this.startFields[2].getText());
            }
        }
        for (i = 0; i < n; ++i) {
            this.currentIndex[i] = this.choices[i].getSelectedIndex();
        }
        Datatype dtype = this.dataset.getDatatype();
        int tclass = dtype.getDatatypeClass();
        if (tclass == 2 || tclass == 0) {
            int tsize = dtype.getDatatypeSize();
            this.charCheckbox.setEnabled(tsize == 1 && this.spreadsheetButton.isSelected());
            this.extractBitButton.setEnabled(tsize <= 2);
            this.applyBitmaskButton.setEnabled(tsize <= 2);
        } else {
            this.charCheckbox.setEnabled(false);
            this.charCheckbox.setSelected(false);
            this.extractBitButton.setEnabled(false);
            this.applyBitmaskButton.setEnabled(false);
        }
    }

    private void setJComboBoxSelectedIndex(JComboBox box, int idx) {
        this.performJComboBoxEvent = false;
        box.setSelectedIndex(idx);
        this.performJComboBoxEvent = true;
    }

    private void setPalette() {
        if (!(this.dataset instanceof ScalarDS)) {
            return;
        }
        byte[][] pal = null;
        int palChoice = this.choicePalette.getSelectedIndex();
        if (palChoice == 0) {
            return;
        }
        if (palChoice == this.numberOfPalettes + 1) {
            pal = Tools.createGrayPalette();
        } else if (palChoice == this.numberOfPalettes + 2) {
            pal = Tools.createReverseGrayPalette();
        } else if (palChoice == this.numberOfPalettes + 3) {
            pal = Tools.createGrayWavePalette();
        } else if (palChoice == this.numberOfPalettes + 4) {
            pal = Tools.createRainbowPalette();
        } else if (palChoice == this.numberOfPalettes + 5) {
            pal = Tools.createNaturePalette();
        } else if (palChoice == this.numberOfPalettes + 6) {
            pal = Tools.createWavePalette();
        } else if (palChoice > 0 && palChoice <= this.numberOfPalettes) {
            pal = ((ScalarDS)this.dataset).readPalette(palChoice - 1);
        }
        ((ScalarDS)this.dataset).setPalette(pal);
    }

    private boolean setSelection() {
        int i;
        long[] n0 = new long[]{0L, 0L, 0L};
        long[] n1 = new long[]{0L, 0L, 0L};
        long[] n2 = new long[]{1L, 1L, 1L};
        int[] sIndex = new int[]{0, 1, 2};
        boolean retVal = true;
        int n = Math.min(3, this.rank);
        for (i = 0; i < n; ++i) {
            sIndex[i] = this.choices[i].getSelectedIndex();
            try {
                n0[i] = Long.parseLong(this.startFields[i].getText());
                if (i < 2) {
                    n1[i] = Long.parseLong(this.endFields[i].getText());
                    n2[i] = Long.parseLong(this.strideFields[i].getText());
                }
            }
            catch (NumberFormatException ex) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), ex.getMessage(), this.getTitle(), 0);
                return false;
            }
            if (n0[i] < 0L) {
                n0[i] = 0L;
            }
            if (n0[i] >= this.dims[sIndex[i]]) {
                n0[i] = this.dims[sIndex[i]] - 1L;
            }
            if (n1[i] < 0L) {
                n1[i] = 0L;
            }
            if (n1[i] >= this.dims[sIndex[i]]) {
                n1[i] = this.dims[sIndex[i]] - 1L;
            }
            if (n0[i] > n1[i]) {
                n1[i] = n0[i];
            }
            if (n2[i] > this.dims[sIndex[i]]) {
                n2[i] = this.dims[sIndex[i]];
            }
            if (n2[i] > 0L) continue;
            n2[i] = 1L;
        }
        if (this.dataset instanceof CompoundDS) {
            CompoundDS d = (CompoundDS)this.dataset;
            int[] selectedFieldIndices = this.fieldList.getSelectedIndices();
            if (selectedFieldIndices == null || selectedFieldIndices.length < 1) {
                this.toolkit.beep();
                JOptionPane.showMessageDialog((JFrame)((Object)this.viewer), "No member/field is selected.", this.getTitle(), 0);
                return false;
            }
            d.setMemberSelection(false);
            for (int i2 = 0; i2 < selectedFieldIndices.length; ++i2) {
                d.selectMember(selectedFieldIndices[i2]);
            }
        }
        for (i = 0; i < this.rank; ++i) {
            this.selected[i] = 1L;
            this.stride[i] = 1L;
        }
        for (i = 0; i < n; ++i) {
            this.selectedIndex[i] = sIndex[i];
            this.start[this.selectedIndex[i]] = n0[i];
            if (i >= 2) continue;
            this.selected[this.selectedIndex[i]] = (int)((n1[i] - n0[i] + 1L) / n2[i]);
            this.stride[this.selectedIndex[i]] = n2[i];
        }
        if (this.rank > 1 && this.isText) {
            this.selected[this.selectedIndex[1]] = 1L;
            this.stride[this.selectedIndex[1]] = 1L;
        } else if (this.rank > 2 && this.isTrueColorImage && this.imageButton.isSelected()) {
            this.start[this.selectedIndex[2]] = 0L;
            this.selected[this.selectedIndex[2]] = 3L;
        }
        this.dataset.clearData();
        retVal = this.setBitmask();
        return retVal;
    }

    private boolean setBitmask() {
        int i;
        boolean isAll = false;
        boolean isNothing = false;
        if (this.bitmaskButtons == null) {
            this.bitmask = null;
            return true;
        }
        if (!this.applyBitmaskButton.isSelected() && !this.extractBitButton.isSelected()) {
            this.bitmask = null;
            return true;
        }
        int len = this.bitmaskButtons.length;
        for (i = 0; i < len; ++i) {
            isAll = isAll && this.bitmaskButtons[i].isSelected();
            isNothing = isNothing && !this.bitmaskButtons[i].isSelected();
        }
        if (isAll || isNothing) {
            this.bitmask = null;
            return true;
        }
        if (this.bitmask == null) {
            this.bitmask = new BitSet(len);
        }
        for (i = 0; i < len; ++i) {
            this.bitmask.set(i, this.bitmaskButtons[i].isSelected());
        }
        return true;
    }

    public boolean isDisplayTypeChar() {
        return this.charCheckbox.isSelected();
    }

    public BitSet getBitmask() {
        if (this.bitmask == null) {
            return null;
        }
        if (!this.extractBitButton.isEnabled()) {
            return null;
        }
        if (this.bitmask.isEmpty()) {
            return null;
        }
        boolean isAllSelected = true;
        int size = this.bitmask.size();
        for (int i = 0; i < size; ++i) {
            isAllSelected = this.bitmask.get(i) && isAllSelected;
        }
        if (isAllSelected) {
            return null;
        }
        return this.bitmask;
    }

    public boolean isApplyBitmaskOnly() {
        if (this.getBitmask() == null) {
            return false;
        }
        return this.applyBitmaskButton.isSelected();
    }

    public boolean isTransposed() {
        return this.transposeChoice.getSelectedIndex() == 1;
    }

    public String getDataViewName() {
        String viewName = null;
        viewName = this.isText ? (String)this.choiceTextView.getSelectedItem() : (this.isImageDisplay() ? (String)this.choiceImageView.getSelectedItem() : (String)this.choiceTableView.getSelectedItem());
        return viewName;
    }

    private class PreviewNavigator
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        private static final long serialVersionUID = -4458114008420664965L;
        private final int NAVIGATOR_SIZE = 150;
        private int dimX;
        private int dimY;
        private int x;
        private int y;
        private double r;
        private Point startPosition;
        private Rectangle selectedArea;
        private Image previewImage = null;

        private PreviewNavigator(int w, int h) {
            this.dimX = w;
            this.dimY = h;
            if (this.dimX > this.dimY) {
                this.x = 150;
                this.r = (double)this.dimX / (double)this.x;
                this.y = (int)((double)this.dimY / this.r);
            } else {
                this.y = 150;
                this.r = (double)this.dimY / (double)this.y;
                this.x = (int)((double)this.dimX / this.r);
            }
            this.selectedArea = new Rectangle();
            this.setPreferredSize(new Dimension(150, 150));
            try {
                this.previewImage = this.createPreviewImage();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Image createPreviewImage() throws Exception {
            if (DataOptionDialog.this.rank <= 1 || !(DataOptionDialog.this.dataset instanceof ScalarDS)) {
                return null;
            }
            Image preImage = null;
            ScalarDS sd = (ScalarDS)DataOptionDialog.this.dataset;
            if (sd.isText()) {
                return null;
            }
            long[] strideBackup = new long[DataOptionDialog.this.rank];
            long[] selectedBackup = new long[DataOptionDialog.this.rank];
            long[] startBackup = new long[DataOptionDialog.this.rank];
            int[] selectedIndexBackup = new int[3];
            System.arraycopy(DataOptionDialog.this.stride, 0, strideBackup, 0, DataOptionDialog.this.rank);
            System.arraycopy(DataOptionDialog.this.selected, 0, selectedBackup, 0, DataOptionDialog.this.rank);
            System.arraycopy(DataOptionDialog.this.start, 0, startBackup, 0, DataOptionDialog.this.rank);
            System.arraycopy(DataOptionDialog.this.selectedIndex, 0, selectedIndexBackup, 0, 3);
            for (int i = 0; i < DataOptionDialog.this.rank; ++i) {
                ((DataOptionDialog)DataOptionDialog.this).start[i] = 0L;
                ((DataOptionDialog)DataOptionDialog.this).stride[i] = 1L;
                ((DataOptionDialog)DataOptionDialog.this).selected[i] = 1L;
            }
            if (DataOptionDialog.this.choices != null) {
                ((DataOptionDialog)DataOptionDialog.this).selectedIndex[0] = DataOptionDialog.this.choices[0].getSelectedIndex();
                ((DataOptionDialog)DataOptionDialog.this).selectedIndex[1] = DataOptionDialog.this.choices[1].getSelectedIndex();
            }
            long steps = (long)Math.ceil(this.r);
            ((DataOptionDialog)DataOptionDialog.this).selected[((DataOptionDialog)DataOptionDialog.this).selectedIndex[0]] = DataOptionDialog.this.dims[DataOptionDialog.this.selectedIndex[0]] / steps;
            ((DataOptionDialog)DataOptionDialog.this).selected[((DataOptionDialog)DataOptionDialog.this).selectedIndex[1]] = DataOptionDialog.this.dims[DataOptionDialog.this.selectedIndex[1]] / steps;
            long l = steps;
            ((DataOptionDialog)DataOptionDialog.this).stride[((DataOptionDialog)DataOptionDialog.this).selectedIndex[1]] = l;
            ((DataOptionDialog)DataOptionDialog.this).stride[((DataOptionDialog)DataOptionDialog.this).selectedIndex[0]] = l;
            if (DataOptionDialog.this.selected[DataOptionDialog.this.selectedIndex[0]] == 0L) {
                ((DataOptionDialog)DataOptionDialog.this).selected[((DataOptionDialog)DataOptionDialog.this).selectedIndex[0]] = 1L;
            }
            if (DataOptionDialog.this.selected[DataOptionDialog.this.selectedIndex[1]] == 0L) {
                ((DataOptionDialog)DataOptionDialog.this).selected[((DataOptionDialog)DataOptionDialog.this).selectedIndex[1]] = 1L;
            }
            if (DataOptionDialog.this.isTrueColorImage && DataOptionDialog.this.start.length > 2) {
                ((DataOptionDialog)DataOptionDialog.this).start[((DataOptionDialog)DataOptionDialog.this).selectedIndex[2]] = 0L;
                ((DataOptionDialog)DataOptionDialog.this).selected[((DataOptionDialog)DataOptionDialog.this).selectedIndex[2]] = 3L;
                ((DataOptionDialog)DataOptionDialog.this).stride[((DataOptionDialog)DataOptionDialog.this).selectedIndex[2]] = 1L;
            }
            this.y = (int)DataOptionDialog.this.selected[DataOptionDialog.this.selectedIndex[0]];
            this.x = (int)DataOptionDialog.this.selected[DataOptionDialog.this.selectedIndex[1]];
            this.r = Math.min((double)DataOptionDialog.this.dims[DataOptionDialog.this.selectedIndex[0]] / (double)DataOptionDialog.this.selected[DataOptionDialog.this.selectedIndex[0]], (double)DataOptionDialog.this.dims[DataOptionDialog.this.selectedIndex[1]] / (double)DataOptionDialog.this.selected[DataOptionDialog.this.selectedIndex[1]]);
            try {
                Object data = sd.read();
                Object fillValue = sd.getFillValue();
                if (fillValue != null && sd.isFillValueConverted) {
                    fillValue = ScalarDS.convertToUnsignedC(fillValue, null);
                }
                byte[] bData = Tools.getBytes(data, sd.getImageDataRange(), fillValue, null);
                int h = sd.getHeight();
                int w = sd.getWidth();
                if (DataOptionDialog.this.isTrueColorImage) {
                    boolean isPlaneInterlace = sd.getInterlace() == 2;
                    preImage = Tools.createTrueColorImage(bData, isPlaneInterlace, w, h);
                } else {
                    int j;
                    int i;
                    byte[] bData2;
                    int n;
                    byte[][] imagePalette = sd.getPalette();
                    if (imagePalette == null) {
                        imagePalette = Tools.createGrayPalette();
                    }
                    if ((DataOptionDialog.this.isH5 || DataOptionDialog.this.rank > 2) && DataOptionDialog.this.selectedIndex[0] > DataOptionDialog.this.selectedIndex[1]) {
                        n = bData.length;
                        bData2 = new byte[n];
                        System.arraycopy(bData, 0, bData2, 0, n);
                        for (i = 0; i < h; ++i) {
                            for (j = 0; j < w; ++j) {
                                bData[i * w + j] = bData2[j * h + i];
                            }
                        }
                    }
                    if (!DataOptionDialog.this.isH5 && !sd.isDefaultImageOrder() && DataOptionDialog.this.selectedIndex[1] > DataOptionDialog.this.selectedIndex[0]) {
                        n = bData.length;
                        bData2 = new byte[n];
                        System.arraycopy(bData, 0, bData2, 0, n);
                        for (i = 0; i < h; ++i) {
                            for (j = 0; j < w; ++j) {
                                bData[i * w + j] = bData2[j * h + i];
                            }
                        }
                    }
                    preImage = Tools.createIndexedImage(bData, imagePalette, w, h);
                }
            }
            finally {
                System.arraycopy(strideBackup, 0, DataOptionDialog.this.stride, 0, DataOptionDialog.this.rank);
                System.arraycopy(selectedBackup, 0, DataOptionDialog.this.selected, 0, DataOptionDialog.this.rank);
                System.arraycopy(startBackup, 0, DataOptionDialog.this.start, 0, DataOptionDialog.this.rank);
                System.arraycopy(selectedIndexBackup, 0, DataOptionDialog.this.selectedIndex, 0, 3);
            }
            return preImage;
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(Color.blue);
            if (this.previewImage != null) {
                g.drawImage(this.previewImage, 0, 0, this);
            } else {
                g.fillRect(0, 0, this.x, this.y);
            }
            int w = this.selectedArea.width;
            int h = this.selectedArea.height;
            if (w > 0 && h > 0) {
                g.setColor(Color.red);
                g.drawRect(this.selectedArea.x, this.selectedArea.y, w, h);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.startPosition = e.getPoint();
            this.selectedArea.setBounds(this.startPosition.x, this.startPosition.y, 0, 0);
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.startPosition = e.getPoint();
            this.selectedArea.setBounds(this.startPosition.x, this.startPosition.y, 0, 0);
            this.repaint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point p0 = this.startPosition;
            Point p1 = e.getPoint();
            int x0 = Math.max(0, Math.min(p0.x, p1.x));
            int y0 = Math.max(0, Math.min(p0.y, p1.y));
            int x1 = Math.min(this.x, Math.max(p0.x, p1.x));
            int y1 = Math.min(this.y, Math.max(p0.y, p1.y));
            int w = x1 - x0;
            int h = y1 - y0;
            this.selectedArea.setBounds(x0, y0, w, h);
            try {
                this.updateSelection(x0, y0, w, h);
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.repaint();
        }

        private void updateSelection(int x0, int y0, int w, int h) {
            int i0 = 0;
            int i1 = 0;
            i0 = (int)((double)y0 * this.r);
            if ((long)i0 > DataOptionDialog.this.dims[DataOptionDialog.this.currentIndex[0]]) {
                i0 = (int)DataOptionDialog.this.dims[DataOptionDialog.this.currentIndex[0]];
            }
            DataOptionDialog.this.startFields[0].setText(String.valueOf(i0));
            i1 = (int)((double)(y0 + h) * this.r);
            if (i1 < i0) {
                i1 = i0;
            }
            DataOptionDialog.this.endFields[0].setText(String.valueOf(i1));
            String selStr = String.valueOf((int)((double)h * this.r));
            if (DataOptionDialog.this.rank > 1) {
                i0 = (int)((double)x0 * this.r);
                if ((long)i0 > DataOptionDialog.this.dims[DataOptionDialog.this.currentIndex[1]]) {
                    i0 = (int)DataOptionDialog.this.dims[DataOptionDialog.this.currentIndex[1]];
                }
                DataOptionDialog.this.startFields[1].setText(String.valueOf(i0));
                i1 = (int)((double)(x0 + w) * this.r);
                if (i1 < i0) {
                    i1 = i0;
                }
                DataOptionDialog.this.endFields[1].setText(String.valueOf(i1));
                selStr = selStr + " x " + (int)((double)w * this.r);
            }
            DataOptionDialog.this.selLabel.setText(selStr);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        private void setDimensionSize(int w, int h) {
            this.dimX = w;
            this.dimY = h;
            if (this.dimX > this.dimY) {
                this.x = 150;
                this.r = (double)this.dimX / (double)this.x;
                this.y = (int)((double)this.dimY / this.r);
            } else {
                this.y = 150;
                this.r = (double)this.dimY / (double)this.y;
                this.x = (int)((double)this.dimX / this.r);
            }
            this.setPreferredSize(new Dimension(150, 150));
            this.selectedArea.setSize(0, 0);
            try {
                this.previewImage = this.createPreviewImage();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.repaint();
        }
    }
}

