/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.object.nc2;

import java.util.List;
import java.util.Vector;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.nc2.NC2File;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;

public class NC2Group
extends Group {
    private static final long serialVersionUID = -1261533010442193447L;
    private List attributeList;
    private static final long[] DEFAULT_OID = new long[]{0L};

    public NC2Group(FileFormat fileFormat, String name, String path, Group parent, long[] theID) {
        super(fileFormat, name, path, parent, theID == null ? DEFAULT_OID : theID);
    }

    @Override
    public boolean hasAttribute() {
        return false;
    }

    @Override
    public List getMetadata() throws Exception {
        if (!this.isRoot()) {
            return null;
        }
        if (this.attributeList != null) {
            return this.attributeList;
        }
        NC2File theFile = (NC2File)this.getFileFormat();
        NetcdfFile ncFile = theFile.getNetcdfFile();
        List<Attribute> netcdfAttributeList = ncFile.getGlobalAttributes();
        if (netcdfAttributeList == null) {
            return null;
        }
        int n = netcdfAttributeList.size();
        this.attributeList = new Vector(n);
        Attribute netcdfAttr = null;
        for (int i = 0; i < n; ++i) {
            netcdfAttr = netcdfAttributeList.get(i);
            this.attributeList.add(NC2File.convertAttribute(netcdfAttr));
        }
        return this.attributeList;
    }

    @Override
    public void writeMetadata(Object info) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public void removeMetadata(Object info) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public int open() {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    @Override
    public void close(int gid) {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    public static NC2Group create(String name, Group pgroup) throws Exception {
        throw new UnsupportedOperationException("Unsupported operation for NetCDF.");
    }

    public List getMetadata(int ... attrPropList) throws Exception {
        throw new UnsupportedOperationException("getMetadata(int... attrPropList) is not supported");
    }
}

